/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.sonet.TdmTransceiverTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class TdmTransceiverPane
extends AbstractPane
implements ActionListener {
    protected JButton refreshButton;
    protected JLabel refreshLabel;
    protected TdmTransceiverTableModel dataModel;
    protected TdmLineModel[] lineModels;
    private static final SDebug db = new SDebug("TransceiverPane");

    public TdmTransceiverPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.lineModels = tdmLineModelArray;
        this.setLayout(new BorderLayout());
        this.initTable();
        this.initButtonPanel();
        this.registerForLineUpdates();
    }

    protected void initTable() {
        TableColumn tableColumn = null;
        this.dataModel = new TdmTransceiverTableModel(this.getUiModel().getNodeModel(), this.lineModels);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(TdmTransceiverTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(255);
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.TdmTransceiverPane;
    }

    protected void initButtonPanel() {
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.refreshLabel = new JLabel("");
        JPanel jPanel = new JPanel();
        jPanel.add(this.refreshButton);
        jPanel.add(this.refreshLabel);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        cSHelpButtonPane.addLeft(jPanel);
        this.add(cSHelpButtonPane, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object == this.refreshButton) {
                this.refresh();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void dispose() {
        this.refreshButton = null;
        this.refreshLabel = null;
        super.dispose();
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.lineModels = (TdmLineModel[])((OcnLineUpdate)object).getModels();
            this.dataModel.refreshMyLines(this.lineModels);
        }
    }

    public void refresh() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.refreshLabel();
        this.dataModel.refreshFromModel();
    }

    protected void refreshLabel() {
        this.refreshLabel.setText("Optical Transceiver Parameters last refreshed at " + new Date().toString());
    }

    public void enteringPage() throws Exception {
        this.refresh();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }
}

