/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.SonetMedia.sLaserParams;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.SDebug;

public class TdmTransceiverTableModel
extends TdmTableModel {
    public static final String[] columnNames = new String[]{"Port", "Non-normalized LBC (mA)", "Non-normalized OPT (dbm)", "Non-normalized OPR (dbm)"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int LBC_INDEX = 1;
    public static final int OPT_INDEX = 2;
    public static final int OPR_INDEX = 3;
    protected EntityCellRenderer myPortRenderer = new EntityCellRenderer();
    protected sLaserParams[] currVal;
    private static final SDebug db = new SDebug("TdmTransceiverTableModel");

    public TdmTransceiverTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray) {
        super(iNodeModel);
        this.setModel(tdmLineModelArray);
    }

    protected void setModel(TdmLineModel[] tdmLineModelArray) {
        this.model = tdmLineModelArray;
        if (tdmLineModelArray == null) {
            db.println("Table model is empty.  Line models are being set to null");
            this.numLines = 0;
        } else {
            this.numLines = this.model.length;
        }
        this.currVal = new sLaserParams[this.numLines];
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return Float.class;
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.currVal[n] == null ? null : new Float(this.currVal[n].biasCurrent);
                }
                case 2: {
                    return this.currVal[n] == null ? null : new Float(this.currVal[n].txPower);
                }
                case 3: {
                    return this.currVal[n] == null ? null : new Float(this.currVal[n].rxPower);
                }
            }
        }
        catch (Exception exception) {
            db.warning("Unable to retreive value for row(" + n + ") and column(" + n2 + ")");
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public void refreshMyLines(TdmLineModel[] tdmLineModelArray) {
        this.setModel(tdmLineModelArray);
        this.fireTableDataChanged();
    }

    public void refreshFromModel() {
        sLaserParams[] sLaserParamsArray = new sLaserParams[this.numLines];
        DetailedLog detailedLog = null;
        for (int i = 0; i < this.numLines; ++i) {
            try {
                sLaserParamsArray[i] = this.model[i].getCurrentLaserParams();
                continue;
            }
            catch (InternalCommError internalCommError) {
                if (null == detailedLog) {
                    detailedLog = new DetailedLog(1, ErrorMsg.getString((EID)EMC.WID_RTRV_LASER_STATS_COMM_ERROR));
                }
                if (!db.on()) continue;
                db.fine("InternalCommError caught while trying to retrieve the laser params for line # " + i);
                continue;
            }
            catch (CTCUserException cTCUserException) {
                String string = ErrorMsg.getString((EID)EMC.EID_RTRV_LASER_STATS_ERROR_PARAM_1, (Object)Integer.toString(i + 1));
                DetailedLog detailedLog2 = new DetailedLog(2, string);
                detailedLog2.setException((Exception)((Object)cTCUserException));
                EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog2);
                if (!db.on()) continue;
                db.fine("CTCUserException caught while trying to retrieve the laser params for line # " + i);
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
        }
        if (null != detailedLog) {
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, detailedLog);
        }
        this.currVal = sLaserParamsArray;
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }
}

