/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Node.sIpConfig;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.INodeModel;
import cerent.cms.xml.ConverterUtil;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.converter.XsIpConfigConverter;
import cerent.util.SDebug;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class ConverterFactory {
    public static final int RETURN_CONV = 0;
    public static final int PARM_CONV = 1;
    private static ConverterFactory _instance;
    private static Map pconversions;
    private static Map rconversions;
    protected static SDebug db;

    public static ConverterFactory getInstance() {
        if (_instance == null) {
            try {
                _instance = new ConverterFactory();
                _instance.init();
            }
            catch (CTCUserException cTCUserException) {
                if (db.on()) {
                    db.println("[ConverterFactory] Init problems need to be fixed in development: " + (Object)((Object)cTCUserException));
                }
                return null;
            }
        }
        return _instance;
    }

    private ConverterFactory() {
    }

    private static synchronized void init() throws CTCUserException {
        if (rconversions == null) {
            rconversions = new HashMap();
            pconversions = new HashMap();
            ClassLoader classLoader = ConverterFactory.class.getClassLoader();
            String string = "cerent/cms/xml/converter/";
            List list = new LinkedList();
            try {
                list = ConverterUtil.getChildClassResources(classLoader, string, false);
            }
            catch (IOException iOException) {
                throw new CTCUserException("[ConverterFactory] exception: " + iOException);
            }
            catch (SAXException sAXException) {
                throw new CTCUserException("[ConverterFactory] exception: " + sAXException);
            }
            if (db.on()) {
                db.println("# of resources fnd: " + list.size());
            }
            Iterator iterator = list.iterator();
            try {
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (db.on()) {
                        db.println("resource: '" + string2 + "'");
                    }
                    Class clazz = ReflectionUtil.forName(string2);
                    Class<?>[] classArray = null;
                    Constructor constructor = clazz.getConstructor(classArray);
                    Object[] objectArray = null;
                    Object t = constructor.newInstance(objectArray);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CTCUserException("[ConverterFactory] exception: " + classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new CTCUserException("[ConverterFactory] exception: " + noSuchMethodException);
            }
            catch (InstantiationException instantiationException) {
                throw new CTCUserException("[ConverterFactory] exception: " + instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CTCUserException("[ConverterFactory] exception: " + illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CTCUserException("[ConverterFactory] exception: " + illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new CTCUserException("[ConverterFactory] exception: " + invocationTargetException);
            }
        }
    }

    public void register(Class clazz, Class clazz2, Method method) {
        if (db.on()) {
            db.println("ptype: " + clazz.getName());
            db.println("rtype: " + clazz2.getName());
            db.println("convs: " + method.getName());
        }
        rconversions.put(clazz, method);
        pconversions.put(clazz2, method);
    }

    public boolean canConvert(String string, int n) throws CTCUserException {
        ConverterFactory.checkDirection(n);
        boolean bl = false;
        try {
            Class clazz = ReflectionUtil.forName(string);
            bl = this.canConvert(clazz, n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public boolean canConvert(Class clazz, int n) {
        Map map;
        boolean bl = false;
        if (clazz == null) {
            return false;
        }
        Map map2 = map = n == 0 ? rconversions : pconversions;
        if (map.containsKey(clazz)) {
            bl = true;
        } else if (clazz.isArray()) {
            bl = this.canConvert(clazz.getComponentType(), n);
        }
        return bl;
    }

    public boolean canConvert(Object object, int n) throws CTCUserException {
        boolean bl = false;
        if (object instanceof Class) {
            bl = this.canConvert((Class)object, n);
        } else if (object != null) {
            bl = this.canConvert(object.getClass(), n);
        }
        return bl;
    }

    public Class getConvertClass(String string, int n) {
        Class clazz = null;
        try {
            clazz = this.getConvertClass(ReflectionUtil.forName(string), n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        return clazz;
    }

    public Class getConvertClass(Class clazz, int n) {
        Class clazz2;
        Map map;
        ConverterFactory.checkDirection(n);
        Class clazz3 = null;
        Method method = null;
        Map map2 = map = n == 0 ? rconversions : pconversions;
        if (map.containsKey(clazz)) {
            method = (Method)map.get(clazz);
            clazz3 = n == 0 ? method.getReturnType() : ConverterFactory.getFirstParm(method);
        } else if (clazz.isArray() && (clazz2 = this.getConvertClass(clazz.getComponentType(), n)) != null) {
            clazz3 = ConverterFactory.getJvmArrayClass(clazz2);
        }
        return clazz3;
    }

    static Class getJvmArrayClass(Class clazz) {
        String string = clazz.getName();
        string = string + "[]";
        Class clazz2 = null;
        try {
            clazz2 = ReflectionUtil.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz2;
    }

    static Class getFirstParm(Method method) {
        Class<?>[] classArray;
        Class<?> clazz = null;
        if (method != null && (classArray = method.getParameterTypes()) != null) {
            clazz = classArray[0];
        }
        return clazz;
    }

    static void checkDirection(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("dir: " + n + " now allowed. Must be RETURN_CONV or PARM_CONV");
        }
    }

    public Object convert(Object object, INodeModel iNodeModel) throws CTCUserException {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Object object2 = null;
        Method method = null;
        Object[] objectArray = new Object[]{object};
        Object[] objectArray2 = new Object[]{object, iNodeModel};
        Map map = rconversions;
        method = (Method)map.get(clazz);
        if (method == null && clazz.isArray() && (method = (Method)map.get(clazz.getComponentType())) != null) {
            return this.implicitConvertArray(object, iNodeModel);
        }
        if (method != null) {
            Object[] objectArray3;
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length == 1) {
                objectArray3 = objectArray;
            } else if (classArray.length == 2) {
                objectArray3 = objectArray2;
            } else {
                throw new CTCUserException("[ConverterFactory] convert method " + method + " has invalid number of arguments");
            }
            try {
                method.setAccessible(true);
                object2 = method.invoke(null, objectArray3);
            }
            catch (Exception exception) {
                throw new CTCUserException("[ConverterFactory] invoke exception on method " + method, (Throwable)exception);
            }
        }
        return object2;
    }

    private Object implicitConvertArray(Object object, INodeModel iNodeModel) throws CTCUserException {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Class clazz2 = this.getConvertClass(clazz.getComponentType(), 0);
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(clazz2, n);
        for (int i = 0; i < n; ++i) {
            Object object3 = Array.get(object, i);
            Object object4 = this.convert(object3, iNodeModel);
            Array.set(object2, i, object4);
        }
        return object2;
    }

    public static void main(String[] stringArray) {
        block3: {
            int n = 0;
            try {
                ConverterFactory converterFactory = ConverterFactory.getInstance();
                String string = "0.0.0.0";
                sIpAddr sIpAddr2 = new sIpAddr(string.getBytes());
                short s = 1;
                sIpConfig sIpConfig2 = new sIpConfig(sIpAddr2, s, sIpAddr2, s, s);
                boolean bl = false;
                bl = converterFactory.canConvert(sIpConfig2, n);
                Object object = converterFactory.convert(sIpConfig2, null);
                Class clazz = converterFactory.getConvertClass(sIpConfig2.getClass(), n);
                XsIpConfigConverter.XsIpConfig xsIpConfig = (XsIpConfigConverter.XsIpConfig)object;
                bl = converterFactory.canConvert(xsIpConfig, n);
                Object object2 = converterFactory.convert(xsIpConfig, null);
                if (db.on()) {
                    db.println("sConfig: " + object2 + " xConfig: " + xsIpConfig + " Class: " + clazz);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("Exception: " + exception);
            }
        }
    }

    static {
        pconversions = null;
        rconversions = null;
        db = new SDebug("ConverterFactory");
    }
}

