/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.xml.MetaDataRepository;
import cerent.cms.xml.MethodTypeInfo;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.TypeInfoRepository;
import cerent.cms.xml.XmlHelperFactory;
import cerent.cms.xml.ncvcall.NCVCall;
import cerent.util.xml.AbstractDOMParser;
import cerent.util.xml.DOMUtil;
import cerent.util.xml.XIncludeXercesDOMParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TypeInfoValidator {
    private static boolean verboseMode = false;
    private static boolean extendedChecking = false;
    private final String CLASS_ERROR = "[ Class Error:] ";
    private final String CTC_TYPEINFO_SCHEMA = "/vob/pacwan/CTC/CTCTypeInfoSchema.xsd";
    private final String FATAL_ERROR = "[ Fatal Error:] ";
    private final String ERROR_MSG = "[ERROR:] ";
    private final String FIXME = "FIX_ME";
    private final String FIXME_ERROR = "[FIX_ME Error:] ";
    private final String INFO_MSG = "[    INFO:    ] ";
    private final String WARNING_MSG = "[ WARNING:    ] ";
    private final String METHOD_ERROR = "[Method Error:] ";
    private final String METHOD_WARNING = "[Method Warning:] ";
    private final String MODEL_CLASS = "cerent.cms.model.Model";
    private final String NF_SRC_CODE = " not found in public source code ";
    private final String RETURN_TYPE_ERROR = "[Return Error:] ";
    private final String SUPER_CLASS_ERROR = "[ Super Error:] ";
    private static String MODE = "Full";
    private static String schemaFileName = "";
    private static String typeInfoFileName = "";
    private static String PLATFORM_TYPE = "454";
    private static String BASE_PLATFORM_TYPE = "454";
    private static String PLATFORM_PKG_PREFIX = "com.cisco.ctc";
    private static final String NL = System.getProperty("line.separator");
    private static final String NLTAB = NL + '\t';
    private boolean extendsModel = false;
    private boolean isValid = true;
    private String fqTIClassString = "";
    private String fqTISuperClassString = "";
    private String fqClassName = "";
    private String methodName = "";
    private String expandedTypeInfoFile = "";
    private String expandedTypeInfoWithLineNum = "";
    private File schemaFile = null;
    private URL typeInfoUrl = null;
    private TypeInfoValidator validator = null;
    private TypeInfoRepository typeInfoRep = null;
    private Map fqTISuperClassNames = null;
    private Set fqTIClassNamesSet;
    private Class[] refSuperClasses = null;
    private AbstractDOMParser parser = null;
    private Document doc = null;

    protected TypeInfoValidator() {
        new TypeInfoValidator(typeInfoFileName, false, schemaFileName, PLATFORM_TYPE);
    }

    protected TypeInfoValidator(String string, boolean bl, String string2, String string3) {
        verboseMode = bl;
        schemaFileName = string2;
        typeInfoFileName = string;
        PLATFORM_TYPE = string3;
        this.typeInfoUrl = this.createTypeInfoUrl(string);
        this.schemaFile = this.createSchemaFile(string2);
        this.validator = this;
    }

    protected TypeInfoValidator(boolean bl) {
        verboseMode = bl;
        new TypeInfoValidator(typeInfoFileName, verboseMode, schemaFileName, PLATFORM_TYPE);
    }

    private URL createTypeInfoUrl(String string) {
        int n = string.trim().equals("") ? 0 : 1;
        switch (n) {
            case 0: {
                this.typeInfoUrl = MetaDataRepository.getTypeInfoUrl();
                string = this.typeInfoUrl.getFile();
                break;
            }
            case 1: {
                File file = new File(string);
                if (!file.isFile()) {
                    TypeInfoValidator.errorPrintLine(NL + "[ Fatal Error:] " + string + " Cannot be found, exiting....");
                    this.setIsValid(false);
                    System.exit(this.getExitCode());
                    break;
                }
                try {
                    this.typeInfoUrl = file.toURL();
                    break;
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
        }
        return this.typeInfoUrl;
    }

    private File createSchemaFile(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            TypeInfoValidator.errorPrintLine(NL + "[ Fatal Error:] " + string + " Cannot be found, exiting....");
            this.setIsValid(false);
            System.exit(this.getExitCode());
        }
        return file;
    }

    public void validateTypeInfo() {
        Object var2_1 = null;
        Map map = null;
        this.infoPrintLine(NL + "Beginning validation for " + PLATFORM_TYPE + NL + TypeInfoValidator.indentSpace(4) + "Using XML File    - " + typeInfoFileName + NL + TypeInfoValidator.indentSpace(4) + "Using Schema File - " + schemaFileName + NL);
        if (this.isRunQuickMode()) {
            this.validator.isXmlFileValid();
            this.printSummaryResults();
            System.exit(this.getExitCode());
        }
        try {
            this.typeInfoRep = TypeInfoRepository.createFromXmlStream(this.typeInfoUrl);
        }
        catch (Exception exception) {
            TypeInfoValidator.errorPrintLine("[ Fatal Error:] Cannot open file " + this.typeInfoUrl.getFile());
            this.setIsValid(false);
            this.printSummaryResults();
            System.exit(this.getExitCode());
        }
        this.verifyFixMeTagsRemoved();
        map = this.typeInfoRep.getSuperTypes();
        this.fqTISuperClassNames = this.typeInfoRep.getSuperTypes();
        this.fqTIClassNamesSet = this.typeInfoRep.getFullyQualifiedClassNames();
        Iterator iterator = this.fqTIClassNamesSet.iterator();
        while (iterator.hasNext()) {
            this.fqTIClassString = (String)iterator.next();
            this.infoPrintLine("Validating Class " + this.fqTIClassString);
            if (this.typeInfoRep.isProductExcluded(this.fqTIClassString, PLATFORM_TYPE)) {
                this.infoPrintLine("Skipping Class - " + this.fqTIClassString + " is excluded from " + PLATFORM_TYPE + " in " + typeInfoFileName);
                continue;
            }
            if (this.isRunExcludedMode() && !this.typeInfoRep.isProductExcluded(this.fqTIClassString, BASE_PLATFORM_TYPE)) {
                this.infoPrintLine("Skipping Class - " + this.fqTIClassString + " is included from " + BASE_PLATFORM_TYPE + " in " + typeInfoFileName);
                continue;
            }
            boolean bl = this.validator.isPlatformConsistent(this.fqTIClassString, PLATFORM_TYPE);
            this.infoPrintLine("isPlatformConsistent:" + bl + " for " + this.fqTIClassString);
            this.fqTISuperClassString = (String)map.get(this.fqTIClassString);
            this.validator.isExtendsDefinedCorrectly(this.fqTIClassString, this.fqTISuperClassString);
            this.validator.isDefinedMethodLoadable(this.fqTIClassString);
        }
        this.printSummaryResults();
    }

    private void printSummaryResults() {
        String string = this.isValid ? "  " + MODE + " Mode" + (extendedChecking ? " Extended" : "") + " Validation Successful for " + PLATFORM_TYPE + " Platform" : "  " + MODE + " Mode Validation Failed for " + PLATFORM_TYPE + " Platform - " + typeInfoFileName + NL + "Email ctc-xml@cisco.com if you need assistance." + NL;
        System.out.println(string);
    }

    protected void infoPrintLine(String string) {
        if (verboseMode) {
            System.out.println("[    INFO:    ] " + string);
        }
    }

    protected static void errorPrintLine(String string) {
        System.out.println(string);
    }

    protected void errorPrintLine(String string, int n) {
        System.out.println("[ERROR:] Line " + n + " - " + string);
    }

    public boolean isXmlFileValid() {
        try {
            this.parser = TypeInfoRepository.getParser();
            this.parser.setErrorHandler((ErrorHandler)new Handler());
            this.parser.setDOMParser(schemaFileName, null, false);
            this.doc = ((XIncludeXercesDOMParser)this.parser).expand(TypeInfoRepository.getTypeInfoUrl().getFile());
            this.expandedTypeInfoFile = DOMUtil.nodeToString((Node)this.doc);
            if (verboseMode) {
                this.infoPrintLine(this.addLineNumbersToString(this.expandedTypeInfoFile));
            }
            this.parser.setDOMParser(schemaFileName, null, true);
            this.doc = this.parser.parse(this.typeInfoUrl.getFile());
        }
        catch (Exception exception) {
            this.setIsValid(false);
            TypeInfoValidator.errorPrintLine(NL + "[ Fatal Error:] " + typeInfoFileName + " Invalid Syntax" + NL + TypeInfoValidator.indentSpace(16) + "Please correct syntax and restart ..." + NL);
            System.out.println(this.addLineNumbersToString(this.expandedTypeInfoFile));
            this.printSummaryResults();
            System.exit(this.getExitCode());
        }
        return this.isValid;
    }

    private boolean isSuperClassDefined(String string) {
        this.infoPrintLine("Processing Class " + string);
        boolean bl = true;
        try {
            String string2 = "";
            Class[] classArray = null;
            Map map = this.typeInfoRep.getSuperTypes();
            Iterator iterator = this.fqTIClassNamesSet.iterator();
            while (iterator.hasNext()) {
                boolean bl2;
                string = (String)iterator.next();
                if (this.typeInfoRep.isProductExcluded(string, PLATFORM_TYPE)) {
                    this.infoPrintLine("Skipping Class - " + string + " is excluded from " + PLATFORM_TYPE + " in " + typeInfoFileName);
                    continue;
                }
                classArray = ReflectionUtil.superclasses(string);
                string2 = (String)map.get(string);
                boolean bl3 = bl2 = this.extendsModel || this.fqTIClassNamesSet.contains(string2);
                if (classArray.length <= 1 || bl2) continue;
                TypeInfoValidator.errorPrintLine("[ Super Error:] Superclass " + string2 + " Not Defined in TypeInfo file for class " + string);
                bl = false;
            }
        }
        catch (Exception exception) {
            TypeInfoValidator.errorPrintLine("[ Class Error:] Class " + string + " not found in public source code ");
            bl = false;
        }
        this.setIsValid(bl);
        return bl;
    }

    private boolean isPlatformConsistent(String string, String string2) {
        String string3;
        int n;
        String string4 = ReflectionUtil.processNeType((String)string2);
        boolean bl = true;
        int n2 = string.indexOf(PLATFORM_PKG_PREFIX);
        if (n2 >= 0 && (n = string.indexOf(".", n2 += PLATFORM_PKG_PREFIX.length())) > 0 && !(string3 = string.substring(n2, n)).equals(string4)) {
            TypeInfoValidator.errorPrintLine(NL + "[ Class Error:] " + string + " class is in pkg " + PLATFORM_PKG_PREFIX + string3 + " which is incorrect for netype: " + string2);
            this.setIsValid(false);
            bl = false;
        }
        return bl;
    }

    private boolean isExtendsDefinedCorrectly(String string, String string2) {
        String string3 = null;
        if (string == null) {
            TypeInfoValidator.errorPrintLine(NL + "[ Class Error:] " + string + " classString found in" + " method isExtendsDefinedCorrectly");
            this.setIsValid(false);
            return false;
        }
        string3 = string2 == null ? "cerent.cms.model.Model" : string2;
        boolean bl = true;
        Class clazz = null;
        Class clazz2 = null;
        Class clazz3 = null;
        try {
            clazz = ReflectionUtil.forName("cerent.cms.model.Model");
            clazz2 = ReflectionUtil.forName(string);
            this.extendsModel = clazz2.getSuperclass() == clazz;
            clazz3 = this.extendsModel ? clazz : ReflectionUtil.forName(string3);
            bl = clazz2.getSuperclass() == clazz3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            TypeInfoValidator.errorPrintLine("[ Class Error:] Class " + string + " not found in public source code ");
            bl = false;
        }
        if (clazz2 != null && !bl) {
            TypeInfoValidator.errorPrintLine("[ Super Error:] Superclass for " + clazz2.getName() + " defined incorrectly" + NL + TypeInfoValidator.indentSpace(16) + "Valid Superclass = " + clazz2.getSuperclass().getName());
        }
        if (bl) {
            Set set = this.typeInfoRep.getFullyQualifiedClassNames();
            String string4 = clazz3.getName();
            String string5 = MethodTypeInfo.getLastSegment(string4);
            if (!string5.equals("Model") && !set.contains(string4)) {
                TypeInfoValidator.errorPrintLine("[ Super Error:] Superclass " + clazz3 + " (for " + clazz2.getName() + ") typeinfo is missing " + NL + TypeInfoValidator.indentSpace(16) + "Check that there exists a " + string5 + ".xml file");
                bl = false;
            }
        }
        this.setIsValid(bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDefinedMethodLoadable(String string) {
        boolean bl = true;
        MethodTypeInfo methodTypeInfo = null;
        try {
            LinkedList linkedList = this.typeInfoRep.getTypeInfosByClass(string);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                boolean bl2;
                methodTypeInfo = (MethodTypeInfo)iterator.next();
                String[] stringArray = methodTypeInfo.getArgNames();
                String[] stringArray2 = methodTypeInfo.getRealArgTypes();
                this.methodName = methodTypeInfo.getMethodName();
                this.fqClassName = methodTypeInfo.getFullyQualifiedClassName();
                Class clazz = ReflectionUtil.forName(this.fqClassName);
                Method method = ReflectionUtil.getMethodWithSignature((Class)clazz, (String)this.methodName, (String[])stringArray2);
                this.infoPrintLine("Validating Method " + clazz.getName() + "." + this.methodName);
                if (method == null) {
                    bl = false;
                    TypeInfoValidator.errorPrintLine("[Method Error:] Method " + methodTypeInfo.signatureString() + " not found in public source code ");
                    continue;
                }
                this.isReturnTypeValid(methodTypeInfo, method);
                if (!extendedChecking) continue;
                String string2 = methodTypeInfo.getRealReturnType();
                boolean bl3 = bl2 = !methodTypeInfo.getIsAction();
                if (stringArray2 != null && stringArray2.length != 0 || string2 != null && string2.equals("void") || !bl2) continue;
                String string3 = methodTypeInfo.getFullyQualifiedMethodName();
                boolean bl4 = NCVCall.isNcvCallDone(this.fqClassName, string3, "/vob", "/vob/pacwan/CTC/schema/classlist.txt", false, verboseMode);
                if (bl4) {
                    TypeInfoValidator.errorPrintLine("[Method Warning:] Method " + methodTypeInfo.signatureString() + " is marked as ACTION=false but internally does an NCV call");
                    bl = false;
                }
                if (bl4) continue;
                List list = ReflectionUtil.subclasses(this.fqClassName);
                Iterator iterator2 = list != null ? list.iterator() : null;
                String string4 = methodTypeInfo.getMethodName();
                while (iterator2 != null && iterator2.hasNext()) {
                    boolean bl5;
                    String string5 = (String)iterator2.next();
                    if (string5.equals(this.fqClassName) || !(bl5 = NCVCall.isNcvCallDone(this.fqClassName, string3, "/vob", "/vob/pacwan/CTC/schema/classlist.txt", false, verboseMode, string5))) continue;
                    MethodTypeInfo methodTypeInfo2 = this.typeInfoRep.lookupMethodTypeInfoByType(string5 + "." + string4, stringArray2);
                    if (methodTypeInfo2 == null) {
                        if (this.typeInfoRep.isProductExcluded(string5, PLATFORM_TYPE)) continue;
                        TypeInfoValidator.errorPrintLine("[Method Warning:] Method " + methodTypeInfo.signatureString() + " needs to be cloned in " + string5 + " and marked as ACTION=true");
                        bl = false;
                        continue;
                    }
                    if (methodTypeInfo2.getIsAction()) continue;
                    TypeInfoValidator.errorPrintLine("[Method Warning:] Method " + methodTypeInfo2.signatureString() + " should instead be marked as ACTION=true");
                    bl = false;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
            TypeInfoValidator.errorPrintLine("[ Class Error:] Class " + this.fqClassName + " not found in public source code ");
            classNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            bl = false;
            TypeInfoValidator.errorPrintLine("[Method Error:] Method " + methodTypeInfo.signatureString() + " not found in public source code ");
            exception.printStackTrace();
        }
        finally {
            this.setIsValid(bl);
        }
        return bl;
    }

    boolean isReturnTypeValid(MethodTypeInfo methodTypeInfo, Method method) {
        String string = methodTypeInfo.getRealReturnType();
        String string2 = methodTypeInfo.getReturnType();
        String string3 = methodTypeInfo.getReturnHelper();
        String string4 = methodTypeInfo.getFullyQualifiedMethodName();
        Class<?> clazz = method.getReturnType();
        String string5 = clazz.getName();
        String string6 = "";
        Class clazz2 = null;
        Class clazz3 = null;
        Class clazz4 = null;
        boolean bl = true;
        if (clazz.isPrimitive()) {
            if (!string.equals(string5)) {
                string6 = "[Return Error:] Invalid (" + string + ") return type defined for method " + methodTypeInfo.getFullyQualifiedMethodName() + NL + TypeInfoValidator.indentSpace(16) + "Valid return type = " + clazz.getName();
                bl = false;
                this.setIsValid(bl);
            }
            if (!bl) {
                TypeInfoValidator.errorPrintLine(string6);
            }
            return this.isValid;
        }
        try {
            clazz4 = ReflectionUtil.forName(string5);
            clazz2 = ReflectionUtil.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.infoPrintLine("Inside method isReturnTypeValid(): " + string + " is invalid.");
            bl = false;
            this.setIsValid(bl);
        }
        if (ReflectionUtil.isModelClass(clazz2)) {
            if (ReflectionUtil.isArrayClass((Class)clazz2)) {
                if (string3.equals("ModelAsIdArray")) {
                    bl = true;
                } else {
                    bl = false;
                    string6 = "[Return Error:] Invalid return type for method" + string4 + " - Valid return type  = ModlAsIdArray";
                    TypeInfoValidator.errorPrintLine(string6);
                }
                this.setIsValid(bl);
            } else {
                if (string3.equals("ModelAsId")) {
                    bl = true;
                } else {
                    bl = false;
                    string6 = "[Return Error:] Invalid return type for method " + string4 + " - Valid return type = ModelAsId";
                    TypeInfoValidator.errorPrintLine(string6);
                }
                this.setIsValid(bl);
            }
        }
        if (bl && TypeInfoValidator.isContainer(clazz) && !string2.equals(string)) {
            try {
                clazz3 = ReflectionUtil.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.infoPrintLine("Inside method isReturnTypeValid(): " + string2 + " is invalid.");
                bl = false;
                this.setIsValid(bl);
            }
            if (TypeInfoValidator.isContainer(clazz3)) {
                bl = false;
                string6 = "[Return Error:] Invalid (" + string2 + ") return item type for method " + string4 + " - cannot return an item which itself is an array/collection/map";
                TypeInfoValidator.errorPrintLine(string6);
                this.setIsValid(bl);
                return this.isValid;
            }
        }
        if (string.equals(string5)) {
            bl = true;
        } else if (clazz.isArray()) {
            if (clazz.equals(clazz2)) {
                bl = true;
            } else {
                bl = false;
                string6 = "[Return Error:] Invalid (" + string + ") return type for method " + string4 + " - Valid return type == " + string5;
            }
        } else {
            bl = false;
            string6 = "[Return Error:] Invalid (" + string + ") return type for method " + string4 + " - Valid return type is " + string5;
        }
        try {
            Class clazz5 = XmlHelperFactory.getXmlHelperClass(string3);
            if (clazz5 == null) {
                throw new ClassNotFoundException();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
            string6 = "[Return Error:] Return helper " + string3 + " is not valid, for method " + string4;
        }
        this.setIsValid(bl);
        if (!bl) {
            TypeInfoValidator.errorPrintLine(string6);
        }
        return this.isValid;
    }

    private static boolean isContainer(Class clazz) {
        boolean bl = ReflectionUtil.isArrayClass((Class)clazz) || ReflectionUtil.isCollectionClass((Class)clazz) || ReflectionUtil.isMapClass((Class)clazz);
        return bl;
    }

    public static String indentSpace(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private void setIsValid(boolean bl) {
        if (!bl) {
            this.isValid = false;
        }
    }

    private boolean isRunQuickMode() {
        boolean bl = MODE == "Quick";
        return bl;
    }

    private boolean isRunExcludedMode() {
        boolean bl = MODE == "Excluded";
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addLineNumbersToString(String string) {
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            string2 = bufferedReader.readLine();
            int n = 1;
            while (string2 != null) {
                stringBuffer.append(n + string2 + NL);
                string2 = bufferedReader.readLine();
                ++n;
            }
        }
        catch (IOException iOException) {
            TypeInfoValidator.errorPrintLine(NL + "[ Fatal Error:] " + "Error reading line from" + typeInfoFileName);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuffer.toString();
    }

    private void verifyFixMeTagsRemoved() {
        if (this.typeInfoRep != null) {
            Collection collection = this.typeInfoRep.getFixMes();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                TypeInfoValidator.errorPrintLine("[ERROR:] FIX_ME found in definition for " + string + ".  Replace with correct definition.");
                this.setIsValid(false);
            }
        }
    }

    private int getExitCode() {
        return this.isValid ? 0 : 1;
    }

    public static void usage() {
        System.out.println("Usage: validate-ctctypeinfo [-? | -h] -p platform [-t CTCTypeInfo.xml file]  [-s CTCTypeInfoSchema.xsd file] [-m Q] [-v] [-x]" + NL);
        System.out.println("       -?|-h              - Display Usage");
        System.out.println("       -p all|platform(s) - platform can be one of");
        System.out.println("                single platform 454|455|327|600|310CL");
        System.out.println("                file, where platforms are space separated");
        System.out.println("                command separated list of platforms");
        System.out.println("       -m Q|E|F           - Quick, Excluded, or Full Mode");
        System.out.println("                Default Mode = Full");
        System.out.println("                Quick Mode checks well formed XML only");
        System.out.println("                Excluded Mode checks validity of classes where excluded products are defined");
        System.out.println("       -s schema-file     - Fully qualified file name");
        System.out.println("       -t typeinfo-file   - Fully qualified file name");
        System.out.println("       -v                 - Verbose output enabled");
        System.out.println("       -x                 - Extended checking enabled");
        System.out.println("                (e.g. NCV call checking)");
        System.out.println(NL + "Required argument -p <platform>, all other parameters are optional");
        System.out.println("     e.g. validate-ctctypeinfo -p 454" + NL);
        System.out.println(NL + "Email ctc-xml@cisco.com if you need assistance." + NL);
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                if (string.startsWith("-?") || string.startsWith("?")) {
                    TypeInfoValidator.usage();
                    continue;
                }
                if (string.startsWith("-h") || string.startsWith("-?")) {
                    TypeInfoValidator.usage();
                    continue;
                }
                if (string.startsWith("-m") || string.startsWith("-M")) {
                    if (string.substring(2).equalsIgnoreCase("Q")) {
                        MODE = "Quick";
                        continue;
                    }
                    if (string.substring(2).equalsIgnoreCase("E")) {
                        MODE = "Excluded";
                        continue;
                    }
                    MODE = "Full";
                    continue;
                }
                if (string.startsWith("-b") || string.startsWith("-B")) {
                    BASE_PLATFORM_TYPE = string.substring(2);
                    continue;
                }
                if (string.startsWith("-p") || string.startsWith("-P")) {
                    PLATFORM_TYPE = string.substring(2);
                    continue;
                }
                if (string.startsWith("-s") || string.startsWith("-S")) {
                    schemaFileName = string.substring(2);
                    continue;
                }
                if (string.startsWith("-t") || string.startsWith("-T")) {
                    typeInfoFileName = string.substring(2);
                    continue;
                }
                if (string.startsWith("-v") || string.startsWith("-V")) {
                    verboseMode = true;
                    continue;
                }
                if (!string.startsWith("-x") && !string.startsWith("-X")) continue;
                extendedChecking = true;
            }
            TypeInfoValidator typeInfoValidator = new TypeInfoValidator(typeInfoFileName, verboseMode, schemaFileName, PLATFORM_TYPE);
            typeInfoValidator.validateTypeInfo();
            int n = typeInfoValidator.isValid ? 0 : 1;
            System.exit(n);
        }
        catch (Exception exception) {
            TypeInfoValidator.errorPrintLine(exception.getMessage());
            exception.printStackTrace(System.out);
            System.exit(1);
        }
    }

    private class Handler
    implements ErrorHandler {
        public void error(SAXParseException sAXParseException) throws SAXException {
            TypeInfoValidator.errorPrintLine(NL + "[ Fatal Error:] " + "There was an error while parsing on line number " + sAXParseException.getLineNumber());
            sAXParseException.printStackTrace();
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            TypeInfoValidator.errorPrintLine("[ Fatal Error:] There was an error while parsing on line number " + sAXParseException.getLineNumber() + " (" + sAXParseException.getColumnNumber() + ")");
            sAXParseException.printStackTrace();
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) {
            TypeInfoValidator.errorPrintLine("[ WARNING:    ] There was an error while parsing on line number " + sAXParseException.getLineNumber() + " (" + sAXParseException.getColumnNumber() + ")");
            sAXParseException.printStackTrace();
        }
    }
}

