/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.XmlHelperValue;
import cerent.cms.xml.helper.StringHelper;
import cerent.util.ConcurrentReaderMap;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class XmlHelperFactory {
    private static final Class NO_HELPER = Object.class;
    private static final int ARRAY_CLASS = 1;
    private static final int MODEL_ARRAY_CLASS = 8;
    private static final int COLLECTION_CLASS = 2;
    private static final int MAP_CLASS = 3;
    private static final int MODEL_CLASS = 4;
    private static final int ENUM_CLASS = 5;
    private static final int STRUCT_CLASS = 6;
    private static final int BEAN_CLASS = 7;
    private static final String HELPER = "Helper";
    private static final String ARRAY_HELPER = "GenericArrayHelper";
    private static final String MODEL_ARRAY_HELPER = "ModelAsIdArrayHelper";
    private static final String COLLECTION_HELPER = "GenericCollectionHelper";
    private static final String MAP_HELPER = "MapHelper";
    private static final String MODEL_HELPER = "ModelAsIdHelper";
    private static final String ENUM_HELPER = "EnumHelper";
    private static final String STRUCT_HELPER = "StructHelper";
    private static final String BEAN_HELPER = "BeanHelper";
    private static final String GENERIC_HELPER = "GenericHelper";
    private static final String MODEL_PKG = "cerent.cms.model.Model";
    private static ConcurrentReaderMap class2HelperMap = new ConcurrentReaderMap();
    private static XmlHelperFactory instance;
    private static String helperPackage;
    private static final Debug db;

    public static Class getXmlHelperClass(String string) throws ClassNotFoundException {
        String string2 = XmlHelperFactory.testPrimitiveCases(string);
        if (string2.length() == 0) {
            string = string.replace('$', '.');
            int n = string.lastIndexOf(46);
            string = string.substring(n + 1);
        } else {
            string = string2;
        }
        String string3 = helperPackage + string;
        if (!string3.endsWith(HELPER)) {
            string3 = string3.concat(HELPER);
        }
        return ReflectionUtil.forName(string3);
    }

    public static Class getXmlHelperClass(Object object) throws ClassNotFoundException {
        return object == null ? null : XmlHelperFactory.getXmlHelperClass(object.getClass());
    }

    public static Class getXmlHelperClass(Class clazz) throws ClassNotFoundException {
        return XmlHelperFactory.getXmlHelperClass(clazz.getName());
    }

    static boolean addHelper(Class clazz, Class clazz2, String string) {
        boolean bl = false;
        if (clazz2 != null && class2HelperMap.get((Object)clazz) == null) {
            XmlHelperValue xmlHelperValue = new XmlHelperValue(clazz2, string);
            class2HelperMap.put((Object)clazz, (Object)xmlHelperValue);
            if (db.on()) {
                db.println("cache size now: " + class2HelperMap.size());
            }
            bl = true;
        }
        return bl;
    }

    static Class getHelper(Class clazz) {
        XmlHelperValue xmlHelperValue;
        Class clazz2 = null;
        if (clazz != null && (xmlHelperValue = (XmlHelperValue)class2HelperMap.get((Object)clazz)) != null) {
            clazz2 = xmlHelperValue.helper;
        }
        return clazz2;
    }

    static void dump() {
        Iterator iterator = class2HelperMap.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            XmlHelperValue xmlHelperValue = (XmlHelperValue)class2HelperMap.get((Object)clazz);
            String string = ReflectionUtil.fromJvmClassname((String)clazz.getName());
            String string2 = ReflectionUtil.fromJvmClassname((String)xmlHelperValue.helper.getName());
            String string3 = xmlHelperValue.caseNum;
            db.display(string + ", " + ", " + string2 + ", " + string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void read(String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
                Class clazz = ReflectionUtil.forName(stringTokenizer.nextToken());
                Class clazz2 = ReflectionUtil.forName(stringTokenizer.nextToken());
                String string3 = stringTokenizer.nextToken();
                XmlHelperFactory.addHelper(clazz, clazz2, string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String testPrimitiveCases(String string) {
        String string2 = "";
        char c = string.charAt(0);
        switch (c) {
            case '[': {
                char c2 = string.charAt(1);
                switch (c2) {
                    case 'B': {
                        string2 = "ByteArray";
                        break;
                    }
                    case 'C': {
                        string2 = "CharacterArray";
                        break;
                    }
                    case 'D': {
                        string2 = "DoubleArray";
                        break;
                    }
                    case 'F': {
                        string2 = "FloatArray";
                        break;
                    }
                    case 'I': {
                        string2 = "IntegerArray";
                        break;
                    }
                    case 'J': {
                        string2 = "LongArray";
                        break;
                    }
                    case 'S': {
                        string2 = "ShortArray";
                        break;
                    }
                    case 'Z': {
                        string2 = "BooleanArray";
                    }
                }
                break;
            }
            case 'b': {
                if (string.equals("byte")) {
                    string2 = "Byte";
                    break;
                }
                if (!string.equals("boolean")) break;
                string2 = "Boolean";
                break;
            }
            case 'c': {
                if (!string.equals("char")) break;
                string2 = "Character";
                break;
            }
            case 'd': {
                if (!string.equals("double")) break;
                string2 = "Double";
                break;
            }
            case 'f': {
                if (!string.equals("float")) break;
                string2 = "Float";
                break;
            }
            case 'i': {
                if (!string.equals("int")) break;
                string2 = "Integer";
                break;
            }
            case 'l': {
                if (!string.equals("long")) break;
                string2 = "Long";
                break;
            }
            case 's': {
                if (!string.equals("short")) break;
                string2 = "Short";
            }
        }
        return string2;
    }

    public static Class lookupHelperClass(Object object) throws CTCUserException {
        if (object == null) {
            return null;
        }
        return XmlHelperFactory.lookupHelperClass(object.getClass());
    }

    private static void println(KDebug kDebug, String string) {
        if (kDebug == null) {
            System.out.println(string);
        } else if (kDebug.on()) {
            kDebug.println(string);
        }
    }

    public static Class lookupHelperClass(Class clazz, KDebug kDebug) throws CTCUserException {
        XmlHelperFactory.println(kDebug, "In lookupHelperClass " + clazz.getName());
        Class clazz2 = null;
        String string = "???";
        boolean bl = false;
        clazz2 = XmlHelperFactory.getHelper(clazz);
        if (clazz2 != null) {
            if (clazz2.equals(NO_HELPER)) {
                XmlHelperFactory.println(kDebug, "no Helper findable  for " + clazz.getName());
                return null;
            }
            string = "1";
            XmlHelperFactory.println(kDebug, "looked-up Helper " + clazz2.getName() + " for " + clazz.getName());
            bl = true;
        }
        if (clazz2 == null) {
            try {
                clazz2 = XmlHelperFactory.getXmlHelperClass(clazz);
                string = "2";
            }
            catch (ClassNotFoundException classNotFoundException) {
                XmlHelperFactory.println(kDebug, "(Case 2) Unable to find Helper for " + clazz.getName());
            }
        }
        if (clazz2 == null) {
            XmlHelperFactory.println(kDebug, "Trying to use class type to find Helper class");
            int n = ReflectionUtil.categorizeClass(clazz);
            XmlHelperFactory.println(kDebug, "categorizeClass(" + clazz.getName() + ") returned " + n);
            if (n > 0) {
                try {
                    clazz2 = XmlHelperFactory.getTypeHelperClass(n);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    XmlHelperFactory.println(kDebug, classNotFoundException.toString());
                    throw new CTCUserException("[XmlHelperFactory] Unable to find a Helper for " + clazz + classNotFoundException.toString());
                }
                if (clazz2 != null) {
                    string = "3";
                    boolean bl2 = true;
                    switch (n) {
                        case 1: {
                            Class[] classArray = new Class[]{clazz.getComponentType()};
                            bl2 = XmlHelperFactory.canLookupHelpers(clazz, classArray, kDebug);
                            break;
                        }
                        case 6: {
                            Class[] classArray = ReflectionUtil.getStructFieldTypes((Class)clazz);
                            bl2 = XmlHelperFactory.canLookupHelpers(clazz, classArray, kDebug);
                            break;
                        }
                        case 7: {
                            Class[] classArray = ReflectionUtil.getBeanMethodTypes((Class)clazz);
                            bl2 = XmlHelperFactory.canLookupHelpers(clazz, classArray, kDebug);
                            break;
                        }
                    }
                    if (!bl2) {
                        clazz2 = null;
                        XmlHelperFactory.println(kDebug, "[XmlHelperFactory] " + clazz.getName() + " had a subtype with no helper coverage");
                    }
                }
            }
        }
        if (clazz2 == null) {
            if (clazz.equals(Date.class)) {
                clazz2 = StringHelper.class;
            }
            string = "4";
        }
        if (clazz2 != null) {
            XmlHelperFactory.println(kDebug, "found Helper " + clazz2.getName() + " for " + clazz.getName());
        } else {
            XmlHelperFactory.println(kDebug, "no Helper found  for " + clazz.getName());
        }
        if (!bl) {
            Class clazz3 = clazz2 != null ? clazz2 : NO_HELPER;
            XmlHelperFactory.println(kDebug, "caching Helper " + clazz3.getName() + " for " + clazz.getName());
            boolean bl3 = XmlHelperFactory.addHelper(clazz, clazz3, string);
            if (bl3) {
                XmlHelperFactory.println(kDebug, "cached Helper " + clazz3.getName() + " for " + clazz.getName());
            }
        }
        return clazz2;
    }

    public static Class lookupHelperClass(Class clazz) throws CTCUserException {
        return XmlHelperFactory.lookupHelperClass(clazz, db);
    }

    private static boolean canLookupHelpers(Class clazz, Class[] classArray, KDebug kDebug) throws CTCUserException {
        boolean bl = true;
        if (classArray != null && classArray.length > 0) {
            HashSet<Class> hashSet = new HashSet<Class>();
            for (int i = 0; i < classArray.length; ++i) {
                hashSet.add(classArray[i]);
            }
            Iterator iterator = hashSet.iterator();
            while (bl && iterator.hasNext()) {
                Class clazz2 = (Class)iterator.next();
                bl = XmlHelperFactory.lookupHelperClass(clazz2, kDebug) != null;
            }
        }
        XmlHelperFactory.println(kDebug, "canLookupHelpers(" + clazz.getName() + ") returned: " + bl);
        return bl;
    }

    private static Class getTypeHelperClass(int n) throws ClassNotFoundException {
        String string;
        switch (n) {
            case 8: {
                string = MODEL_ARRAY_HELPER;
                break;
            }
            case 1: {
                string = ARRAY_HELPER;
                break;
            }
            case 2: {
                string = COLLECTION_HELPER;
                break;
            }
            case 3: {
                string = MAP_HELPER;
                break;
            }
            case 4: {
                string = MODEL_HELPER;
                break;
            }
            case 5: {
                string = ENUM_HELPER;
                break;
            }
            case 6: {
                string = STRUCT_HELPER;
                break;
            }
            case 7: {
                string = BEAN_HELPER;
                break;
            }
            default: {
                string = GENERIC_HELPER;
            }
        }
        Class clazz = ReflectionUtil.forName(helperPackage + string);
        return clazz;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n == 0) {
            System.out.println("usage: cerent.cms.xml.XmlHelperFactory [-d] <class to lookup> {<optional default helper>}");
            return;
        }
        PrintStream printStream = System.out;
        try {
            String string = stringArray[0];
            int n3 = 1;
            boolean bl = false;
            if (string.equals("-d")) {
                bl = true;
                if (n <= 1) {
                    return;
                }
                string = stringArray[n3];
                n3 = 2;
            }
            Class clazz = null;
            clazz = ReflectionUtil.forName(string);
            String string2 = n <= n3 ? null : stringArray[n3];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            System.setOut(new PrintStream(byteArrayOutputStream));
            Class clazz2 = XmlHelperFactory.lookupHelperClass(clazz, null);
            System.out.flush();
            System.setOut(printStream);
            if (bl) {
                System.out.println(byteArrayOutputStream.toString());
            }
            if (clazz2 != null) {
                System.out.println("lookup: '" + clazz2.getName() + "'");
            } else {
                System.out.println("lookup NOT found");
            }
        }
        catch (Exception exception) {
            System.out.flush();
            System.setOut(printStream);
            System.out.println(exception.getMessage());
            exception.printStackTrace(System.out);
        }
    }

    static {
        helperPackage = "cerent.cms.xml.helper.";
        db = new Debug("XmlHelperFactory");
    }

    public static class Debug
    extends SDebug {
        Debug(String string) {
            super(string);
        }

        public final void lookupHelperClass(String string) {
            try {
                Class<?> clazz = Class.forName(string);
                Class clazz2 = XmlHelperFactory.lookupHelperClass(clazz, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public final void dumpCache() {
            XmlHelperFactory.dump();
        }

        public final void initCache(String string) {
            XmlHelperFactory.read(string);
        }
    }
}

