/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.MetaDataRepository;
import cerent.cms.xml.helper.BaseObjectHelper;
import cerent.launcher.CachedJar;
import cerent.launcher.CmsClassLoader;
import cerent.util.SDebug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class XmlTagFactory {
    public static final String COMMENT_START = "<!-- ";
    public static final String COMMENT_END = " -->";
    private static Class ME = XmlTagFactory.class;
    private static String ELE_VERSION = XmlTagFactory.getBuildInfoVersionAndDate(ME.getClassLoader());
    private static String CORE_VERSION = XmlTagFactory.getBuildInfoVersionAndDate(ME.getClassLoader().getParent());
    private static URL DEFAULT_URL = null;
    protected static final String INDEX_ATTR = " index=";
    public static String nl = System.getProperty("line.separator");
    public static final SDebug db = new SDebug("XmlTagFactory", false);
    public static final SDebug fdb = new SDebug("XmlFault", false);

    private XmlTagFactory() {
    }

    public static String printHeader() {
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\"?>" + nl);
        return stringBuffer.toString();
    }

    public static String startDocument(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\"?>" + nl);
        stringBuffer.append("<!DOCTYPE " + XmlTagFactory.rules(string) + " SYSTEM \"" + string2 + "\">" + nl);
        return stringBuffer.toString();
    }

    public static String makeElement(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlTagFactory.tabSpace(n) + XmlTagFactory.startElement(string));
        if (string2.length() > 0) {
            stringBuffer.append(XmlTagFactory.value(string2));
        }
        stringBuffer.append(XmlTagFactory.endElement(string));
        return stringBuffer.toString();
    }

    public static String makeFaultElement(String string, String string2, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append(XmlTagFactory.startElement("fault", n));
        stringBuffer.append(XmlTagFactory.makeElement("faultcode", string, n + 1));
        stringBuffer.append(XmlTagFactory.makeElement("faultstring", COMMENT_START + exception.getMessage() + COMMENT_END, n + 1));
        stringBuffer.append(XmlTagFactory.makeElement("ele-version", COMMENT_START + XmlTagFactory.getEleBuildInfoVersionAndDate() + COMMENT_END, n + 1));
        stringBuffer.append(XmlTagFactory.makeElement("core-version", COMMENT_START + XmlTagFactory.getCoreBuildInfoVersionAndDate() + COMMENT_END, n + 1));
        stringBuffer.append(XmlTagFactory.makeElement("thread", COMMENT_START + Thread.currentThread().toString() + COMMENT_END, n + 1));
        stringBuffer.append(XmlTagFactory.makeElement("metadata", COMMENT_START + XmlTagFactory.getMetaDataUrl().toString() + COMMENT_END, n + 1));
        stringBuffer.append(XmlTagFactory.makeElement("typeinfo", COMMENT_START + XmlTagFactory.getTypeInfoUrl().toString() + COMMENT_END, n + 1));
        stringBuffer.append(XmlTagFactory.makeElement("xmlCommand", COMMENT_START + XmlTagFactory.decomment(string2) + COMMENT_END, n + 1));
        stringBuffer.append(XmlTagFactory.makeElement("stacktrace", COMMENT_START + XmlTagFactory.getStackTrace(exception) + COMMENT_END, n + 1));
        stringBuffer.append(XmlTagFactory.endElement("fault", n));
        return stringBuffer.toString();
    }

    static String getEleBuildInfoVersionAndDate() {
        return ELE_VERSION;
    }

    static String getCoreBuildInfoVersionAndDate() {
        return CORE_VERSION;
    }

    private static String getBuildInfoVersionAndDate(ClassLoader classLoader) {
        String string;
        if (classLoader instanceof CmsClassLoader) {
            CmsClassLoader cmsClassLoader = (CmsClassLoader)classLoader;
            CachedJar cachedJar = cmsClassLoader.getCachedJar();
            string = cachedJar.getCachedSwVersion() + ", built " + cachedJar.getCachedSwDate(null);
        } else {
            string = "???, run " + new Date();
        }
        return string;
    }

    public static Throwable getOriginatingException(Throwable throwable) {
        Throwable throwable2 = throwable;
        Throwable throwable3 = throwable;
        while (throwable2 != null) {
            throwable3 = throwable2;
            if (throwable3 instanceof CTCUserException) {
                throwable2 = ((CTCUserException)throwable3).getTargetException();
                continue;
            }
            if (!(throwable3 instanceof InvocationTargetException)) break;
            throwable2 = ((InvocationTargetException)throwable3).getTargetException();
        }
        return throwable3;
    }

    protected static String getStackTrace(Exception exception) {
        if (exception == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Throwable throwable = XmlTagFactory.getOriginatingException(exception);
        if (XmlTagFactory.db.on || XmlTagFactory.fdb.on) {
            SDebug.printStackTrace((Throwable)throwable);
        }
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static String makeIndexElement(String string, int n, int n2) {
        String string2 = XmlTagFactory.rules(string);
        String string3 = BaseObjectHelper.integerToString(n2, INDEX_ATTR);
        return XmlTagFactory.tabSpace(n + 2) + "<" + string2 + INDEX_ATTR + "\"" + string3 + "\"/>" + nl;
    }

    public static String startElement(String string, int n, int n2) {
        String string2 = XmlTagFactory.rules(string);
        String string3 = BaseObjectHelper.integerToString(n2, INDEX_ATTR);
        return XmlTagFactory.tabSpace(n) + "<" + string2 + INDEX_ATTR + "\"" + string3 + "\">";
    }

    public static String startElement(String string, int n, int n2, String string2) {
        String string3 = string2 + XmlTagFactory.rules(string);
        String string4 = BaseObjectHelper.integerToString(n2, INDEX_ATTR);
        return XmlTagFactory.tabSpace(n) + "<" + string3 + INDEX_ATTR + "\"" + string4 + "\">";
    }

    public static String startElement(String string) {
        return XmlTagFactory.startElement(string, 0);
    }

    public static String startElement(String string, int n) {
        return XmlTagFactory.tabSpace(n) + "<" + XmlTagFactory.rules(string) + ">";
    }

    public static String endElement(String string) {
        return XmlTagFactory.endElement(string, 0);
    }

    public static String endElement(String string, int n) {
        return XmlTagFactory.tabSpace(n) + "</" + XmlTagFactory.rules(string) + ">" + nl;
    }

    public static String endElement(String string, int n, String string2) {
        return XmlTagFactory.tabSpace(n) + "</" + string2 + XmlTagFactory.rules(string) + ">" + nl;
    }

    public static String value(String string) {
        return XmlTagFactory.value(string, 0);
    }

    public static String value(String string, int n) {
        return XmlTagFactory.tabSpace(n) + string;
    }

    public static String rules(String string) {
        int n;
        int n2 = string.length();
        if (string.startsWith("[") && string.endsWith(";")) {
            string = string.substring(1, n2 - 1);
            string = string.concat("List");
            n2 += 2;
        }
        if ((n = string.lastIndexOf(36)) == -1) {
            n = string.lastIndexOf(46);
        }
        String string2 = string.substring(n < 0 ? 0 : n + 1);
        return string2;
    }

    public static String addTabSpace(String string, int n) {
        return XmlTagFactory.tabSpace(n) + string;
    }

    public static String tabSpace(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        return stringBuffer.toString();
    }

    public static String createCommentElement(String string) {
        return COMMENT_START + XmlTagFactory.decomment(string) + COMMENT_END + nl;
    }

    static String decomment(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            if (stringBuffer.charAt(n2++) != '-' || n2 >= n || stringBuffer.charAt(n2) != '-') continue;
            stringBuffer.setCharAt(n2++, ' ');
        }
        return stringBuffer.toString();
    }

    private static URL getMetaDataUrl() {
        URL uRL = MetaDataRepository.getMetaDataUrl();
        return uRL == null ? DEFAULT_URL : uRL;
    }

    private static URL getTypeInfoUrl() {
        URL uRL = MetaDataRepository.getTypeInfoUrl();
        return uRL == null ? DEFAULT_URL : uRL;
    }

    static {
        try {
            DEFAULT_URL = new URL("file://host");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

