/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.ncvcall;

import cerent.cms.xml.ncvcall.Node;
import cerent.cms.xml.ncvcall.SourcePathResolver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class ImportResolver {
    private String packag;
    private SourcePathResolver srcPathResolver;
    private HashMap idMap;
    private LinkedList defaultPackages;
    private HashMap names;

    public ImportResolver(String string, SourcePathResolver sourcePathResolver) {
        this.packag = string;
        this.srcPathResolver = sourcePathResolver;
        this.idMap = new HashMap();
        this.defaultPackages = new LinkedList();
        this.names = new HashMap();
    }

    public SourcePathResolver getSourcePathResolver() {
        return this.srcPathResolver;
    }

    public String getPackage() {
        return this.packag;
    }

    public void addImport(String string) {
        String[] stringArray = this.split(string);
        HashMap hashMap = null;
        HashMap hashMap2 = this.idMap;
        int n = 0;
        for (n = 0; n < stringArray.length; ++n) {
            Node node;
            String string2 = stringArray[n];
            if (!hashMap2.containsKey(string2)) {
                node = new Node(n == 0 ? "" : stringArray[n - 1], hashMap);
                hashMap2.put(string2, node);
                hashMap = hashMap2;
                hashMap2 = node.getHashMap();
            } else {
                node = (Node)hashMap2.get(string2);
                hashMap = hashMap2;
                hashMap2 = node.getHashMap();
            }
            if (n != stringArray.length - 1) continue;
            if (!string2.equals("*")) {
                this.names.put(string2, node);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (i > 0) {
                    stringBuffer.append("/");
                }
                stringBuffer.append(string2);
            }
            this.defaultPackages.add(stringBuffer.toString());
        }
    }

    public String resolve(String string, boolean bl) {
        String string2 = string;
        if (string == null || string.length() == 0) {
            return string2;
        }
        boolean bl2 = true;
        String[] stringArray = this.split(string);
        HashMap hashMap = this.idMap;
        int n = 0;
        int n2 = stringArray.length;
        if (n2 > 1) {
            for (n = 0; n < n2; ++n) {
                String string3 = stringArray[n];
                if (!hashMap.containsKey(string3)) {
                    bl2 = false;
                    break;
                }
                Node node = (Node)hashMap.get(string3);
                hashMap = node.getHashMap();
            }
        } else {
            String string4 = this.packag + "." + string;
            if (bl && this.didFindInSourcePath(string4)) {
                return string4;
            }
            if (this.names.containsKey(string)) {
                String string5 = string;
                Node node = (Node)this.names.get(string);
                HashMap hashMap2 = node.getParent();
                while (hashMap2 != null) {
                    String string6 = node.getParentStr();
                    string5 = string6 + "." + string5;
                    node = (Node)hashMap2.get(string6);
                    hashMap2 = node.getParent();
                }
                return string5;
            }
            String string7 = this.findByDefaultPackage(string);
            if (string7 != null) {
                return string7;
            }
            try {
                Class.forName("java.lang." + string);
                return "java.lang." + string;
            }
            catch (ClassNotFoundException classNotFoundException) {
                string2 = string4;
            }
        }
        return string2;
    }

    public String resolve(String string) {
        return this.resolve(string, true);
    }

    private String[] split(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    private boolean didFindInSourcePath(String string) {
        return this.srcPathResolver.didFindInSourcePath(string);
    }

    private String findByDefaultPackage(String string) {
        Iterator iterator = this.defaultPackages.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = string2 + "." + string;
            if (!this.didFindInSourcePath(string3)) continue;
            return string3;
        }
        return null;
    }
}

