/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.ncvcall;

import cerent.cms.xml.ncvcall.ClassDef;
import cerent.cms.xml.ncvcall.ClassDefs;
import cerent.cms.xml.ncvcall.ClassMember;
import cerent.cms.xml.ncvcall.Item;
import cerent.cms.xml.ncvcall.MemberDef;
import cerent.cms.xml.ncvcall.MethodCallsExpression;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;

public class MCExpressionBuilder {
    public static final int PIDENT_CALL = 1;
    public static final int PRIM_CALL = 2;
    public static final int TYPECAST = 3;
    public static final int FIELD_VAR_ACCESS = 4;
    public static final int STATIC_TYPE_ACCESS = 5;
    public static final int SUB_CALL = 6;
    private WeakReference parentMethod;
    private LinkedList stack;
    private int lastCallDepth = -1;
    private int lastNumArgs = -1;
    private int numPushes;
    private boolean finished;

    public MCExpressionBuilder(MemberDef memberDef) {
        this.parentMethod = new WeakReference<MemberDef>(memberDef);
        this.stack = new LinkedList();
    }

    public MemberDef getParentMethod() {
        Object t = this.parentMethod.get();
        return t == null ? null : (MemberDef)t;
    }

    public ClassDef getParentClass() {
        return this.getParentMethod().getParentClass();
    }

    public void addPIdentCall(String string, int n, int n2) {
        String string2;
        Object object;
        this.lastCallDepth = n2;
        this.lastNumArgs = n;
        String string3 = null;
        int n3 = string.lastIndexOf(".");
        String string4 = "???";
        if (n3 >= 0) {
            object = string.substring(0, n3);
            Item item = this.addFieldVarAccess((String)object);
            string3 = item == null ? "???" : item.fqType;
            string2 = string.substring(n3 + 1);
            string4 = string3 + "." + string2;
        } else {
            string2 = string;
            object = this.getParentClass().resolveName(string2, n);
            if (object != null) {
                ClassDef classDef = ((ClassMember)object).getParentClass();
                string3 = classDef.getFqName();
                string4 = ((ClassMember)object).getFqName();
            }
        }
        object = this.resolveFqReturnType(string3, string2, n);
        this.push(new Item(1, (String)object, string4, n, n2));
    }

    public void addPrimCall(String string, int n, int n2) {
        this.lastCallDepth = n2;
        this.lastNumArgs = n;
        Item item = this.top();
        if (item != null) {
            int n3 = item.callType;
            switch (n3) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    String string2 = item.fqType;
                    String string3 = this.resolveFqReturnType(string2, string, n);
                    this.push(new Item(2, string3, string2 + "." + string, n, n2));
                }
            }
        }
    }

    public Item addFieldVarAccess(String string) {
        String string2 = "???";
        String string3 = null;
        Object object = this.resolveName(string);
        Item item = null;
        if (object instanceof String) {
            string2 = (String)object;
            string3 = string;
            item = new Item(4, string2, string3);
        } else if (object instanceof ClassMember) {
            ClassMember classMember = (ClassMember)object;
            int n = classMember.getMemType();
            if (n == 2) {
                MemberDef memberDef = (MemberDef)classMember;
                string2 = memberDef.getFqMemType();
                string3 = memberDef.getFqName();
                item = new Item(4, string2, string3);
            } else if (n == 0 || n == 1) {
                string3 = string2 = classMember.getFqName();
                item = new Item(5, string2, string3);
            }
        }
        if (item != null) {
            this.push(item);
        }
        return item;
    }

    public void addTypecast(String string, int n) {
        this.lastCallDepth = n;
        String string2 = this.resolveFqType(string);
        this.push(new Item(3, string2, n));
    }

    public boolean isTypeCastOnTopOfStack() {
        boolean bl = false;
        if (this.stack.size() > 0) {
            Item item = this.top();
            if (item.callType == 3) {
                bl = true;
            }
        }
        return bl;
    }

    public void addSubCall(MethodCallsExpression methodCallsExpression) {
        this.push(methodCallsExpression);
    }

    public int getLastCallDepth() {
        return this.lastCallDepth;
    }

    public int getLastNumArgs() {
        return this.lastNumArgs;
    }

    public MethodCallsExpression finish(MemberDef memberDef) {
        if (this.finished) {
            return null;
        }
        this.finished = true;
        String string = memberDef.getFqName();
        MethodCallsExpression methodCallsExpression = new MethodCallsExpression(memberDef);
        Iterator iterator = this.stack.iterator();
        Item item = null;
        Item item2 = null;
        LinkedList<Item> linkedList = null;
        block4: while (item2 != null || iterator.hasNext()) {
            Item item3 = item = item2 != null ? item2 : (Item)iterator.next();
            if (item2 != null) {
                item2 = null;
            }
            int n = item.callType;
            block0 : switch (n) {
                case 1: 
                case 2: {
                    Item item4;
                    methodCallsExpression.addNewMethodCall(item.fqType, item.fqName, item.numArgs);
                    if (linkedList == null) break;
                    Iterator iterator2 = linkedList.iterator();
                    while (iterator2.hasNext()) {
                        item4 = (Item)iterator2.next();
                        MethodCallsExpression methodCallsExpression2 = item4.methodCall;
                        methodCallsExpression.addSubMCExpression(methodCallsExpression2);
                    }
                    continue block4;
                }
                case 6: {
                    Item item4;
                    linkedList = new LinkedList<Item>();
                    int n2 = item.callDepth;
                    linkedList.add(item);
                    while (iterator.hasNext()) {
                        item4 = (Item)iterator.next();
                        if (item4.callType == 6 && item4.callDepth == n2) {
                            linkedList.add(item4);
                            continue;
                        }
                        item2 = item4;
                        break block0;
                    }
                    break;
                }
            }
        }
        return methodCallsExpression;
    }

    private Object resolveName(String string) {
        String string2 = this.getLocalVariable(string);
        if (string2 != null) {
            return string2;
        }
        ClassMember classMember = this.getParentClass().resolveName(string);
        return classMember;
    }

    private String getLocalVariable(String string) {
        return this.getParentMethod().getVariableDecl(string);
    }

    private String resolveFqType(String string) {
        return this.getParentClass().resolveType(string);
    }

    private String resolveFqReturnType(String string, String string2, int n) {
        ClassDef classDef = ClassDefs.getClassDef(string);
        if (classDef == null) {
            return "???";
        }
        return classDef.resolveReturnType(string2, n, 0);
    }

    private void push(Item item) {
        ++this.numPushes;
        this.stack.add(item);
    }

    private void push(MethodCallsExpression methodCallsExpression) {
        this.stack.add(new Item(methodCallsExpression));
    }

    private Item pop() {
        return this.stack.size() == 0 ? null : (Item)this.stack.removeLast();
    }

    private Item top() {
        return this.stack.size() == 0 ? null : (Item)this.stack.getLast();
    }

    public boolean unused() {
        return this.numPushes == 0;
    }
}

