/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.ncvcall;

import antlr.Token;
import antlr.collections.AST;
import cerent.cms.xml.ncvcall.CallItem;
import cerent.cms.xml.ncvcall.ClassDef;
import cerent.cms.xml.ncvcall.ClassDefs;
import cerent.cms.xml.ncvcall.IParsingManager;
import cerent.cms.xml.ncvcall.ImportResolver;
import cerent.cms.xml.ncvcall.MCExpressionBuilder;
import cerent.cms.xml.ncvcall.MemberDef;
import cerent.cms.xml.ncvcall.ParsingManager;
import cerent.cms.xml.ncvcall.SourcePathResolver;
import cerent.cms.xml.ncvcall.Thunk;
import cerent.util.antlr.ASTChildIterator;
import cerent.util.antlr.ASTUtil;
import cerent.util.antlr.DefaultParserBinder;
import cerent.util.antlr.IParserBinder;
import cerent.util.antlr.JavaRecognizer;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NCVCallParserBinder
extends DefaultParserBinder
implements IParserBinder {
    private static final String PIDENT_CALL = "pident";
    private static final String PRIM_CALL = "prim";
    private static final String SUPER_CALL = "super";
    private static SourcePathResolver srcPathResolver;
    private static IParsingManager parsingManager;
    private int pass;
    private String packag;
    private ImportResolver importResolver;
    private ClassDef thisClass;
    private ClassDef currentClass;
    private String currentFQClass = null;
    private MemberDef currentMethod;
    private LinkedList callStack = new LinkedList();
    private LinkedList thunks = new LinkedList();
    private static Method endBindMethodDefPass2Method;
    private static Method bindVariableDeclPass2Method;
    private static Method bindTypeCastPass2Method;
    private static Method bindMethodCallPass2Method;
    private static Method bindFieldVarAccessPass2Method;
    private static Method endBindMethodCallPass2Method;

    private static Method lookup(String string, Class[] classArray) {
        Method method = null;
        try {
            method = NCVCallParserBinder.class.getDeclaredMethod(string, classArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return method;
    }

    public static void init(String string, String string2) {
        srcPathResolver = new SourcePathResolver(string, string2);
    }

    public NCVCallParserBinder(JavaRecognizer javaRecognizer, int n) {
        super(javaRecognizer);
        this.pass = n;
    }

    public int getPass() {
        return this.pass;
    }

    public void setPass(int n) {
        this.pass = n;
    }

    public void logln(String string) {
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        if (n == 1) {
            return;
        }
        if (JavaRecognizer.verbose) {
            NCVCallParserBinder._logln((String)string);
        }
    }

    public void log(String string) {
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        if (n == 1) {
            return;
        }
        if (JavaRecognizer.verbose) {
            NCVCallParserBinder._log((String)string);
        }
    }

    public void timestamp(String string) {
        NCVCallParserBinder._timestamp((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPass2Thunks() {
        boolean bl = true;
        try {
            Iterator iterator = this.thunks.iterator();
            while (iterator.hasNext()) {
                Thunk thunk = (Thunk)iterator.next();
                thunk.invoke();
            }
        }
        catch (RuntimeException runtimeException) {
            bl = false;
        }
        finally {
            this.thunks.clear();
            this.thunks = null;
        }
        return bl;
    }

    private LinkedList getParmTypes(AST aST) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (aST != null) {
            for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
                AST aST3;
                AST aST4 = ASTUtil.getChild((AST)aST2, (int)1);
                if (aST4 == null || (aST3 = aST4.getFirstChild()) == null) continue;
                linkedList.add(this.trueType(aST3));
            }
        }
        return linkedList;
    }

    private LinkedList getArgs(AST aST) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (aST != null) {
            for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
                AST aST3 = ASTUtil.getChild((AST)aST2, (int)2);
                if (aST3 == null) continue;
                linkedList.add(aST3.getText());
            }
        }
        return linkedList;
    }

    private static String toParmTypesStr(List list) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (list != null) {
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)iterator.next());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void bindPackageDef(AST aST) {
        super.bindPackageDef(aST);
        this.bindPackageDef(aST.getText());
    }

    private void bindPackageDef(String string) {
        this.packag = string;
        this.importResolver = new ImportResolver(string, srcPathResolver);
        this.logln("package: " + string);
    }

    public void bindImport(AST aST) {
        super.bindImport(aST);
        this.bindImport(aST.getText());
    }

    private void bindImport(String string) {
        this.importResolver.addImport(string);
        this.logln("import: " + string);
    }

    public void bindClassDef(AST aST) {
        super.bindClassDef(aST);
        String string = aST.getText();
        this.currentFQClass = this.currentFQClass == null ? this.packag + "." + string : this.currentFQClass + "." + string;
        ClassDef classDef = ClassDefs.getClassDef(this.currentFQClass);
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getClassNesting();
        if (n == 0) {
            this.thisClass = classDef != null ? classDef : new ClassDef(null, 0, this.importResolver, this.currentFQClass, parsingManager);
            this.currentClass = this.thisClass;
        } else {
            ClassDef classDef2 = classDef != null ? classDef : new ClassDef(this.currentClass, 1, this.importResolver, this.currentFQClass, parsingManager);
            this.currentClass = classDef2;
        }
        for (int i = 0; i < n; ++i) {
            this.log("  ");
        }
        this.log("class: " + this.currentFQClass);
    }

    public void endBindClassDef() {
        ClassDef classDef;
        super.endBindClassDef();
        this.currentClass = classDef = this.currentClass.getParentClass();
        int n = this.currentFQClass.lastIndexOf(".");
        this.currentFQClass = this.currentFQClass.substring(0, n);
        if (this.currentFQClass.equals(this.packag)) {
            this.currentFQClass = null;
        }
    }

    public void bindSuperClass(AST aST) {
        ClassDef classDef;
        super.bindSuperClass(aST);
        String string = "";
        AST aST2 = aST;
        if (aST2 != null) {
            aST2 = aST2.getFirstChild();
        }
        if ((classDef = ClassDefs.getClassDef(string = aST2 != null ? aST2.getText() : "")) == null) {
            String string2 = this.currentClass.resolveType(string);
            classDef = ClassDefs.getClassDef(string2);
        }
        this.currentClass.addSuperClassDef(classDef);
        if (string.endsWith("NonCachedValue")) {
            this.logln("...ncv");
        } else {
            this.logln("");
        }
    }

    private String trueType(AST aST) {
        if (aST.getType() == 14) {
            aST = aST.getFirstChild();
        }
        int n = aST.getType();
        String string = aST.getText();
        int n2 = ASTUtil.countChild((AST)aST, (int)18);
        for (int i = 0; i < n2; ++i) {
            string = string + "[]";
        }
        return string;
    }

    public void bindMethodDef(AST aST, AST aST2, AST aST3, AST aST4) {
        super.bindMethodDef(aST, aST2, aST3, aST4);
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getClassNesting();
        String string = aST3.getText();
        for (int i = 0; i < n; ++i) {
            this.log("  ");
        }
        String string2 = this.trueType(aST2);
        String string3 = NCVCallParserBinder.getAccessControl(aST);
        boolean bl = NCVCallParserBinder.getStaticness(aST);
        String string4 = this.currentFQClass + "." + string;
        LinkedList linkedList = this.getParmTypes(aST4);
        LinkedList linkedList2 = this.getArgs(aST4);
        this.currentMethod = this.currentClass.addMethodDef(string3, bl, string2, string4, linkedList, linkedList2);
        String string5 = NCVCallParserBinder.toParmTypesStr(linkedList);
        this.logln(string2 + " method " + string + ": " + string5);
    }

    private static String getAccessControl(AST aST) {
        String string = null;
        ASTChildIterator aSTChildIterator = new ASTChildIterator(aST);
        while (aSTChildIterator.hasNext() && string == null) {
            AST aST2 = aSTChildIterator.nextAST();
            String string2 = aST2.getText();
            if (string2.equals("public")) {
                string = "public";
                continue;
            }
            if (string2.equals("private")) {
                string = "private";
                continue;
            }
            if (!string2.equals("protected")) continue;
            string = "protected";
        }
        return string;
    }

    private static boolean getStaticness(AST aST) {
        boolean bl = false;
        ASTChildIterator aSTChildIterator = new ASTChildIterator(aST);
        while (aSTChildIterator.hasNext() && !bl) {
            AST aST2 = aSTChildIterator.nextAST();
            String string = aST2.getText();
            if (!string.equals("static")) continue;
            bl = true;
        }
        return bl;
    }

    public void endBindMethodDef() {
        super.endBindMethodDef();
        if (this.currentMethod == null) {
            return;
        }
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        if (n == 1) {
            this.thunks.add(new Thunk(endBindMethodDefPass2Method, this.currentMethod));
        } else {
            NCVCallParserBinder.endBindMethodDefPass2(this.currentMethod);
        }
        this.currentMethod = null;
    }

    private static void endBindMethodDefPass2(MemberDef memberDef) {
        memberDef.popAllBuilder();
    }

    public void bindFieldDef(AST aST, AST aST2) {
        super.bindFieldDef(aST, aST2);
        AST aST3 = aST2;
        if (aST3 != null) {
            aST3 = aST3.getFirstChild().getNextSibling();
        }
        if (aST3 != null) {
            aST3 = aST3.getNextSibling();
        }
        String string = aST.getText();
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getClassNesting();
        for (int i = 0; i < n + 1; ++i) {
            this.log("  ");
        }
        String string2 = this.trueType(aST);
        String string3 = aST3.getText();
        String string4 = this.currentFQClass + "." + string3;
        this.currentClass.addFieldDef(string2, string4);
        this.logln(string2 + " field " + string3);
    }

    private StringBuffer prepMemberAccessBuffer() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        JavaRecognizer javaRecognizer = this.getParser();
        int n2 = javaRecognizer.getClassNesting();
        for (n = 0; n < n2 + 1; ++n) {
            stringBuffer.append("  ");
        }
        n = javaRecognizer.getCallDepth();
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("..");
        return stringBuffer;
    }

    public void bindVariableDecl(AST aST, Token token) {
        super.bindVariableDecl(aST, token);
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        boolean bl = javaRecognizer.isInMethodDef();
        String string = null;
        String string2 = null;
        if (bl) {
            string = this.trueType(aST);
            string2 = token.getText();
        }
        if (n == 1 || !bl) {
            this.thunks.add(new Thunk(bindVariableDeclPass2Method, new Boolean(bl), string, string2, (Object)this, this.currentMethod));
            return;
        }
        NCVCallParserBinder.bindVariableDeclPass2(bl, string, string2, this, this.currentMethod);
    }

    private static void bindVariableDeclPass2(boolean bl, String string, String string2, NCVCallParserBinder nCVCallParserBinder, MemberDef memberDef) {
        if (bl) {
            memberDef.addVariableDecl(string, string2);
            if (JavaRecognizer.verbose) {
                StringBuffer stringBuffer = nCVCallParserBinder.prepMemberAccessBuffer();
                nCVCallParserBinder.log(stringBuffer.toString());
                nCVCallParserBinder.logln(string + " variable " + string2);
            }
        }
    }

    public void bindTypeCast(AST aST) {
        super.bindTypeCast(aST);
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        boolean bl = javaRecognizer.isInMethodDef();
        int n2 = javaRecognizer.getCallDepth();
        if (n == 1 || !bl) {
            this.thunks.add(new Thunk(bindTypeCastPass2Method, new Integer(n2), new Boolean(bl), aST, (Object)this, this.currentMethod));
            return;
        }
        NCVCallParserBinder.bindTypeCastPass2(n2, bl, aST, this, this.currentMethod);
    }

    private static void bindTypeCastPass2(int n, boolean bl, AST aST, NCVCallParserBinder nCVCallParserBinder, MemberDef memberDef) {
        if (!bl) {
            return;
        }
        String string = nCVCallParserBinder.trueType(aST.getFirstChild());
        if (memberDef.isCallDepthGreater(n)) {
            memberDef.pushBuilder();
        } else if (memberDef.isCallDepthLesser(n)) {
            memberDef.popBuilder();
        } else if (!memberDef.unusedBuilder()) {
            memberDef.finishBuilder();
            memberDef.resetBuilder();
        }
        memberDef.getBuilder().addTypecast(string, n);
        if (JavaRecognizer.verbose) {
            StringBuffer stringBuffer = nCVCallParserBinder.prepMemberAccessBuffer();
            stringBuffer.append(string + " typecast(" + n + "}");
            nCVCallParserBinder.bindMemberAccess(stringBuffer);
        }
    }

    public void bindPIdentMethodCall(Token token, AST aST) {
        super.bindPIdentMethodCall(token, aST);
        if (this.currentMethod == null) {
            return;
        }
        this.bindMethodCall(PIDENT_CALL, token, aST);
    }

    public void bindPrimMethodCall(Token token, AST aST) {
        super.bindPrimMethodCall(token, aST);
        if (this.currentMethod == null) {
            return;
        }
        this.bindMethodCall(PRIM_CALL, token, aST);
    }

    public void bindSuperMethodCall(Token token, AST aST) {
        super.bindSuperMethodCall(token, aST);
        if (this.currentMethod == null) {
            return;
        }
        this.bindMethodCall(SUPER_CALL, token, aST);
    }

    private void bindMethodCall(String string, Token token, AST aST) {
        String string2 = token.getText();
        this.bindMethodCall(string, string2, aST);
    }

    private void bindMethodCall(String string, String string2, AST aST) {
        int n = aST == null ? 0 : aST.getNumberOfChildren();
        this.bindMethodCall(string, string2, n);
    }

    private void bindMemberAccess(StringBuffer stringBuffer) {
        if (JavaRecognizer.verbose) {
            CallItem callItem = this.callStack.size() == 0 ? null : (CallItem)this.callStack.getLast();
            JavaRecognizer javaRecognizer = this.getParser();
            int n = javaRecognizer.getCallDepth();
            if (callItem != null) {
                int n2;
                int n3 = n + 1;
                LinkedList<CallItem> linkedList = new LinkedList<CallItem>();
                while ((n2 = this.callStack.size()) > 0) {
                    callItem = (CallItem)this.callStack.getLast();
                    if (callItem.callDepth != n3) break;
                    this.callStack.removeLast();
                    linkedList.add(callItem);
                }
                while ((n2 = linkedList.size()) > 0) {
                    callItem = (CallItem)linkedList.removeLast();
                    stringBuffer.append('\n');
                    stringBuffer.append(callItem.text);
                }
            }
            CallItem callItem2 = new CallItem(n, stringBuffer.toString());
            this.callStack.add(callItem2);
        }
    }

    private void bindMethodCall(String string, String string2, int n) {
        JavaRecognizer javaRecognizer = this.getParser();
        int n2 = javaRecognizer.getPass();
        boolean bl = javaRecognizer.isInMethodDef();
        int n3 = javaRecognizer.getCallDepth();
        if (n2 == 1 || !bl) {
            this.thunks.add(new Thunk(bindMethodCallPass2Method, new Integer(n3), string, string2, new Integer(n), (Object)this, this.currentMethod));
            return;
        }
        NCVCallParserBinder.bindMethodCallPass2(n3, string, string2, n, this, this.currentMethod);
    }

    private static void bindMethodCallPass2(int n, String string, String string2, int n2, NCVCallParserBinder nCVCallParserBinder, MemberDef memberDef) {
        if (string == PIDENT_CALL) {
            if (memberDef.isCallDepthGreater(n)) {
                memberDef.pushBuilder();
            } else if (memberDef.isCallDepthLesser(n)) {
                memberDef.popBuilder();
            } else if (!memberDef.isTypeCastOnTopOfStack() && !memberDef.unusedBuilder()) {
                memberDef.finishBuilder();
                memberDef.resetBuilder();
            }
            memberDef.getBuilder().addPIdentCall(string2, n2, n);
        } else if (string == PRIM_CALL) {
            memberDef.getBuilder().addPrimCall(string2, n2, n);
        }
        if (JavaRecognizer.verbose) {
            StringBuffer stringBuffer = nCVCallParserBinder.prepMemberAccessBuffer();
            stringBuffer.append(string + " call{" + n + "}: " + string2 + "(" + n2 + ")");
            nCVCallParserBinder.bindMemberAccess(stringBuffer);
        }
    }

    public void bindFieldVarAccess(String string) {
        super.bindFieldVarAccess(string);
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        boolean bl = javaRecognizer.isInMethodDef();
        int n2 = javaRecognizer.getCallDepth();
        if (n == 1 || !bl) {
            this.thunks.add(new Thunk(bindFieldVarAccessPass2Method, new Integer(n2), new Boolean(bl), string, (Object)this, this.currentMethod));
            return;
        }
        NCVCallParserBinder.bindFieldVarAccessPass2(n2, bl, string, this, this.currentMethod);
    }

    private static void bindFieldVarAccessPass2(int n, boolean bl, String string, NCVCallParserBinder nCVCallParserBinder, MemberDef memberDef) {
        if (string != null && bl) {
            MCExpressionBuilder mCExpressionBuilder = memberDef.getBuilder();
            mCExpressionBuilder.addFieldVarAccess(string);
            if (JavaRecognizer.verbose) {
                StringBuffer stringBuffer = nCVCallParserBinder.prepMemberAccessBuffer();
                stringBuffer.append("fieldvar-access{" + n + "}: " + string);
                nCVCallParserBinder.bindMemberAccess(stringBuffer);
            }
        }
    }

    public void endBindMethodCall() {
        super.endBindMethodCall();
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        boolean bl = javaRecognizer.isInMethodDef();
        int n2 = javaRecognizer.getCallDepth();
        if (n == 1 || !bl) {
            this.thunks.add(new Thunk(endBindMethodCallPass2Method, new Integer(n2), new Boolean(bl), (Object)this));
            return;
        }
        NCVCallParserBinder.endBindMethodCallPass2(n2, bl, this);
    }

    private static void endBindMethodCallPass2(int n, boolean bl, NCVCallParserBinder nCVCallParserBinder) {
        if (JavaRecognizer.verbose && bl && n == 0 && nCVCallParserBinder.callStack.size() > 0) {
            LinkedList linkedList = nCVCallParserBinder.callStack;
            LinkedList<String> linkedList2 = new LinkedList<String>();
            CallItem callItem = (CallItem)linkedList.getLast();
            while (callItem.callDepth == 1) {
                linkedList.removeLast();
                linkedList2.add(callItem.text);
                if (linkedList.size() == 0) break;
                callItem = (CallItem)linkedList.getLast();
            }
            while (linkedList2.size() > 0) {
                nCVCallParserBinder.logln((String)linkedList2.removeLast());
            }
        }
    }

    public void reportNcvCalls(String string) {
        NCVCallParserBinder._logln((String)("*** starting NCV call checking report for: " + string));
        ClassDef classDef = ClassDefs.getClassDef(string);
        if (classDef == null) {
            NCVCallParserBinder._logln((String)(string + " not found..."));
            Iterator iterator = ClassDefs.getFqNameIterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                ClassDef classDef2 = ClassDefs.getClassDef(string2);
                NCVCallParserBinder._logln((String)("--- " + string2));
            }
        } else {
            int n = classDef.reportNcvCalls(true, false);
            int n2 = classDef.getMethodCount();
            NCVCallParserBinder._logln((String)("*** (" + n2 + ") considered " + n + " candidates"));
        }
        NCVCallParserBinder._logln((String)"");
    }

    static {
        parsingManager = ParsingManager.inst();
        endBindMethodDefPass2Method = NCVCallParserBinder.lookup("endBindMethodDefPass2", new Class[]{MemberDef.class});
        bindVariableDeclPass2Method = NCVCallParserBinder.lookup("bindVariableDeclPass2", new Class[]{Boolean.TYPE, String.class, String.class, NCVCallParserBinder.class, MemberDef.class});
        bindTypeCastPass2Method = NCVCallParserBinder.lookup("bindTypeCastPass2", new Class[]{Integer.TYPE, Boolean.TYPE, AST.class, NCVCallParserBinder.class, MemberDef.class});
        bindMethodCallPass2Method = NCVCallParserBinder.lookup("bindMethodCallPass2", new Class[]{Integer.TYPE, String.class, String.class, Integer.TYPE, NCVCallParserBinder.class, MemberDef.class});
        bindFieldVarAccessPass2Method = NCVCallParserBinder.lookup("bindFieldVarAccessPass2", new Class[]{Integer.TYPE, Boolean.TYPE, String.class, NCVCallParserBinder.class, MemberDef.class});
        endBindMethodCallPass2Method = NCVCallParserBinder.lookup("endBindMethodCallPass2", new Class[]{Integer.TYPE, Boolean.TYPE, NCVCallParserBinder.class});
    }
}

