/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IQueue;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.ThreadedQueue;
import cerent.util.UObservable;
import java.util.StringTokenizer;

public class BoundedQueue
extends UObservable
implements IQueue {
    protected final String RAISE_CMD = "raise";
    protected final String CLEAR_CMD = "clear";
    private final String theMaxQueueSizeStr = "MaxQueueSize";
    private final String theElapsedTimeStr = "ClearElapsedTime";
    private final int theDefaultQueueSize = 5000;
    private final long theDefaultElapsedTime = 60000L;
    private ThreadedQueue theQueue = null;
    private int theMaxQueueSize = 0;
    private long theElapsedTime = 0L;
    private int theQueueAt90 = 0;
    private int theQueueAt80 = 0;
    private boolean theRaised90 = false;
    private boolean theRaised100 = false;
    private long theTimeAt90 = 0L;
    private long theTimeAt100 = 0L;
    protected SDebug db;

    public BoundedQueue(String string) {
        String string2 = Preferences.instance().getProperty(string, "MaxQueueSize", null);
        String string3 = Preferences.instance().getProperty(string, "ClearElapsedTime", null);
        if (string2 == null || string3 == null) {
            int n = string.lastIndexOf(".");
            if (string2 == null && n != -1) {
                string2 = Preferences.instance().getProperty(string.substring(n + 1), "MaxQueueSize", null);
            }
            if (string3 == null && n != -1) {
                string3 = Preferences.instance().getProperty(string.substring(n + 1), "ClearElapsedTime", null);
            }
        }
        this.setQueueSize(string2 != null ? Integer.parseInt(string2) : 5000);
        this.setElapsedTime(string3 != null ? (long)Integer.parseInt(string3) : 60000L);
        this.setQueueName(string);
    }

    public BoundedQueue(String string, int n, long l) {
        this.setQueueSize(n);
        this.setElapsedTime(l);
        this.setQueueName(string);
    }

    public void enqueue(Object object) {
        this.enqueue(object, true);
    }

    public void enqueue(Object object, boolean bl) {
        int n = this.theQueue.size();
        long l = System.currentTimeMillis();
        if (this.db.on()) {
            this.db.println("[" + this.theQueue.getName() + "] Calling enqueue size=" + n);
        }
        if (n < this.theQueueAt90) {
            this.clearNotifications();
            this.theQueue.enqueue(object, bl);
        } else if (n >= this.theQueueAt90 && n <= this.theMaxQueueSize - 1) {
            this.theQueue.enqueue(object, bl);
            this.theTimeAt90 = l;
            if (!this.theRaised90) {
                this.notifyObsAt90(true);
            }
        } else {
            this.theTimeAt100 = l;
            if (!this.theRaised100) {
                this.notifyObsAt100(true);
            }
        }
    }

    public Object dequeue() {
        Object object = null;
        if (this.db.on()) {
            this.db.println("[" + this.theQueue.getName() + "] Calling dequeue, size=" + this.theQueue.size());
        }
        object = this.theQueue.dequeue();
        this.clearNotifications();
        return object;
    }

    public int size() {
        return this.theQueue.size();
    }

    public void clear() {
        this.theQueue.clear();
        this.clearNotifications();
    }

    public boolean isFull() {
        return this.theQueue.size() == this.theMaxQueueSize;
    }

    public void extractCmdAndPerct(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        stringBuffer.replace(0, stringBuffer.length(), stringTokenizer.nextToken());
        stringBuffer2.replace(0, stringBuffer2.length(), stringTokenizer.nextToken());
    }

    protected int getMaxQueueSize() {
        return this.theMaxQueueSize;
    }

    private void setQueueSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("The MaxQueueSize given must be greater than 0");
        }
        this.theMaxQueueSize = n;
        this.theQueueAt90 = (int)((double)this.theMaxQueueSize * 0.9);
        this.theQueueAt80 = (int)((double)this.theMaxQueueSize * 0.8);
    }

    private void setElapsedTime(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("The ElapsedTime given must be greater than 0");
        }
        this.theElapsedTime = l;
    }

    private void setQueueName(String string) {
        this.theQueue = new ThreadedQueue(string);
    }

    private void clearNotifications() {
        long l = System.currentTimeMillis();
        int n = this.theQueue.size();
        if (this.theRaised90) {
            if (this.db.on()) {
                this.db.println("Time90=" + this.theTimeAt90 + ", CurrentTime=" + l);
            }
            if (l - this.theTimeAt90 > this.theElapsedTime && n < this.theQueueAt80) {
                this.theTimeAt90 = 0L;
                this.notifyObsAt90(false);
            }
        }
        if (this.theRaised100) {
            if (this.db.on()) {
                this.db.println("Time100=" + this.theTimeAt100 + ", CurrentTime=" + l);
            }
            if (l - this.theTimeAt100 > this.theElapsedTime && n < this.theQueueAt90) {
                this.theTimeAt100 = 0L;
                this.notifyObsAt100(false);
            }
        }
    }

    private void notifyObsAt90(boolean bl) {
        this.theRaised90 = bl;
        this.notifyObs(bl ? "raise,90" : "clear,90");
    }

    private void notifyObsAt100(boolean bl) {
        this.theRaised100 = bl;
        this.notifyObs(bl ? "raise,100" : "clear,100");
    }

    private void notifyObs(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }
}

