/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.OrderedListListener;
import cerent.util.gui.row.SortDirectionIconFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OrderedListModel
extends AbstractListModel
implements ActionListener,
ListSelectionListener {
    private static final SDebug db = new SDebug("OrderedListModel");
    private JList list;
    private HashMap map;
    private ArrayList content = new ArrayList();
    public static final String UP = "Up";
    public static final String DOWN = "Down";
    public static final String REMOVE = "Remove";
    private ActionOrganizer org;
    private OrderedListListener listener;
    private boolean ordered;

    public OrderedListModel(OrderedListListener orderedListListener, boolean bl) {
        this.map = new HashMap();
        this.list = new JList(this);
        this.org = new ActionOrganizer(this);
        if (bl) {
            this.org.createButton(SortDirectionIconFactory.getIcon((boolean)true), UP);
            this.org.createButton(SortDirectionIconFactory.getIcon((boolean)false), DOWN);
        }
        this.ordered = bl;
        this.org.createButton(REMOVE);
        this.listener = orderedListListener;
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
    }

    public void setListRenderer(ListCellRenderer listCellRenderer) {
        if (this.list != null && listCellRenderer != null) {
            this.list.setCellRenderer(listCellRenderer);
            if (db.on()) {
                db.println("List renderer is now: " + listCellRenderer.getClass().getName());
            }
        }
    }

    public void clearAll() {
        this.content.clear();
        this.map.clear();
        this.list.removeAll();
        this.syncButtons();
    }

    public AbstractButton getButton(String string) {
        return this.org.getAbstractButton(string);
    }

    public JList getJList() {
        return this.list;
    }

    public void add(Object object, String string) {
        int n = this.content.size();
        this.content.add(object);
        this.map.put(object, string);
        this.fireIntervalAdded(this, n, n);
        this.list.setSelectedIndex(n);
        this.syncButtons();
    }

    public void remove(Object object) {
        for (int i = 0; i < this.content.size(); ++i) {
            if (this.content.get(i) != object) continue;
            this.content.remove(i);
            this.map.remove(object);
            if (db.on()) {
                db.println("fireIntervalRemoved() start, index=" + i);
            }
            this.fireIntervalRemoved(this, i, i);
            if (db.on()) {
                db.println("fireIntervalRemoved() end, index=" + i);
            }
            if (i < this.content.size()) {
                this.list.setSelectedIndex(i);
            } else if (!this.content.isEmpty()) {
                this.list.setSelectedIndex(this.content.size() - 1);
            }
            this.syncButtons();
            this.listener.entryRemoved(object);
        }
    }

    public ArrayList getContent() {
        return this.content;
    }

    public Object getSelectedEntry() {
        int n = this.list.getSelectedIndex();
        if (n >= 0) {
            return this.content.get(n);
        }
        return null;
    }

    public boolean setSelectedEntry(Object object) {
        int n = this.content.indexOf(object);
        if (n >= 0) {
            this.list.setSelectedIndex(n);
            return true;
        }
        this.list.clearSelection();
        return false;
    }

    public boolean contains(Object object) {
        return this.map.get(object) != null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = this.list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (string == UP) {
            this.swapEntries(n - 1);
        } else if (string == DOWN) {
            this.swapEntries(n);
        } else if (string == REMOVE) {
            this.remove(this.content.get(n));
        }
    }

    public void swapEntries(int n) {
        if (n >= 0 && n < this.content.size()) {
            int n2 = this.list.getSelectedIndex();
            Object e = this.content.get(n);
            Object e2 = this.content.get(n + 1);
            this.content.set(n, e2);
            this.content.set(n + 1, e);
            this.fireContentsChanged(this, n, n + 1);
            if (n2 == n) {
                this.list.setSelectedIndex(n + 1);
            } else if (n2 == n + 1) {
                this.list.setSelectedIndex(n);
            }
            this.syncButtons();
            this.listener.orderSwapped(e2, e);
        }
    }

    public void syncButtons() {
        int n = this.list.getSelectedIndex();
        this.org.getAbstractButton(REMOVE).setEnabled(n >= 0);
        if (this.ordered) {
            this.org.getAbstractButton(UP).setEnabled(n > 0);
            this.org.getAbstractButton(DOWN).setEnabled(n >= 0 && n < this.content.size() - 1);
        }
    }

    public Object getElementAt(int n) {
        Object e = this.content.get(n);
        if (e != null) {
            String string = (String)this.map.get(e);
            ++n;
            if (this.ordered) {
                string = "(" + n + ") " + string;
            }
            return string;
        }
        return null;
    }

    public int getSize() {
        return this.content.size();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getLastIndex();
            this.syncButtons();
            Object var4_4 = null;
            Object var5_5 = null;
            if (this.content == null) {
                db.println("OrderedListModel::valueChanged() content null!");
                return;
            }
            int n3 = this.content.size();
            if (n3 == 0) {
                return;
            }
            if (db.on()) {
                db.println("valueChanged(), oldIdx=" + n + ", newIdx=" + n2);
            }
            if (n >= n3 || n2 >= n3) {
                if (db.on()) {
                    db.println("valueChanged()-- leaving because one index is bigger than contentSize.  oldIdx=" + n + "\tnewIdx=" + n2 + "\tcontentSize=" + n3);
                }
                return;
            }
            if (n == 0 && n2 == 0) {
                var4_4 = null;
                var5_5 = this.content.get(n2);
                if (var5_5 == null) {
                    return;
                }
            } else if (n != n2) {
                if (n >= 0) {
                    var4_4 = this.content.get(n);
                }
                try {
                    if (n2 >= 0) {
                        var5_5 = this.content.get(n2);
                    }
                }
                catch (Exception exception) {
                    var5_5 = null;
                }
                if (this.list.getSelectedIndex() == n) {
                    Object var7_8 = var4_4;
                    var4_4 = var5_5;
                    var5_5 = var7_8;
                }
            } else if (n == n2) {
                if (n > 0) {
                    var4_4 = this.content.get(n);
                }
                if (n2 > 0) {
                    var5_5 = this.content.get(n2);
                }
            }
            this.listener.selectionChanged(var4_4, var5_5);
        }
    }
}

