/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

import cerent.util.ior.CdrReader;
import cerent.util.ior.CdrWriter;
import cerent.util.ior.IopComponent;
import java.io.IOException;
import java.io.PrintStream;

public class SslTransport
implements IopComponent {
    private int _targetSupports;
    private int _targetRequires;
    private int _port;
    private static final int NO_PROTECTION = 1;
    private static final int INTEGRITY = 2;
    private static final int CONFIDENTIALITY = 4;
    private static final int DETECT_REPLAY = 8;
    private static final int DETECT_MISORDERING = 16;
    private static final int ESTABLISH_TRUST_IN_TARGET = 32;
    private static final int ESTABLISH_TRUST_IN_CLIENT = 64;
    private static final int NO_DELEGATION = 128;
    private static final int SIMPLE_DELEGATION = 256;
    private static final int COMPOSITE_DELEGATION = 512;
    private static final int OTHER = 64512;

    public SslTransport(CdrReader cdrReader) throws IOException {
        this._targetSupports = cdrReader.getShort();
        this._targetRequires = cdrReader.getShort();
        this._port = cdrReader.getShort();
    }

    public CdrWriter write(CdrWriter cdrWriter) {
        cdrWriter.putShort(this._targetSupports);
        cdrWriter.putShort(this._targetRequires);
        cdrWriter.putShort(this._port);
        return cdrWriter;
    }

    public void print(PrintStream printStream, String string) {
        printStream.println(string + "SSL Secure Transport:");
        printStream.println(string + "   Supports = " + this.asAssociationOptions(this._targetSupports));
        printStream.println(string + "   Requires = " + this.asAssociationOptions(this._targetRequires));
        printStream.println(string + "   port     = " + this._port);
    }

    public int getSslPort() {
        return this._port;
    }

    public void setSslPort(int n) {
        this._port = n;
    }

    private String asAssociationOptions(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        if ((n & 1) != 0) {
            stringBuffer.append("NoProtection ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("Integrity ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("Confidentiality ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("DetectReplay ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("DetectMisordering ");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("EstablishTrustInTarget ");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append("EstablishTrustInClient ");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("NoDelegation ");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("SimpleDelegation ");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("CompositeDelegation ");
        }
        if ((n & 0xFC00) != 0) {
            stringBuffer.append("Others: 0x" + Integer.toHexString(n & 0xFC00));
        }
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }
}

