/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc310cl.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractEntityModelFactory;
import cerent.cms.model.BbeModuleModel;
import cerent.cms.model.BbeSlot;
import cerent.cms.model.CtxClModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FillerModuleModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SlotModel;
import cerent.cms.model.WbeSlot;
import cerent.util.KDebug;
import cerent.util.SDebug;

public class EntityModelFactory
extends AbstractEntityModelFactory {
    private static ModelSingletonCollection entityModelFactorySingletons;

    public static synchronized EntityModelFactory getInstance(NodeModelDelegate nodeModelDelegate) {
        EntityModelFactory entityModelFactory;
        if (entityModelFactorySingletons == null) {
            entityModelFactorySingletons = ModelSingletonCollection.getMSCInstanceByName((String)"EntityModelFactory");
        }
        if ((entityModelFactory = (EntityModelFactory)entityModelFactorySingletons.get((Object)nodeModelDelegate)) == null) {
            entityModelFactory = new EntityModelFactory(nodeModelDelegate);
            entityModelFactorySingletons.add((Object)nodeModelDelegate, (Object)entityModelFactory);
        }
        return entityModelFactory;
    }

    private EntityModelFactory(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate, new SDebug((KDebug)nodeModelDelegate.getDebug(), "EntityModelFactory"));
    }

    public EntityModel makeEntityModel(Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        EntityModel entityModel = null;
        switch (eEqType2.value()) {
            case 157: {
                entityModel = new CtxClModuleModel(this.node, entity, n, eEqType2, eClass2, n2);
                break;
            }
            case 160: {
                entityModel = new BbeModuleModel(this.node, entity, n, eEqType2, eClass2, n2);
                break;
            }
            case 158: {
                entityModel = new SlotModel(this.node, entity, n, eEqType2, eClass2, n2);
                break;
            }
            case 159: {
                entityModel = new BbeSlot(this.node, entity, n, eEqType2, eClass2, n2);
                break;
            }
            case 161: {
                entityModel = new WbeSlot(this.node, entity, n, eEqType2, eClass2, n2);
                break;
            }
            case 163: 
            case 164: {
                entityModel = new ML2ModuleModel(this.node, entity, n, eEqType2, eClass2, n2);
                break;
            }
            case 166: {
                entityModel = new ML2EtherPortModel(this.node, entity, n, eEqType2, eClass2, n2);
                break;
            }
            case 165: {
                entityModel = new ML2PosPortModel(this.node, entity, n, eEqType2, eClass2, n2);
                break;
            }
            case 125: {
                entityModel = new FillerModuleModel(this.node, entity, n, eEqType2, eClass2, n2);
                break;
            }
            default: {
                entityModel = super.makeEntityModel(entity, n, eEqType2, eClass2, n2);
            }
        }
        return entityModel;
    }
}

