/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc310ma.ui;

import cerent.cms.model.BbeModuleModel;
import cerent.cms.model.CtxMaModuleModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.MainTabbedView;
import cerent.cms.ui.bbe.BbeCardTabbedView;
import cerent.cms.ui.ctx.CtxMaCardTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.ml2.ML2CardTabbedView;
import cerent.cms.ui.wbe.WbeCardTabbedView;

public class PlatformCardTabbedViewFactory
extends CardTabbedViewFactory {
    private static PlatformCardTabbedViewFactory instance = new PlatformCardTabbedViewFactory();

    private PlatformCardTabbedViewFactory() {
    }

    public static PlatformCardTabbedViewFactory instance() {
        return instance;
    }

    private static MainTabbedView createCtxCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new CtxMaCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createBbeCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new BbeCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createML2Ctv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new ML2CardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createWbeCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new WbeCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    public MainTabbedView getCardView(IModuleModel iModuleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        MainTabbedView mainTabbedView = null;
        ModuleModel moduleModel = (ModuleModel)iModuleModel;
        switch (moduleModel.getEqType()) {
            case 232: {
                mainTabbedView = PlatformCardTabbedViewFactory.createCtxCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 235: {
                mainTabbedView = PlatformCardTabbedViewFactory.createBbeCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 163: 
            case 164: {
                mainTabbedView = PlatformCardTabbedViewFactory.createML2Ctv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 233: 
            case 234: {
                mainTabbedView = PlatformCardTabbedViewFactory.createWbeCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            default: {
                mainTabbedView = super.getCardView(moduleModel, iEventPanelController, iUiToolkit);
            }
        }
        return mainTabbedView;
    }

    public static boolean isCardViewAvailable(IModuleModel iModuleModel) {
        boolean bl = false;
        switch (iModuleModel.getEqType()) {
            case 232: {
                bl = iModuleModel instanceof CtxMaModuleModel;
                break;
            }
            case 160: {
                bl = iModuleModel instanceof BbeModuleModel;
                break;
            }
            case 163: {
                bl = true;
                break;
            }
            case 164: {
                bl = true;
                break;
            }
            default: {
                bl = CardTabbedViewFactory.isCardViewAvailable(iModuleModel);
            }
        }
        return bl;
    }
}

