/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc327.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.EventInfo;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

class FanGraphic
extends JLabel
implements Observer {
    protected ElementAlarmStore alarmStore;
    protected AlarmStatus alarmStatus = null;
    protected eEqState eqState = null;
    private int severity;
    private char state;
    protected Color fgColor = Color.white;
    protected Color currentColor = Color.white;
    private int nodeId;
    MfgEntityModel m = null;
    private static final int HEIGHT = 200;
    private static final int WIDTH = 100;
    public static final Dimension FAN_DIM = new Dimension(100, 200);
    private static final SDebug db = new SDebug("FanGraphic");

    public FanGraphic(MfgEntityModel mfgEntityModel, String string) {
        super(string, 0);
        this.m = mfgEntityModel;
        this.initialize();
    }

    public String toString() {
        return "FAN";
    }

    public synchronized void refreshCard(boolean bl) {
        block14: {
            EventInfo eventInfo = null;
            String string = null;
            try {
                if (bl) {
                    ArrayList arrayList = this.alarmStore.getAlarmByCondition(122);
                    if (arrayList.size() == 0) {
                        this.showAlarmStatus(1, 'C', string);
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        eventInfo = (EventInfo)arrayList.get(i);
                        if (eventInfo.getCondition() != 122) continue;
                        this.severity = eventInfo.getSeverity();
                        this.state = eventInfo.getState();
                        this.showAlarmStatus(this.severity, this.state, string);
                        if (this.severity == 4) break;
                    }
                    if (db.on()) {
                        db.println("AlarmStatus = " + this.severity);
                    }
                } else {
                    if (db.on()) {
                        db.println("Got an update message in Card Graphic");
                    }
                    this.eqState = this.m.getState();
                    if (this.eqState == null) {
                        string = "Unknown";
                    } else {
                        string = this.getStateString();
                        switch (this.eqState.value()) {
                            case 0: {
                                this.setText("No FAN");
                                this.currentColor = Color.white;
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                this.setText("FAN");
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block14;
                db.println("failed to refresh the card");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.repaint();
    }

    private void showAlarmStatus(int n, char c, String string) {
        if (c == 'C') {
            this.setStatus(0);
        } else {
            switch (n) {
                case 1: {
                    this.setStatus(0);
                    break;
                }
                case 2: {
                    this.setStatus(1);
                    string = string + ", Minor Alarm";
                    break;
                }
                case 3: {
                    this.setStatus(2);
                    string = string + ", Major Alarm";
                    break;
                }
                case 4: {
                    this.setStatus(3);
                    string = string + ", Critical Alarm";
                    break;
                }
                default: {
                    this.setStatus(0);
                }
            }
        }
    }

    public synchronized void setStatus(int n) {
        this.fgColor = Color.black;
        switch (n) {
            case 0: {
                this.currentColor = Color.white;
                break;
            }
            case 3: {
                this.currentColor = ElementDefaults.CRITICAL_ALARM_COLOR;
                this.fgColor = Color.white;
                break;
            }
            case 2: {
                this.currentColor = ElementDefaults.MAJOR_ALARM_COLOR;
                break;
            }
            case 1: {
                this.currentColor = ElementDefaults.MINOR_ALARM_COLOR;
            }
        }
        this.setBackground(this.currentColor);
        this.setForeground(this.fgColor);
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (db.on()) {
                    db.println("Got an update message in Card Graphic");
                }
                this.refreshCard(false);
            }
        } else {
            this.refreshCard(true);
        }
    }

    private void initialize() {
        this.alarmStore = (ElementAlarmStore)this.m.getNodeModel().getElementAlarmStore();
        this.alarmStore.addAlarmStatusObserver(this);
        if (this.m != null) {
            this.m.addObserver(this);
        }
        this.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.currentColor = Color.white;
        this.setBackground(this.currentColor);
        this.refreshCard(true);
        this.refreshCard(false);
        this.setStatus(0);
    }

    public void destroy() {
        this.alarmStore.deleteAlarmStatusObserver(this);
        this.alarmStore = null;
        if (this.m != null) {
            this.m.deleteObserver(this);
            this.m = null;
        }
    }

    protected String getStateString() {
        return ElementDefaults.eqStateToString(this.eqState);
    }
}

