/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc327.ui.shelf;

import cerent.cms.model.IChassisModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardPanel;
import cerent.util.gui.IconImpl;
import com.cisco.ctc327.ui.shelf.CardPainter;
import com.cisco.ctc327.ui.shelf.FanGraphic;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShelfLayout
extends AbstractShelfLayout {
    static final int SHELF_SLOT_COUNT = 8;
    static final Font TEXT_FONT = new Font("Arial", 0, 10);
    static int[] slot2x = new int[]{0, 0, 0, 0, 1, 1, 1, 1};
    static int[] slot2y = new int[]{3, 2, 1, 0, 0, 1, 2, 3};
    protected FanGraphic fanLabel;
    protected static JPanel rightLabelsPanel;

    public ShelfLayout(IChassisModel iChassisModel, ShelfViewController shelfViewController) {
        super(iChassisModel, shelfViewController);
    }

    protected int getShelfSlotCount() {
        return 8;
    }

    protected Font getTextFont() {
        return TEXT_FONT;
    }

    protected void createLabels() {
        if (this.labelsPanel == null) {
            this.labelsPanel = new JPanel(new GridLayout(4, 1, 0, 0));
            rightLabelsPanel = new JPanel(new GridLayout(4, 1, 0, 0));
            Dimension dimension = new Dimension(10, 12);
            this.labels = new JLabel[8];
            for (int i = 0; i < this.cards.length; ++i) {
                JLabel jLabel = new JLabel();
                jLabel.setFont(TEXT_FONT);
                jLabel.setPreferredSize(dimension);
                jLabel.setMinimumSize(dimension);
                jLabel.setHorizontalAlignment(0);
                if (i < 4) {
                    jLabel.setText("" + (4 - i));
                    this.labels[3 - i] = jLabel;
                    this.labelsPanel.add(jLabel);
                    continue;
                }
                jLabel.setText("" + (i + 1));
                this.labels[i] = jLabel;
                rightLabelsPanel.add(jLabel);
            }
        }
    }

    protected void createFanPanel() {
        MfgEntityModel mfgEntityModel = null;
        List list = this.chassis.getDescendantsOfEqType(27);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MfgEntityModel mfgEntityModel2 = (MfgEntityModel)iterator.next();
            if (mfgEntityModel2.getEqType() != 27) continue;
            mfgEntityModel = mfgEntityModel2;
            break;
        }
        if (mfgEntityModel != null) {
            this.fanLabel = new FanGraphic(mfgEntityModel, "FAN");
            this.fanLabel.setPreferredSize(FanGraphic.FAN_DIM);
            this.fanLabel.setFont(TEXT_FONT);
        }
    }

    protected void createSlotsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.slotsPanel = new JPanel(gridBagLayout);
        Dimension dimension = new Dimension(450, 200);
        this.slotsPanel.setMinimumSize(dimension);
        for (int i = 0; i < 8; ++i) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = slot2x[i];
            gridBagConstraints.gridy = slot2y[i];
            IconImpl iconImpl = new IconImpl(CardPainter.getSlotDim(i + 1));
            this.cards[i] = new CardPanel(iconImpl, this);
            this.cards[i].setFont(TEXT_FONT);
            this.cards[i].addMouseListener(this.mouseListener);
            gridBagLayout.setConstraints(this.cards[i], gridBagConstraints);
            this.slotsPanel.add(this.cards[i]);
        }
    }

    protected void addLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelsPanel, gridBagConstraints);
        this.add(this.labelsPanel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(rightLabelsPanel, gridBagConstraints);
        this.add(rightLabelsPanel);
    }

    protected void removeLabels() {
        this.remove(this.labelsPanel);
        this.remove(rightLabelsPanel);
    }

    protected void addPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.slotsPanel, gridBagConstraints);
        this.add(this.slotsPanel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        ((GridBagLayout)this.getLayout()).setConstraints(this.fanLabel, gridBagConstraints);
        this.add(this.fanLabel);
    }

    public void destroy() {
        this.fanLabel.destroy();
        this.fanLabel = null;
        super.destroy();
    }
}

