/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc327.ui.xtc;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.aic.EnvAlarmPanesFactory;
import cerent.cms.ui.aic.EnvControlPanesFactory;
import cerent.cms.ui.ds1.Ds1ProvPane;
import cerent.cms.ui.ds3.Ds3ProvPane;
import java.awt.Component;

public class XtcProvPane
extends NodeProvPane {
    public XtcProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, EnvAlarmModel[] envAlarmModelArray, EnvControlModel[] envControlModelArray) {
        super(string, tabbedView);
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        ModuleModel moduleModel = (ModuleModel)this.getUiModel();
        this.subTabs.addTab("DS1", (Component)this.getDs1Tab(this.subTabs, ds123LineModelArray));
        if (ds123LineModelArray2.length > 0) {
            this.subTabs.addTab("DS3", (Component)this.getDs3Tab(this.subTabs, ds123LineModelArray2));
        }
        this.subTabs.addTab("External Alarms", (Component)this.getExtAlarmsTab(this.subTabs, moduleModel, envAlarmModelArray));
        this.subTabs.addTab("External Controls", (Component)this.getExtControlsTab(this.subTabs, moduleModel, envControlModelArray));
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    private Pane getDs1Tab(TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        return new Ds1ProvPane("DS1", tabbedView, ds123LineModelArray, false);
    }

    private Pane getDs3Tab(TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        return new Ds3ProvPane("DS3", tabbedView, ds123LineModelArray, false);
    }

    private Pane getExtAlarmsTab(TabbedView tabbedView, ModuleModel moduleModel, EnvAlarmModel[] envAlarmModelArray) {
        EnvAlarmPanesFactory envAlarmPanesFactory = new EnvAlarmPanesFactory(tabbedView, envAlarmModelArray);
        return new ProtCardDualPane(tabbedView, moduleModel, envAlarmPanesFactory.getEnvAlarmProvTab());
    }

    private Pane getExtControlsTab(TabbedView tabbedView, ModuleModel moduleModel, EnvControlModel[] envControlModelArray) {
        EnvControlPanesFactory envControlPanesFactory = new EnvControlPanesFactory(tabbedView, envControlModelArray);
        return new ProtCardDualPane(tabbedView, moduleModel, envControlPanesFactory.getEnvControlProvTab());
    }

    public boolean hasSubTabs() {
        return true;
    }
}

