/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.ds3xm12;

import cerent.cms.idl.Ds123Media.mFdl;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.Ds3xmLineUpdate;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ElementPmCellRenderer;
import cerent.cms.ui.PmCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1.Ds1BfdlPmTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Observable;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class Ds3xm12BfdlPmPane
extends AbstractPane
implements ActionListener,
PropertyChangeListener,
TableModelListener {
    private TableColumnModel dataColumnModel;
    protected int indexOfFirstCB;
    private static final String LONGEST_PARAM_NAME = "Transceiver Voltage (Unit)";
    private static final int DS1_COUNT_FOR_STS48C = 672;
    public static final String REFRESH = "Refresh";
    protected JPanel controlBar;
    private JButton refreshPB;
    protected JLabel dateLB;
    private JComboBox ds1CB;
    private JComboBox ds3CB;
    private JComboBox pmReqTypeCB;
    private static final String autoRefreshPrefPath = "ctc";
    private static final String autoRefreshPrefKey = "PM-auto-refresh-rate";
    private TableColumn colZero = null;
    protected JTable table2 = null;
    protected Ds1BfdlPmTableModel model;
    protected Ds123LineModel[] lineModels;
    protected Ds123ModuleModel eqpmtModel;
    protected int numLines;
    protected boolean isSts48c;
    private String[] pmRequestType;
    private String[] ds3Strings48c;
    private String[] ds3Strings12c;
    private String[] ds1Strings;
    private int numDs3s = 0;
    private NodeModelDelegate nodeModel;
    private static final SDebug db = new SDebug("Ds3xmBfdlPmPane");

    public Ds3xm12BfdlPmPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView);
        int n;
        this.lineModels = ds123LineModelArray;
        this.numLines = this.lineModels != null ? this.lineModels.length : 0;
        this.isSts48c = this.numLines == 672;
        String[] stringArray = new String[]{"Enhanced ES One Day", "Enhanced UAS One Day", "Enhanced BES One Day", "Enhanced SES One Day", "Enhanced CSS/LOFC One Day"};
        this.pmRequestType = stringArray;
        this.ds3Strings12c = new String[18];
        this.ds3Strings48c = new String[24];
        int n2 = 0;
        for (n = 0; n < 36; ++n) {
            if (n > 12 && n % 2 == 1) continue;
            this.ds3Strings48c[n2] = Integer.toString(n + 1);
            if (n < 24) {
                this.ds3Strings12c[n2] = Integer.toString(n + 1);
            }
            ++n2;
        }
        this.ds1Strings = new String[28];
        for (n = 0; n < 28; ++n) {
            this.ds1Strings[n] = Integer.toString(n + 1);
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.setLayout(new BorderLayout());
        this.model = this.getDataModel();
        this.add(this.createButtonBar(), "South");
        this.add(this.createTable(), "Center");
        Object var6_7 = null;
        this.model.addTableModelListener(this);
        this.ds3CB.setSelectedIndex(0);
        this.nodeModel = ((ModuleModel)this.getUiModel()).getNodeModelDelegate();
        this.registerWithModel();
    }

    protected Ds1BfdlPmTableModel getDataModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        return new Ds1BfdlPmTableModel(iNodeModel, this.lineModels);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setCursor(3);
        Object object = actionEvent.getSource();
        if (object == this.refreshPB) {
            if (db.on()) {
                db.println("class name = " + this.getClass().getName());
            }
            this.refreshNow();
        } else if (object == this.ds3CB) {
            int n = this.ds3CB.getSelectedIndex();
            int n2 = n * 28;
            Object[] objectArray = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < 28; ++i) {
                try {
                    if (this.lineModels[i + n2].getConfig().fdlModeMask != mFdl.FDL_ATT_54016.value()) continue;
                    arrayList.add(String.valueOf(i + 1));
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    // empty catch block
                }
            }
            if (arrayList.isEmpty()) {
                this.ds1CB.setEnabled(false);
                this.ds1CB.setSelectedItem(null);
            } else {
                this.ds1CB.setEnabled(true);
                objectArray = arrayList.toArray();
                this.ds1CB.setModel(new DefaultComboBoxModel<Object>(objectArray));
            }
        }
        this.setCursor(0);
    }

    private JComponent createTable() {
        this.table = new UTable((TableModel)this.model);
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(this.model.getColumnClass(1), this.getPmCellRenderer());
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table2 = new UTable((TableModel)this.model);
        ((UTable)this.table2).setExportable(false);
        this.table2.getTableHeader().setUpdateTableInRealTime(false);
        this.dataColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        this.colZero = this.dataColumnModel.getColumn(0);
        Font font = this.table.getTableHeader().getFont();
        FontMetrics fontMetrics = this.table.getTableHeader().getFontMetrics(font);
        int n = fontMetrics.stringWidth(LONGEST_PARAM_NAME) + 20;
        this.colZero.setPreferredWidth(n);
        this.colZero.setMinWidth(n);
        this.dataColumnModel.removeColumn(this.colZero);
        defaultTableColumnModel.addColumn(this.colZero);
        this.table2.setColumnModel(defaultTableColumnModel);
        this.table2.setPreferredScrollableViewportSize(new Dimension(this.colZero.getPreferredWidth() + this.table2.getColumnModel().getColumnMargin(), 0));
        this.table2.getTableHeader().setReorderingAllowed(false);
        uScrollPane.setRowHeaderView((Component)this.table2);
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)this.table2.getTableHeader());
        this.table.setAutoCreateColumnsFromModel(false);
        this.table2.setAutoCreateColumnsFromModel(false);
        this.colZero.addPropertyChangeListener(this);
        return uScrollPane;
    }

    private JPanel createButtonBar() {
        if (db.on()) {
            db.println("createButtonBar");
        }
        JPanel jPanel = Ds3xm12BfdlPmPane.createVerticalPanel(null);
        JPanel jPanel2 = Ds3xm12BfdlPmPane.createHorizontalPanel(null);
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        this.controlBar = Ds3xm12BfdlPmPane.createHorizontalPanel(null);
        this.indexOfFirstCB = this.controlBar.getComponentCount();
        this.pmReqTypeCB = new UComboBox((Object[])this.pmRequestType);
        this.controlBar.add(Box.createHorizontalGlue());
        this.controlBar.add(new JLabel("Request:"));
        this.controlBar.add(Box.createHorizontalStrut(4));
        this.controlBar.add(this.pmReqTypeCB);
        this.ds3CB = this.isSts48c ? new UComboBox((Object[])this.ds3Strings48c) : new UComboBox((Object[])this.ds3Strings12c);
        this.ds3CB.addActionListener(this);
        this.controlBar.add(Box.createHorizontalGlue());
        this.controlBar.add(new JLabel("DS3:"));
        this.controlBar.add(Box.createHorizontalStrut(4));
        this.controlBar.add(this.ds3CB);
        this.ds1CB = new UComboBox((Object[])this.ds1Strings);
        this.controlBar.add(Box.createHorizontalGlue());
        this.controlBar.add(new JLabel("DS1:"));
        this.controlBar.add(Box.createHorizontalStrut(4));
        this.controlBar.add(this.ds1CB);
        this.controlBar.add(Box.createHorizontalGlue());
        this.controlBar.add(new JLabel("  "));
        this.controlBar.add(Box.createHorizontalStrut(4));
        this.refreshPB = new JButton(REFRESH);
        this.refreshPB.addActionListener(this);
        this.refreshPB.setAlignmentY(0.5f);
        this.controlBar.add(Box.createHorizontalStrut(4));
        this.controlBar.add(this.refreshPB);
        this.controlBar.add(Box.createHorizontalGlue());
        this.controlBar.add(Box.createHorizontalStrut(4));
        CSHelpID cSHelpID = this.getHelpID();
        if (cSHelpID != null) {
            CSHelpButton cSHelpButton = new CSHelpButton(cSHelpID);
            cSHelpButton.setMinimumSize(new Dimension(75, cSHelpButton.getPreferredSize().height));
            cSHelpButton.setAlignmentY(0.5f);
            this.controlBar.add(cSHelpButton);
            this.controlBar.add(Box.createHorizontalStrut(4));
        }
        this.dateLB = new JLabel("");
        this.updateTimeLabel();
        jPanel2.add(this.dateLB);
        jPanel.add(this.controlBar);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void reDraw() {
        if (db.on()) {
            db.println("reDraw");
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this.model);
        this.table.tableChanged(tableModelEvent);
        if (this.table2 != null) {
            this.table2.tableChanged(tableModelEvent);
        }
    }

    protected void updateTimeLabel() {
        String string = DateFormat.getDateTimeInstance(1, 1).format(new Date());
        String string2 = "BFDL Far End Registers accessed: " + string;
        this.dateLB.setText(string2);
    }

    protected PmCellRenderer getPmCellRenderer() {
        return new ElementPmCellRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            this.refreshNow();
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
        this.updateTimeLabel();
    }

    public void dispose() {
    }

    public void update(Observable observable, Object object) {
    }

    public void applyChangesToModel() {
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    public void leavingPage() {
        if (null != this.table && this.table.isEditing()) {
            this.table.editingCanceled(new ChangeEvent(this.table));
        }
    }

    public void destroy() {
        try {
            this.leavingPage();
        }
        catch (Exception exception) {
            db.finer("Exception in destroy(): " + exception);
        }
        if (this.table2 != null) {
            this.table2 = null;
        }
        if (this.model != null) {
            // empty if block
        }
        super.destroy();
    }

    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.model.refreshFromModel();
    }

    protected void refreshNow() {
        int n = -1;
        if (this.ds1CB.getSelectedItem() != null) {
            n = this.ds3CB.getSelectedIndex() * 28 + Integer.valueOf((String)this.ds1CB.getSelectedItem()) - 1;
        }
        int n2 = this.pmReqTypeCB.getSelectedIndex();
        this.model.refreshModel(n, n2);
        this.reDraw();
        this.updateTimeLabel();
    }

    public void refresh() {
    }

    public CSHelpID getHelpID() {
        TabbedView tabbedView = this.getParentView();
        return CSHelpConst.Ds3xm12BfdlPmPane;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.table2.setPreferredScrollableViewportSize(new Dimension(this.colZero.getWidth() + this.table2.getColumnModel().getColumnMargin(), 0));
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3xmLineUpdate) {
            if (db.on()) {
                db.info("Received Ds3xmLineUpdate..");
            }
            this.lineModels = ((Ds3xmLineUpdate)object).getDs1s();
            if (this.lineModels.length == 672) {
                this.ds3CB.setModel(new DefaultComboBoxModel<String>(this.ds3Strings48c));
            } else {
                this.ds3CB.setModel(new DefaultComboBoxModel<String>(this.ds3Strings12c));
            }
        }
    }
}

