/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.ds3xm12;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.cms.ui.pm.PmLayerDs1NetworkPath;
import com.cisco.ctc454.ui.ds3xm12.PmLayerDs3xm12Ds1Path;

public class PmLayerDs3xm12Ds1
extends PmLayer {
    protected int numParms;
    protected int pathCount;
    protected PmLayer pathLayer;
    protected int pathCountNet;
    protected PmLayer pathLayerNet;

    public PmLayerDs3xm12Ds1(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        this.pathLayer = new PmLayerDs3xm12Ds1Path(pmTableModel, ds123LineModel, n);
        this.pathLayerNet = new PmLayerDs1NetworkPath(pmTableModel, ds123LineModel, n);
        this.pathCount = this.pathLayer.parmCount();
        this.pathCountNet = this.pathLayerNet.parmCount();
        this.numParms = this.pathCount + this.pathCountNet;
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        this.pathLayer.clearStats();
    }

    public boolean hasFarEnd() {
        return this.pathLayer.hasFarEnd() || this.pathLayerNet.hasFarEnd();
    }

    public void setNearEnd(boolean bl) {
        this.pathLayer.setNearEnd(bl);
        this.pathLayerNet.setNearEnd(bl);
    }

    public void setIntervalType(eIntervalType eIntervalType2) {
        this.pathLayer.setIntervalType(eIntervalType2);
        this.pathLayerNet.setIntervalType(eIntervalType2);
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (n < this.pathCount) {
            return this.pathLayer.getPmValue(n, n2);
        }
        return this.pathLayerNet.getPmValue(n -= this.pathCount, n2);
    }

    public String layerLabel() {
        return "DS1";
    }

    public int parmCount() {
        return this.numParms;
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.pathLayer.refreshPmStats(n);
        this.pathLayerNet.refreshPmStats(n);
        this.fromPeerCard = this.pathLayer.isFromPeerCard() || this.pathLayerNet.isFromPeerCard();
    }

    public String parmName(int n) {
        if (n < this.pathCount) {
            return this.pathLayer.parmName(n);
        }
        return this.pathLayerNet.parmName(n -= this.pathCount);
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.pathLayer.setModel(interfaceModel);
        this.pathLayerNet.setModel(interfaceModel);
    }

    public void tossData() {
        this.pathLayer.tossData();
        this.pathLayerNet.tossData();
        this.fromPeerCard = false;
    }

    public void destroy() {
        this.pathLayer.destroy();
        this.pathLayerNet.destroy();
        super.destroy();
    }
}

