/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CardPainter
implements ICardPainter {
    public static final float CARD_H_TO_CARD_W_RATIO = 9.166667f;
    private static final float PORT_W_TO_CARD_W_RATIO = 0.41666666f;
    private static final float OPTICON_Y_OFFSET_TO_CARD_H_RATIO = 0.3181818f;
    private static final float OPTICON_Y_SPACING_TO_CARD_H_RATIO = 0.11363637f;
    public static final int CARD_WIDTH = 30;
    public final int CARD_HEIGHT = Math.round((float)this.getCardWidth() * 9.166667f);
    private final int PORT_WIDTH = Math.round((float)this.getCardWidth() * 0.41666666f);
    private final int PORT_HEIGHT = this.PORT_WIDTH * 2;
    private final int SMALL_PORT_HEIGHT = this.PORT_WIDTH;
    private static final int PORT_LOOPBACK_DIST = 3;
    private final int PORT_CONN1_X;
    private final int PORT_CONN2_X = this.PORT_CONN1_X = this.PORT_WIDTH / 2;
    private final int PORT_CONN1_Y = this.PORT_HEIGHT / 3;
    private final int PORT_CONN2_Y = this.PORT_CONN1_Y * 2;
    private final int SMALL_PORT_CONN1_Y = this.SMALL_PORT_HEIGHT / 3;
    private final int SMALL_PORT_CONN2_Y = this.SMALL_PORT_CONN1_Y * 2;
    final int OPTICON_X_OFFSET = (this.getCardWidth() - this.PORT_WIDTH) / 2;
    private final int MULTIPORT_OPTICON_X_OFFSET = (this.getCardWidth() - this.PORT_WIDTH) / 2;
    private final int OPTICON_Y_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.3181818f);
    private final int HEIGHT = this.CARD_HEIGHT;
    private static final float RECT_H_TO_CARD_H_RATIO = 0.013636364f;
    private static final float RECT_OFFSET_TO_CARD_H_RATIO = 0.23636363f;
    private static final float BOTTOM_RECT_OFFSET_TO_CARD_H_RATIO = 0.81363636f;
    private static final float EXTRACTOR_H_TO_CARD_H_RATIO = 0.11818182f;
    private static final float EXTRACTOR_W_TO_EXTRACTOR_H_RATIO = 0.46153846f;
    private static final float NAME_X_OFFSET_TO_CARD_W_RATIO = 0.083333336f;
    private static final float NAME_Y_OFFSET_TO_CARD_H_RATIO = 0.19545455f;
    private static final float ACTIVE_Y_LIGHT_OFFSET_TO_CARD_H_RATIO = 0.27272728f;
    private static final float ACTIVE_LIGHT_W_TO_CARD_W_RATIO = 0.25f;
    private static final float ACTIVE_LIGHT_H_TO_CARD_H_RATIO = 0.018181818f;
    private final int RECT_HEIGHT = Math.round((float)this.CARD_HEIGHT * 0.013636364f);
    private final int RECT_OFFSET;
    private final int TOP_RECT_OFFSET = this.RECT_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.23636363f);
    private final int TOP_RECT_HEIGHT = this.RECT_HEIGHT;
    private final int BOTTOM_RECT_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.81363636f);
    private final int BOTTOM_RECT_HEIGHT = this.RECT_HEIGHT;
    private final int EXTRACTOR_HEIGHT = Math.round((float)this.CARD_HEIGHT * 0.11818182f);
    private final int EXTRACTOR_WIDTH = Math.round((float)this.EXTRACTOR_HEIGHT * 0.46153846f);
    private static final int TAB_MARGIN = 2;
    private final int TAB_RADIUS = (this.getCardWidth() - this.EXTRACTOR_WIDTH) / 2;
    private final int TAB_DIAMETER = this.TAB_RADIUS * 2;
    private final int TAB_ARC_WIDTH = this.getCardWidth() - this.EXTRACTOR_WIDTH - this.TAB_RADIUS;
    private final int TAB_ARC_HEIGHT = this.EXTRACTOR_HEIGHT - this.TAB_DIAMETER;
    private final int BOTTOM_EXTRACTOR_OFFSET = this.CARD_HEIGHT - this.EXTRACTOR_HEIGHT - 1;
    private final int BOTTOM_EXTRACTOR_HEIGHT = this.EXTRACTOR_HEIGHT;
    private static final int TOP_EXTRACTOR_OFFSET = 0;
    private final int TOP_EXTRACTOR_HEIGHT = this.EXTRACTOR_HEIGHT;
    private final int NAME_X_OFFSET = Math.round((float)this.getCardWidth() * 0.083333336f) - 1;
    private final int NAME_Y_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.19545455f);
    private final int ACTIVE_LIGHT_Y_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.27272728f);
    private final int ACTIVE_LIGHT_WIDTH = Math.round((float)this.getCardWidth() * 0.25f) - 1;
    private final int ACTIVE_LIGHT_HEIGHT = Math.round((float)this.CARD_HEIGHT * 0.018181818f);
    private static final int OPTICON_X_SPACING = 0;
    private final int OPTICON_Y_SPACING = Math.round((float)this.CARD_HEIGHT * 0.11363637f);
    private final int SMALL_OPTICON_Y_SPACING = Math.round((float)((double)((float)this.CARD_HEIGHT * 0.11363637f) * 0.75));
    private final int MINI_PORT_WIDTH = this.PORT_WIDTH;
    private final int MINI_PORT_HEIGHT = Math.round((float)this.getCardWidth() * 0.41666666f * 1.15f);
    private final int MINI_MULTIPORT_OPTICON_X_OFFSET = (this.getCardWidth() - this.MINI_PORT_WIDTH) / 2;
    private final int MINI_OPTICON_Y_OFFSET = this.OPTICON_Y_OFFSET - 4;
    private static final int MINI_OPTICON_X_SPACING = 0;
    private final int MINI_OPTICON_Y_SPACING = this.MINI_PORT_HEIGHT + 3;
    private static final float[] dash1 = new float[]{1.5f};
    public final Rectangle topExtractorRectangle = new Rectangle(2, 2, this.EXTRACTOR_WIDTH - 4, this.TOP_EXTRACTOR_HEIGHT - 4);
    public final Rectangle bottomExtractorRectangle = new Rectangle(2, this.BOTTOM_EXTRACTOR_OFFSET + 2, this.EXTRACTOR_WIDTH - 4, this.BOTTOM_EXTRACTOR_HEIGHT - 4);
    public final Arc2D.Double topExtractorMain = new Arc2D.Double(this.EXTRACTOR_WIDTH, 0 - this.TAB_ARC_HEIGHT, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, 90.0, 0);
    public final Arc2D.Double topExtractorSmall = new Arc2D.Double(this.EXTRACTOR_WIDTH, 0 + this.TAB_ARC_HEIGHT, this.TAB_DIAMETER, this.TAB_DIAMETER, 90.0, -180.0, 0);
    public final Line2D.Double topExtractorLine = new Line2D.Double(0.0, this.EXTRACTOR_HEIGHT, this.EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH, this.EXTRACTOR_HEIGHT);
    public final Arc2D.Double bottomExtractorMain = new Arc2D.Double(this.EXTRACTOR_WIDTH, this.BOTTOM_EXTRACTOR_OFFSET + this.TAB_DIAMETER, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, -90.0, 0);
    public final Arc2D.Double bottomExtractorSmall = new Arc2D.Double(this.EXTRACTOR_WIDTH, this.BOTTOM_EXTRACTOR_OFFSET, this.TAB_DIAMETER, this.TAB_DIAMETER, -90.0, 180.0, 0);
    public final Line2D.Double bottomExtractorLine = new Line2D.Double(0.0, this.BOTTOM_EXTRACTOR_OFFSET, this.EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH, this.BOTTOM_EXTRACTOR_OFFSET);
    private final int WIDTH;
    private final Rectangle topRectangle;
    private final Rectangle bottomRectangle;
    private final Rectangle mainRectangle;
    protected CardGraphic cg;
    private Rectangle topBackgroundRectangle;
    private Rectangle bottomBackgroundRectangle;
    protected OpticsMultiplexSectionModel[] bandmodels;
    protected OpticsChannelModel[] models;
    public static final String[] ChnWavelengthStrings = new String[]{"UNKNOWN", "1530.33", "1531.11", "1531.90", "1532.68", "1534.25", "1535.04", "1535.82", "1536.61", "1538.19", "1538.98", "1539.77", "1540.56", "1542.14", "1542.94", "1543.73", "1544.53", "1546.12", "1546.92", "1547.72", "1548.51", "1550.12", "1550.92", "1551.72", "1552.52", "1554.13", "1554.94", "1555.75", "1556.55", "1558.17", "1558.98", "1559.79", "1560.61"};
    public static final String[] BandWavelengthStrings = new String[]{"UNKNOWN", "1530.33", "1534.25", "1538.19", "1542.14", "1546.12", "1550.12", "1554.13", "1558.17"};

    public CardPainter(CardGraphic cardGraphic) {
        OpticsModuleModel opticsModuleModel;
        this.cg = cardGraphic;
        this.WIDTH = cardGraphic.getSlotsOccupied() * this.getCardWidth();
        this.topRectangle = new Rectangle(0, this.TOP_RECT_OFFSET, this.WIDTH, this.TOP_RECT_HEIGHT);
        this.bottomRectangle = new Rectangle(0, this.BOTTOM_RECT_OFFSET, this.WIDTH, this.BOTTOM_RECT_HEIGHT);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, this.HEIGHT);
        int n = this.getCardWidth();
        this.topBackgroundRectangle = new Rectangle(0, 0, n, this.TOP_EXTRACTOR_HEIGHT);
        this.bottomBackgroundRectangle = new Rectangle(0, this.BOTTOM_RECT_OFFSET, n, this.HEIGHT);
        if (this.cg.getModel() instanceof OpticsModuleModel && (opticsModuleModel = (OpticsModuleModel)this.cg.getModel()).getState() != eEqState.DELETED) {
            this.models = opticsModuleModel.getOpticsChannelModels();
            this.bandmodels = opticsModuleModel.getOpticsOMSModels();
        }
    }

    public void updateWidth() {
    }

    public int getOpticonXOffset() {
        return this.OPTICON_X_OFFSET;
    }

    public int getOpticonYOffset() {
        return this.OPTICON_Y_OFFSET;
    }

    public int getMultiPortOpticonXOffset() {
        return this.MULTIPORT_OPTICON_X_OFFSET;
    }

    public int getOpticonXSpacing() {
        return 0;
    }

    public int getOpticonYSpacing() {
        return this.OPTICON_Y_SPACING;
    }

    public int getMiniMultiPortOticonXOffset() {
        return this.MINI_MULTIPORT_OPTICON_X_OFFSET;
    }

    public int getCardWidth() {
        return 30;
    }

    public int getCardHeight() {
        return this.CARD_HEIGHT;
    }

    public Rectangle getMainRectangle() {
        return this.mainRectangle;
    }

    public int getPortWidth() {
        return this.PORT_WIDTH;
    }

    public int getPortHeight() {
        return this.PORT_HEIGHT;
    }

    public int getMiniPortWidth() {
        return this.MINI_PORT_WIDTH;
    }

    public int getMiniPortHeight() {
        return this.MINI_PORT_HEIGHT;
    }

    public int getMiniOpticonXSpacing() {
        return 0;
    }

    public int getMiniOpticonYSpacing() {
        return this.MINI_OPTICON_Y_SPACING;
    }

    public int getMiniOpticonYOffset() {
        return this.MINI_OPTICON_Y_OFFSET;
    }

    public int getPortX(int n, int n2) {
        return this.MULTIPORT_OPTICON_X_OFFSET + 0 * n2;
    }

    public int getPortY(int n, int n2) {
        if (n == 0) {
            return this.OPTICON_Y_OFFSET + this.OPTICON_Y_SPACING * n2;
        }
        return this.OPTICON_Y_OFFSET + this.SMALL_OPTICON_Y_SPACING * n2;
    }

    public int getSmallPortWidth() {
        return 0;
    }

    public int getSmallPortHeight() {
        return this.SMALL_PORT_HEIGHT;
    }

    public int getPortConn1X() {
        return this.PORT_CONN1_X;
    }

    public int getPortConn2X() {
        return this.PORT_CONN2_X;
    }

    public int getPortConn1Y() {
        return this.PORT_CONN1_Y;
    }

    public int getPortConn2Y() {
        return this.PORT_CONN2_Y;
    }

    public int getSmallPortConn1Y() {
        return this.SMALL_PORT_CONN1_Y;
    }

    public int getSmallPortConn2Y() {
        return this.SMALL_PORT_CONN2_Y;
    }

    public int getSmallPortConn1X() {
        return 0;
    }

    public int getSmallPortConn2X() {
        return 0;
    }

    public int getPortLoopbackDist() {
        return 3;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.cg.getCurrentColor());
        graphics2D.fill(this.mainRectangle);
        this.paintActual(graphics2D);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(this.mainRectangle);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.gray);
        graphics2D.draw(this.topExtractorRectangle);
        graphics2D.draw(this.bottomExtractorRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.topExtractorMain);
        graphics2D.draw(this.topExtractorSmall);
        graphics2D.draw(this.topExtractorLine);
        graphics2D.draw(this.bottomExtractorMain);
        graphics2D.draw(this.bottomExtractorSmall);
        graphics2D.draw(this.bottomExtractorLine);
        int n3 = this.cg.getState();
        String string = "";
        Color color = graphics2D.getColor();
        Color color2 = this.cg.getCurrentColor();
        switch (n3) {
            case 5: {
                string = "Act";
                color2 = Color.green;
                break;
            }
            case 4: {
                string = "Sby";
                color2 = Color.yellow;
                break;
            }
            case 2: {
                string = "Ldg";
                color2 = Color.white;
                break;
            }
            case 3: {
                string = "Fail";
                break;
            }
            case 1: {
                string = "Mis";
                break;
            }
            case 0: {
                string = "NP";
                break;
            }
            case 6: {
                string = "Del";
                break;
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, 2, this.ACTIVE_LIGHT_Y_OFFSET + this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color2);
        graphics2D.fillRect(this.getCardWidth() - this.ACTIVE_LIGHT_WIDTH - 2, this.ACTIVE_LIGHT_Y_OFFSET, this.ACTIVE_LIGHT_WIDTH, this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(this.getCardWidth() - this.ACTIVE_LIGHT_WIDTH - 2, this.ACTIVE_LIGHT_Y_OFFSET, this.ACTIVE_LIGHT_WIDTH, this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color);
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 3.0f, dash1, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(this.topRectangle);
        graphics2D.draw(this.bottomRectangle);
        graphics2D.setColor(Color.black);
        String string2 = "";
        int n4 = 0;
        String string3 = this.cg.getEqLabel();
        if (string3.length() > 4) {
            StringTokenizer stringTokenizer;
            Font font = graphics.getFont();
            FontMetrics fontMetrics = component.getFontMetrics(font);
            int n5 = fontMetrics.getAscent();
            String string4 = string3;
            String string5 = "";
            String string6 = "";
            int n6 = n2 + this.NAME_Y_OFFSET;
            if (string3.startsWith("OC")) {
                if (string3.equals("OC48AS")) {
                    string4 = string3.substring(0, 4);
                    string5 = string3.substring(4, string3.length());
                } else if (string3.startsWith("OC192XFP")) {
                    string4 = string3.substring(0, 5);
                    string5 = string3.substring(5, string3.length());
                } else {
                    stringTokenizer = new StringTokenizer(string3, "_");
                    try {
                        string4 = stringTokenizer.nextToken();
                        string5 = stringTokenizer.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
            } else if (string3.startsWith("DS3_E")) {
                stringTokenizer = new StringTokenizer(string3, "_");
                try {
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string3.startsWith("DS1_E")) {
                stringTokenizer = new StringTokenizer(string3, "_");
                try {
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string3.startsWith("DS")) {
                string4 = string3.substring(0, 3);
                string5 = string3.substring(3, string3.length());
            } else if (string3.startsWith("ETH")) {
                string4 = string3.substring(0, 3);
                string5 = string3.substring(3, string3.length());
            } else if (string3.startsWith("XC")) {
                string4 = string3.substring(0, 2);
                string5 = string3.substring(2, string3.length());
                if (string5.length() > 3) {
                    string5 = string5.substring(0, string5.indexOf(32));
                }
            } else if (string3.startsWith("G1000")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string4 = string3.substring(0, 5);
                if (string3.endsWith("(TXP)")) {
                    string5 = string3.substring(6);
                }
            } else if (string3.startsWith("ML100")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string4 = string3.substring(0, 2);
                string5 = string3.substring(2, string3.length());
                string5 = string5.replaceFirst("-8", "");
            } else if (string3.startsWith("ML2")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string4 = string3.substring(0, 3);
                string5 = string3.substring(4, 8);
            } else if (string3.startsWith("MS-I")) {
                stringTokenizer = new StringTokenizer(string3, "-");
                try {
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string3.startsWith("CE")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string4 = string3.substring(0, 2);
                string5 = string3.substring(3, 7);
            } else if (string3.startsWith("TXP") || string3.startsWith("MXP")) {
                stringTokenizer = new StringTokenizer(string3, "_");
                String string7 = null;
                try {
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                    string7 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                if (string7 != null) {
                    int n7 = fontMetrics.getAscent() / 2;
                    int n8 = (this.BOTTOM_EXTRACTOR_OFFSET - (this.BOTTOM_RECT_OFFSET + this.BOTTOM_RECT_HEIGHT)) / 2;
                    int n9 = (n + this.getCardWidth() - fontMetrics.stringWidth(string7)) / 2;
                    int n10 = n2 + this.BOTTOM_RECT_OFFSET + this.BOTTOM_RECT_HEIGHT + n8 + n7;
                    graphics2D.drawString(string7, n9, n10);
                }
                if (string4.length() > 4 || string5.length() > 4 || string6.length() > 4) {
                    font = new Font(font.getFontName(), font.getStyle(), font.getSize() - 1);
                    fontMetrics = component.getFontMetrics(font);
                    graphics2D.setFont(font);
                }
            } else if (string3.startsWith("FC-MR")) {
                stringTokenizer = new StringTokenizer(string3, "-");
                try {
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string3.startsWith("AD-1B")) {
                string4 = "AD1B";
                n4 = this.getBandWave();
                string5 = n4 != 0 ? BandWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("AD-4B")) {
                string4 = "AD4B";
                n4 = this.getBandWave();
                string5 = n4 != 0 ? BandWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("AD-1C")) {
                string4 = "AD1C";
                n4 = this.getWave();
                string5 = n4 != 0 ? ChnWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("AD-2C")) {
                string4 = "AD2C";
                n4 = this.getWave();
                string5 = n4 != 0 ? ChnWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("AD-4C")) {
                string4 = "AD4C";
                n4 = this.getWave();
                string5 = n4 != 0 ? ChnWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("OPT-BST E")) {
                string4 = "OPT";
                string5 = "BST";
                string6 = "E";
            } else if (string3.equals("OPT-BST")) {
                string4 = "OPT";
                string5 = "BST";
            } else if (string3.equals("OPT-BST L")) {
                string4 = "OPT";
                string5 = "BST";
                string6 = "L";
            } else if (string3.startsWith("OPT-PRE")) {
                string4 = "OPT";
                string5 = "PRE";
            } else if (string3.startsWith("OPT-AMP L")) {
                string4 = "OPT";
                string5 = "AMP";
                string6 = "L";
            } else if (string3.startsWith("OSC M")) {
                string4 = "OSCM";
                string5 = "";
            } else if (string3.startsWith("OSC-CSM")) {
                string4 = "OSC";
                string5 = "CSM";
            } else if (string3.equals("32 WSS L")) {
                string4 = "     32WSS-L";
                string5 = "";
            } else if (string3.equals("32 WSS")) {
                string4 = "     32 WSS";
                string5 = "";
            } else if (string3.equals("32 DMX L")) {
                string4 = "32";
                string5 = "DMX";
                string6 = "L";
            } else if (string3.equals("32 DMX")) {
                string4 = "32";
                string5 = "DMX";
            } else if (string3.startsWith("4MD")) {
                string4 = "4MD";
                n4 = this.getWave();
                string5 = n4 != 0 ? ChnWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("32 MUXO")) {
                string4 = "       32 MUXO";
                string5 = "";
            } else if (string3.equals("32 DMXO")) {
                string4 = "       32 DMXO";
                string5 = "";
            } else if (string3.startsWith("MRC")) {
                string4 = string3.substring(0, 3);
                string5 = string3.substring(4, string3.length());
            } else if (string3.startsWith("PPM")) {
                string4 = "";
                string5 = "";
            } else if (string3.startsWith("TCC2P")) {
                string4 = string3.substring(0, 4);
                string5 = string3.substring(4, string3.length());
            } else if (string3.startsWith("RAN_SVC")) {
                string4 = "RAN";
                string5 = "SVC";
            }
            if (string5.length() != 0 && string6.length() != 0) {
                n6 -= n5;
            }
            int n11 = fontMetrics.stringWidth(string4);
            graphics2D.drawString(string4, (n + this.getCardWidth() - n11) / 2, n6);
            if (string5.length() > 0) {
                n11 = fontMetrics.stringWidth(string5);
                graphics2D.drawString(string5, (n + this.getCardWidth() - n11) / 2, n6 += n5);
            }
            if (string6.length() > 0) {
                n11 = fontMetrics.stringWidth(string6);
                graphics2D.drawString(string6, (n + this.getCardWidth() - n11) / 2, n6 += n5);
            }
        } else if (string3 != null) {
            int n12 = 0;
            if (string3.startsWith("UNK")) {
                n12 = -1;
            }
            graphics2D.drawString(string3, n + this.NAME_X_OFFSET + n12, n2 + this.NAME_Y_OFFSET);
        }
        graphics2D.setStroke(stroke);
    }

    public void paintActual(Graphics2D graphics2D) {
        int n = this.cg.getState();
        int n2 = this.cg.getSlot();
        int n3 = this.cg.getSlotsOccupied();
        String string = null;
        int n4 = this.getCardWidth();
        boolean bl = false;
        ArrayList arrayList = null;
        try {
            arrayList = ((EntityModel)this.cg.getModel()).getNodeModelDelegate().getMfgData(this.cg.getModel().getShelfId());
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            // empty catch block
        }
        for (int i = 0; i < n3; ++i) {
            block8: {
                block10: {
                    block9: {
                        block7: {
                            bl = false;
                            if (arrayList != null && arrayList.size() < n2 + i - 1) {
                                string = (String)arrayList.get(n2 + i - 1);
                            }
                            this.topBackgroundRectangle = new Rectangle(i * n4, 0, n4, this.TOP_EXTRACTOR_HEIGHT);
                            this.bottomBackgroundRectangle = new Rectangle(i * n4, this.BOTTOM_RECT_OFFSET, n4, this.HEIGHT);
                            if (string == null || !string.equals("FILLER")) break block7;
                            graphics2D.setColor(Color.white);
                            graphics2D.fill(this.topBackgroundRectangle);
                            graphics2D.fill(this.bottomBackgroundRectangle);
                            bl = true;
                            break block8;
                        }
                        if (i != 0) break block9;
                        if (this.cg.getState() == 1 && this.cg.hasProvisionedCard()) break block10;
                    }
                    if (i <= 0 || string == null || string.equals("")) break block8;
                }
                graphics2D.setColor(this.cg.getCurrentColor());
                graphics2D.fill(this.topBackgroundRectangle);
                graphics2D.fill(this.bottomBackgroundRectangle);
                bl = true;
            }
            if (!bl || i <= 0) continue;
            Rectangle rectangle = new Rectangle(i * n4 + 2, 2, this.EXTRACTOR_WIDTH - 4, this.TOP_EXTRACTOR_HEIGHT - 4);
            Rectangle rectangle2 = new Rectangle(i * n4 + 2, this.BOTTOM_EXTRACTOR_OFFSET + 2, this.EXTRACTOR_WIDTH - 4, this.BOTTOM_EXTRACTOR_HEIGHT - 4);
            Arc2D.Double double_ = new Arc2D.Double(i * n4 + this.EXTRACTOR_WIDTH, 0 - this.TAB_ARC_HEIGHT, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, 90.0, 0);
            Arc2D.Double double_2 = new Arc2D.Double(i * n4 + this.EXTRACTOR_WIDTH, 0 + this.TAB_ARC_HEIGHT, this.TAB_DIAMETER, this.TAB_DIAMETER, 90.0, -180.0, 0);
            Line2D.Double double_3 = new Line2D.Double(i * n4, this.EXTRACTOR_HEIGHT, this.EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH + i * n4, this.EXTRACTOR_HEIGHT);
            Arc2D.Double double_4 = new Arc2D.Double(i * n4 + this.EXTRACTOR_WIDTH, this.BOTTOM_EXTRACTOR_OFFSET + this.TAB_DIAMETER, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, -90.0, 0);
            Arc2D.Double double_5 = new Arc2D.Double(i * n4 + this.EXTRACTOR_WIDTH, this.BOTTOM_EXTRACTOR_OFFSET, this.TAB_DIAMETER, this.TAB_DIAMETER, -90.0, 180.0, 0);
            Line2D.Double double_6 = new Line2D.Double(i * n4, this.BOTTOM_EXTRACTOR_OFFSET, this.EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH + i * n4, this.BOTTOM_EXTRACTOR_OFFSET);
            Line2D.Double double_7 = new Line2D.Double(i * n4, 0.0, i * n4, this.EXTRACTOR_HEIGHT);
            Line2D.Double double_8 = new Line2D.Double(i * (n4 * 2), 0.0, i * (n4 * 2), this.EXTRACTOR_HEIGHT);
            Line2D.Double double_9 = new Line2D.Double(i * n4, this.BOTTOM_RECT_OFFSET, i * n4, this.BOTTOM_EXTRACTOR_OFFSET + this.EXTRACTOR_HEIGHT);
            Line2D.Double double_10 = new Line2D.Double(i * (n4 * 2), this.BOTTOM_RECT_OFFSET, i * (n4 * 2), this.BOTTOM_EXTRACTOR_OFFSET + this.EXTRACTOR_HEIGHT);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.draw(this.mainRectangle);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.gray);
            graphics2D.draw(rectangle);
            graphics2D.draw(rectangle2);
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
            graphics2D.draw(double_2);
            graphics2D.draw(double_3);
            graphics2D.draw(double_4);
            graphics2D.draw(double_5);
            graphics2D.draw(double_6);
            graphics2D.draw(double_8);
            graphics2D.draw(double_7);
            graphics2D.draw(double_10);
            graphics2D.draw(double_9);
        }
    }

    private int getWave() {
        int n = 0;
        try {
            n = this.models[0].getExpectedWaveLength();
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    private int getBandWave() {
        int n = 0;
        try {
            n = this.bandmodels[0].getExpectedBand().value();
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }
}

