/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.shelf;

import cerent.cms.model.IChassisModel;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardPanel;
import cerent.util.gui.IconImpl;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShelfLayout
extends AbstractShelfLayout {
    private static final int SHELF_SLOT_COUNT = 17;
    private static final float FONT_TO_CARD_W_RATIO = 0.33333334f;
    private static final Font TEXT_FONT = new Font("Arial", 0, Math.round(10.0f));
    private static final Font labelFont = new Font("Arial", 0, 10);

    public ShelfLayout(IChassisModel iChassisModel, ShelfViewController shelfViewController) {
        super(iChassisModel, shelfViewController);
    }

    protected int getShelfSlotCount() {
        return 17;
    }

    protected Font getTextFont() {
        return TEXT_FONT;
    }

    protected void createLabels() {
        if (this.labelsPanel == null) {
            this.labelsPanel = new JPanel(new GridLayout(1, 17, 0, 0));
            Dimension dimension = new Dimension(30, 12);
            this.labels = new JLabel[17];
            for (int i = 0; i < 17; ++i) {
                JLabel jLabel = new JLabel("" + (i + 1));
                jLabel.setFont(labelFont);
                jLabel.setPreferredSize(dimension);
                jLabel.setMinimumSize(dimension);
                jLabel.setHorizontalAlignment(0);
                this.labels[i] = jLabel;
                this.labelsPanel.add(jLabel);
            }
        }
    }

    protected void createSlotsPanel() {
        this.slotsPanel = new JPanel(new FlowLayout(0, 0, 0));
        Dimension dimension = new Dimension(30, Math.round(275.0f));
        for (int i = 0; i < this.cards.length; ++i) {
            IconImpl iconImpl = new IconImpl(dimension);
            this.cards[i] = new CardPanel(iconImpl, this);
            this.cards[i].addMouseListener(this.mouseListener);
            this.slotsPanel.add(this.cards[i]);
        }
    }

    protected void addLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelsPanel, gridBagConstraints);
        this.add(this.labelsPanel);
    }

    protected void removeLabels() {
        this.remove(this.labelsPanel);
    }

    protected void addPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.slotsPanel, gridBagConstraints);
        this.add(this.slotsPanel);
    }
}

