/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455;

import cerent.cms.IPlatform;
import cerent.cms.ReferencePlatform;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.MsCardGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.SDHTDMTerminology;
import cerent.util.TDMTerminology;
import com.cisco.ctc455.model.AlarmDecoderDefs;
import com.cisco.ctc455.model.nedefaults.NodeDefaults;
import com.cisco.ctc455.model.vf.Blsr2FiberVersionedFeature;
import com.cisco.ctc455.model.vf.Blsr4FiberVersionedFeature;
import com.cisco.ctc455.ui.CardViewPanel;
import com.cisco.ctc455.ui.PlatformCardTabbedViewFactory;
import com.cisco.ctc455.ui.ms.MsCardFactory;
import com.cisco.ctc455.ui.ms.MsCardPainter;
import com.cisco.ctc455.ui.ms.MsShelfLayout;
import com.cisco.ctc455.ui.network.IconStore;
import com.cisco.ctc455.ui.shelf.CardFactory;
import com.cisco.ctc455.ui.shelf.CardPainter;
import com.cisco.ctc455.ui.shelf.ShelfLayout;
import com.cisco.ctc455.ui.shelf.ShelfMaintenancePane;
import com.cisco.ctc455.ui.shelf.ShelfProvPane;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Platform
extends ReferencePlatform {
    private static final int[] supportedXcCardEqTypes = new int[]{59, 43, 3, 84, 107, 216, 217};
    private static final LANAccessMode[] LAN_ACCESS_MODE = new LANAccessMode[]{LANAccessMode.DCC_ONLY, LANAccessMode.FRONT_ONLY, LANAccessMode.BACKPLANE_ONLY, LANAccessMode.FRONT_BACKPLANE};
    private static final HashMap versionedFeatureMap = new HashMap();
    private static final int[] vwMasks;
    private static final int XCON_A_SLOT = 8;
    private static final int XCON_B_SLOT = 10;
    private static final int XCON_A_SLOT_INDEX = 32768;
    private static final int XCON_B_SLOT_INDEX = 40960;
    private static final int XCON_A_INDEX = 32769;
    private static final int XCON_B_INDEX = 40961;
    private static final String[] pmColumnNames;
    private static final Map opticalLoopbackMap;
    private static final Map timingModeMap;
    private static final int AICI_PORT_IO_MIN = 35;
    private static Platform instance;

    public static IPlatform instance() {
        return instance;
    }

    private Platform() {
    }

    public boolean is455() {
        return true;
    }

    public TDMTerminology getTDMTerminology() {
        return SDHTDMTerminology.instance();
    }

    public Image[] getIcons(NodeModelDelegate nodeModelDelegate) {
        return IconStore.getIcons(nodeModelDelegate);
    }

    public CardTabbedViewFactory getCardTabbedViewFactory() {
        return PlatformCardTabbedViewFactory.instance();
    }

    public AbstractCardViewPanel getCardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        return new CardViewPanel(moduleModel, cardViewController);
    }

    public CardGraphic createCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        return CardFactory.createCard(entityModel, abstractShelfLayout);
    }

    public MsCardGraphic createMsCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        return MsCardFactory.createMsCard(entityModel, abstractShelfLayout);
    }

    public ICardPainter getMsCardPainter(MsCardGraphic msCardGraphic) {
        return new MsCardPainter(msCardGraphic);
    }

    public ICardPainter getCardPainter(CardGraphic cardGraphic) {
        return new CardPainter(cardGraphic);
    }

    public AbstractShelfLayout getShelfLayout(IChassisModel iChassisModel, ShelfViewController shelfViewController) {
        return new ShelfLayout(iChassisModel, shelfViewController);
    }

    public AbstractShelfLayout getMsShelfLayout(IChassisModel iChassisModel, AbstractViewController abstractViewController, BayViewPanel bayViewPanel) {
        return new MsShelfLayout(iChassisModel, abstractViewController, bayViewPanel);
    }

    public AbstractShelfProvPane getShelfProvPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        return new ShelfProvPane(string, tabbedView, iGuestPaneFactory);
    }

    public AbstractShelfMaintenancePane getShelfMaintenancePane(String string, TabbedView tabbedView) {
        return new ShelfMaintenancePane(string, tabbedView);
    }

    public AbstractVersionedFeature getVersionedFeature(Feature feature) {
        return (AbstractVersionedFeature)versionedFeatureMap.get(feature);
    }

    public String[] getSonetMonTypeNames() {
        return AlarmDecoderDefs.getSonetMonTypeNames();
    }

    public String[] getSdhMonTypeNames() {
        return AlarmDecoderDefs.getSdhMonTypeNames();
    }

    public Map[] getEqTypeNameMapsForDefaults() {
        return NodeDefaults.getEqTypeNameMaps();
    }

    public Object[][] getDefaultsList(String string) {
        return NodeDefaults.getDefaultsList(string);
    }

    public Object[] getListOfDefaultsLists() {
        return NodeDefaults.getListOfDefaultsLists();
    }

    public Map getTimingModeAttributeMap() {
        return timingModeMap;
    }

    public Map getLoopbackAttributeMap() {
        return opticalLoopbackMap;
    }

    public String[] getPmColumnNames() {
        return pmColumnNames;
    }

    public int[] getVwMasks() {
        return vwMasks;
    }

    public int getXconASlot() {
        return 8;
    }

    public int getXconBSlot() {
        return 10;
    }

    public int getXconASlotIndex() {
        return 32768;
    }

    public int getXconBSlotIndex() {
        return 40960;
    }

    public int getXconAIndex() {
        return 32769;
    }

    public int getXconBIndex() {
        return 40961;
    }

    public int[] getSupportedXcCardEqTypes() {
        return supportedXcCardEqTypes;
    }

    public boolean isXcEnabled(INodeModel iNodeModel) {
        return iNodeModel.getNodeType() != 2;
    }

    public LANAccessMode[] getSupportedLanAccessModes() {
        return LAN_ACCESS_MODE;
    }

    public boolean isConfigurableSDPSupported() {
        return false;
    }

    public boolean canSendPdip() {
        return false;
    }

    public String getPlatformName() {
        return "15455";
    }

    public int getAiciIoPortsStartNum() {
        return 35;
    }

    public boolean hasVC11() {
        return true;
    }

    public boolean hasXcMixedMode(IChassisModel iChassisModel) {
        boolean bl = false;
        if (iChassisModel == null) {
            return bl;
        }
        boolean bl2 = false;
        for (int i = 0; i < supportedXcCardEqTypes.length; ++i) {
            if (iChassisModel.getDescendantsOfEqType(supportedXcCardEqTypes[i]).size() <= 0) continue;
            bl2 = true;
            break;
        }
        if (bl2 && ((EntityModel)((Object)iChassisModel)).getDescendantsOfType(eEqType.XCVXC_CARD).size() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean supportsTdmTransceiver(int n) {
        return n == 106 || n == 60 || n == 219 || n == 220;
    }

    protected int[] eqTypesWithoutUniqueNames() {
        int[] nArray = new int[]{187};
        return nArray;
    }

    public boolean supportsMultishelf() {
        return true;
    }

    public int baysPerRack() {
        return 3;
    }

    public boolean supportsServerTrail() {
        return true;
    }

    public boolean supportsRpr() {
        return true;
    }

    static {
        versionedFeatureMap.put(Feature.BLSR_2F_VERSIONING, new Blsr2FiberVersionedFeature());
        versionedFeatureMap.put(Feature.BLSR_4F_VERSIONING, new Blsr4FiberVersionedFeature());
        vwMasks = new int[]{8, 4, 2, 1};
        pmColumnNames = new String[]{"Param", "Curr", "Prev", "Prev-1", "Prev-2", "Prev-3", "Prev-4", "Prev-5", "Prev-6", "Prev-7", "Prev-8", "Prev-9", "Prev-10", "Prev-11", "Prev-12", "Prev-13", "Prev-14", "Prev-15", "Prev-16", "Prev-17", "Prev-18", "Prev-19", "Prev-20", "Prev-21", "Prev-22", "Prev-23", "Prev-24", "Prev-25", "Prev-26", "Prev-27", "Prev-28", "Prev-29", "Prev-30", "Prev-31"};
        opticalLoopbackMap = new TreeMap();
        timingModeMap = new TreeMap();
        instance = new Platform();
        Platform.putAttribute(opticalLoopbackMap, 0, "None");
        Platform.putAttribute(opticalLoopbackMap, 1, "Terminal (Inward)");
        Platform.putAttribute(opticalLoopbackMap, 2, "Facility (Line)");
        Platform.putAttribute(timingModeMap, 0, "External");
        Platform.putAttribute(timingModeMap, 1, "Line");
        Platform.putAttribute(timingModeMap, 2, "Mixed");
    }
}

