/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui;

import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.MSIsc100T.MSIsc100TCardView;
import cerent.cms.ui.ml2.ML2CardView;
import cerent.cms.ui.mrc.MrcCardView;
import cerent.cms.ui.ransvc.RanSvcCardView;
import cerent.cms.ui.shelf.AiciCardView;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.DwdmCardView;
import cerent.cms.ui.shelf.E142CardView;
import cerent.cms.ui.shelf.G1000CardView;
import cerent.cms.ui.shelf.MuxDmuxCardView;
import cerent.cms.ui.shelf.OadmCardView;
import cerent.cms.ui.shelf.OadmLCardView;
import cerent.cms.ui.shelf.OscCardView;
import cerent.cms.ui.shelf.Wss32CardView;
import cerent.util.SDebug;

public class CardViewPanel
extends AbstractCardViewPanel {
    private static final SDebug db = new SDebug("CardViewPanel");

    public CardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        super(moduleModel, cardViewController);
    }

    protected void setupCardView() {
        if (this.model instanceof DwdmModuleModel) {
            this.cardView = new DwdmCardView((DwdmModuleModel)this.model);
        } else {
            switch (this.model.getEqType()) {
                case 108: 
                case 109: {
                    this.cardView = new E142CardView(this.model);
                    break;
                }
                case 97: {
                    this.cardView = new AiciCardView(this.model);
                    break;
                }
                case 102: 
                case 103: 
                case 221: {
                    if (!(this.model instanceof L2scModuleModel)) break;
                    L2scModuleModel l2scModuleModel = (L2scModuleModel)this.model;
                    this.cardView = new ML2CardView(l2scModuleModel, l2scModuleModel.getL2scEtherPorts(), l2scModuleModel.getL2scPosPorts());
                    break;
                }
                case 238: {
                    if (!(this.model instanceof L2scModuleModel)) break;
                    L2scModuleModel l2scModuleModel = (L2scModuleModel)this.model;
                    this.cardView = new MSIsc100TCardView(l2scModuleModel, l2scModuleModel.getL2scEtherPorts());
                    break;
                }
                case 62: {
                    this.cardView = new G1000CardView(this.model);
                    break;
                }
                case 187: 
                case 229: {
                    if (!(this.model instanceof ML2ModuleModel)) break;
                    ML2ModuleModel mL2ModuleModel = (ML2ModuleModel)this.model;
                    this.cardView = new ML2CardView(mL2ModuleModel, mL2ModuleModel.getEtherPortModels(), mL2ModuleModel.getPosPortModels(), mL2ModuleModel.isInMapperMode());
                    break;
                }
                case 129: 
                case 130: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 196: 
                case 239: 
                case 249: {
                    this.cardView = new OadmCardView(this.model);
                    break;
                }
                case 240: {
                    this.cardView = new OadmLCardView(this.model);
                    break;
                }
                case 131: 
                case 132: 
                case 192: 
                case 241: {
                    this.cardView = new MuxDmuxCardView(this.model);
                    break;
                }
                case 191: 
                case 242: {
                    this.cardView = new Wss32CardView(this.model);
                    break;
                }
                case 127: 
                case 128: {
                    this.cardView = new OscCardView(this.model);
                    break;
                }
                case 219: 
                case 220: {
                    this.cardView = new MrcCardView((PluggableCarrierModel)this.model);
                    break;
                }
                case 248: {
                    this.cardView = new RanSvcCardView(this.model);
                    break;
                }
                default: {
                    this.cardView = new CardView(this.model);
                }
            }
        }
        if (db.on()) {
            db.println("setupCardView cardView is " + this.cardView);
        }
    }
}

