/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.ms;

import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.IMsShelfLayout;
import cerent.cms.ui.ms.MsCardGraphic;
import cerent.cms.ui.ms.MsCardPanel;
import cerent.cms.ui.ms.ShelfTransferHandler;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.ObservableManager;
import cerent.util.gui.IconImpl;
import com.cisco.ctc455.ui.ms.MsCardFactory;
import com.cisco.ctc455.ui.ms.MsCardPainter;
import com.cisco.ctc455.ui.ms.MsFmecBlankCard;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class MsShelfLayout
extends AbstractShelfLayout
implements IMsShelfLayout,
Observer {
    protected static final Border UNSELECTED_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    public static final int SHELF_SLOT_COUNT = 17;
    public static final int FMEC_SHELF_SLOT_COUNT = 12;
    private static final float FONT_TO_CARD_W_RATIO = 0.33333334f;
    private static final Font TEXT_FONT = new Font("Arial", 0, Math.round(4.0f));
    private static final Font labelFont = new Font("Arial", 0, 10);
    private final AbstractShelfLayout.Highlighter highLighter = new AbstractShelfLayout.Highlighter(this);
    private JPanel fmecSlotsPanel;
    private JLabel idLbl;
    private ObservableManager observableManager;

    public MsShelfLayout(IChassisModel iChassisModel, AbstractViewController abstractViewController, BayViewPanel bayViewPanel) {
        super(iChassisModel, abstractViewController, bayViewPanel);
        this.chassis.addObserver(this);
        this.chassis.getShelfAlarmStore().addAlarmStatusObserver((Observer)this);
        this.setBorder(UNSELECTED_BORDER);
    }

    public void destroy() {
        this.chassis.deleteObserver(this);
        this.chassis.getShelfAlarmStore().deleteAlarmStatusObserver((Observer)this);
        super.destroy();
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED) || ((Integer)object).equals(ModelUpdateType.STRUCTURE_CHANGED)) {
                if (db.on()) {
                    db.println("Received Shelf change message");
                }
                this.refreshShelfColor();
            }
        } else if (object instanceof AlarmStatus) {
            this.refreshShelfColor();
        }
    }

    protected void refreshShelfColor() {
        this.setShelfColor(this.getState());
        this.labelsPanel.setBackground(this.currShelfColor);
        this.idLbl.setBackground(this.currShelfColor);
    }

    public BayViewPanel getBayViewPanel() {
        return this.bvp;
    }

    protected MouseInputAdapter getMouseClickProcessor() {
        return new MouseClickProcessor();
    }

    protected Font getTextFont() {
        return TEXT_FONT;
    }

    protected void createLabels() {
        if (this.labelsPanel == null) {
            this.labelsPanel = this.getInnerLabelPanel(new GridLayout(1, 17, 0, 0), this.chassis.getTDMTerminology());
            Dimension dimension = new Dimension(204, 10);
            this.labels = new JLabel[29];
            for (int i = 0; i < 29; ++i) {
                this.labels[i] = new JLabel("");
            }
            this.idLbl = new JLabel("Shelf " + this.chassis.getShelfId());
            this.idLbl.setFont(labelFont);
            this.idLbl.setPreferredSize(dimension);
            this.idLbl.setMinimumSize(dimension);
            this.idLbl.setHorizontalAlignment(0);
            this.labelsPanel.add(this.idLbl);
            this.refreshShelfColor();
        }
    }

    private void createFmecSlotsPanel(TransferHandler transferHandler) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.fmecSlotsPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        for (int i = 17; i < 29; ++i) {
            IconImpl iconImpl = new IconImpl(MsFmecBlankCard.SINGLE_SLOT_DIM);
            this.cards[i] = new MsCardPanel(iconImpl, this);
            this.cards[i].addMouseMotionListener(this.mouseListener);
            this.cards[i].setTransferHandler(transferHandler);
            gridBagLayout.setConstraints(this.cards[i], gridBagConstraints);
            this.fmecSlotsPanel.add(this.cards[i]);
            ++gridBagConstraints.gridx;
        }
    }

    protected void createSlotsPanel() {
        this.slotsPanel = new JPanel(new FlowLayout(0, 0, 0));
        Dimension dimension = new Dimension(12, MsCardPainter.CARD_HEIGHT);
        ShelfTransferHandler shelfTransferHandler = new ShelfTransferHandler(this.chassis.getNodeModelDelegate().getChassisModelsInstance(), this.bvp.getRVP().getMVP());
        for (int i = 0; i < 17; ++i) {
            IconImpl iconImpl = new IconImpl(dimension);
            this.cards[i] = new MsCardPanel(iconImpl, this);
            this.cards[i].addMouseListener(this.mouseListener);
            this.cards[i].addMouseMotionListener(this.mouseListener);
            this.cards[i].setTransferHandler(shelfTransferHandler);
            this.slotsPanel.add(this.cards[i]);
        }
        this.createFmecSlotsPanel(shelfTransferHandler);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.setTransferHandler(shelfTransferHandler);
    }

    protected CardGraphic createCard(EntityModel entityModel) {
        return MsCardFactory.createMsCard(entityModel, this);
    }

    protected int getShelfSlotCount() {
        return 29;
    }

    protected void addLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelsPanel, gridBagConstraints);
        this.add(this.labelsPanel);
    }

    protected void removeLabels() {
        this.remove(this.labelsPanel);
    }

    protected void addPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.slotsPanel, gridBagConstraints);
        this.add(this.slotsPanel);
        this.addFmecPanels();
    }

    private void addFmecPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.fmecSlotsPanel, gridBagConstraints);
        this.add(this.fmecSlotsPanel);
    }

    private class MouseClickProcessor
    extends MouseInputAdapter {
        private MouseEvent firstMouseEvent = null;

        private MouseClickProcessor() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.firstMouseEvent = mouseEvent;
            mouseEvent.consume();
            MsShelfLayout.this.highLighter.cancel();
            MsShelfLayout.this.bvp.getRVP().getMVP().setSelectedShelf(MsShelfLayout.this);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.firstMouseEvent != null) {
                JComponent jComponent;
                TransferHandler transferHandler;
                mouseEvent.consume();
                int n = 2;
                int n2 = Math.abs(mouseEvent.getX() - this.firstMouseEvent.getX());
                int n3 = Math.abs(mouseEvent.getY() - this.firstMouseEvent.getY());
                if ((n2 > 5 || n3 > 5) && (transferHandler = (jComponent = (JComponent)mouseEvent.getSource()).getTransferHandler()) != null) {
                    transferHandler.exportAsDrag(jComponent, this.firstMouseEvent, n);
                    this.firstMouseEvent = null;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.firstMouseEvent = null;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof MsCardPanel) {
                Icon icon = ((MsCardPanel)object).getIcon();
                if ((mouseEvent.getModifiers() & 4) != 0) {
                    if (icon instanceof CardGraphic) {
                        ((CardGraphic)icon).rightMouseClicked(mouseEvent.getPoint(), (MsCardPanel)object);
                    }
                } else if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 2 && icon instanceof MsCardGraphic) {
                    ((MsCardGraphic)icon).openShelf();
                }
            }
        }
    }
}

