/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.shelf;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eBitsLBO;
import cerent.cms.idl.Synchronization.eCableType;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.model.Attribute;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractBitsProvPane;
import cerent.cms.ui.shelf.AbstractSppTimingBitsPane;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;

public abstract class AbstractSdhBitsProvPane
extends AbstractBitsProvPane {
    private static final String[] bitsInChoices = new String[]{"E1", "2MHz", "64kHz+8kHz"};
    private static final String[] bitsOutChoices = new String[]{"E1", "2MHz", "6MHz"};
    protected static final String[] codingChoices = new String[]{"HDB3", "AMI", NA};
    protected static final eLineCoding[] codingValue = new eLineCoding[]{eLineCoding.HDB3, eLineCoding.AMI, eLineCoding.LINECODING_NOT_APPLICABLE};
    protected static final String[] framingChoices = new String[]{"Unframed", "FAS", "FAS+CAS", "FAS+CRC", "FAS+CAS+CRC", NA};
    protected static final eLineType[] framingValue = new eLineType[]{eLineType.E1_UNFRAME, eLineType.E1_FRAME, eLineType.E1_MF, eLineType.E1_CRC, eLineType.E1_CRCMF, eLineType.LINETYPE_NOT_APPLICABLE};
    protected static final String[] sabitChoices = new String[]{"4", "5", "6", "7", "8", NA};
    private SynchronizationModel syncModel;

    public AbstractSdhBitsProvPane(String string, TabbedView tabbedView, AbstractSppTimingBitsPane abstractSppTimingBitsPane, eBits eBits2, SynchronizationModel synchronizationModel) {
        super(string, tabbedView, abstractSppTimingBitsPane, eBits2);
        this.syncModel = synchronizationModel;
    }

    protected abstract String[] getStateChoices();

    protected abstract eAdminState getAdminStateFromSelection(int var1);

    protected abstract eLineCoding getCodingFromSelection(int var1);

    protected abstract eLineType getFramingFromSelection(int var1);

    protected abstract int getFramingIndex(eLineType var1);

    public String[] getFacilityChoices(int n) {
        if (n == 0) {
            return bitsInChoices;
        }
        return bitsOutChoices;
    }

    protected String[] getCodingChoices() {
        return codingChoices;
    }

    protected String[] getFramingChoices() {
        return framingChoices;
    }

    public Attribute[] getQualityChoices() {
        return attrMap.getAttributeArray("timingSdhSsmQuality");
    }

    private Attribute getQualityAttribute(int n) {
        return attrMap.getAttributeForVal("timingSdhSsmQuality", n);
    }

    public JComboBox createBitsInSabit() {
        this.sabitBitsInCB = new JComboBox<String>(sabitChoices);
        this.sabitBitsInCB.setName("Sa Bit");
        this.sabitBitsInCB.addActionListener(this);
        this.enableComponent(this.sabitBitsInCB);
        return this.sabitBitsInCB;
    }

    public JComboBox createBitsOutSabit() {
        this.sabitBitsOutCB = new JComboBox<String>(sabitChoices);
        this.sabitBitsOutCB.setName("Sa Bit");
        this.sabitBitsOutCB.addActionListener(this);
        this.enableComponent(this.sabitBitsOutCB);
        return this.sabitBitsOutCB;
    }

    public void updateBitsInValues() {
        int n = this.codingBitsInCB.getItemCount();
        if (this.parent.isBits2M(0)) {
            if (n < codingChoices.length) {
                this.codingBitsInCB.addItem(NA);
            }
            this.codingBitsInCB.setSelectedItem(NA);
        } else {
            if (n == codingChoices.length) {
                this.codingBitsInCB.removeItemAt(n - 1);
            }
            this.codingBitsInCB.setSelectedIndex(1);
        }
        int n2 = this.sabitBitsInCB.getItemCount();
        if (this.parent.isBits64K(0) || this.parent.isBits2M(0)) {
            if (n2 < sabitChoices.length) {
                this.sabitBitsInCB.addItem(NA);
            }
            this.sabitBitsInCB.setSelectedItem(NA);
        } else if (n2 == sabitChoices.length) {
            this.sabitBitsInCB.removeItemAt(n2 - 1);
            this.sabitBitsInCB.setSelectedIndex(0);
        }
        super.updateBitsInValues();
    }

    public void updateBitsOutValues() {
        int n = this.codingBitsOutCB.getItemCount();
        this.codingBitsOutCB.setSelectedIndex(1);
        if (this.parent.isBits2M(1)) {
            if (n < codingChoices.length) {
                this.codingBitsOutCB.addItem(NA);
            }
            this.codingBitsOutCB.setSelectedItem(NA);
        } else if (this.parent.isBits64K(1) && n == codingChoices.length) {
            this.codingBitsOutCB.removeItemAt(n - 1);
        }
        int n2 = this.sabitBitsOutCB.getItemCount();
        if (this.parent.isBits64K(1) || this.parent.isBits2M(1)) {
            if (n2 < sabitChoices.length) {
                this.sabitBitsOutCB.addItem(NA);
            }
            this.sabitBitsOutCB.setSelectedItem(NA);
        } else if (n2 == sabitChoices.length) {
            this.sabitBitsOutCB.removeItemAt(n2 - 1);
            this.sabitBitsOutCB.setSelectedIndex(0);
        }
        super.updateBitsOutValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.framingBitsInCB) {
            if (this.isSyncMsgFraming(0)) {
                this.enableComponent(this.sabitBitsInCB);
            } else {
                this.sabitBitsInCB.setEnabled(false);
            }
        }
    }

    public void applyChangesToModel() throws Exception {
        sBitsConfig sBitsConfig2 = new sBitsConfig();
        if (db.on()) {
            db.println("eneter ASBPP applyChangesToModel");
        }
        sBitsConfig2.facilityType = this.parent.getFacilityTypeSelection(this.parent.getBitsInFacilityType());
        sBitsConfig2.adminState = this.getAdminStateFromSelection(this.stateBitsInCB.getSelectedIndex());
        sBitsConfig2.coding = this.getCodingFromSelection(this.codingBitsInCB.getSelectedIndex());
        sBitsConfig2.framing = this.getFramingFromSelection(this.framingBitsInCB.getSelectedIndex());
        sBitsConfig2.syncMessageIn = this.ssmEnabledBitsInCB.isSelected();
        sBitsConfig2.assumedQuality = this.pci.showAdminSSM() ? this.getQualitySelection((Attribute)this.adminSsmBitsInCB.getSelectedItem()) : eQualityLevel.STU_SDH;
        sBitsConfig2.saBit = !this.parent.isLineMode() ? eSaBit.from_int(this.sabitBitsInCB.getSelectedIndex()) : eSaBit.from_int(this.sabitBitsOutCB.getSelectedIndex());
        sBitsConfig2.facilityTypeBitsOut = this.parent.getFacilityTypeSelection(this.parent.getBitsOutFacilityType());
        if (this.pci.isBitsOutStateProvisionable()) {
            sBitsConfig2.adminStateBitsOut = this.getAdminStateFromSelection(this.stateBitsOutCB.getSelectedIndex());
        }
        sBitsConfig2.codingBitsOut = this.getCodingFromSelection(this.codingBitsOutCB.getSelectedIndex());
        sBitsConfig2.framingBitsOut = this.getFramingFromSelection(this.framingBitsOutCB.getSelectedIndex());
        sBitsConfig2.aisThreshold = this.pci.isAISThresholdProvisionable() ? this.getQualitySelection((Attribute)this.qualityCB.getSelectedItem()) : eQualityLevel.STU_SDH;
        sBitsConfig2.cableSelection = eCableType.PAUSE_75_OHM;
        sBitsConfig2.bitsLBO = eBitsLBO.BITS_LBO_0_133_FEET;
        this.dumpData(sBitsConfig2);
        this.syncModel.setBitsConfig(this.bitsPort, sBitsConfig2);
        if (db.on()) {
            db.println("leave ASBPP applyChangesToModel");
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("enter ASBPP refreshFromModel (bitsPort=" + this.bitsPort.value() + ")");
        }
        sBitsConfig sBitsConfig2 = null;
        sBitsConfig2 = this.syncModel.getBitsConfig(this.bitsPort);
        this.dumpData(sBitsConfig2);
        this.stateBitsInCB.setSelectedIndex(this.getAdminStateIndex(sBitsConfig2.adminState));
        this.codingBitsInCB.setSelectedIndex(this.getCodingIndex(sBitsConfig2.coding));
        this.framingBitsInCB.setSelectedIndex(this.getFramingIndex(sBitsConfig2.framing));
        this.ssmEnabledBitsInCB.setSelected(sBitsConfig2.syncMessageIn);
        if (this.pci.showAdminSSM()) {
            this.adminSsmBitsInCB.setSelectedItem(this.getQualityAttribute(sBitsConfig2.assumedQuality.value()));
        }
        this.sabitBitsInCB.setSelectedIndex(sBitsConfig2.saBit.value());
        if (this.pci.isBitsOutStateProvisionable()) {
            this.stateBitsOutCB.setSelectedIndex(this.getAdminStateIndex(sBitsConfig2.adminStateBitsOut));
        }
        this.codingBitsOutCB.setSelectedIndex(this.getCodingIndex(sBitsConfig2.codingBitsOut));
        this.framingBitsOutCB.setSelectedIndex(this.getFramingIndex(sBitsConfig2.framingBitsOut));
        if (this.pci.isAISThresholdProvisionable()) {
            this.qualityCB.setSelectedItem(this.getQualityAttribute(sBitsConfig2.aisThreshold.value()));
        }
        this.sabitBitsOutCB.setSelectedIndex(sBitsConfig2.saBit.value());
        this.enableBitsInComponents();
        this.enableBitsOutComponents();
        if (db.on()) {
            db.println("leave ASBPP refreshFromModel");
        }
    }

    public void enableBitsInComponents() {
        super.enableBitsInComponents();
        if (this.parent.isLineMode() || this.parent.isBits64K(0) || this.parent.isBits2M(0)) {
            this.sabitBitsInCB.setEnabled(false);
        } else if (this.isSyncMsgFraming(0)) {
            this.enableComponent(this.sabitBitsInCB);
        } else {
            this.sabitBitsInCB.setEnabled(false);
        }
    }

    public void enableBitsOutComponents() {
        super.enableBitsOutComponents();
        if (!this.parent.isLineMode() || this.parent.isBits64K(1) || this.parent.isBits2M(1)) {
            this.sabitBitsOutCB.setEnabled(false);
        } else if (this.isSyncMsgFraming(1)) {
            this.enableComponent(this.sabitBitsOutCB);
        } else {
            this.sabitBitsOutCB.setEnabled(false);
        }
    }

    protected boolean isSyncMsgFraming(int n) {
        int n2 = 0;
        n2 = n == 0 ? this.framingBitsInCB.getSelectedIndex() : this.framingBitsOutCB.getSelectedIndex();
        return n2 >= 3 || n2 == framingChoices.length - 1;
    }
}

