/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CardPainter
implements ICardPainter {
    public static final float CARD_H_TO_CARD_W_RATIO = 8.461538f;
    private static final float PORT_H_TO_PORT_W_RATIO = 1.8f;
    private static final float PORT_W_TO_CARD_W_RATIO = 0.3846154f;
    private static final float OPTICON_Y_OFFSET_TO_CARD_H_RATIO = 0.27272728f;
    private static final float OPTICON_Y_SPACING_TO_CARD_H_RATIO = 0.11363637f;
    private static final float FONT_TO_CARD_W_RATIO = 0.30769232f;
    public static final int CARD_WIDTH = 26;
    public int CARD_HEIGHT = Math.round((float)this.getCardWidth() * 8.461538f);
    private final int PORT_WIDTH = Math.round((float)this.getCardWidth() * 0.3846154f);
    private final int PORT_HEIGHT = Math.round((float)this.PORT_WIDTH * 1.8f);
    private final int SMALL_PORT_HEIGHT = this.PORT_WIDTH;
    private static final int PORT_LOOPBACK_DIST = 3;
    private final int PORT_CONN1_X;
    private final int PORT_CONN2_X = this.PORT_CONN1_X = this.PORT_WIDTH / 2;
    private final int PORT_CONN1_Y = this.PORT_HEIGHT / 3;
    private final int PORT_CONN2_Y = this.PORT_CONN1_Y * 2;
    private final int SMALL_PORT_CONN1_Y = this.SMALL_PORT_HEIGHT / 3;
    private final int SMALL_PORT_CONN2_Y = this.SMALL_PORT_CONN1_Y * 2;
    private int OPTICON_X_OFFSET = (this.getCardWidth() - this.PORT_WIDTH) / 2;
    private final int MULTIPORT_OPTICON_X_OFFSET = (this.getCardWidth() - this.PORT_WIDTH) / 2;
    private final int OPTICON_Y_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.27272728f);
    private static final int OPTICON_X_SPACING = 0;
    private final int OPTICON_Y_SPACING = Math.round((float)this.CARD_HEIGHT * 0.11363637f);
    private final int SMALL_OPTICON_Y_SPACING = Math.round((float)((double)((float)this.CARD_HEIGHT * 0.11363637f) * 0.75));
    private final int MINI_PORT_WIDTH = this.PORT_WIDTH;
    private final int MINI_PORT_HEIGHT = Math.round((float)this.PORT_HEIGHT * 0.6f);
    private final int MINI_MULTIPORT_OPTICON_X_OFFSET = Math.round((float)(this.getCardWidth() - this.MINI_PORT_WIDTH) / 2.0f);
    private final int MINI_OPTICON_Y_OFFSET = this.OPTICON_Y_OFFSET - 4;
    private static final int MINI_OPTICON_X_SPACING = 0;
    private final int MINI_OPTICON_Y_SPACING = this.MINI_PORT_HEIGHT + 1;
    public static final double FACTOR_454 = 1.0;
    public static final double FACTOR_454SDH = 0.86;
    public static double SCALE_FACTOR = 0.86;
    public int WIDTH;
    public static int HEIGHT;
    public final int SLOT_WIDTH = this.getCardWidth();
    public static final int SLOT_HEIGHT;
    private static final int SM_WIDTH = 13;
    private static int SM_HEIGHT;
    public Dimension SLOT_DIM;
    public static Dimension SMALL_SLOT_DIM;
    private static final float ACTIVE_Y_LIGHT_OFFSET_TO_CARD_H_RATIO = 0.27272728f;
    private static final float ACTIVE_LIGHT_W_TO_CARD_W_RATIO = 0.23076923f;
    private static final float ACTIVE_LIGHT_H_TO_CARD_H_RATIO = 0.018181818f;
    public static int RECT_HEIGHT;
    public static int RECT_OFFSET;
    public static int TOP_RECT_OFFSET;
    public static int TOP_RECT_HEIGHT;
    public static int BOTTOM_RECT_OFFSET;
    public static int BOTTOM_RECT_HEIGHT;
    public static int EXTRACTOR_HEIGHT;
    public static int EXTRACTOR_WIDTH;
    public static final int TAB_MARGIN = 2;
    public int TAB_RADIUS = (int)((double)((this.getCardWidth() - EXTRACTOR_WIDTH - 2) / 2) * SCALE_FACTOR);
    public int TAB_DIAMETER = this.TAB_RADIUS * 2;
    public int TAB_ARC_WIDTH = this.getCardWidth() - EXTRACTOR_WIDTH - this.TAB_RADIUS - 2;
    public int TAB_ARC_HEIGHT = EXTRACTOR_HEIGHT - this.TAB_DIAMETER;
    public static int BOTTOM_EXTRACTOR_OFFSET;
    public static int BOTTOM_EXTRACTOR_HEIGHT;
    public static final int TOP_EXTRACTOR_OFFSET = 0;
    public static int TOP_EXTRACTOR_HEIGHT;
    public static final int NAME_X_OFFSET = 2;
    public static int NAME_Y_OFFSET;
    public final int ACTIVE_LIGHT_Y_OFFSET = (int)(Math.round((double)((float)this.CARD_HEIGHT * 0.27272728f) * SCALE_FACTOR) - 4L);
    public final int ACTIVE_LIGHT_WIDTH = Math.round((float)this.getCardWidth() * 0.23076923f) - 1;
    public final int ACTIVE_LIGHT_HEIGHT = (int)Math.round((double)((float)this.CARD_HEIGHT * 0.018181818f) * SCALE_FACTOR + 2.0);
    protected Rectangle mainRectangle;
    private static final float[] dash1;
    private static Rectangle topExtractorRectangle;
    private static Rectangle bottomExtractorRectangle;
    private Arc2D.Double topExtractorMain = new Arc2D.Double(EXTRACTOR_WIDTH, 0 - this.TAB_ARC_HEIGHT, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, 90.0, 0);
    private Arc2D.Double topExtractorSmall = new Arc2D.Double(EXTRACTOR_WIDTH + 2, 0 + this.TAB_ARC_HEIGHT, this.TAB_DIAMETER, this.TAB_DIAMETER, 90.0, -180.0, 0);
    private Line2D.Double topExtractorLine = new Line2D.Double(0.0, EXTRACTOR_HEIGHT, EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH, EXTRACTOR_HEIGHT);
    private Arc2D.Double bottomExtractorMain = new Arc2D.Double(EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET + this.TAB_DIAMETER, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, -90.0, 0);
    private Arc2D.Double bottomExtractorSmall = new Arc2D.Double(EXTRACTOR_WIDTH + 2, BOTTOM_EXTRACTOR_OFFSET, this.TAB_DIAMETER, this.TAB_DIAMETER, -90.0, 180.0, 0);
    private Line2D.Double bottomExtractorLine = new Line2D.Double(0.0, BOTTOM_EXTRACTOR_OFFSET, EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH, BOTTOM_EXTRACTOR_OFFSET);
    private static Rectangle topRectangle;
    private static Rectangle bottomRectangle;
    protected CardGraphic cg;
    private Rectangle topBackgroundRectangle;
    private Rectangle bottomBackgroundRectangle;
    protected OpticsModuleModel model;
    protected OpticsMultiplexSectionModel[] bandmodels;
    protected OpticsChannelModel[] models;
    public static final String[] ChnWavelengthStrings;
    public static final String[] BandWavelengthStrings;

    public CardPainter(CardGraphic cardGraphic) {
        OpticsModuleModel opticsModuleModel;
        this.cg = cardGraphic;
        this.WIDTH = cardGraphic.getSlotsOccupied() * 26;
        topRectangle = new Rectangle(0, TOP_RECT_OFFSET, this.WIDTH, TOP_RECT_HEIGHT);
        bottomRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, this.WIDTH, BOTTOM_RECT_HEIGHT);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, HEIGHT);
        int n = 26;
        this.topBackgroundRectangle = new Rectangle(0, 0, n, TOP_EXTRACTOR_HEIGHT);
        this.bottomBackgroundRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, n, HEIGHT);
        this.updateWidth();
        if (this.cg.getModel() instanceof OpticsModuleModel && (opticsModuleModel = (OpticsModuleModel)this.cg.getModel()).getState() != eEqState.DELETED) {
            this.models = opticsModuleModel.getOpticsChannelModels();
            this.bandmodels = opticsModuleModel.getOpticsOMSModels();
        }
    }

    public void updateWidth() {
        this.WIDTH = this.cg.getSlotsOccupied() * this.getCardWidth();
        this.SLOT_DIM = new Dimension(this.WIDTH, HEIGHT);
        topRectangle = new Rectangle(0, TOP_RECT_OFFSET, this.WIDTH, TOP_RECT_HEIGHT);
        bottomRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, this.WIDTH, BOTTOM_RECT_HEIGHT);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, HEIGHT);
    }

    protected int getRectHeight() {
        return RECT_HEIGHT;
    }

    protected int getRectOffset() {
        return RECT_OFFSET;
    }

    protected int getExtractorHeight() {
        return EXTRACTOR_HEIGHT;
    }

    protected int getExtractorWidth() {
        return EXTRACTOR_WIDTH;
    }

    protected int getTabMargin() {
        return 2;
    }

    protected int getExtractorOffset() {
        return 0;
    }

    protected int getNameXOffset() {
        return 2;
    }

    protected int getNameYOffset() {
        return NAME_Y_OFFSET;
    }

    public int getOpticonXOffset() {
        return this.OPTICON_X_OFFSET;
    }

    public int getOpticonYOffset() {
        return this.OPTICON_Y_OFFSET;
    }

    public int getMultiPortOpticonXOffset() {
        return this.MULTIPORT_OPTICON_X_OFFSET;
    }

    public int getOpticonXSpacing() {
        return 0;
    }

    public int getOpticonYSpacing() {
        return this.OPTICON_Y_SPACING;
    }

    public int getMiniMultiPortOticonXOffset() {
        return this.MINI_MULTIPORT_OPTICON_X_OFFSET;
    }

    public int getCardWidth() {
        return 26;
    }

    public int getCardHeight() {
        return this.CARD_HEIGHT;
    }

    public Rectangle getMainRectangle() {
        return this.mainRectangle;
    }

    public int getPortWidth() {
        return this.PORT_WIDTH;
    }

    public int getPortHeight() {
        return this.PORT_HEIGHT;
    }

    public int getMiniPortWidth() {
        return this.MINI_PORT_WIDTH;
    }

    public int getMiniPortHeight() {
        return this.MINI_PORT_HEIGHT;
    }

    public int getMiniOpticonXSpacing() {
        return 0;
    }

    public int getMiniOpticonYSpacing() {
        return this.MINI_OPTICON_Y_SPACING;
    }

    public int getMiniOpticonYOffset() {
        return this.MINI_OPTICON_Y_OFFSET;
    }

    public int getPortX(int n, int n2) {
        return this.MULTIPORT_OPTICON_X_OFFSET + 0 * n2;
    }

    public int getPortY(int n, int n2) {
        if (n == 0) {
            return this.OPTICON_Y_OFFSET + this.OPTICON_Y_SPACING * n2;
        }
        return this.OPTICON_Y_OFFSET + this.SMALL_OPTICON_Y_SPACING * n2;
    }

    public int getSmallPortWidth() {
        return 0;
    }

    public int getSmallPortHeight() {
        return this.SMALL_PORT_HEIGHT;
    }

    public int getPortConn1X() {
        return this.PORT_CONN1_X;
    }

    public int getPortConn2X() {
        return this.PORT_CONN2_X;
    }

    public int getPortConn1Y() {
        return this.PORT_CONN1_Y;
    }

    public int getPortConn2Y() {
        return this.PORT_CONN2_Y;
    }

    public int getSmallPortConn1Y() {
        return this.SMALL_PORT_CONN1_Y;
    }

    public int getSmallPortConn2Y() {
        return this.SMALL_PORT_CONN2_Y;
    }

    public int getSmallPortConn1X() {
        return 0;
    }

    public int getSmallPortConn2X() {
        return 0;
    }

    public int getPortLoopbackDist() {
        return 3;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(graphics2D.getFont().deriveFont(1));
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Font font = graphics2D.getFont();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.cg.getCurrentColor());
        graphics2D.fill(this.mainRectangle);
        this.paintActual(graphics2D);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.draw(this.mainRectangle);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.gray);
        graphics2D.draw(topExtractorRectangle);
        graphics2D.draw(bottomExtractorRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.topExtractorMain);
        graphics2D.draw(this.topExtractorSmall);
        graphics2D.draw(this.topExtractorLine);
        graphics2D.draw(this.bottomExtractorMain);
        graphics2D.draw(this.bottomExtractorSmall);
        graphics2D.draw(this.bottomExtractorLine);
        int n5 = this.cg.getState();
        String string = "";
        Color color = graphics2D.getColor();
        Color color2 = this.cg.getCurrentColor();
        switch (n5) {
            case 5: {
                string = "Act";
                color2 = Color.green;
                break;
            }
            case 4: {
                string = "Sby";
                color2 = Color.yellow;
                break;
            }
            case 2: {
                string = "Ldg";
                color2 = Color.white;
                break;
            }
            case 3: {
                string = "Fail";
                break;
            }
            case 1: {
                string = "Mis";
                break;
            }
            case 0: {
                string = "NP";
                break;
            }
            case 6: {
                string = "Del";
                break;
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, 2, this.ACTIVE_LIGHT_Y_OFFSET + this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color2);
        graphics2D.fillRect(this.getCardWidth() - this.ACTIVE_LIGHT_WIDTH - 2, this.ACTIVE_LIGHT_Y_OFFSET, this.ACTIVE_LIGHT_WIDTH, this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(this.getCardWidth() - this.ACTIVE_LIGHT_WIDTH - 2, this.ACTIVE_LIGHT_Y_OFFSET, this.ACTIVE_LIGHT_WIDTH, this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color);
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 3.0f, dash1, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(topRectangle);
        graphics2D.draw(bottomRectangle);
        graphics2D.setColor(Color.black);
        int n6 = 0;
        String string2 = this.cg.getEqLabel();
        Font font2 = graphics.getFont();
        FontMetrics fontMetrics = component.getFontMetrics(font2);
        int n7 = fontMetrics.getAscent() - 1;
        if (SCALE_FACTOR == 1.0) {
            n4 = 3;
            n3 = 7;
        } else {
            n4 = 0;
            n3 = 9;
        }
        if (string2.startsWith("STM64XFP")) {
            String string3 = string2.substring(0, 3);
            String string4 = string2.substring(3, 5);
            String string5 = string2.substring(5, string2.length());
            int n8 = n2 + NAME_Y_OFFSET - 1;
            int n9 = fontMetrics.stringWidth(string3);
            graphics2D.drawString(string3, (n + this.getCardWidth() - n9) / 2, n8);
            n9 = fontMetrics.stringWidth(string4);
            graphics2D.drawString(string4, (n + this.getCardWidth() - n9) / 2, n8 += n7);
            n9 = fontMetrics.stringWidth(string5);
            graphics2D.drawString(string5, (n + this.getCardWidth() - n9) / 2, n8 += n7);
        } else if (string2.startsWith("STM") || string2.startsWith("E1_") || string2.startsWith("ML100") || string2.startsWith("DS3") && string2.length() > 3 || string2.startsWith("ETH") && string2.length() > 3) {
            int n10 = 3;
            if (string2.startsWith("ML100")) {
                n10 = 2;
            }
            String string6 = string2.substring(0, n10);
            String string7 = string2.substring(n10);
            if (string2.startsWith("ML100X")) {
                string7 = string7.replaceFirst("-8", "");
            }
            graphics2D.drawString(string6, n + 2, n2 + NAME_Y_OFFSET - n4);
            int n11 = string7.length() == 1 ? n + 2 + 7 : (string7.length() == 2 ? n + 2 + 4 : n + 2);
            graphics2D.drawString(string7, n11, n2 + NAME_Y_OFFSET + n3);
        } else if (string2.startsWith("MS-I")) {
            String string8 = string2.substring(0, 3);
            String string9 = string2.substring(3, 5);
            String string10 = string2.substring(5, string2.length());
            int n12 = n2 + NAME_Y_OFFSET - 1;
            int n13 = fontMetrics.stringWidth(string8);
            graphics2D.drawString(string8, (n + this.getCardWidth() - n13) / 2, n12);
            n13 = fontMetrics.stringWidth(string9);
            graphics2D.drawString(string9, (n + this.getCardWidth() - n13) / 2, n12 += n7);
            n13 = fontMetrics.stringWidth(string10);
            graphics2D.drawString(string10, (n + this.getCardWidth() - n13) / 2, n12 += n7);
        } else if (string2.startsWith("XC")) {
            String string11 = string2.substring(0, 2);
            String string12 = string2.substring(2);
            if (string12.length() > 3) {
                string12 = string12.substring(0, string12.indexOf(32));
            }
            graphics2D.drawString(string11, n + 2, n2 + NAME_Y_OFFSET - n4);
            graphics2D.drawString(string12, n + 2 + 2, n2 + NAME_Y_OFFSET + n3);
        } else if (string2.startsWith("UNK")) {
            String string13 = string2.substring(0, 4);
            graphics2D.drawString(string13, n + 2 - 1, n2 + NAME_Y_OFFSET - n4);
        } else if (string2.startsWith("TXP") || string2.startsWith("MXP")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
            String string14 = "";
            String string15 = "";
            String string16 = "";
            String string17 = null;
            int n14 = n2 + NAME_Y_OFFSET - 1;
            try {
                string14 = stringTokenizer.nextToken();
                string15 = stringTokenizer.nextToken();
                string16 = stringTokenizer.nextToken();
                string17 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (string17 != null) {
                int n15 = fontMetrics.getAscent() / 2;
                int n16 = (BOTTOM_EXTRACTOR_OFFSET - (BOTTOM_RECT_OFFSET + BOTTOM_RECT_HEIGHT)) / 2;
                int n17 = (n + this.getCardWidth() - fontMetrics.stringWidth(string17)) / 2;
                int n18 = n2 + BOTTOM_RECT_OFFSET + BOTTOM_RECT_HEIGHT + n16 + n15;
                graphics2D.drawString(string17, n17, n18);
            }
            if (string14.length() > 4 || string15.length() > 4 || string16.length() > 4) {
                font2 = new Font(font2.getFontName(), font2.getStyle(), font2.getSize() - 1);
                fontMetrics = component.getFontMetrics(font2);
                graphics2D.setFont(font2);
            }
            graphics2D.drawString(string14, n + 2, n14);
            graphics2D.drawString(string15, n + 2, n14 += n7);
            graphics2D.drawString(string16, n + 2, n14 += n7);
        } else if (string2.startsWith("AD-1B")) {
            String string18 = "AD1B";
            String string19 = "x.x";
            n6 = this.getBandWave();
            if (n6 != 0) {
                string19 = BandWavelengthStrings[n6].substring(2, 6);
            }
            int n19 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string18, n + 2, n19);
            graphics2D.drawString(string19, n + 2, n19 += n7);
        } else if (string2.startsWith("AD-4B")) {
            String string20 = "AD4B";
            String string21 = "x.x";
            n6 = this.getBandWave();
            if (n6 != 0) {
                string21 = BandWavelengthStrings[n6].substring(2, 6);
            }
            int n20 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string20, n + 2, n20);
            graphics2D.drawString(string21, n + 2, n20 += n7);
        } else if (string2.startsWith("AD-1C")) {
            String string22 = "AD1C";
            String string23 = "x.x";
            n6 = this.getWave();
            if (n6 != 0) {
                string23 = ChnWavelengthStrings[n6].substring(2, 6);
            }
            int n21 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string22, n + 2, n21);
            graphics2D.drawString(string23, n + 2, n21 += n7);
        } else if (string2.startsWith("AD-2C")) {
            String string24 = "AD2C";
            String string25 = "x.x";
            n6 = this.getWave();
            if (n6 != 0) {
                string25 = ChnWavelengthStrings[n6].substring(2, 6);
            }
            int n22 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string24, n + 2, n22);
            graphics2D.drawString(string25, n + 2, n22 += n7);
        } else if (string2.startsWith("AD-4C")) {
            String string26 = "AD4C";
            String string27 = "x.x";
            n6 = this.getWave();
            if (n6 != 0) {
                string27 = ChnWavelengthStrings[n6].substring(2, 6);
            }
            int n23 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string26, n + 2, n23);
            graphics2D.drawString(string27, n + 2, n23 += n7);
        } else if (string2.startsWith("OPT-BST E")) {
            String string28 = "OPT";
            String string29 = "BST";
            String string30 = "E";
            int n24 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string28, n + 2, n24);
            graphics2D.drawString(string29, n + 2, n24 += n7);
            graphics2D.drawString(string30, n + 2, n24 += n7);
        } else if (string2.equals("OPT-BST L")) {
            String string31 = "OPT";
            String string32 = "BST";
            String string33 = "L";
            int n25 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string31, n + 2, n25);
            graphics2D.drawString(string32, n + 2, n25 += n7);
            graphics2D.drawString(string33, n + 2, n25 += n7);
        } else if (string2.equals("OPT-BST")) {
            String string34 = "OPT";
            String string35 = "BST";
            int n26 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string34, n + 2, n26);
            graphics2D.drawString(string35, n + 2, n26 += n7);
        } else if (string2.startsWith("OPT-PRE")) {
            String string36 = "OPT";
            String string37 = "PRE";
            int n27 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string36, n + 2, n27);
            graphics2D.drawString(string37, n + 2, n27 += n7);
        } else if (string2.startsWith("Optical amplifier L")) {
            String string38 = "OPT";
            String string39 = "AMP";
            String string40 = "L";
            int n28 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string38, n + 2, n28);
            graphics2D.drawString(string39, n + 2, n28 += n7);
            graphics2D.drawString(string40, n + 2, n28 += n7);
        } else if (string2.startsWith("OSC M")) {
            String string41 = "OSCM";
            String string42 = "";
            int n29 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string41, n + 2, n29);
            graphics2D.drawString(string42, n + 2, n29 += n7);
        } else if (string2.startsWith("OSC-CSM")) {
            String string43 = "OSC";
            String string44 = "CSM";
            int n30 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string43, n + 2, n30);
            graphics2D.drawString(string44, n + 2, n30 += n7);
        } else if (string2.startsWith("CE-100T")) {
            String string45 = "CE";
            String string46 = "100T";
            int n31 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string45, n + 2, n31);
            graphics2D.drawString(string46, n + 2, n31 += n7);
        } else if (string2.startsWith("CE-1000")) {
            String string47 = "CE";
            String string48 = "1000";
            int n32 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string47, n + 2, n32);
            graphics2D.drawString(string48, n + 2, n32 += n7);
        } else if (string2.startsWith("32 WSS L")) {
            String string49 = "   32WSS-L";
            String string50 = "";
            int n33 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string49, n + 2, n33);
            graphics2D.drawString(string50, n + 2, n33 += n7);
        } else if (string2.equals("32 DMX L")) {
            String string51 = "   32DMX-L";
            String string52 = "";
            int n34 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string51, n + 2, n34);
            graphics2D.drawString(string52, n + 2, n34 += n7);
        } else if (string2.startsWith("32 WSS")) {
            String string53 = "       32 WSS";
            String string54 = "";
            int n35 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string53, n + 2, n35);
            graphics2D.drawString(string54, n + 2, n35 += n7);
        } else if (string2.equals("32 DMX")) {
            String string55 = "32";
            String string56 = "DMX";
            int n36 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string55, n + 2, n36);
            graphics2D.drawString(string56, n + 2, n36 += n7);
        } else if (string2.startsWith("4MD")) {
            String string57 = "4MD";
            String string58 = "x.xx";
            n6 = this.getWave();
            if (n6 != 0) {
                string58 = ChnWavelengthStrings[n6].substring(2, 6);
            }
            int n37 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string57, n + 2, n37);
            graphics2D.drawString(string58, n + 2, n37 += n7);
        } else if (string2.startsWith("32 MUXO")) {
            String string59 = "       32 MUXO";
            String string60 = "";
            int n38 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string59, n + 2, n38);
            graphics2D.drawString(string60, n + 2, n38 += n7);
        } else if (string2.equals("32 DMXO")) {
            String string61 = "       32 DMXO";
            String string62 = "";
            int n39 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string61, n + 2, n39);
            graphics2D.drawString(string62, n + 2, n39 += n7);
        } else if (string2.startsWith("FC-MR")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "-");
            String string63 = "";
            String string64 = "";
            int n40 = n2 + NAME_Y_OFFSET - 1;
            try {
                string63 = stringTokenizer.nextToken();
                string64 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            graphics2D.drawString(string63, n + 2, n40);
            graphics2D.drawString(string64, n + 2, n40 += n7);
        } else if (string2.startsWith("TCC2P")) {
            String string65 = "";
            String string66 = "";
            int n41 = n2 + NAME_Y_OFFSET - 1;
            string65 = string2.substring(0, 4);
            string66 = string2.substring(4, string2.length());
            int n42 = fontMetrics.stringWidth(string65);
            graphics2D.drawString(string65, (n + 26 - n42) / 2, n41);
            graphics2D.drawString(string66, (n + this.getCardWidth() - n42) / 2, n41 += n7);
        } else if (string2.startsWith("RAN_SVC")) {
            int n43 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString("RAN", n + 2, n43);
            graphics2D.drawString("SVC", n + 2, n43 += n7);
        } else if (string2.startsWith("MRC")) {
            String string67 = string2.substring(0, 3);
            String string68 = string2.substring(4, string2.length());
            int n44 = n2 + NAME_Y_OFFSET - 1;
            int n45 = fontMetrics.stringWidth(string67);
            graphics2D.drawString(string67, (n + this.getCardWidth() - n45) / 2, n44);
            n45 = fontMetrics.stringWidth(string68);
            graphics2D.drawString(string68, (n + this.getCardWidth() - n45) / 2, n44 += n7);
        } else {
            if (string2.startsWith("G1000")) {
                graphics2D.setFont(new Font(font2.getFontName(), font2.getStyle(), font2.getSize() - 1));
            }
            graphics2D.drawString(string2, n + 2, n2 + NAME_Y_OFFSET);
            if (string2.endsWith("(TXP)")) {
                graphics2D.drawString("(TXP)", n + 2, n2 + n7 + NAME_Y_OFFSET);
            }
            graphics2D.setFont(font2);
        }
        graphics2D.setStroke(stroke);
    }

    public void paintActual(Graphics2D graphics2D) {
        int n = this.cg.getState();
        int n2 = this.cg.getSlot();
        int n3 = this.cg.getSlotsOccupied();
        String string = null;
        int n4 = 26;
        boolean bl = false;
        ArrayList arrayList = null;
        try {
            arrayList = ((EntityModel)this.cg.getModel()).getNodeModelDelegate().getMfgData(this.cg.getModel().getShelfId());
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            // empty catch block
        }
        for (int i = 0; i < n3; ++i) {
            block9: {
                block8: {
                    block7: {
                        bl = false;
                        if (arrayList != null && arrayList.size() < n2 + i - 1) {
                            string = (String)arrayList.get(n2 + i - 1);
                        }
                        this.topBackgroundRectangle = new Rectangle(i * n4, 0, n4, TOP_EXTRACTOR_HEIGHT);
                        this.bottomBackgroundRectangle = new Rectangle(i * n4, BOTTOM_RECT_OFFSET, n4, HEIGHT);
                        if (i != 0) break block7;
                        if (this.cg.getState() == 1 && this.cg.hasProvisionedCard()) break block8;
                    }
                    if (i <= 0 || string == null || string.equals("")) break block9;
                }
                graphics2D.setColor(this.cg.getCurrentColor());
                graphics2D.fill(this.topBackgroundRectangle);
                graphics2D.fill(this.bottomBackgroundRectangle);
                bl = true;
            }
            if (!bl || i <= 0) continue;
            Rectangle rectangle = new Rectangle(i * n4 + 2, 2, EXTRACTOR_WIDTH - 4, TOP_EXTRACTOR_HEIGHT - 4);
            Rectangle rectangle2 = new Rectangle(i * n4 + 2, BOTTOM_EXTRACTOR_OFFSET + 2, EXTRACTOR_WIDTH - 4, BOTTOM_EXTRACTOR_HEIGHT - 4);
            Arc2D.Double double_ = new Arc2D.Double(i * n4 + EXTRACTOR_WIDTH, 0 - this.TAB_ARC_HEIGHT, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, 90.0, 0);
            Arc2D.Double double_2 = new Arc2D.Double(i * n4 + EXTRACTOR_WIDTH, 0 + this.TAB_ARC_HEIGHT, this.TAB_DIAMETER, this.TAB_DIAMETER, 90.0, -180.0, 0);
            Line2D.Double double_3 = new Line2D.Double(i * n4, EXTRACTOR_HEIGHT, EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH + i * n4, EXTRACTOR_HEIGHT);
            Arc2D.Double double_4 = new Arc2D.Double(i * n4 + EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET + this.TAB_DIAMETER, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, -90.0, 0);
            Arc2D.Double double_5 = new Arc2D.Double(i * n4 + EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET, this.TAB_DIAMETER, this.TAB_DIAMETER, -90.0, 180.0, 0);
            Line2D.Double double_6 = new Line2D.Double(i * n4, BOTTOM_EXTRACTOR_OFFSET, EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH + i * n4, BOTTOM_EXTRACTOR_OFFSET);
            Line2D.Double double_7 = new Line2D.Double(i * n4, 0.0, i * n4, EXTRACTOR_HEIGHT);
            Line2D.Double double_8 = new Line2D.Double(i * (n4 * 2), 0.0, i * (n4 * 2), EXTRACTOR_HEIGHT);
            Line2D.Double double_9 = new Line2D.Double(i * n4, BOTTOM_RECT_OFFSET, i * n4, BOTTOM_EXTRACTOR_OFFSET + EXTRACTOR_HEIGHT);
            Line2D.Double double_10 = new Line2D.Double(i * (n4 * 2), BOTTOM_RECT_OFFSET, i * (n4 * 2), BOTTOM_EXTRACTOR_OFFSET + EXTRACTOR_HEIGHT);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.draw(this.mainRectangle);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.gray);
            graphics2D.draw(rectangle);
            graphics2D.draw(rectangle2);
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
            graphics2D.draw(double_2);
            graphics2D.draw(double_3);
            graphics2D.draw(double_4);
            graphics2D.draw(double_5);
            graphics2D.draw(double_6);
            graphics2D.draw(double_8);
            graphics2D.draw(double_7);
            graphics2D.draw(double_10);
            graphics2D.draw(double_9);
        }
    }

    public int getWave() {
        int n = 0;
        try {
            n = this.models[0].getExpectedWaveLength();
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    public int getBandWave() {
        int n = 0;
        try {
            n = this.bandmodels[0].getExpectedBand().value();
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    static {
        SLOT_HEIGHT = HEIGHT = (int)(220.0 * SCALE_FACTOR);
        SM_HEIGHT = HEIGHT / 2;
        SMALL_SLOT_DIM = new Dimension(13, SM_HEIGHT);
        RECT_HEIGHT = (int)(4.0 * SCALE_FACTOR);
        RECT_OFFSET = (int)(49.0 * SCALE_FACTOR);
        TOP_RECT_OFFSET = 40;
        TOP_RECT_HEIGHT = RECT_HEIGHT;
        BOTTOM_RECT_OFFSET = (int)(179.0 * SCALE_FACTOR);
        BOTTOM_RECT_HEIGHT = RECT_HEIGHT;
        EXTRACTOR_HEIGHT = (int)(22.0 * SCALE_FACTOR);
        EXTRACTOR_WIDTH = 10;
        BOTTOM_EXTRACTOR_OFFSET = HEIGHT - EXTRACTOR_HEIGHT - 1;
        BOTTOM_EXTRACTOR_HEIGHT = EXTRACTOR_HEIGHT;
        TOP_EXTRACTOR_HEIGHT = EXTRACTOR_HEIGHT;
        NAME_Y_OFFSET = (int)(32.0 * SCALE_FACTOR);
        dash1 = new float[]{1.5f};
        topExtractorRectangle = new Rectangle(2, 2, EXTRACTOR_WIDTH - 4, TOP_EXTRACTOR_HEIGHT - 4);
        bottomExtractorRectangle = new Rectangle(2, BOTTOM_EXTRACTOR_OFFSET + 2, EXTRACTOR_WIDTH - 4, BOTTOM_EXTRACTOR_HEIGHT - 4);
        ChnWavelengthStrings = new String[]{"UNKNOWN", "1530.33", "1531.11", "1531.90", "1532.68", "1534.25", "1535.04", "1535.82", "1536.61", "1538.19", "1538.98", "1539.77", "1540.56", "1542.14", "1542.94", "1543.73", "1544.53", "1546.12", "1546.92", "1547.72", "1548.51", "1550.12", "1550.92", "1551.72", "1552.52", "1554.13", "1554.94", "1555.75", "1556.55", "1558.17", "1558.98", "1559.79", "1560.61"};
        BandWavelengthStrings = new String[]{"UNKNOWN", "1530.33", "1534.25", "1538.19", "1542.14", "1546.12", "1550.12", "1554.13", "1558.17"};
    }
}

