/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sPathThresholds;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import com.cisco.ctc455.ui.stm1e.STM1E12PathPmThresholdsTableModel;
import com.cisco.ctc455.ui.stm1e.STM1ECardTabbedView;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class STM1E12PathPmThresholdsPane
extends NodeProvPane
implements TableModelListener {
    protected STM1E12PathPmThresholdsTableModel dataModel = null;
    protected TdmHoModel[] stsModels = null;
    protected InterfaceModel[] lineModels = null;
    protected int indexOfSts;
    protected int numSts = 0;
    protected int numLines = 0;
    protected TdmModuleModel eqpmtModel = null;
    protected eIntervalType intervalType = null;
    protected boolean nearEnd = false;
    protected Observer strucChangeObserver = null;
    private static final SDebug db = new SDebug("STM1E12PathPmThresholdsPane");

    public STM1E12PathPmThresholdsPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, eIntervalType eIntervalType2, boolean bl, int n) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.lineModels = interfaceModelArray;
        this.indexOfSts = n;
        this.stsModels = this.getSts(interfaceModelArray, n);
        this.numLines = this.lineModels == null ? 0 : this.lineModels.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        if (this.stsModels == null) {
            this.numSts = 0;
            return;
        }
        this.numSts = this.stsModels.length;
        tableColumn.setPreferredWidth(225);
        this.table.setAutoCreateColumnsFromModel(false);
        this.strucChangeObserver = new Observer(){

            public void update(Observable observable, Object object) {
                Integer n;
                if (db.on()) {
                    db.println("Got an update from linemodel");
                }
                if (object instanceof Integer && (n = (Integer)object).equals(ModelUpdateType.ADDED)) {
                    STM1E12PathPmThresholdsPane.this.initializeLines();
                }
            }
        };
        this.registerWithModel();
        this.add((Component)uScrollPane);
    }

    protected TdmHoModel[] getSts(InterfaceModel[] interfaceModelArray, int n) {
        Collection collection = null;
        if (this.nearEnd) {
            InterfaceModel[] interfaceModelArray2 = ((STM1ECardTabbedView)this.getParentView()).getStmModeModels();
            collection = InterfaceModel.getHigherLayerModels(interfaceModelArray2, n);
        }
        if (collection == null) {
            if (db.on()) {
                db.println("Error in getting STS lines");
            }
            return null;
        }
        if (db.on()) {
            db.println("Returning STSs " + collection.size());
        }
        return collection.toArray(new TdmHoModel[0]);
    }

    protected synchronized void initializeLines() {
        this.dispose();
        this.stsModels = this.getSts(this.lineModels, this.indexOfSts);
        this.numSts = this.stsModels == null ? 0 : this.stsModels.length;
        this.registerWithModel();
        this.dataModel.setStsModel(this.stsModels);
    }

    protected STM1E12PathPmThresholdsTableModel getDataModel() {
        return new STM1E12PathPmThresholdsTableModel(this.getUiModel().getNodeModel(), this.stsModels, this.intervalType, this.nearEnd);
    }

    protected void registerWithModel() {
        int n;
        for (n = 0; n < this.numSts; ++n) {
            this.stsModels[n].addObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.numLines; ++n) {
            this.lineModels[n].addObserver(this.strucChangeObserver);
        }
    }

    public void dispose() {
        int n;
        for (n = 0; n < this.numSts; ++n) {
            this.stsModels[n].deleteObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.numLines; ++n) {
            this.lineModels[n].deleteObserver(this.strucChangeObserver);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (db.on()) {
                    db.println("Got an Update Message for " + observable);
                }
                this.requestRefresh(observable, this.getRefreshThread(observable));
            } else if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (db.on()) {
                    db.println("GOT A DELETED MESSAGE ");
                }
                SwingUtilities.invokeLater(this.getDeleteThread());
            }
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                STM1E12PathPmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    private Runnable getDeleteThread() {
        return new Runnable(){

            public void run() {
                STM1E12PathPmThresholdsPane.this.initializeLines();
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.stsModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In StsTermPmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            if (db.on()) {
                db.println("Applying changes");
            }
            for (n = 0; n < this.numSts; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.printStats(this.dataModel.getThresholdsVal(n));
                this.stsModels[n].setPmThresholds(this.nearEnd, this.intervalType, this.dataModel.getThresholdsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.numSts; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void printStats(sPathThresholds sPathThresholds2) {
        if (db.on()) {
            db.println("===============================================");
        }
        if (db.on()) {
            db.println("CV " + sPathThresholds2.cv);
        }
        if (db.on()) {
            db.println("ES " + sPathThresholds2.es);
        }
        if (db.on()) {
            db.println("SES " + sPathThresholds2.ses);
        }
        if (db.on()) {
            db.println("FC " + sPathThresholds2.fc);
        }
        if (db.on()) {
            db.println("UAS " + sPathThresholds2.uas);
        }
        if (db.on()) {
            db.println("BBE " + sPathThresholds2.bbe);
        }
        if (db.on()) {
            db.println("===============================================");
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.STM1E12PathPmThresholdsPane;
    }
}

