/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SlotModel;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.StoreObservable;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ChangeCardDialog;
import cerent.util.SDebug;
import com.cisco.ctc600.ui.asap.PimSlot;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class AsapCard
extends CardGraphic {
    private Object pimSlotsLock = new Object();
    private PimSlot[] pimSlots = null;
    private IAlarmStore eleAlarmStore = null;

    public AsapCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug);
        this.createChildren();
        if (sDebug.on()) {
            sDebug.println("Card: " + entityModel.getEqLabel() + "\tNum of children: " + this.entityM.getChildren().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createChildren() {
        block10: {
            try {
                List list = this.entityM.getChildren();
                if (this.db.on()) {
                    this.db.println("Number of PIM slot is " + list.size());
                }
                PimSlot[] pimSlotArray = new PimSlot[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    EntityModel entityModel = (EntityModel)list.get(i);
                    if (this.db.on()) {
                        this.db.println("Entity for PIM slot [" + i + "] is " + entityModel);
                    }
                    if (entityModel == null) {
                        if (!this.db.on()) continue;
                        this.db.println("Entity for PIM slot [" + i + "] is NULL");
                        continue;
                    }
                    if (!(entityModel instanceof PluggableSlotModel)) {
                        if (!this.db.on()) continue;
                        this.db.println("Error: Entity for PIM slot [" + i + "] is " + entityModel);
                        continue;
                    }
                    pimSlotArray[i] = new PimSlot((PluggableSlotModel)entityModel, this.parent, this.db, this.getChildBounds(i));
                }
                Object object = this.pimSlotsLock;
                synchronized (object) {
                    this.pimSlots = pimSlotArray;
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block10;
                this.db.println("Exception while creating PIM slots");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PimSlot[] getChildren() {
        Object object = this.pimSlotsLock;
        synchronized (object) {
            int n = this.pimSlots == null ? 0 : this.pimSlots.length;
            PimSlot[] pimSlotArray = new PimSlot[n];
            if (n > 0) {
                System.arraycopy(this.pimSlots, 0, pimSlotArray, 0, n);
            }
            return pimSlotArray;
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            PimSlot[] pimSlotArray = this.getChildren();
            for (int i = 0; i < pimSlotArray.length; ++i) {
                if (pimSlotArray[i] == null || !pimSlotArray[i].contains(mouseEvent.getPoint())) continue;
                return pimSlotArray[i].getTooltipText(mouseEvent);
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        Object[] objectArray;
        if (observable instanceof StoreObservable && object instanceof Object[] && (objectArray = (Object[])object)[0] == ModelUpdateType.DELETED) {
            return;
        }
        super.update(observable, object);
        if (observable instanceof StoreObservable && object instanceof ArrayList) {
            super.refreshCard();
        }
        if (this.db.on()) {
            this.db.println("AsapCard:update: END");
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        PimSlot[] pimSlotArray = this.getChildren();
        for (int i = 0; i < pimSlotArray.length; ++i) {
            if (pimSlotArray[i] == null) continue;
            pimSlotArray[i].draw(graphics2D);
        }
    }

    protected void addCustomMenuItems(JPopupMenu jPopupMenu) {
        SlotModel slotModel;
        ModuleModel moduleModel;
        IEntityModel iEntityModel;
        super.addCustomMenuItems(jPopupMenu);
        IEntityModel iEntityModel2 = this.getModel();
        if (iEntityModel2 != null && iEntityModel2 instanceof ModuleModel && (iEntityModel = (moduleModel = (ModuleModel)iEntityModel2).getParent()) instanceof SlotModel && (slotModel = (SlotModel)iEntityModel).getListOfValidChangeType(eEqType.from_int(moduleModel.getEqType())).size() > 0) {
            jPopupMenu.addSeparator();
            boolean bl = AbstractPane.isUserAuthorized(moduleModel, SecurityLevel.PROVISIONING);
            boolean bl2 = this.isCardChangeAllowed() && bl;
            jPopupMenu.add(this.makeMenuAction("Change Card...", bl2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (actionEvent.getActionCommand().equals("Change Card...")) {
                new ChangeCardDialog(JOptionPane.getFrameForComponent(this.parent), (ModuleModel)this.getModel());
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    protected Rectangle getChildBounds(int n) {
        return new Rectangle(3, 35 + 49 * n, this.cardPainter.getCardWidth() - 7, 46);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.eleAlarmStore != null) {
            this.eleAlarmStore.deleteObserver((Observer)this);
            this.eleAlarmStore = null;
        }
        Object object = this.pimSlotsLock;
        synchronized (object) {
            if (this.pimSlots != null) {
                for (int i = 0; i < this.pimSlots.length; ++i) {
                    if (this.pimSlots[i] == null) continue;
                    this.pimSlots[i].dispose();
                    this.pimSlots[i] = null;
                }
            }
            this.pimSlots = null;
        }
        super.dispose();
    }

    protected String getStateString() {
        if (this.eqState == null) {
            return "";
        }
        return ElementDefaults.eqStateToOCNString(this.eqState);
    }
}

