/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapModuleModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InService;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.RollsOnPort;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enum.IfEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.IAdminTableAccess;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class AsapEtherLineMaintTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    private AsapModuleModel asapModuleModel = null;
    private AsapEtherLineModel[] etherLineModels = null;
    private boolean[][] rowDirty = null;
    private int numLines = 0;
    private Attribute[] loopbackVal = null;
    private AdminState[] adminState = null;
    private IServiceState[] serviceState;
    private EntityCellRenderer myPortRenderer;
    protected String[] columnNames = new String[]{"Port", "Admin State", "Service State", "Loopback Type"};
    protected static final int LINENUMBER_INDEX = 0;
    protected static final int STATE_INDEX = 1;
    protected static final int SERVICE_STATE_INDEX = 2;
    protected static final int LOOPBACK_INDEX = 3;
    private static final SDebug db = new SDebug("AsapEtherLineMaintTableModel");

    public AsapEtherLineMaintTableModel(AsapModuleModel asapModuleModel, AsapEtherLineModel[] asapEtherLineModelArray) {
        this.asapModuleModel = asapModuleModel;
        this.etherLineModels = asapEtherLineModelArray;
        this.myPortRenderer = new EntityCellRenderer();
        this.init();
        this.resetDirty();
    }

    private void init() {
        this.numLines = this.etherLineModels.length;
        this.loopbackVal = new Attribute[this.numLines];
        this.rowDirty = new boolean[this.numLines][this.getColumnCount()];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
    }

    public boolean isAdminStateDirty(int n) {
        return this.rowDirty[n][1];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.numLines > 0 && n < this.numLines && AbstractPane.isUserAuthorized(this.asapModuleModel, SecurityLevel.MAINTENANCE)) {
            try {
                return n2 == 1 || n2 == 3 && AdminState.admitsLoopback(this.getAdminState(n).getAdminStateEnum());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean isRowDirty(int n) {
        for (int i = 0; i < this.rowDirty[n].length; ++i) {
            if (!this.rowDirty[n][i]) continue;
            return true;
        }
        return false;
    }

    private eLoopback getLoopbackFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        eLoopback eLoopback2 = eLoopback.NO_LOOPBACK;
        AsapPosLineModel asapPosLineModel = this.etherLineModels[n].getPosLineModel();
        if (asapPosLineModel != null) {
            eLoopback2 = asapPosLineModel.getLoopback();
        } else if (AsapEtherLineMaintTableModel.db.on) {
            db.println("getLoopbackFromModel(): POS line model is null, returning eLoopback.NO_LOOPBACK");
        }
        return eLoopback2;
    }

    private void setLineLoopback(int n) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InService, LoopbackActive, RollsOnPort, EMCProvisionError {
        AsapPosLineModel asapPosLineModel = this.etherLineModels[n].getPosLineModel();
        if (asapPosLineModel != null) {
            asapPosLineModel.setLoopback(eLoopback.from_int(this.getLoopback(n).getIntValue()));
        } else if (AsapEtherLineMaintTableModel.db.on) {
            db.println("setLineLoopback(): POS line model is null, cannot setloopback");
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.adminState[n] == null) {
            this.adminState[n] = AdminState.enumToAdminState(this.getAdminStateFromModel(n));
        }
        return this.adminState[n];
    }

    private eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.etherLineModels[n].getAdminStateEnum();
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.etherLineModels[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private TDMTerminology getTerms() {
        return this.asapModuleModel.getNodeModel().getTDMTerminology();
    }

    private Attribute getLoopback(int n) throws NoSuchInterface, WrongInterfaceType {
        if (AdminState.admitsLoopback(this.getAdminState(n).getAdminStateEnum())) {
            if (this.loopbackVal[n] == null) {
                this.loopbackVal[n] = IfEnumStrings.get(eLoopback.class, this.getLoopbackFromModel(n).value());
            }
        } else {
            this.loopbackVal[n] = IfEnumStrings.get(eLoopback.class, 0);
        }
        this.rowDirty[n][3] = this.loopbackVal[n].getIntValue() != this.getLoopbackFromModel(n).value();
        return this.loopbackVal[n];
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return AdminState.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 3: {
                    return this.getLoopback(n);
                }
                case 1: {
                    return this.getAdminState(n).toString();
                }
                case 2: {
                    return this.getServiceState(n).toString(this.getTerms());
                }
            }
        }
        catch (Exception exception) {
            db.fine("Error in getValueAt " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return null;
    }

    private String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.etherLineModels[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 3: {
                if (!(object instanceof Attribute)) break;
                this.loopbackVal[n] = (Attribute)object;
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n][n2] = true;
        this.fireTableRowsUpdated(n, n);
    }

    protected eLoopback getOldLoopback(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getLoopbackFromModel(n);
    }

    protected eLoopback getNewLoopback(int n) {
        return eLoopback.from_int(this.loopbackVal[n].getIntValue());
    }

    protected void applyToModel() throws Exception {
        block4: for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i][1] && !this.rowDirty[i][3]) continue;
            eAdminState eAdminState2 = this.adminState[i].getAdminStateEnum();
            switch (eAdminState2.value()) {
                case 0: 
                case 1: 
                case 3: {
                    if (!this.rowDirty[i][1]) continue block4;
                    if (this.rowDirty[i][3]) {
                        this.setLineLoopback(i);
                    }
                    this.etherLineModels[i].setAdminState(eAdminState2);
                    continue block4;
                }
                case 2: {
                    if (this.rowDirty[i][1]) {
                        this.etherLineModels[i].setAdminState(eAdminState2);
                    }
                    if (!this.rowDirty[i][3]) continue block4;
                    this.setLineLoopback(i);
                    continue block4;
                }
            }
        }
        this.resetDirty();
    }

    private void resetRowDirty(int n) {
        for (int i = 0; i < this.rowDirty[n].length; ++i) {
            this.rowDirty[n][i] = false;
        }
    }

    private void clearLineModel(int n) {
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.loopbackVal[n] = null;
    }

    private void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetRowDirty(i);
        }
    }

    protected void refreshLineFromModel(int n) {
        this.clearLineModel(n);
        this.resetRowDirty(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.clearLineModel(i);
        }
        this.resetDirty();
        this.fireTableDataChanged();
    }

    public void refreshMyLines(AsapEtherLineModel[] asapEtherLineModelArray) {
        this.etherLineModels = asapEtherLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    protected Attribute[] getLoopbackAttrs() {
        return IfEnumStrings.get(eLoopback.class, IfEnumStrings.LOOPBACK_DEFAULTS);
    }
}

