/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.TdmHoMaintenancePane;
import cerent.util.SDebug;
import com.cisco.ctc600.ui.asap.AsapEtherLineMaintPane;
import java.awt.Component;

public class AsapEtherLoopbackTabbedPane
extends AbstractSubTabbedPane
implements ITabName {
    protected AsapEtherLineModel[] etherLineModels;
    protected AsapPosLineModel[] posLineModels;
    private static final SDebug dbg = new SDebug("AsapEtherLoopbackTabbedPane");

    public AsapEtherLoopbackTabbedPane(String string, TabbedView tabbedView, AsapEtherLineModel[] asapEtherLineModelArray, AsapPosLineModel[] asapPosLineModelArray) {
        super(string, tabbedView);
        this.etherLineModels = asapEtherLineModelArray;
        this.posLineModels = asapPosLineModelArray;
        super.registerWithModel();
    }

    protected void createSubTabs() {
        this.subTabs.setTabPlacement(1);
        this.subTabs.add("Port", (Component)this.getLineMaintPane("Port", this.subTabs, this.etherLineModels));
        String string = this.getUiModel().getNodeModel().getFramingType() == 1 ? "VC4" : "SONET STS";
        this.subTabs.add(string, (Component)this.getHoMaintPane(string, this.subTabs, this.posLineModels, 1));
    }

    protected Pane getLineMaintPane(String string, TabbedView tabbedView, AsapEtherLineModel[] asapEtherLineModelArray) {
        return new AsapEtherLineMaintPane(string, tabbedView, asapEtherLineModelArray);
    }

    protected Pane getHoMaintPane(String string, TabbedView tabbedView, AsapPosLineModel[] asapPosLineModelArray, int n) {
        return new TdmHoMaintenancePane(string, tabbedView, asapPosLineModelArray, n);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof EtherLineUpdate) {
            if (dbg.on()) {
                dbg.println("Received EtherLineUpdate...");
            }
            this.etherLineModels = (AsapEtherLineModel[])((EtherLineUpdate)object).getEtherLineModels();
            this.posLineModels = (AsapPosLineModel[])((EtherLineUpdate)object).getPosLineModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

