/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.model.AdminState;
import cerent.cms.model.AsapModuleModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.Model;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.AnnotatedException;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import com.cisco.ctc600.ui.asap.AsapPosPortTableModel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AsapPosPortProvPane
extends NodeProvPane
implements ItemListener,
TableModelListener,
PropertyChangeListener {
    private AsapPosPortTableModel dataModel = null;
    private AsapPosLineModel[] posLineModels = null;
    private ObservableManager obsMgr = null;
    private JComboBox frmTypeCombo;
    private RowEditorModel rowEditorModel;
    private static final SDebug db = new SDebug("AsapPosPortProvPane");

    public AsapPosPortProvPane(String string, TabbedView tabbedView, AsapPosLineModel[] asapPosLineModelArray) {
        super(string, tabbedView);
        this.posLineModels = asapPosLineModelArray;
        this.dataModel = new AsapPosPortTableModel((AsapModuleModel)this.getUiModel(), asapPosLineModelArray);
        this.dataModel.addTableModelListener(this);
        this.rowEditorModel = new RowEditorModel();
        this.table = new UTableExt(this.dataModel, this.rowEditorModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane);
        this.customizedProvPane();
        this.table.sizeColumnsToFit(-1);
        this.registerWithModel();
    }

    private void customizedProvPane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField()));
        tableColumn.setPreferredWidth(200);
        this.setCellEditorAdminState();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[5]);
        Attribute[] attributeArray = this.dataModel.getEncapCrcTypeAttrs();
        Attribute attribute = attributeArray[0];
        Attribute attribute2 = attributeArray[1];
        Attribute attribute3 = attributeArray[2];
        this.frmTypeCombo = this.getComboBoxFor(this.dataModel.getPosFramingTypeAttrs());
        this.frmTypeCombo.addItemListener(this);
        tableColumn.setCellEditor(new DefaultCellEditor(this.frmTypeCombo));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[6]);
        attributeArray = this.dataModel.getEncapCrcTypeAttrs();
        Attribute attribute4 = attributeArray[0];
        Attribute attribute5 = attributeArray[1];
        Attribute attribute6 = attributeArray[2];
        this.rowEditorModel.addEditor(attribute, new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute4, attribute6})));
        this.rowEditorModel.addEditor(attribute2, new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute5, attribute6})));
        this.rowEditorModel.addEditor(attribute3, new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute6})));
        tableColumn.setPreferredWidth(100);
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[8]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
    }

    protected void setCellEditorAdminState() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[2]);
        boolean bl = true;
        try {
            bl = Model.getFramingType(this.uiModel.getNodeModel()).isSonet();
        }
        catch (AnnotatedException annotatedException) {
            db.fine("Could not get framing type. Assuming SONET");
        }
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(bl);
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        db.fine("enteringPage");
        this.getObsMgr().setPassing(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        db.fine("leavingPage");
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected void registerWithModel() {
        super.registerWithModel();
        this.getObsMgr().setObservable((Observable[])this.posLineModels);
    }

    protected ObservableManager getObsMgr() {
        if (this.obsMgr == null) {
            this.obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this.obsMgr;
    }

    protected void changeMessage(Observable observable, Object object) {
        db.fine("Got a ObjChangeMessage for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                AsapPosPortProvPane.this.refreshLine(observable);
            }
        };
    }

    private void refreshLine(Observable observable) {
        int n = Arrays.asList(this.posLineModels).indexOf(observable);
        if (n != -1) {
            db.fine("Refreshing Line " + n);
            this.dataModel.refreshLineFromModel(n);
        } else {
            db.fine("Cannot find Model during refreshLine() " + observable);
        }
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof EtherLineUpdate) {
            this.posLineModels = (AsapPosLineModel[])((EtherLineUpdate)object).getPosLineModels();
            this.getObsMgr().setObservable((Observable[])this.posLineModels);
            db.fine("Refreshing lines, pos lines= " + this.posLineModels.length);
            this.dataModel.refreshMyLines(this.posLineModels);
        }
    }

    public void dispose() {
        if (this.obsMgr != null) {
            this.obsMgr.removeObservable((Observable[])this.posLineModels);
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.posLineModels.length == 0) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.posLineModels.length ? this.posLineModels.length - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        try {
            if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.posLineModels)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
                String string = AdminState.getSevWarningMsg(this.dataModel, this.posLineModels, false, true);
                stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                    return;
                }
            }
            this.dataModel.applyToModels();
        }
        catch (Exception exception) {
            if (AsapPosPortProvPane.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            throw new AnnotatedException("Error applying changes", exception);
        }
        this.resetDirty();
    }

    public void refreshFromModel() {
        db.finest("In refreshFromModel");
        this.dataModel.refreshFromModel();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.AsapPosPortProvPane;
    }

    class UTableExt
    extends UTable {
        private RowEditorModel rowEditorModel;

        public UTableExt(AsapPosPortTableModel asapPosPortTableModel, RowEditorModel rowEditorModel) {
            super((TableModel)asapPosPortTableModel);
            this.rowEditorModel = rowEditorModel;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (this.convertColumnIndexToModel(n2) != 6) {
                return super.getCellEditor(n, n2);
            }
            return this.rowEditorModel.getEditor((Attribute)this.getValueAt(n, this.convertColumnIndexToView(5)));
        }
    }

    class RowEditorModel {
        private Map data = new HashMap();

        public void addEditor(Attribute attribute, TableCellEditor tableCellEditor) {
            this.data.put(attribute, tableCellEditor);
        }

        public TableCellEditor getEditor(Attribute attribute) {
            return (TableCellEditor)this.data.get(attribute);
        }

        public void destroy() {
            if (this.data != null) {
                this.data.clear();
                this.data = null;
            }
        }
    }
}

