/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class CardView600
extends CardView {
    private static final int MAX_CONNECTORS = 4;
    private static final int MAX_PORTS_PER_CONNECTOR = 4;
    protected static final int PORT_WIDTH = 40;
    protected static final int PORT_HEIGHT = 20;
    protected static final int CARD_WIDTH = 45;
    protected static final int CARD_HEIGHT = 220;
    protected static final int TOP_SERIAL_OFFSET = 0;
    protected static final int SERIAL_WIDTH = 7;
    protected static final int SERIAL_HEIGHT = 20;
    protected static final int BOTTOM_SERIAL_OFFSET = 196;
    protected static final int TOP_EXTRACTOR_OFFSET = 10;
    protected static final int BOTTOM_EXTRACTOR_OFFSET = 168;
    protected static final int EXTRACTOR_WIDTH = 11;
    protected static final int EXTRACTOR_HEIGHT = 52;
    protected static final int LED_WIDTH = 5;
    protected static final int LED_HEIGHT = 6;
    protected static final int STATUS_LED_X_OFFSET = 15;
    protected static final int STATUS_LED_Y_OFFSET = 21;
    protected int eqType = 95;

    public CardView600(EntityModel entityModel) {
        super(entityModel);
        this.eqType = entityModel.getEqType();
        this.setLayout(null);
        this.update(this.cardAlarmStore.getAlarmStatusObservable(), this.cardAlarmStore.getAlarmStatus());
    }

    protected void addPorts(boolean bl) {
        int n;
        int n2;
        int n3;
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createLoweredBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
        int n4 = this.portModels.size();
        if (n4 < (n3 = 4)) {
            n3 = n4;
        }
        int n5 = n4 / n3;
        JPanel[] jPanelArray = new JPanel[n3];
        for (int i = 0; i < n3; ++i) {
            jPanelArray[i] = new JPanel(new GridLayout(1, 0));
            jPanelArray[i].setBorder(compoundBorder);
            if (n5 == 1) {
                jPanelArray[i].setBounds(14, i * 27 + 61, 16, 20);
            } else {
                jPanelArray[i].setBounds(2, i * 27 + 61, 40, 20);
            }
            this.add(jPanelArray[i]);
        }
        EntityModel entityModel = null;
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                int n7 = n2 * n5 + n;
                entityModel = (EntityModel)this.portModels.get(n7);
                this.ports[n6] = new GenericPortGraphic(this, entityModel, entityModel.getPort());
                jPanelArray[n2].add(this.ports[n6]);
                ++n6;
            }
        }
        n2 = n4 - n6;
        for (n = 0; n < n2; ++n) {
            entityModel = (EntityModel)this.portModels.get(n);
            jPanelArray[n3 - 1].add(new GenericPortGraphic(this, entityModel, entityModel.getPort()));
        }
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintIcon(graphics);
    }

    protected eEqState getState() {
        if (this.model instanceof PluggableModel) {
            return ((PluggableModel)this.model).getState();
        }
        return null;
    }

    protected IServiceState getServiceState() {
        try {
            return ((MfgEntityModel)this.model).getServiceSt();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void paintIcon(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getState() == null) {
            return;
        }
        int n = this.getState().value();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setFont(graphics2D.getFont().deriveFont(1));
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Font font = graphics2D.getFont();
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.gray);
        if (this.eqType != 146) {
            graphics2D.fill(new Rectangle(0, 0, 11, 52));
            graphics2D.fill(new Rectangle(0, 168, 11, 52));
            graphics2D.setColor(Color.black);
            graphics2D.draw(new Rectangle(0, 0, 11, 52));
            graphics2D.draw(new Rectangle(0, 168, 11, 52));
            graphics2D.setColor(Color.lightGray);
            graphics2D.draw(new Rectangle(3, 3, 7, 20));
            graphics2D.draw(new Rectangle(3, 196, 7, 20));
        }
        graphics2D.setColor(Color.black);
        String string = this.model.getEqLabel();
        if (string.startsWith("OC")) {
            graphics2D.setFont(font.deriveFont(9.0f));
            object = string.substring(2, string.length());
            graphics2D.drawString((String)object, this.getLedXOffset(), this.getLedYOffset() - 10);
        }
        graphics2D.setFont(font.deriveFont(8.0f));
        graphics2D.setColor(this.getStatusColor(n));
        graphics2D.fillOval(this.getLedXOffset(), this.getStatusLedYOffset(), 5, 6);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("O", this.getLedXOffset(), this.getStatusLedYOffset() + 6);
        graphics2D.drawString("STA", this.getLedXOffset() + 8, this.getStatusLedYOffset() + 6);
        graphics2D.setColor(this.getServiceColor(this.getServiceState()));
        graphics2D.fillOval(this.getLedXOffset(), this.getServiceLedYOffset(), 5, 6);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("O", this.getLedXOffset(), this.getServiceLedYOffset() + 6);
        graphics2D.drawString("SRV", this.getLedXOffset() + 8, this.getServiceLedYOffset() + 6);
        if (this.eqType != 146) {
            graphics2D.setColor(Color.darkGray);
            object = new float[]{1.5f};
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 3.0f, (float[])object, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(new Rectangle(0, 59, 45, 23));
            graphics2D.draw(new Rectangle(0, 86, 45, 23));
            graphics2D.draw(new Rectangle(0, 113, 45, 23));
            graphics2D.draw(new Rectangle(0, 140, 45, 23));
        }
        graphics2D.setStroke(stroke);
    }

    public void update(Observable observable, Object object) {
        if (this.model == null || !this.model.getNodeModel().isInited()) {
            return;
        }
        if (object instanceof AlarmStatus) {
            AlarmStatus alarmStatus = (AlarmStatus)object;
            this.setAlarmColor(alarmStatus.getHighestSeverity());
            if (this.eqType == 87 || this.eqType == 86 || this.eqType == 150) {
                this.updatePortAlarms();
            }
        } else if (object instanceof Integer) {
            AlarmStatus alarmStatus = (AlarmStatus)this.cardAlarmStore.getAlarmStatus();
            this.setAlarmColor(alarmStatus.getHighestSeverity());
        }
    }

    protected void updatePortAlarms() {
        for (int i = 0; i < this.numPorts; ++i) {
            PortModel portModel = (PortModel)this.portModels.get(i);
            IAlarmStatus iAlarmStatus = this.cardAlarmStore.getEntityAlarmStatus(portModel);
            if (iAlarmStatus == null || this.ports[i] == null) continue;
            this.ports[i].setAlarmState(iAlarmStatus.getHighestSeverity());
        }
    }

    protected Dimension getCardSize() {
        return new Dimension(45, 220);
    }

    public Dimension getPreferredSize() {
        return this.getCardSize();
    }

    protected int getLedXOffset() {
        return 15;
    }

    protected int getLedYOffset() {
        return 21;
    }

    protected int getStatusLedYOffset() {
        int n = 15;
        if (this.eqType == 146) {
            n = 7;
        }
        return n;
    }

    protected int getServiceLedYOffset() {
        int n = 23;
        if (this.eqType == 146) {
            n = 23;
        }
        return n;
    }

    protected Color getStatusColor(int n) {
        switch (n) {
            case 3: {
                return Color.red;
            }
        }
        return Color.gray;
    }

    protected Color getServiceColor(IServiceState iServiceState) {
        if (iServiceState == null) {
            return ElementDefaults.OOS_DSBLD_COLOR.darker();
        }
        eEqState eEqState2 = this.getState();
        if (eEqState2 == eEqState.NOT_PRESENT || eEqState2 == eEqState.DELETED || eEqState2 == eEqState.LOADING) {
            return ElementDefaults.OOS_DSBLD_COLOR.darker();
        }
        switch (iServiceState.getPSTValue()) {
            case 0: {
                return ElementDefaults.IS_COLOR;
            }
        }
        return ElementDefaults.MAJOR_ALARM_COLOR;
    }
}

