/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.model.ElementDefaults;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.OpticalPortGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import com.cisco.ctc600.ui.shelf.OCNCard600;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;

public class OCNConnectorGraphic
extends Rectangle
implements Observer {
    public int nodeId;
    public int portNo;
    public int slotNo;
    public int connectorNo;
    private OpticalPortGraphic[] portGraphics = null;
    private InterfaceModel[] ifModel = null;
    private PortModel[] portModel = null;
    private OCNCard600 parent;
    private String statusString = "";
    private String alarmProfileString = "";
    private Color currentColor = Color.gray;
    private int numPorts = 0;
    private int currentSeverity = 0;
    private int currentAdminState = -1;
    private Rectangle connector = new Rectangle(0, 0, 2, 2);
    private static int CONN_X = 4;
    private static int CONN1_Y = 2;
    private static int WIDTH = 25;
    private static int HEIGHT = 8;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfLayout.db, "OCNConnectorGraphic");

    public OCNConnectorGraphic(OCNCard600 oCNCard600, int n, int n2, int n3, OpticalPortGraphic[] opticalPortGraphicArray) {
        this.x = n;
        this.y = n2;
        this.parent = oCNCard600;
        this.connectorNo = n3;
        this.portGraphics = opticalPortGraphicArray;
        this.numPorts = opticalPortGraphicArray.length;
        this.width = WIDTH;
        this.height = HEIGHT;
        this.setPortPosition();
        this.setIfModels();
        this.registerWithModel();
        this.updateCurrentState();
    }

    private void setIfModels() {
        this.ifModel = new InterfaceModel[this.numPorts];
        this.portModel = new PortModel[this.numPorts];
        for (int i = 0; i < this.numPorts; ++i) {
            this.portModel[i] = this.portGraphics[i].getPortModel();
            this.ifModel[i] = (InterfaceModel)this.portModel[i].getInterfaceModel();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got state changed message ");
            }
            this.updateCurrentState();
        }
    }

    public String getTooltipText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numPorts; ++i) {
            stringBuffer.append(this.portGraphics[i].getTooltipText() + "\n");
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        for (int i = 0; i < this.numPorts; ++i) {
            if (this.ifModel[i] != null) {
                this.ifModel[i].deleteObserver(this);
                this.ifModel[i] = null;
            }
            if (this.portModel[i] == null) continue;
            this.portModel[i].deleteObserver(this);
            this.portModel[i] = null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OpticalPortGraphic) {
            return object == this;
        }
        return super.equals(object);
    }

    protected void setAlarmState(int n) {
        if (db.on()) {
            db.println("set alrm st=" + n);
        }
        if (this.currentSeverity != n) {
            this.currentSeverity = n;
            if (this.currentAdminState == 0) {
                this.currentColor = AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminState, n);
                this.parent.repaint();
            }
        }
    }

    private void updateCurrentState() {
        boolean bl = false;
        try {
            for (int i = 0; i < this.numPorts; ++i) {
                int n;
                if (this.ifModel[i] == null) continue;
                this.currentAdminState = n = this.ifModel[i].getAdminState();
                if (n == 0) {
                    this.currentColor = AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminState, this.currentSeverity);
                    break;
                }
                if (n == 2) {
                    this.currentColor = ElementDefaults.OOS_MT_COLOR;
                    bl = true;
                }
                if (bl || n == 0 || n == 2) continue;
                this.currentColor = ElementDefaults.OOS_DSBLD_COLOR;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            // empty catch block
        }
    }

    protected Rectangle getConnector() {
        return this.connector;
    }

    protected Color getCurrentColor() {
        return this.currentColor;
    }

    private void registerWithModel() {
        for (int i = 0; i < this.numPorts; ++i) {
            if (this.ifModel[i] != null) {
                if (db.on()) {
                    db.println("registering with " + this.ifModel[i]);
                }
                this.ifModel[i].addObserver(this);
            }
            if (this.portModel[i] == null) continue;
            if (db.on()) {
                db.println("registering with " + this.portModel[i]);
            }
            this.portModel[i].addObserver(this);
        }
    }

    protected int getConnector1XOffset() {
        return this.x + CONN_X;
    }

    protected int getConnector1YOffset() {
        return this.y + CONN1_Y;
    }

    private void setPortPosition() {
        int n = this.portGraphics.length;
        for (int i = 0; i < n; ++i) {
            this.portGraphics[i].width = 4;
            this.portGraphics[i].height = 12;
            this.portGraphics[i].x = n == 1 ? 14 + i * 7 : 4 + i * 7;
            if (this.connectorNo == 0) {
                this.portGraphics[i].y = 93;
                continue;
            }
            if (this.connectorNo == 1) {
                this.portGraphics[i].y = 113;
                continue;
            }
            if (this.connectorNo == 2) {
                this.portGraphics[i].y = 135;
                continue;
            }
            if (this.connectorNo != 3) continue;
            this.portGraphics[i].y = 155;
        }
    }

    public void draw(Graphics2D graphics2D) {
        for (int i = 0; i < this.portGraphics.length; ++i) {
            graphics2D.setColor(this.portGraphics[i].getCurrentColor());
            graphics2D.fill(this.portGraphics[i]);
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.portGraphics[i]);
        }
    }
}

