/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Equipment.sXconDiagInfo;
import cerent.cms.idl.Equipment.xCommFail;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Node.xStandbyTccNotReady;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.BlsrProvisioned;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractSmpDiagnosticPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import com.cisco.ctc600.model.CxcDiagnosticsModel;
import com.cisco.ctc600.model.PlatformNodeModel;
import com.cisco.ctc600.model.SystemResetModel;
import com.cisco.ctc600.ui.shelf.CrossConnectDiagnosticsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.omg.CORBA.BAD_OPERATION;

public class SmpDiagnosticPane600
extends AbstractSmpDiagnosticPane {
    private static final String SYSTEM_SOFT_RESET_TT = "Perform System Soft-reset";
    private static final String XCONN_DIAG_TT = "Perform Cross Connect test on every STS-1";
    private static final String RESET_TITLE = "System Reset";
    protected static final String NORMAL_WARNING = "Are you sure you want to perform a soft-reset of the shelf?";
    protected static final String FORCED_RETRY_WARNING = "The shelf reset operation failed.\nThe shelf or the protect TSC card is not ready.\n\nDo you want to perform a FORCED soft-reset of the shelf?";
    private JButton xconnTestButton;
    private JButton sysSoftResetButton;

    public SmpDiagnosticPane600(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = SmpDiagnosticPane600.createVerticalPanel(null);
        this.setLayout(new BorderLayout());
        jPanel.add(jPanel2);
        this.add(jPanel, "North");
        JPanel jPanel3 = new JPanel();
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Controller"));
        this.diagnosticButton = new JButton("Retrieve Diagnostics File");
        this.diagnosticButton.addActionListener(this);
        this.diagnosticButton.setDefaultCapable(false);
        this.diagnosticButton.setToolTipText("Request a diagnostic file from the " + this.nodeModel.getPlatform().getControlCardName());
        this.diagnosticButton.setAlignmentX(0.5f);
        jPanel3.add(this.diagnosticButton);
        jPanel3 = new JPanel();
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Cross Connect"));
        this.xconnTestButton = new JButton("Run Diagnostics Test");
        this.xconnTestButton.addActionListener(this);
        this.xconnTestButton.setDefaultCapable(false);
        this.xconnTestButton.setToolTipText(XCONN_DIAG_TT);
        this.xconnTestButton.setAlignmentX(0.5f);
        jPanel3.add(this.xconnTestButton);
        jPanel3 = new JPanel();
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder(RESET_TITLE));
        this.sysSoftResetButton = new JButton("Soft-reset");
        this.sysSoftResetButton.addActionListener(this);
        this.sysSoftResetButton.setDefaultCapable(false);
        this.sysSoftResetButton.setToolTipText(SYSTEM_SOFT_RESET_TT);
        this.sysSoftResetButton.setAlignmentX(0.5f);
        jPanel3.add(this.sysSoftResetButton);
        this.enableComponent(this.diagnosticButton, this.uiModel, SecurityLevel.PROVISIONING);
        this.enableComponent(this.sysSoftResetButton, this.uiModel, SecurityLevel.MAINTENANCE);
        this.enableComponent(this.xconnTestButton);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpDiagnosticPane600);
        this.add(Box.createVerticalGlue(), "Center");
        this.add(cSHelpButtonPane, "South");
        if (db.on()) {
            db.println("init: finish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        PlatformNodeModel platformNodeModel = (PlatformNodeModel)this.nodeModel;
        if (object == this.sysSoftResetButton) {
            this.doSystemReset(platformNodeModel, false, NORMAL_WARNING);
        } else if (object == this.xconnTestButton) {
            CxcDiagnosticsModel cxcDiagnosticsModel = platformNodeModel.getCxcDiagnosticsModel();
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            try {
                sXconDiagInfo[] sXconDiagInfoArray = cxcDiagnosticsModel.runXconDiags();
                if (sXconDiagInfoArray.length == 0) {
                    CerentDialog.infoDialog((Component)((Object)this), (String)"The Cross Connect Diagnostics completed successfully without any errors.", (String)"Cross Connect Diagnostics");
                }
                new CrossConnectDiagnosticsDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), this.nodeModel, sXconDiagInfoArray);
            }
            catch (xInUse xInUse2) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_XC_DIAGS_FAIL, "One or more IO cards are provisioned and in use.");
            }
            catch (xProvisionError xProvisionError2) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_XC_DIAGS_FAIL, "One or more required cards is not currently provisioned.");
            }
            catch (xCommFail xCommFail2) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_XC_DIAGS_FAIL, "A communication error occurred between cards in the shelf.");
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_XC_DIAGS_FAIL);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)abstractCmsIOException.getMessage());
            }
            finally {
                if (this.uiToolkit != null) {
                    this.uiToolkit.setCursor(0);
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void enteringPage() {
        if (this.diagnosticButton == null) {
            this.init();
        }
        super.enteringPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSystemReset(PlatformNodeModel platformNodeModel, boolean bl, String string) {
        db.config("System soft reset requested.  Warning message presented: " + string);
        boolean bl2 = CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)RESET_TITLE);
        if (bl2) {
            SystemResetModel systemResetModel = platformNodeModel.getSystemResetModel();
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            try {
                systemResetModel.systemReset(bl);
                db.config("Performing system soft reset. Issued warning: " + string);
            }
            catch (xStandbyTccNotReady xStandbyTccNotReady2) {
                if (!bl) {
                    db.warning("Normal system soft reset failed on a dual TSC system; ask user if a FORCED system soft reset should be attempted.");
                    this.doSystemReset(platformNodeModel, true, FORCED_RETRY_WARNING);
                } else {
                    db.warning("FORCED system soft reset failed and threw xStandbyTccNotReady exception?");
                }
            }
            catch (BlsrProvisioned blsrProvisioned) {
                CerentDialog.errorDialog((Component)((Object)this), (String)ErrorMsg.getString((EID)EMC.EID_NO_SYSTEM_RESET_ALLOWED_BLSR_RING_ON_NODE));
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_COMMUNICATION_ERROR_PARAM_1, abstractCmsIOException.getMessage(), abstractCmsIOException.toString());
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_RESET_SHELF_FAILURE, exception.toString());
            }
            finally {
                if (this.uiToolkit != null) {
                    this.uiToolkit.setCursor(0);
                }
            }
        }
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        this.diagnosticButton.setSelected(false);
        this.sysSoftResetButton.setSelected(false);
        this.xconnTestButton.setSelected(false);
    }
}

