/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.AnyType;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VectorType;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class SequenceType
extends VectorType {
    private boolean written = false;
    private static int idxNum = 0;
    private boolean recursive = false;
    public ConstExpr max = null;
    int length = 0;

    public SequenceType(int num) {
        super(num);
        this.name = null;
        this.typedefd = false;
    }

    public Object clone() {
        SequenceType st = new SequenceType(IdlSymbol.new_num());
        st.type_spec = this.type_spec;
        st.max = this.max;
        st.length = this.length;
        st.name = this.name;
        st.pack_name = this.pack_name;
        st.included = this.included;
        st.typedefd = this.typedefd;
        st.recursive = this.recursive;
        st.set_token(this.get_token());
        st.setEnclosingSymbol(this.getEnclosingSymbol());
        return st;
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.type_spec.setPackage(s);
        if (this.max != null) {
            this.max.setPackage(s);
        }
    }

    public int length() {
        return this.length;
    }

    void setRecursive() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Sequence " + this.typeName + " set recursive ------- this: " + this);
        }
        this.recursive = true;
    }

    public String getTypeCodeExpression() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sequence getTypeCodeExpression " + this.name);
        }
        String originalType = null;
        originalType = this.recursive ? "org.omg.CORBA.ORB.init().create_sequence_tc(" + this.length + ", org.omg.CORBA.ORB.init().create_recursive_tc(\"" + this.elementTypeSpec().id() + "\"))" : "org.omg.CORBA.ORB.init().create_sequence_tc(" + this.length + ", " + this.elementTypeExpression() + ")";
        return originalType;
    }

    public static int getNumber() {
        return idxNum++;
    }

    public String printReadStatement(String var_name, String streamname) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sequence printReadStatement for " + this.typeName());
        }
        StringBuffer sb = new StringBuffer();
        String type = this.typeName();
        String lgt = "_l" + var_name.replace('.', '_');
        if (lgt.indexOf("[") > 0) {
            lgt = lgt.substring(0, lgt.indexOf("[")) + "_";
        }
        lgt = lgt + SequenceType.getNumber();
        sb.append("int " + lgt + " = " + streamname + ".read_long();\n");
        if (this.length != 0) {
            sb.append("\t\tif (" + lgt + " > " + this.length + ")\n");
            sb.append("\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Sequence length incorrect!\");\n");
        }
        sb.append("\t\ttry\n\t\t{\n");
        sb.append("\t\t\t int x = " + streamname + ".available();\n");
        sb.append("\t\t\t if ( x > 0 && " + lgt + " > x )\n");
        sb.append("\t\t\t\t{\n");
        sb.append("\t\t\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Sequence length too large. Only \" + x + \" available and trying to assign \" + " + lgt + ");\n");
        sb.append("\t\t\t\t}\n");
        sb.append("\t\t}\n\t\tcatch (java.io.IOException e)\n\t\t{\n\t\t}\n");
        sb.append("\t\t" + var_name + " = new " + type.substring(0, type.indexOf("[")) + "[" + lgt + "]" + type.substring(type.indexOf("]") + 1) + ";\n");
        TypeSpec elemType = this.elementTypeSpec();
        if (elemType instanceof AliasTypeSpec) {
            elemType = ((AliasTypeSpec)elemType).originalType();
        }
        if (elemType instanceof BaseType && !(elemType instanceof AnyType)) {
            String _tmp = elemType.printReadExpression(streamname);
            sb.append("\t\t");
            sb.append(_tmp.substring(0, _tmp.indexOf("(")));
            sb.append("_array(");
            sb.append(var_name);
            sb.append(",0,");
            sb.append(lgt);
            sb.append(");");
        } else {
            char idx_variable = 'i';
            String indent = "";
            if (var_name.endsWith("]")) {
                idx_variable = (char)(var_name.charAt(var_name.length() - 2) + '\u0001');
                indent = "    ";
            }
            sb.append("\t\t" + indent + "for (int " + idx_variable + "=0;" + idx_variable + "<" + var_name + ".length;" + idx_variable + "++)\n\t\t" + indent + "{\n");
            sb.append("\t\t\t" + indent + this.elementTypeSpec().printReadStatement(var_name + "[" + idx_variable + "]", streamname) + "\n");
            sb.append("\t\t" + indent + "}\n");
        }
        return sb.toString();
    }

    public String printWriteStatement(String var_name, String streamname) {
        StringBuffer sb = new StringBuffer();
        String type = this.typeName();
        if (this.length != 0) {
            sb.append("\t\tif (" + var_name + ".length > " + this.length + ")\n");
            sb.append("\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Incorrect sequence length\");");
        }
        sb.append("\n\t\t" + streamname + ".write_long(" + var_name + ".length);\n");
        TypeSpec elemType = this.elementTypeSpec();
        if (elemType instanceof AliasTypeSpec) {
            elemType = ((AliasTypeSpec)elemType).originalType();
        }
        if (elemType instanceof BaseType && !(elemType instanceof AnyType)) {
            String _tmp = elemType.printWriteStatement(var_name, streamname);
            sb.append("\t\t");
            sb.append(_tmp.substring(0, _tmp.indexOf("(")));
            sb.append("_array(");
            sb.append(var_name);
            sb.append(",0,");
            sb.append(var_name);
            sb.append(".length);");
        } else {
            char idx_variable = 'i';
            String indent = "";
            if (var_name.endsWith("]")) {
                idx_variable = (char)(var_name.charAt(var_name.length() - 2) + '\u0001');
                indent = "    ";
            }
            sb.append("\t\t" + indent + "for (int " + idx_variable + "=0; " + idx_variable + "<" + var_name + ".length;" + idx_variable + "++)\n\t\t" + indent + "{\n");
            sb.append("\t\t\t" + indent + this.elementTypeSpec().printWriteStatement(var_name + "[" + idx_variable + "]", streamname) + "\n");
            sb.append("\t\t" + indent + "}\n");
        }
        return sb.toString();
    }

    public String holderName() {
        if (!this.typedefd) {
            throw new RuntimeException("Compiler Error: should not be called (helpername on not typedef'd SequenceType " + this.name + ")");
        }
        String s = this.full_name();
        if (this.pack_name.length() > 0 && !s.startsWith("org.omg")) {
            s = this.omg_package_prefix + s;
        }
        return s + "Holder";
    }

    public String helperName() {
        if (!this.typedefd) {
            throw new RuntimeException("Compiler Error: should not be called (helperName() on not typedef'd SequenceType)");
        }
        String s = this.full_name();
        if (this.pack_name.length() > 0 && !s.startsWith("org.omg")) {
            s = this.omg_package_prefix + s;
        }
        return s + "Helper";
    }

    public String className() {
        String cName;
        String fullName = this.full_name();
        if (fullName.indexOf(46) > 0) {
            this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
            cName = fullName.substring(fullName.lastIndexOf(46) + 1);
        } else {
            this.pack_name = "";
            cName = fullName;
        }
        return cName;
    }

    public void parse() {
        if (this.max != null) {
            this.max.parse();
            this.length = Integer.parseInt(this.max.value());
        }
        if (this.type_spec.typeSpec() instanceof ScopedName) {
            TypeSpec ts = ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec();
            if (ts != null) {
                this.type_spec = ts;
            }
            if (this.type_spec instanceof AliasTypeSpec) {
                this.addImportedAlias(this.type_spec.full_name());
            } else {
                this.addImportedName(this.type_spec.typeName());
            }
            this.addImportedName(this.type_spec.typeSpec().typeName());
        }
        try {
            NameTable.define(this.full_name(), "type");
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            // empty catch block
        }
    }

    public String full_name() {
        if (this.name == null) {
            return "<" + this.pack_name + ".anon>";
        }
        if (this.pack_name.length() > 0) {
            return ScopedName.unPseudoName(this.pack_name + "." + this.name);
        }
        return ScopedName.unPseudoName(this.name);
    }

    private void printHolderClass(String className, PrintWriter ps) {
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";\n");
        }
        String type = this.typeName();
        this.printImport(ps);
        this.printClassComment(className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + type + " value;");
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder (final " + type + " initial)\n\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + className + "Helper.type ();");
        ps.println("\t}");
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + className + "Helper.read (_in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream _out)");
        ps.println("\t{");
        ps.println("\t\t" + className + "Helper.write (_out,value);");
        ps.println("\t}");
        ps.println("}");
    }

    private void printHelperClass(String className, PrintWriter ps) {
        String _tmp;
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        String type = this.typeName();
        this.printImport(ps);
        this.printClassComment(className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Helper");
        ps.println("{");
        ps.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        TypeSpec.printHelperClassMethods(ps, type);
        this.printIdMethod(ps);
        ps.println("\tpublic static " + type + " read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        ps.println("\t\tint l = in.read_long();");
        if (this.length != 0) {
            ps.println("\t\tif (l > " + this.length + ")");
            ps.println("\t\t\tthrow new org.omg.CORBA.MARSHAL();");
        }
        ps.println("\t\t" + type + " result = new " + type.substring(0, type.indexOf("[")) + "[l]" + type.substring(type.indexOf("]") + 1) + ";");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            _tmp = this.elementTypeSpec().printReadExpression("in");
            ps.println("\t\t" + _tmp.substring(0, _tmp.indexOf("(")) + "_array(result,0,result.length);");
        } else {
            ps.println("\t\tfor (int i = 0; i < l; i++)");
            ps.println("\t\t{");
            ps.println("\t\t\t" + this.elementTypeSpec().printReadStatement("result[i]", "in"));
            ps.println("\t\t}");
        }
        ps.println("\t\treturn result;");
        ps.println("\t}");
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final " + type + " s)");
        ps.println("\t{");
        if (this.length != 0) {
            ps.println("\t\tif (s.length > " + this.length + ")");
            ps.println("\t\t\tthrow new org.omg.CORBA.MARSHAL();");
        }
        ps.println("\t\tout.write_long(s.length);");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            _tmp = this.elementTypeSpec().printWriteStatement("s", "out");
            ps.println(_tmp.substring(0, _tmp.indexOf("(")) + "_array(s,0,s.length);");
        } else {
            ps.println("\t\tfor (int i = 0; i < s.length; i++)");
            ps.println("\t\t\t" + this.elementTypeSpec().printWriteStatement("s[i]", "out"));
        }
        ps.println("\t}");
        ps.println("}");
    }

    public void print(PrintWriter _ps) {
        try {
            if (!this.written && this.typedefd) {
                PrintWriter ps;
                String fname;
                File f;
                String className;
                String fullName = this.full_name();
                if (fullName.indexOf(46) > 0) {
                    this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
                    className = fullName.substring(fullName.lastIndexOf(46) + 1);
                } else {
                    this.pack_name = "";
                    className = fullName;
                }
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Holder.java"))) {
                    ps = new PrintWriter(new FileWriter(f));
                    this.printHolderClass(className, ps);
                    ps.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Helper.java"))) {
                    ps = new PrintWriter(new FileWriter(f));
                    this.printHelperClass(className, ps);
                    ps.close();
                }
                this.written = true;
            }
        }
        catch (IOException i) {
            throw new RuntimeException("File IO error" + i);
        }
    }
}

