/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl.javamapping;

import java.util.Enumeration;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.AnyType;
import org.jacorb.idl.ArrayTypeSpec;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Definition;
import org.jacorb.idl.Definitions;
import org.jacorb.idl.EnumType;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.InterfaceBody;
import org.jacorb.idl.Member;
import org.jacorb.idl.MemberList;
import org.jacorb.idl.Method;
import org.jacorb.idl.Module;
import org.jacorb.idl.NativeType;
import org.jacorb.idl.ObjectTypeSpec;
import org.jacorb.idl.OpDecl;
import org.jacorb.idl.Operation;
import org.jacorb.idl.ParamDecl;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SequenceType;
import org.jacorb.idl.Spec;
import org.jacorb.idl.StringType;
import org.jacorb.idl.StructType;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeDef;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.UnionType;
import org.jacorb.idl.Value;
import org.jacorb.idl.VectorType;

public class JavaMappingGeneratingVisitor
implements IDLTreeVisitor {
    public void visitSpec(Spec spec) {
        Enumeration e = spec.definitions.elements();
        while (e.hasMoreElements()) {
            IdlSymbol s = (IdlSymbol)e.nextElement();
            s.accept(this);
        }
    }

    public void visitDefinitions(Definitions defs) {
        Enumeration e = defs.getElements();
        while (e.hasMoreElements()) {
            IdlSymbol s = (IdlSymbol)e.nextElement();
            s.accept(this);
        }
    }

    public void visitDefinition(Definition def) {
        def.get_declaration().accept(this);
    }

    public void visitDeclaration(Declaration declaration) {
        System.out.println("Unimplemented behavior: visitDeclaration");
    }

    public void visitModule(Module module) {
        module.getDefinitions().accept(this);
    }

    public void visitInterface(Interface interfce) {
        if (interfce.body == null) {
            return;
        }
        String[] superInts = interfce.get_ids();
        for (int i = 1; i < superInts.length; ++i) {
        }
        if (interfce.body != null) {
            interfce.body.accept(this);
        }
    }

    public void visitInterfaceBody(InterfaceBody body) {
        Operation[] ops = body.getMethods();
        for (int i = 0; i < ops.length; ++i) {
            ops[i].accept(this);
        }
    }

    public void visitMethod(Method m) {
        if (m.isGetter()) {
            // empty if block
        }
    }

    public void visitOpDecl(OpDecl op) {
        Enumeration e = op.paramDecls.elements();
        while (e.hasMoreElements()) {
            ParamDecl param = (ParamDecl)e.nextElement();
            param.accept(this);
        }
    }

    public void visitParamDecl(ParamDecl param) {
        String direction = "in";
        if (param.paramAttribute == 2) {
            direction = "out";
        } else if (param.paramAttribute == 3) {
            direction = "inout";
        }
    }

    public void visitTypeDeclaration(TypeDeclaration typeDecl) {
    }

    public void visitConstrTypeSpec(ConstrTypeSpec typeDecl) {
    }

    public void visitStruct(StructType struct) {
        int length = -1;
        boolean isSeq = false;
        boolean isArray = false;
        MemberList members = struct.memberlist;
        if (members != null) {
            Enumeration e = members.elements();
            while (e.hasMoreElements()) {
                Member m = (Member)e.nextElement();
                String memberType = this.typeSpecDesignator(m.type_spec);
                if (!(m.type_spec instanceof VectorType)) continue;
                memberType = this.typeSpecDesignator(((VectorType)m.type_spec).elementTypeSpec());
                length = ((VectorType)m.type_spec).length();
                if (m.type_spec instanceof SequenceType) {
                    isSeq = true;
                    continue;
                }
                if (m.type_spec instanceof ArrayTypeSpec) {
                    isArray = true;
                    continue;
                }
                throw new RuntimeException("Internal Error: encountered vector that is neither array nor sequence!");
            }
        }
    }

    public void visitEnum(EnumType enm) {
        Enumeration e = enm.enumlist.elements();
        while (e.hasMoreElements()) {
        }
    }

    public void visitUnion(UnionType union) {
    }

    public void visitSequence(SequenceType seq) {
    }

    public void visitNative(NativeType _native) {
    }

    public void visitTypeDef(TypeDef typedef) {
    }

    public void visitAlias(AliasTypeSpec alias) {
        boolean isSeq = false;
        boolean isArray = false;
        int length = -1;
        String aliasedType = this.typeSpecDesignator(alias.originalType());
        if (alias.originalType() instanceof VectorType) {
            aliasedType = this.typeSpecDesignator(((VectorType)alias.originalType()).elementTypeSpec());
            length = ((VectorType)alias.originalType()).length();
            if (alias.originalType() instanceof SequenceType) {
                isSeq = true;
            } else if (alias.originalType() instanceof ArrayTypeSpec) {
                isArray = true;
            } else {
                throw new RuntimeException("Internal Error: encountered vector that is neither array nor sequence!");
            }
        }
    }

    public void visitValue(Value value) {
    }

    private String typeSpecDesignator(TypeSpec ts) {
        if (ts == null) {
            new RuntimeException().printStackTrace();
        }
        if (!ts.basic()) {
            if (ts.typeSpec() instanceof AnyType) {
                return "any";
            }
            return ts.id();
        }
        System.out.println("typeSpecDesignator for " + ts.typeSpec().getClass().getName());
        if (ts.typeSpec() instanceof ObjectTypeSpec) {
            return ts.id();
        }
        if (ts.typeSpec() instanceof ConstrTypeSpec) {
            return ((ConstrTypeSpec)ts.typeSpec()).id();
        }
        if (ts.typeSpec() instanceof ScopedName) {
            return this.typeSpecDesignator(((ScopedName)ts.typeSpec()).resolvedTypeSpec());
        }
        if (ts.typeSpec() instanceof StringType) {
            return "string";
        }
        return ts.toString();
    }
}

