/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.util;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.imrutility.imr.RepositoryHelper;
import org.jacorb.imrutility.imr.util.MulticastClient;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

public class IMRLocator {
    private final int udpPort;
    private final ArrayList iors;
    private ArrayList imrs;
    private final ORB orb;
    private final Logger logger = Debug.getNamedLogger("jacorb.imr.locator");

    public IMRLocator(ORB orb_) {
        this.orb = orb_;
        this.udpPort = Environment.getIntPropertyWithDefault("jacorb.imr.udp_port", 0);
        this.iors = (ArrayList)Environment.getListProperty("jacorb.imr.other_imrs");
    }

    public static void main(String[] args) {
        IMRLocator locator = null;
        Properties props = new Properties();
        props.put("jacorb.use_imr", "off");
        ORB mainorb = ORB.init(args, props);
        if (args.length > 0) {
            if (args[0].equals("-h") || args[0].equals("--help")) {
                IMRLocator.usage();
            } else if (args.length == 2) {
                try {
                    Integer.parseInt(args[1]);
                    Environment.setProperty("jacorb.imr.udp_port", args[1]);
                }
                catch (NumberFormatException nfe) {
                    System.out.println("The UDP Port " + args[1] + " is not valid \n");
                    IMRLocator.usage();
                }
            }
        }
        try {
            locator = new IMRLocator(mainorb);
            locator.findIMRs();
            if (locator.getIMRs().size() > 0) {
                locator.printIMRs();
            } else {
                System.out.println("No IMRs found");
            }
        }
        catch (Exception ie) {
            System.err.println("Failed to find IMRs\n");
            ie.printStackTrace();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findIMRs() throws SocketException, UnknownHostException, IOException {
        this.imrs = new ArrayList();
        if (this.iors != null && this.iors.size() > 0) {
            for (int i = 0; i < this.iors.size(); ++i) {
                String iorRef = (String)this.iors.get(0);
                if (!iorRef.startsWith("IOR")) {
                    this.imrs.add(this.orb.string_to_object(ObjectUtil.readURL(iorRef)));
                    continue;
                }
                this.imrs.add(this.orb.string_to_object(iorRef));
            }
        }
        if (this.udpPort != 0) {
            byte[][] returnedData = null;
            MulticastClient mcClient = new MulticastClient(this.udpPort);
            byte[] imrData = null;
            CDRInputStream serverResponse = null;
            Repository imr = null;
            try {
                CDROutputStream clientRequest = new CDROutputStream();
                clientRequest.beginEncapsulatedArray();
                clientRequest.write_string("ImplementationRepository");
                byte[] inputPacket = clientRequest.getBufferCopy();
                clientRequest.close();
                mcClient.multicastSend(inputPacket);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Waiting 3 seconds for IMR responses");
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                returnedData = mcClient.getReturnedData();
                if (returnedData != null) {
                    for (int i = 0; i < returnedData.length; ++i) {
                        imrData = returnedData[i];
                        serverResponse = new CDRInputStream(this.orb, imrData);
                        serverResponse.openEncapsulatedArray();
                        serverResponse.read_string();
                        imr = RepositoryHelper.read(serverResponse);
                        this.imrs.add(imr);
                        serverResponse.close();
                    }
                }
            }
            finally {
                mcClient.close();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found imrs: " + this.imrs);
        }
    }

    public ArrayList getIMRs() {
        if (this.imrs == null) {
            this.imrs = new ArrayList();
        }
        return this.imrs;
    }

    private void printIMRs() {
        Iterator iter = this.imrs.iterator();
        System.out.println("Found " + this.imrs.size() + " IMRs on:");
        while (iter.hasNext()) {
            try {
                Object obj = (Object)iter.next();
                Repository rep = RepositoryHelper.narrow(obj);
                ParsedIOR imrIOR = ((Delegate)((ObjectImpl)((java.lang.Object)rep))._get_delegate()).getParsedIOR();
                System.out.println("Running at address - " + imrIOR.getEffectiveProfile().toString() + "\n");
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.error("Exception getting host name for ImR", ex);
            }
        }
    }

    private static void usage() {
        System.out.println(" Usage : To locate any ImRs running the UDP port number must be");
        System.out.println("         provided either using the command line option below or");
        System.out.println("         setting the jacorb.imr.udp_port property              ");
        System.out.println("                                                               ");
        System.out.println("[ -u | --udp_port ] <port number>: The port number on which the");
        System.out.println("                                   MultiCast server for the ImR");
        System.out.println("                                   is running                  ");
        System.out.println("---------------------------------------------------------------");
        System.out.println("[ -h | --help ]                    displays this help          ");
        System.out.println("---------------------------------------------------------------");
        System.exit(0);
    }
}

