/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.DataOutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;

public class CDROutputStream
extends org.omg.CORBA_2_3.portable.OutputStream {
    private int index;
    private int pos;
    private int deferred_writes;
    private BufferManager bufMgr = BufferManager.getInstance();
    protected byte[] buffer;
    private boolean closed;
    private int codeSet = 65537;
    private int codeSetW = 65801;
    private int encaps_start = -1;
    private Stack encaps_stack;
    private Map knownTCMap;
    private Map valueMap;
    private Map repIdMap;
    private Map codebaseMap;
    private static Map cachedTypecodes;
    private int chunk_size_tag_pos = -1;
    private int chunk_size_tag_index;
    private int chunk_octets_pos;
    private int valueNestingLevel = 0;
    private List deferredArrayQueue;
    private ORB orb;
    protected int giop_minor = 2;
    private int chunkingFlag = 0;
    private static boolean useBOM;
    private static boolean chunkCustomRmiValuetypes;
    private static final IOR null_ior;

    public CDROutputStream() {
        this.buffer = this.bufMgr.getPreferredMemoryBuffer();
    }

    public CDROutputStream(ORB oRB) {
        this();
        this.orb = oRB;
    }

    public CDROutputStream(byte[] byArray) {
        this.buffer = byArray;
    }

    public ORB orb() {
        if (this.orb == null) {
            this.orb = ORB.init();
        }
        return this.orb;
    }

    private Stack getEncapsStack() {
        if (this.encaps_stack == null) {
            this.encaps_stack = new Stack();
        }
        return this.encaps_stack;
    }

    private Map getKnownTCMap() {
        if (this.knownTCMap == null) {
            this.knownTCMap = new HashMap();
        }
        return this.knownTCMap;
    }

    private Map getValueMap() {
        if (this.valueMap == null) {
            this.valueMap = Environment.createIdentityHashMap();
        }
        return this.valueMap;
    }

    private Map getRepIdMap() {
        if (this.repIdMap == null) {
            this.repIdMap = new HashMap();
        }
        return this.repIdMap;
    }

    private Map getCodebaseMap() {
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        }
        return this.codebaseMap;
    }

    public void write(OutputStream outputStream, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n;
        int n5 = 0;
        int n6 = 0;
        DeferredWriteFrame deferredWriteFrame = null;
        if (this.deferredArrayQueue != null && this.deferredArrayQueue.size() > 0) {
            deferredWriteFrame = (DeferredWriteFrame)this.deferredArrayQueue.get(n6++);
            while (deferredWriteFrame.write_pos < n && n6 < this.deferredArrayQueue.size()) {
                n5 += deferredWriteFrame.length;
                deferredWriteFrame = (DeferredWriteFrame)this.deferredArrayQueue.get(n6++);
            }
            if (deferredWriteFrame.write_pos < n && n6 >= this.deferredArrayQueue.size()) {
                n5 += deferredWriteFrame.length;
                deferredWriteFrame = null;
            }
        }
        while (n3 < n + n2) {
            if (deferredWriteFrame != null && n3 == deferredWriteFrame.write_pos) {
                if (deferredWriteFrame.length > n + n2 - n3) {
                    throw new MARSHAL("Deferred array does not fit");
                }
                outputStream.write(deferredWriteFrame.buf, deferredWriteFrame.start, deferredWriteFrame.length);
                n3 += deferredWriteFrame.length;
                deferredWriteFrame = null;
                if (this.deferredArrayQueue != null && n6 < this.deferredArrayQueue.size()) {
                    deferredWriteFrame = (DeferredWriteFrame)this.deferredArrayQueue.get(n6++);
                    if (deferredWriteFrame.write_pos > n + n2) {
                        deferredWriteFrame = null;
                    }
                }
            }
            if (n3 >= n + n2) continue;
            int n7 = Math.min(n + n2, deferredWriteFrame != null ? deferredWriteFrame.write_pos : n + n2);
            outputStream.write(this.buffer, n4 - n5, n7 -= n3);
            n4 += n7;
            n3 += n7;
        }
    }

    public void setCodeSet(int n, int n2) {
        this.codeSet = n;
        this.codeSetW = n2;
    }

    public void setGIOPMinor(int n) {
        this.giop_minor = n;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.bufMgr.returnBuffer(this.buffer, true);
        this.buffer = null;
        this.closed = true;
        this.deferredArrayQueue = null;
        this.deferred_writes = 0;
    }

    private final void check(int n, int n2) {
        int n3 = n2 - this.index % n2;
        this.check(n + n3);
        if (n3 != n2) {
            int n4 = this.buffer.length - this.pos;
            int n5 = n4 <= 8 ? n4 : 8;
            int n6 = 0;
            switch (n5) {
                case 8: {
                    this.buffer[this.pos + n6++] = 0;
                }
                case 7: {
                    this.buffer[this.pos + n6++] = 0;
                }
                case 6: {
                    this.buffer[this.pos + n6++] = 0;
                }
                case 5: {
                    this.buffer[this.pos + n6++] = 0;
                }
                case 4: {
                    this.buffer[this.pos + n6++] = 0;
                }
                case 3: {
                    this.buffer[this.pos + n6++] = 0;
                }
                case 2: {
                    this.buffer[this.pos + n6++] = 0;
                }
                case 1: {
                    this.buffer[this.pos + n6++] = 0;
                }
            }
            this.index += n3;
            this.pos += n3;
        }
    }

    private final void check(int n) {
        if (this.buffer == null || this.pos + n + 2 > this.buffer.length) {
            byte[] byArray = this.bufMgr.getBuffer(this.pos + n + 2, true);
            if (this.buffer != null) {
                System.arraycopy(this.buffer, 0, byArray, 0, this.pos);
            }
            this.bufMgr.returnBuffer(this.buffer, true);
            this.buffer = byArray;
            byArray = null;
        }
    }

    private static final void _write4int(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    public final void beginEncapsulation() {
        this.check(8, 4);
        this.pos += 4;
        this.index += 4;
        this.getEncapsStack().push(new EncapsInfo(this.index, this.encaps_start, this.getValueMap(), this.getRepIdMap(), this.getCodebaseMap()));
        this.valueMap = Environment.createIdentityHashMap();
        this.repIdMap = new HashMap();
        this.codebaseMap = new HashMap();
        this.encaps_start = this.pos;
        this.beginEncapsulatedArray();
    }

    public final void beginEncapsulatedArray() {
        this.resetIndex();
        this.buffer[this.pos++] = 0;
        ++this.index;
    }

    public final void endEncapsulation() {
        if (this.encaps_start == -1) {
            throw new MARSHAL("Too many end-of-encapsulations");
        }
        if (this.encaps_stack == null) {
            throw new MARSHAL("Internal Error - closeEncapsulation failed");
        }
        int n = this.pos - this.encaps_start;
        this.buffer[this.encaps_start - 4] = (byte)(n >>> 24 & 0xFF);
        this.buffer[this.encaps_start - 3] = (byte)(n >>> 16 & 0xFF);
        this.buffer[this.encaps_start - 2] = (byte)(n >>> 8 & 0xFF);
        this.buffer[this.encaps_start - 1] = (byte)(n & 0xFF);
        EncapsInfo encapsInfo = (EncapsInfo)this.getEncapsStack().pop();
        this.encaps_start = encapsInfo.start;
        this.index = encapsInfo.index + n;
        this.valueMap = encapsInfo.valueMap;
        this.repIdMap = encapsInfo.repIdMap;
        this.codebaseMap = encapsInfo.codebaseMap;
    }

    public byte[] getBufferCopy() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.write(byteArrayOutputStream, 0, this.size());
        }
        catch (IOException iOException) {
            Debug.output(1, iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void resetIndex() {
        this.index = 0;
    }

    public int size() {
        return this.pos + this.deferred_writes;
    }

    public void reset() {
        this.deferredArrayQueue = null;
        this.pos = 0;
        this.deferred_writes = 0;
        this.index = 0;
    }

    public final void skip(int n) {
        this.pos += n;
        this.index += n;
    }

    public final void reduceSize(int n) {
        this.pos -= n;
    }

    public final void increaseSize(int n) {
        this.pos += n;
        this.check(n);
    }

    public void setBuffer(byte[] byArray) {
        this.bufMgr.returnBuffer(this.buffer, true);
        this.buffer = byArray;
        this.reset();
    }

    public void setBufferWithoutReset(byte[] byArray, int n) {
        this.close();
        this.buffer = byArray;
        this.pos = n;
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        byte[] byArray = (byte[])this.buffer.clone();
        return new CDRInputStream(this.orb, byArray);
    }

    public final void write_any(Any any) {
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public final void write_boolean(boolean bl) {
        this.check(1);
        this.buffer[this.pos++] = bl ? (byte)1 : 0;
        ++this.index;
    }

    public final void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray != null) {
            this.check(n2);
            for (int i = n; i < n + n2; ++i) {
                this.buffer[this.pos++] = blArray[i] ? (byte)1 : 0;
            }
            this.index += n2;
        }
    }

    public final void write_char(char c) {
        if (c > '\u00ff') {
            throw new DATA_CONVERSION("Char " + c + " out of range");
        }
        this.check(1);
        this.buffer[this.pos++] = (byte)c;
        ++this.index;
    }

    public final void write_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("Cannot marshall null array.");
        }
        if (n + n2 > cArray.length || n2 < 0 || n < 0) {
            throw new MARSHAL("Cannot marshall as indices for array are out bounds.");
        }
        if (Environment.getCodeSetsActive() && Environment.getMultibyteCharArray()) {
            byte[] byArray = CodeSet.getCTBConverter(this.codeSet).convert(cArray, 0);
            this.check(byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                this.buffer[this.pos++] = byArray[i];
            }
            this.index += byArray.length;
        } else {
            this.check(n2);
            for (int i = n; i < n2 + n; ++i) {
                if (cArray[i] > '\u00ff') {
                    throw new DATA_CONVERSION("Char " + cArray[i] + " out of range");
                }
                this.buffer[this.pos++] = (byte)cArray[i];
            }
            this.index += n2;
        }
    }

    public final void write_string(String string) {
        int n = 0;
        if (string == null) {
            throw new MARSHAL("Cannot marshall null string.");
        }
        int n2 = string.length();
        if (n2 == 0) {
            this.write_long(1);
            this.write_octet((byte)0);
        } else {
            if (Environment.getCodeSetsActive()) {
                byte[] byArray = CodeSet.getCTBConverter(this.codeSet).convert(string.toCharArray(), 0);
                n = 4 + byArray.length + 1;
                this.check(n, 4);
                CDROutputStream._write4int(this.buffer, this.pos, n - 4);
                this.pos += 4;
                for (int i = 0; i < byArray.length; ++i) {
                    this.buffer[this.pos++] = byArray[i];
                }
                this.buffer[this.pos++] = 0;
            } else {
                n = 4 + n2 + 1;
                this.check(n, 4);
                CDROutputStream._write4int(this.buffer, this.pos, n - 4);
                this.pos += 4;
                for (int i = 0; i < n2; ++i) {
                    this.buffer[this.pos++] = (byte)string.charAt(i);
                }
                this.buffer[this.pos++] = 0;
            }
            this.index += n;
        }
    }

    public final void write_wchar(char c) {
        this.write_wchar(c, useBOM, true);
    }

    private final void write_wchar(char c, boolean bl, boolean bl2) {
        this.check(3);
        switch (this.codeSetW) {
            case 0x5010001: {
                if (c <= '\u007f') {
                    if (this.giop_minor == 2 && bl2) {
                        this.write_octet((byte)1);
                    }
                    this.buffer[this.pos++] = (byte)c;
                    break;
                }
                if (c > '\u07ff') {
                    if (this.giop_minor == 2 && bl2) {
                        this.write_octet((byte)3);
                    }
                    this.buffer[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.buffer[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                    this.index += 3;
                    break;
                }
                if (this.giop_minor == 2 && bl2) {
                    this.write_octet((byte)2);
                }
                this.buffer[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                this.index += 2;
                break;
            }
            case 65801: {
                if (this.giop_minor == 2) {
                    if (bl2) {
                        this.write_octet((byte)2);
                    }
                    if (bl) {
                        this.buffer[this.pos++] = -2;
                        this.buffer[this.pos++] = -1;
                        this.index += 2;
                    }
                    this.buffer[this.pos++] = (byte)(c >> 8 & 0xFF);
                    this.buffer[this.pos++] = (byte)(c & 0xFF);
                    this.index += 2;
                    break;
                }
                this.write_short((short)c);
                break;
            }
            default: {
                throw new CODESET_INCOMPATIBLE("Bad codeset: " + this.codeSet);
            }
        }
    }

    public final void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("Null References");
        }
        this.check(n2 * 3);
        for (int i = n; i < n + n2; ++i) {
            this.write_wchar(cArray[i]);
        }
    }

    public final void write_wstring(String string) {
        int n;
        if (string == null) {
            throw new MARSHAL("Null References");
        }
        this.check(4 + string.length() * 3 + 3, 4);
        int n2 = this.pos;
        this.pos += 4;
        this.index += 4;
        if (this.giop_minor == 2 && useBOM && string.length() > 0) {
            this.buffer[this.pos++] = -2;
            this.buffer[this.pos++] = -1;
            this.index += 2;
        }
        for (n = 0; n < string.length(); ++n) {
            this.write_wchar(string.charAt(n), false, false);
        }
        if (this.giop_minor < 2) {
            this.write_wchar('\u0000', false, false);
        }
        n = 0;
        if (this.giop_minor == 2) {
            n = this.pos - n2 - 4;
        } else if (this.codeSetW == 0x5010001) {
            n = this.pos - n2 - 4;
        } else if (this.codeSetW == 65801) {
            n = string.length() + 1;
        }
        CDROutputStream._write4int(this.buffer, n2, n);
    }

    public final void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public final void write_double_array(double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.check(7 + n2 * 8, 8);
        if (dArray != null) {
            for (int i = n; i < n + n2; ++i) {
                long l = Double.doubleToLongBits(dArray[i]);
                this.buffer[this.pos] = (byte)(l >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(l >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(l >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(l >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(l >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(l >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(l >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(l & 0xFFL);
                this.pos += 8;
            }
            this.index += 8 * n2;
        }
    }

    public final void write_fixed(BigDecimal bigDecimal) {
        int n;
        byte[] byArray;
        String string = bigDecimal.unscaledValue().toString();
        if (string.startsWith("-")) {
            string = string.substring(1);
        }
        if (string.length() % 2 == 0) {
            byArray = new byte[string.length() / 2 + 1];
            byArray[0] = 0;
            for (int i = 0; i < string.length(); ++i) {
                int n2 = Character.digit(string.charAt(i), 10);
                n = byArray[(1 + i) / 2] << 4;
                byArray[(1 + i) / 2] = (byte)(n |= n2);
            }
        } else {
            byArray = new byte[(string.length() + 1) / 2];
            for (int i = 0; i < string.length(); ++i) {
                int n3 = Character.digit(string.charAt(i), 10);
                n = byArray[i / 2] << 4;
                byArray[i / 2] = (byte)(n |= n3);
            }
        }
        n = byArray[byArray.length - 1] << 4;
        byArray[byArray.length - 1] = (byte)(bigDecimal.signum() < 0 ? n | 0xD : n | 0xC);
        this.check(byArray.length);
        System.arraycopy(byArray, 0, this.buffer, this.pos, byArray.length);
        this.index += byArray.length;
        this.pos += byArray.length;
    }

    public final void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public final void write_float_array(float[] fArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.check(3 + n2 * 4, 4);
        if (fArray != null) {
            for (int i = n; i < n + n2; ++i) {
                CDROutputStream._write4int(this.buffer, this.pos, Float.floatToIntBits(fArray[i]));
                this.pos += 4;
            }
            this.index += 4 * n2;
        }
    }

    public final void write_long(int n) {
        this.check(7, 4);
        CDROutputStream._write4int(this.buffer, this.pos, n);
        this.pos += 4;
        this.index += 4;
    }

    public final void write_long_array(int[] nArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.check(3 + n2 * 4, 4);
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        if (nArray != null) {
            for (int i = n; i < n + n2; ++i) {
                CDROutputStream._write4int(this.buffer, this.pos, nArray[i]);
                this.pos += 4;
            }
            this.index += 4 * n2;
        }
    }

    public final void write_longlong(long l) {
        this.check(15, 8);
        this.buffer[this.pos] = (byte)(l >>> 56 & 0xFFL);
        this.buffer[this.pos + 1] = (byte)(l >>> 48 & 0xFFL);
        this.buffer[this.pos + 2] = (byte)(l >>> 40 & 0xFFL);
        this.buffer[this.pos + 3] = (byte)(l >>> 32 & 0xFFL);
        this.buffer[this.pos + 4] = (byte)(l >>> 24 & 0xFFL);
        this.buffer[this.pos + 5] = (byte)(l >>> 16 & 0xFFL);
        this.buffer[this.pos + 6] = (byte)(l >>> 8 & 0xFFL);
        this.buffer[this.pos + 7] = (byte)(l & 0xFFL);
        this.index += 8;
        this.pos += 8;
    }

    public final void write_longlong_array(long[] lArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.check(7 + n2 * 8, 8);
        if (lArray != null) {
            for (int i = n; i < n + n2; ++i) {
                this.buffer[this.pos] = (byte)(lArray[i] >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(lArray[i] >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(lArray[i] >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(lArray[i] >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(lArray[i] >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(lArray[i] >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(lArray[i] >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(lArray[i] & 0xFFL);
                this.pos += 8;
            }
            this.index += 8 * n2;
        }
    }

    public void write_Object(Object object) {
        if (object == null) {
            IORHelper.write(this, null_ior);
        } else {
            if (object instanceof LocalObject) {
                throw new MARSHAL("Attempt to serialize a locality-constrained object.");
            }
            ObjectImpl objectImpl = (ObjectImpl)object;
            IORHelper.write(this, ((Delegate)objectImpl._get_delegate()).getIOR());
        }
    }

    public void write_IOR(IOR iOR) {
        if (iOR == null) {
            IORHelper.write(this, null_ior);
        } else {
            IORHelper.write(this, iOR);
        }
    }

    public final void write_octet(byte by) {
        this.check(1);
        ++this.index;
        this.buffer[this.pos++] = by;
    }

    public final void write_octet_array(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            if (n2 > 4000) {
                if (this.deferredArrayQueue == null) {
                    this.deferredArrayQueue = new ArrayList();
                }
                this.deferredArrayQueue.add(new DeferredWriteFrame(this.index, n, n2, byArray));
                this.index += n2;
                this.deferred_writes += n2;
            } else {
                this.check(n2);
                System.arraycopy(byArray, n, this.buffer, this.pos, n2);
                this.index += n2;
                this.pos += n2;
            }
        }
    }

    public final void write_Principal(Principal principal) {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public final void write_short(short s) {
        this.check(3, 2);
        this.buffer[this.pos++] = (byte)(s >>> 8);
        this.buffer[this.pos++] = (byte)s;
        this.index += 2;
    }

    public final void write_short_array(short[] sArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.check(2 * n2 + 3);
        int n3 = 2 - this.index % 2;
        if (n3 != 2) {
            this.index += n3;
            this.pos += n3;
        }
        if (sArray != null) {
            for (int i = n; i < n + n2; ++i) {
                this.buffer[this.pos++] = (byte)(sArray[i] >>> 8);
                this.buffer[this.pos++] = (byte)sArray[i];
            }
            this.index += 2 * n2;
        }
    }

    public final void write_TypeCode(org.omg.CORBA.TypeCode typeCode) {
        String string = null;
        org.omg.CORBA.TypeCode typeCode2 = null;
        try {
            string = typeCode.id();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        if (Environment.getCompactTypecodes() > 0 && string != null) {
            if (cachedTypecodes == null) {
                cachedTypecodes = new HashMap();
            } else {
                typeCode2 = (org.omg.CORBA.TypeCode)cachedTypecodes.get(string);
            }
            if (typeCode2 == null) {
                typeCode = typeCode.get_compact_typecode();
                cachedTypecodes.put(string, typeCode);
            } else {
                typeCode = typeCode2;
            }
        }
        this.write_TypeCode(typeCode, null, null);
    }

    private final void writeRecursiveTypeCode(org.omg.CORBA.TypeCode typeCode, Map map) throws BadKind {
        this.write_long(-1);
        int n = (Integer)map.get(typeCode.id()) - this.pos - 4;
        this.write_long(n);
    }

    private final void write_TypeCode(org.omg.CORBA.TypeCode typeCode, Map hashMap, Map hashMap2) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int n = typeCode.kind().value();
        try {
            if (TypeCode.isRecursive(typeCode) && hashMap != null && hashMap.containsKey(typeCode.id())) {
                this.writeRecursiveTypeCode(typeCode, hashMap);
            } else {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        this.write_long(n);
                        break;
                    }
                    case 14: {
                        this.write_long(n);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.endEncapsulation();
                        break;
                    }
                    case 15: {
                        if (Environment.getUseIndirection() && hashMap2 != null && hashMap2.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashMap2);
                            break;
                        }
                        this.write_long(n);
                        if (hashMap == null) {
                            hashMap = new HashMap<String, Integer>();
                        }
                        Integer n2 = new Integer(this.pos);
                        hashMap.put(typeCode.id(), n2);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        int n3 = typeCode.member_count();
                        this.write_long(n3);
                        for (int i = 0; i < n3; ++i) {
                            this.write_string(typeCode.member_name(i));
                            this.write_TypeCode(typeCode.member_type(i), hashMap, hashMap2);
                        }
                        this.endEncapsulation();
                        this.getKnownTCMap().put(typeCode.id(), typeCode);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap();
                        }
                        hashMap2.put(typeCode.id(), n2);
                        break;
                    }
                    case 16: {
                        if (Environment.getUseIndirection() && hashMap2 != null && hashMap2.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashMap2);
                            break;
                        }
                        this.write_long(n);
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        Integer n4 = new Integer(this.pos);
                        hashMap.put(typeCode.id(), n4);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.write_TypeCode(typeCode.discriminator_type());
                        this.write_long(typeCode.default_index());
                        int n5 = typeCode.member_count();
                        this.write_long(n5);
                        for (int i = 0; i < n5; ++i) {
                            if (i == typeCode.default_index()) {
                                this.write_octet((byte)0);
                            } else {
                                typeCode.member_label(i).write_value(this);
                            }
                            this.write_string(typeCode.member_name(i));
                            this.write_TypeCode(typeCode.member_type(i), hashMap, hashMap2);
                        }
                        this.endEncapsulation();
                        this.getKnownTCMap().put(typeCode.id(), typeCode);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap();
                        }
                        hashMap2.put(typeCode.id(), n4);
                        break;
                    }
                    case 17: {
                        if (Environment.getUseIndirection() && hashMap2 != null && hashMap2.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashMap2);
                            break;
                        }
                        this.write_long(n);
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        Integer n6 = new Integer(this.pos);
                        hashMap.put(typeCode.id(), n6);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        int n7 = typeCode.member_count();
                        this.write_long(n7);
                        for (int i = 0; i < n7; ++i) {
                            this.write_string(typeCode.member_name(i));
                        }
                        this.endEncapsulation();
                        this.getKnownTCMap().put(typeCode.id(), typeCode);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap();
                        }
                        hashMap2.put(typeCode.id(), n6);
                        break;
                    }
                    case 18: {
                        this.write_long(n);
                        this.write_long(typeCode.length());
                        break;
                    }
                    case 19: 
                    case 20: {
                        this.write_long(n);
                        this.beginEncapsulation();
                        this.write_TypeCode(typeCode.content_type(), hashMap, hashMap2);
                        this.write_long(typeCode.length());
                        this.endEncapsulation();
                        break;
                    }
                    case 21: {
                        if (Environment.getUseIndirection() && hashMap2 != null && hashMap2.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashMap2);
                            break;
                        }
                        this.write_long(n);
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        Integer n8 = new Integer(this.pos);
                        hashMap.put(typeCode.id(), n8);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.write_TypeCode(typeCode.content_type(), hashMap, hashMap2);
                        this.endEncapsulation();
                        this.getKnownTCMap().put(typeCode.id(), typeCode);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap();
                        }
                        hashMap2.put(typeCode.id(), n8);
                        break;
                    }
                    case 22: {
                        if (Environment.getUseIndirection() && hashMap2 != null && hashMap2.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashMap2);
                            break;
                        }
                        this.write_long(n);
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        Integer n9 = new Integer(this.pos);
                        hashMap.put(typeCode.id(), n9);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        int n10 = typeCode.member_count();
                        this.write_long(n10);
                        for (int i = 0; i < n10; ++i) {
                            this.write_string(typeCode.member_name(i));
                            this.write_TypeCode(typeCode.member_type(i), hashMap, hashMap2);
                        }
                        this.endEncapsulation();
                        this.getKnownTCMap().put(typeCode.id(), typeCode);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap();
                        }
                        hashMap2.put(typeCode.id(), n9);
                        break;
                    }
                    case 23: 
                    case 24: {
                        this.write_long(n);
                        break;
                    }
                    case 25: {
                        throw new MARSHAL("Cannot handle TypeCode with kind: " + n);
                    }
                    case 26: {
                        this.write_long(n);
                        break;
                    }
                    case 27: {
                        this.write_long(n);
                        this.write_long(typeCode.length());
                        break;
                    }
                    case 28: {
                        this.write_long(n);
                        this.write_ushort(typeCode.fixed_digits());
                        this.write_short(typeCode.fixed_scale());
                        break;
                    }
                    case 29: {
                        if (Environment.getUseIndirection() && hashMap2 != null && hashMap2.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashMap2);
                            break;
                        }
                        this.write_long(n);
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        Integer n11 = new Integer(this.pos);
                        hashMap.put(typeCode.id(), n11);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.write_short(typeCode.type_modifier());
                        org.omg.CORBA.TypeCode typeCode2 = typeCode.concrete_base_type();
                        if (typeCode2 != null) {
                            this.write_TypeCode(typeCode2, hashMap, hashMap2);
                        } else {
                            this.write_long(0);
                        }
                        int n12 = typeCode.member_count();
                        this.write_long(n12);
                        for (int i = 0; i < n12; ++i) {
                            this.write_string(typeCode.member_name(i));
                            this.write_TypeCode(typeCode.member_type(i), hashMap, hashMap2);
                            this.write_short(typeCode.member_visibility(i));
                        }
                        this.endEncapsulation();
                        this.getKnownTCMap().put(typeCode.id(), typeCode);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap();
                        }
                        hashMap2.put(typeCode.id(), n11);
                        break;
                    }
                    case 30: {
                        if (Environment.getUseIndirection() && hashMap2 != null && hashMap2.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashMap2);
                            break;
                        }
                        this.write_long(n);
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        Integer n13 = new Integer(this.pos);
                        hashMap.put(typeCode.id(), n13);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.write_TypeCode(typeCode.content_type(), hashMap, hashMap2);
                        this.endEncapsulation();
                        this.getKnownTCMap().put(typeCode.id(), typeCode);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap();
                        }
                        hashMap2.put(typeCode.id(), n13);
                        break;
                    }
                    case 31: {
                        throw new MARSHAL("Cannot handle TypeCode with kind: " + n);
                    }
                    case 32: {
                        if (Environment.getUseIndirection() && hashMap2 != null && hashMap2.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashMap2);
                            break;
                        }
                        this.write_long(n);
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        Integer n14 = new Integer(this.pos);
                        hashMap.put(typeCode.id(), n14);
                        this.getKnownTCMap().put(typeCode.id(), typeCode);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap<String, Integer>();
                        }
                        hashMap2.put(typeCode.id(), n14);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.endEncapsulation();
                        break;
                    }
                    default: {
                        throw new MARSHAL("Cannot handle TypeCode with kind: " + n);
                    }
                }
            }
        }
        catch (BadKind badKind) {
            throw new MARSHAL("When processing TypeCode with kind: " + n + " caught " + badKind);
        }
        catch (Bounds bounds) {
            throw new MARSHAL("When processing TypeCode with kind: " + n + " caught " + bounds);
        }
    }

    public final void write_ulong(int n) {
        this.write_long(n);
    }

    public final void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public final void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public final void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public final void write_ushort(short s) {
        this.write_short(s);
    }

    public final void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public final void write_value(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.portable.InputStream inputStream) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int n = typeCode.kind().value();
        try {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                case 8: {
                    this.write_boolean(inputStream.read_boolean());
                    break;
                }
                case 9: {
                    this.write_char(inputStream.read_char());
                    break;
                }
                case 26: {
                    this.write_wchar(inputStream.read_wchar());
                    break;
                }
                case 10: {
                    this.write_octet(inputStream.read_octet());
                    break;
                }
                case 2: {
                    this.write_short(inputStream.read_short());
                    break;
                }
                case 4: {
                    this.write_ushort(inputStream.read_ushort());
                    break;
                }
                case 3: {
                    this.write_long(inputStream.read_long());
                    break;
                }
                case 5: {
                    this.write_ulong(inputStream.read_ulong());
                    break;
                }
                case 6: {
                    this.write_float(inputStream.read_float());
                    break;
                }
                case 7: {
                    this.write_double(inputStream.read_double());
                    break;
                }
                case 23: {
                    this.write_longlong(inputStream.read_longlong());
                    break;
                }
                case 24: {
                    this.write_ulonglong(inputStream.read_ulonglong());
                    break;
                }
                case 11: {
                    this.write_any(inputStream.read_any());
                    break;
                }
                case 12: {
                    this.write_TypeCode(inputStream.read_TypeCode());
                    break;
                }
                case 13: {
                    throw new NO_IMPLEMENT("Principal deprecated");
                }
                case 14: {
                    this.write_Object(inputStream.read_Object());
                    break;
                }
                case 18: {
                    this.write_string(inputStream.read_string());
                    break;
                }
                case 27: {
                    this.write_wstring(inputStream.read_wstring());
                    break;
                }
                case 28: {
                    this.write_fixed(inputStream.read_fixed());
                    break;
                }
                case 20: {
                    int n2 = typeCode.length();
                    if (typeCode.content_type().kind().value() == 10) {
                        this.check(n2);
                        inputStream.read_octet_array(this.buffer, this.pos, n2);
                        this.index += n2;
                        this.pos += n2;
                        break;
                    }
                    for (int i = 0; i < n2; ++i) {
                        this.write_value(typeCode.content_type(), inputStream);
                    }
                    break;
                }
                case 19: {
                    int n3 = inputStream.read_long();
                    this.write_long(n3);
                    org.omg.CORBA.TypeCode typeCode2 = typeCode.content_type();
                    for (int i = 0; i < n3; ++i) {
                        this.write_value(typeCode2, inputStream);
                    }
                    break;
                }
                case 22: {
                    this.write_string(inputStream.read_string());
                }
                case 15: {
                    for (int i = 0; i < typeCode.member_count(); ++i) {
                        this.write_value(typeCode.member_type(i), inputStream);
                    }
                    break;
                }
                case 17: {
                    this.write_long(inputStream.read_long());
                    break;
                }
                case 16: {
                    org.omg.CORBA.TypeCode typeCode3 = typeCode.discriminator_type();
                    typeCode3 = TypeCode.originalType(typeCode3);
                    int n4 = typeCode.default_index();
                    int n5 = -1;
                    block32 : switch (typeCode3.kind().value()) {
                        case 2: {
                            short s = inputStream.read_short();
                            this.write_short(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || s != typeCode.member_label(i).extract_short()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 4: {
                            short s = inputStream.read_ushort();
                            this.write_ushort(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || s != typeCode.member_label(i).extract_ushort()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 3: {
                            int n6 = inputStream.read_long();
                            this.write_long(n6);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || n6 != typeCode.member_label(i).extract_long()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 5: {
                            int n7 = inputStream.read_ulong();
                            this.write_ulong(n7);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || n7 != typeCode.member_label(i).extract_ulong()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 23: {
                            long l = inputStream.read_longlong();
                            this.write_longlong(l);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || l != typeCode.member_label(i).extract_longlong()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 24: {
                            long l = inputStream.read_ulonglong();
                            this.write_ulonglong(l);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || l != typeCode.member_label(i).extract_ulonglong()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 8: {
                            boolean bl = inputStream.read_boolean();
                            this.write_boolean(bl);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || bl != typeCode.member_label(i).extract_boolean()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 17: {
                            int n8 = inputStream.read_long();
                            this.write_long(n8);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                int n9;
                                if (i == n4 || n8 != (n9 = typeCode.member_label(i).create_input_stream().read_long())) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 9: {
                            char c = inputStream.read_char();
                            this.write_char(c);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || c != typeCode.member_label(i).extract_char()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid union discriminator type: " + typeCode3);
                        }
                    }
                    if (n5 != -1) {
                        this.write_value(typeCode.member_type(n5), inputStream);
                        break;
                    }
                    if (n4 != -1) {
                        this.write_value(typeCode.member_type(n4), inputStream);
                    }
                    break;
                }
                case 21: {
                    this.write_value(typeCode.content_type(), inputStream);
                    break;
                }
                case 30: {
                    String string = typeCode.id();
                    BoxedValueHelper boxedValueHelper = RepositoryID.getBoxedValueHelper(string);
                    if (boxedValueHelper == null) {
                        throw new MARSHAL("No BoxedValueHelper for id " + string);
                    }
                    Serializable serializable = ((InputStream)inputStream).read_value(boxedValueHelper);
                    this.write_value(serializable, boxedValueHelper);
                    break;
                }
                case -1: {
                    org.omg.CORBA.TypeCode typeCode4 = (org.omg.CORBA.TypeCode)this.getKnownTCMap().get(typeCode.id());
                    if (typeCode4 == null) {
                        throw new MARSHAL("Recursive TypeCode not found for " + typeCode.id());
                    }
                    this.write_value(typeCode4, inputStream);
                    break;
                }
                default: {
                    throw new MARSHAL("Cannot handle TypeCode with kind " + n);
                }
            }
        }
        catch (BadKind badKind) {
            throw new MARSHAL("When processing TypeCode with kind: " + n + " caught " + badKind);
        }
        catch (Bounds bounds) {
            throw new MARSHAL("When processing TypeCode with kind: " + n + " caught " + bounds);
        }
    }

    public void write_value(Serializable serializable) {
        if (!this.write_special_value(serializable)) {
            this.write_value_internal(serializable, ValueHandler.getRMIRepositoryID(serializable.getClass()));
        }
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        if (!this.write_special_value(serializable)) {
            this.check(7, 4);
            this.getValueMap().put(serializable, new Integer(this.pos));
            this.write_previous_chunk_size();
            if (serializable instanceof IDLEntity || serializable instanceof String) {
                this.write_long(0x7FFFFF00 | this.chunkingFlag);
            } else {
                this.write_long(0x7FFFFF02 | this.chunkingFlag);
                this.write_repository_id(RepositoryID.repId(serializable.getClass()));
            }
            this.start_chunk();
            boxedValueHelper.write_value(this, serializable);
            this.end_chunk();
        }
    }

    public void write_value(Serializable serializable, Class clazz) {
        if (!this.write_special_value(serializable)) {
            Class<?> clazz2 = serializable.getClass();
            String string = ValueHandler.getRMIRepositoryID(clazz2);
            if (clazz2 == clazz && !string.startsWith("RMI:")) {
                this.write_value_internal(serializable, null);
            } else if (clazz.isInstance(serializable)) {
                this.write_value_internal(serializable, string);
            } else {
                throw new BAD_PARAM();
            }
        }
    }

    public void write_value(Serializable serializable, String string) {
        if (!this.write_special_value(serializable)) {
            this.write_value_internal(serializable, string);
        }
    }

    private boolean write_special_value(Serializable serializable) {
        if (serializable == null) {
            this.write_long(0);
            return true;
        }
        Integer n = (Integer)this.getValueMap().get(serializable);
        if (n != null) {
            this.write_long(-1);
            this.write_long(n - this.pos);
            return true;
        }
        return false;
    }

    private void write_repository_id(String string) {
        Integer n = (Integer)this.getRepIdMap().get(string);
        if (n == null) {
            int n2 = 4 - this.index % 4;
            if (n2 != 4) {
                this.index += n2;
                this.pos += n2;
            }
            this.getRepIdMap().put(string, new Integer(this.pos));
            this.write_string(string);
        } else {
            this.write_long(-1);
            this.write_long(n - this.pos);
        }
    }

    private void write_codebase(String string) {
        Integer n = null;
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        } else {
            n = (Integer)this.getCodebaseMap().get(string);
        }
        if (n == null) {
            int n2 = 4 - this.index % 4;
            if (n2 != 4) {
                this.index += n2;
                this.pos += n2;
            }
            this.getCodebaseMap().put(string, new Integer(this.pos));
            this.write_string(string);
        } else {
            this.write_long(-1);
            this.write_long(n - this.pos);
        }
    }

    private void write_value_header(String[] stringArray) {
        this.write_previous_chunk_size();
        if (stringArray != null) {
            if (stringArray.length > 1) {
                this.chunkingFlag = 8;
                this.write_long(0x7FFFFF06 | this.chunkingFlag);
                this.write_long(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.write_repository_id(stringArray[i]);
                }
            } else {
                this.write_long(0x7FFFFF02 | this.chunkingFlag);
                this.write_repository_id(stringArray[0]);
            }
        } else {
            this.write_long(0x7FFFFF00 | this.chunkingFlag);
        }
    }

    private void write_value_header(String[] stringArray, String string) {
        if (string != null) {
            this.write_previous_chunk_size();
            if (stringArray != null) {
                if (stringArray.length > 1) {
                    this.chunkingFlag = 8;
                    this.write_long(0x7FFFFF07 | this.chunkingFlag);
                    this.write_codebase(string);
                    this.write_long(stringArray.length);
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.write_repository_id(stringArray[i]);
                    }
                } else {
                    this.write_long(0x7FFFFF03 | this.chunkingFlag);
                    this.write_codebase(string);
                    this.write_repository_id(stringArray[0]);
                }
            } else {
                this.write_long(0x7FFFFF01 | this.chunkingFlag);
                this.write_codebase(string);
            }
        } else {
            this.write_value_header(stringArray);
        }
    }

    private void write_value_internal(Serializable serializable, String string) {
        this.check(7, 4);
        this.getValueMap().put(serializable, new Integer(this.pos));
        if (serializable.getClass() == String.class) {
            String[] stringArray;
            if (string == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string;
            }
            String[] stringArray3 = stringArray;
            this.write_value_header(stringArray3);
            this.start_chunk();
            this.write_wstring((String)((java.lang.Object)serializable));
            this.end_chunk();
        } else if (serializable instanceof StreamableValue) {
            StreamableValue streamableValue = (StreamableValue)serializable;
            this.write_value_header(streamableValue._truncatable_ids());
            this.start_chunk();
            ((StreamableValue)serializable)._write(this);
            this.end_chunk();
        } else if (serializable instanceof CustomValue) {
            DataOutputStream dataOutputStream = new DataOutputStream(this);
            this.write_value_header(((CustomValue)serializable)._truncatable_ids());
            ((CustomValue)serializable).marshal(dataOutputStream);
        } else {
            String[] stringArray;
            if (string == null) {
                stringArray = null;
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = string;
            }
            String[] stringArray5 = stringArray;
            Class<?> clazz = serializable.getClass();
            String string2 = ValueHandler.getCodebase(clazz);
            if (serializable instanceof IDLEntity) {
                Method method = null;
                if (clazz != Any.class) {
                    String string3 = clazz.getName() + "Helper";
                    try {
                        Class<?> clazz2 = null;
                        try {
                            clazz2 = Environment.classForName(string3);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            clazz2 = clazz.getClassLoader().loadClass(string3);
                        }
                        Class[] classArray = new Class[]{org.omg.CORBA.portable.OutputStream.class, clazz};
                        method = clazz2.getMethod("write", classArray);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new MARSHAL("Error loading class " + string3 + ": " + classNotFoundException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new MARSHAL("No write method in helper class " + string3 + ": " + noSuchMethodException);
                    }
                }
                this.write_value_header(stringArray5, string2);
                this.start_chunk();
                if (method == null) {
                    this.write_any((Any)serializable);
                } else {
                    try {
                        method.invoke(null, this, serializable);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new MARSHAL("Internal error: " + illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new MARSHAL("Exception marshaling IDLEntity: " + invocationTargetException.getTargetException());
                    }
                }
                this.end_chunk();
            } else {
                Serializable serializable2;
                if (chunkCustomRmiValuetypes && ValueHandler.isCustomMarshaled(clazz)) {
                    this.chunkingFlag = 8;
                }
                if ((serializable2 = ValueHandler.writeReplace(serializable)) != serializable) {
                    String[] stringArray6;
                    String string4 = ValueHandler.getRMIRepositoryID(serializable2.getClass());
                    if (string4 == null) {
                        stringArray6 = null;
                    } else {
                        String[] stringArray7 = new String[1];
                        stringArray6 = stringArray7;
                        stringArray7[0] = string4;
                    }
                    stringArray5 = stringArray6;
                    clazz = serializable2.getClass();
                    string2 = ValueHandler.getCodebase(clazz);
                }
                this.write_value_header(stringArray5, string2);
                this.start_chunk();
                ValueHandler.writeValue(this, serializable2);
                this.end_chunk();
            }
        }
    }

    private void start_chunk() {
        if (this.chunkingFlag > 0) {
            this.write_previous_chunk_size();
            ++this.valueNestingLevel;
            this.skip_chunk_size_tag();
        }
    }

    private void end_chunk() {
        if (this.chunkingFlag > 0) {
            this.write_previous_chunk_size();
            this.write_long(-this.valueNestingLevel);
            if (--this.valueNestingLevel == 0) {
                this.chunkingFlag = 0;
            } else {
                this.skip_chunk_size_tag();
            }
        }
    }

    private void write_previous_chunk_size() {
        if (this.chunk_size_tag_pos != -1) {
            if (this.pos == this.chunk_octets_pos) {
                this.pos = this.chunk_size_tag_pos;
                this.index = this.chunk_size_tag_index;
            } else {
                int n = this.pos;
                int n2 = this.index;
                this.pos = this.chunk_size_tag_pos;
                this.index = this.chunk_size_tag_index;
                this.write_long(n - this.chunk_octets_pos);
                this.pos = n;
                this.index = n2;
            }
            this.chunk_size_tag_pos = -1;
        }
    }

    private void skip_chunk_size_tag() {
        this.chunk_size_tag_pos = this.pos;
        this.chunk_size_tag_index = this.index;
        this.write_long(0);
        this.chunk_octets_pos = this.pos;
    }

    public void write_abstract_interface(java.lang.Object object) {
        if (object instanceof Object) {
            this.write_boolean(true);
            this.write_Object((Object)object);
        } else {
            this.write_boolean(false);
            this.write_value((Serializable)object);
        }
    }

    static {
        useBOM = false;
        chunkCustomRmiValuetypes = false;
        useBOM = Environment.isPropertyOn("jacorb.use_bom");
        chunkCustomRmiValuetypes = Environment.isPropertyOn("jacorb.interop.chunk_custom_rmi_valuetypes");
        null_ior = new IOR("", new TaggedProfile[0]);
    }

    private static final class DeferredWriteFrame {
        public int write_pos = 0;
        public int start = 0;
        public int length = 0;
        public byte[] buf = null;

        public DeferredWriteFrame(int n, int n2, int n3, byte[] byArray) {
            this.write_pos = n;
            this.start = n2;
            this.length = n3;
            this.buf = byArray;
        }
    }
}

