/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.jacorb.orb.factory.PortRangeFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.util.Debug;

public class PortRangeServerSocketFactory
extends PortRangeFactory
implements ServerSocketFactory {
    public static final String MIN_PROP = "jacorb.net.server_socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.server_socket_factory.port.max";

    public PortRangeServerSocketFactory() {
        super(MIN_PROP, MAX_PROP);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                ServerSocket socket = new ServerSocket(localPort, backlog);
                Debug.output(2, "PortRangeServerSocketFactory: Created server socket at :" + localPort);
                return socket;
            }
            catch (IOException ex) {
                continue;
            }
        }
        Debug.output(2, "Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                ServerSocket socket = new ServerSocket(localPort, backlog, ifAddress);
                Debug.output(2, "PortRangeServerSocketFactory: Created server socket at :" + localPort);
                return socket;
            }
            catch (IOException ex) {
                continue;
            }
        }
        Debug.output(2, "Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                ServerSocket socket = new ServerSocket(localPort);
                Debug.output(2, "PortRangeServerSocketFactory: Created server socket at :" + localPort);
                return socket;
            }
            catch (IOException ex) {
                continue;
            }
        }
        Debug.output(3, "Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }
}

