/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.UnsupportedEncodingException;
import org.jacorb.util.Debug;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CTBConverter {
    private CharToByteConverter converter;

    public CTBConverter(String encoding) {
        try {
            this.converter = CharToByteConverter.getConverter((String)encoding);
            this.converter.setSubstitutionMode(false);
        }
        catch (UnsupportedEncodingException ex) {
            if (Debug.isDebugEnabled()) {
                Debug.output(4, ex);
            }
            throw new DATA_CONVERSION(ex.getMessage());
        }
    }

    public byte[] convert(char[] value, int offset) {
        byte[] result = null;
        try {
            int numBytes = 0;
            int numChars = value.length - offset;
            result = new byte[numChars * this.converter.getMaxBytesPerChar()];
            this.converter.reset();
            numBytes = this.converter.convert(value, offset, numChars, result, 0, result.length);
            if ((numBytes += this.converter.flush(result, 0, result.length)) < result.length) {
                byte[] trimResult = new byte[numBytes];
                System.arraycopy(result, 0, trimResult, 0, numBytes);
                result = trimResult;
            }
        }
        catch (MalformedInputException ex) {
            if (Debug.isDebugEnabled()) {
                Debug.output(4, ex);
            }
            throw new DATA_CONVERSION(ex.getMessage());
        }
        catch (UnknownCharacterException ex) {
            if (Debug.isDebugEnabled()) {
                Debug.output(4, ex);
            }
            throw new DATA_CONVERSION(ex.getMessage());
        }
        catch (ConversionBufferFullException ex) {
            if (Debug.isDebugEnabled()) {
                Debug.output(4, ex);
            }
            throw new INTERNAL(ex.getMessage());
        }
        return result;
    }
}

