/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import java.util.List;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;

public class ServerGIOPConnection
extends GIOPConnection {
    private static final byte[] CLOSE_CONNECTION_MESSAGE = new byte[]{71, 73, 79, 80, 1, 0, 0, 5, 0, 0, 0, 0};
    private final GIOPConnectionManager manager;
    private boolean closeOnReadTimeout = false;
    private final boolean delayClose;
    private ArrayList indices;

    public ServerGIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener, StatisticsProvider statistics_provider, GIOPConnectionManager manager) {
        super(profile, transport, request_listener, reply_listener, statistics_provider);
        this.manager = manager;
        this.delayClose = Environment.isPropertyOn("jacorb.connection.delay_close");
    }

    boolean tryClose() {
        if (this.tryDiscard()) {
            this.sendCloseConnection();
            this.closeOnReadTimeout = true;
            if (this.connection_listener != null) {
                this.connection_listener.connectionClosed();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryDiscard() {
        if (!this.hasPendingMessages()) {
            byte[] byArray = this.pendingUndecidedSync;
            synchronized (this.pendingUndecidedSync) {
                this.discard_messages = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCloseConnection() {
        try {
            this.getWriteLock();
            this.write(CLOSE_CONNECTION_MESSAGE, 0, CLOSE_CONNECTION_MESSAGE.length);
            this.transport.flush();
            if (this.statistics_provider != null) {
                this.statistics_provider.flushed();
            }
            if (this.delayClose && this.transport instanceof IIOPConnection) {
                ((IIOPConnection)this.transport).turnOnFinalTimeout();
            } else {
                this.do_close = true;
                this.transport.close();
            }
        }
        catch (COMM_FAILURE e) {
            Debug.output(1, e);
        }
        finally {
            this.releaseWriteLock();
        }
        this.closeCleanup();
    }

    protected void readTimedOut() {
        if (this.closeOnReadTimeout) {
            this.close();
        } else {
            this.tryClose();
        }
    }

    protected void streamClosed() {
        this.close();
    }

    public void close() {
        super.close();
        this.closeCleanup();
    }

    private void closeCleanup() {
        if (this.indices != null) {
            for (int i = 0; i < this.indices.size(); ++i) {
                this.manager.removeContextKey((Integer)this.indices.get(i));
            }
        }
        if (this.manager != null) {
            this.manager.unregisterServerGIOPConnection(this);
        }
    }

    public byte[] addContextKey(byte[] object_key, byte[] oid, List scopes) {
        byte[] result = this.manager.addContextKey(object_key, oid, scopes);
        if (this.indices == null) {
            this.indices = new ArrayList(10);
        }
        this.indices.add(new Integer(this.manager.getSvcID()));
        return result;
    }

    public GIOPConnectionManager.ContextKey getContextKey(byte[] key) {
        return this.manager.getContextKey(key);
    }
}

