/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.naming;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.orb.naming.ASCII_CharStream;
import org.jacorb.orb.naming.IiopConstants;
import org.jacorb.orb.naming.IiopTokenManager;
import org.jacorb.orb.naming.ParseException;
import org.jacorb.orb.naming.Token;
import org.jacorb.orb.naming.TokenMgrError;
import org.jacorb.util.Environment;
import org.omg.CosNaming.NameComponent;

public class Iiop
implements IiopConstants {
    private static boolean init = false;
    private static NameComponent[] nm = null;
    private static int count = -1;
    private static Vector parsedIiop;
    private static boolean jj_initialized_once;
    public static IiopTokenManager token_source;
    static ASCII_CharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static final int[] jj_la1_0;
    private static Vector jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;

    public static boolean parseIiop(String name) {
        return Iiop.parse(name, 1);
    }

    public static boolean parseURL(String name) {
        return Iiop.parse(name, 2);
    }

    public static boolean parseStringified(String name) {
        return Iiop.parse(name, 3);
    }

    public static synchronized NameComponent[] getComponents(String name) {
        if (Iiop.parse(name, 4)) {
            return nm;
        }
        return null;
    }

    public static synchronized Vector getParsedIiop(String name) {
        if (Iiop.parse(name, 5)) {
            return parsedIiop;
        }
        return null;
    }

    private static synchronized boolean parse(String name, int type) {
        count = -1;
        nm = null;
        parsedIiop = null;
        boolean result = true;
        if (name == null) {
            result = false;
        } else {
            StringReader reader = new StringReader(name);
            try {
                if (init) {
                    Iiop.ReInit(reader);
                } else {
                    init = true;
                    new Iiop(reader);
                }
                if (type == 1) {
                    Iiop.checkIiop();
                } else if (type == 2) {
                    Iiop.checkURL();
                } else if (type == 3) {
                    Iiop.checkName();
                } else if (type == 4) {
                    int i;
                    int j = 1;
                    char[] nameArray = name.toCharArray();
                    for (i = 1; i < nameArray.length; ++i) {
                        if (nameArray[i] != '/' || nameArray[i - 1] == '\\') continue;
                        ++j;
                    }
                    nm = new NameComponent[j];
                    for (i = 0; i < j; ++i) {
                        Iiop.nm[i] = new NameComponent();
                        Iiop.nm[i].id = "";
                        Iiop.nm[i].kind = "";
                    }
                    Iiop.checkName();
                } else if (type == 5) {
                    parsedIiop = new Vector();
                    Iiop.checkIiop();
                }
            }
            catch (ParseException e) {
                Environment.getLogger().error("Parse error ", e);
                result = false;
            }
            catch (TokenMgrError e) {
                Environment.getLogger().error("Parse error ", e);
                result = false;
            }
        }
        return result;
    }

    private static synchronized void addHolder(byte type, Token t1, Token t2) throws ParseException {
        if (type != 1) {
            int port = 2829;
            String address = "";
            if (t2.next != t1) {
                StringBuffer sb = new StringBuffer();
                t1 = t1.next;
                while (t1 != t2 && !t1.image.equals(":") && !t1.image.equals("/")) {
                    sb.append(t1.image);
                    t1 = t1.next;
                }
                address = sb.toString();
                if (t1 != t2) {
                    t1 = t1.next;
                    try {
                        port = Integer.parseInt(t1.image);
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseException("Port number format exception" + nfe);
                    }
                }
            }
            parsedIiop.addElement(new Holder(0, address, port));
        } else {
            parsedIiop.addElement(new Holder(1));
        }
    }

    protected static void addToHolders(Token t1, Token t2) {
        StringBuffer sb = new StringBuffer();
        if (t2.next != t1) {
            while (t1 != t2) {
                sb.append(t1.image);
                t1 = t1.next;
            }
            sb.append(t2.image);
        }
        for (int i = 0; i < parsedIiop.size(); ++i) {
            Holder holder = (Holder)parsedIiop.elementAt(i);
            holder.setName(sb.toString());
        }
    }

    public static final void checkIiop() throws ParseException {
        switch (Iiop.jj_nt.kind) {
            case 1: {
                Iiop.jj_consume_token(1);
                Iiop.type();
                block13: while (true) {
                    switch (Iiop.jj_nt.kind) {
                        case 6: 
                        case 7: 
                        case 8: {
                            break;
                        }
                        default: {
                            Iiop.jj_la1[0] = jj_gen;
                            break block13;
                        }
                    }
                    Iiop.typemore();
                }
                Iiop.getKey();
                Iiop.jj_consume_token(0);
                break;
            }
            case 2: {
                Iiop.jj_consume_token(2);
                Iiop.type();
                block14: while (true) {
                    switch (Iiop.jj_nt.kind) {
                        case 6: 
                        case 7: 
                        case 8: {
                            break;
                        }
                        default: {
                            Iiop.jj_la1[1] = jj_gen;
                            break block14;
                        }
                    }
                    Iiop.typemore();
                }
                Iiop.getKey();
                switch (Iiop.jj_nt.kind) {
                    case 3: {
                        Iiop.jj_consume_token(3);
                        Iiop.checkEscapedName();
                        break;
                    }
                    default: {
                        Iiop.jj_la1[2] = jj_gen;
                    }
                }
                Iiop.jj_consume_token(0);
                break;
            }
            default: {
                Iiop.jj_la1[3] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void checkURL() throws ParseException {
        switch (Iiop.jj_nt.kind) {
            case 14: 
            case 16: 
            case 20: {
                Iiop.addr();
                break;
            }
            default: {
                Iiop.jj_la1[4] = jj_gen;
            }
        }
        Iiop.jj_consume_token(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void getKey() throws ParseException {
        Token t1 = Iiop.getToken(1);
        try {
            block1 : switch (Iiop.jj_nt.kind) {
                case 11: {
                    Iiop.jj_consume_token(11);
                    switch (Iiop.jj_nt.kind) {
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 16: 
                        case 18: 
                        case 20: 
                        case 21: 
                        case 22: {
                            Iiop.componentloc();
                            while (true) {
                                switch (Iiop.jj_nt.kind) {
                                    case 11: {
                                        break;
                                    }
                                    default: {
                                        Iiop.jj_la1[5] = jj_gen;
                                        break block1;
                                    }
                                }
                                Iiop.jj_consume_token(11);
                                Iiop.componentloc();
                            }
                        }
                    }
                    Iiop.jj_la1[6] = jj_gen;
                    break;
                }
                default: {
                    Iiop.jj_la1[7] = jj_gen;
                }
            }
            Object var3_1 = null;
            if (parsedIiop == null) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (parsedIiop == null) throw throwable;
            Token t2 = Iiop.getToken(0);
            StringBuffer sb = new StringBuffer();
            if (t2.next != t1) {
                t1 = t1.next;
                while (t1 != t2) {
                    sb.append(t1.image);
                    t1 = t1.next;
                }
                sb.append(t2.image);
            }
            for (int i = 0; i < parsedIiop.size(); ++i) {
                String key = sb.toString();
                if (key.length() == 0) {
                    key = "NameService";
                }
                Holder holder = (Holder)parsedIiop.elementAt(i);
                holder.setKey(key);
            }
            throw throwable;
        }
        Token t2 = Iiop.getToken(0);
        StringBuffer sb = new StringBuffer();
        if (t2.next != t1) {
            t1 = t1.next;
            while (t1 != t2) {
                sb.append(t1.image);
                t1 = t1.next;
            }
            sb.append(t2.image);
        }
        for (int i = 0; i < parsedIiop.size(); ++i) {
            String key = sb.toString();
            if (key.length() == 0) {
                key = "NameService";
            }
            Holder holder = (Holder)parsedIiop.elementAt(i);
            holder.setKey(key);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void type() throws ParseException {
        Token t1 = Iiop.getToken(1);
        byte type = 1;
        try {
            switch (Iiop.jj_nt.kind) {
                case 9: {
                    Iiop.jj_consume_token(9);
                    Iiop.addr();
                    type = 0;
                    break;
                }
                case 4: {
                    Iiop.jj_consume_token(4);
                    Iiop.addr();
                    type = 0;
                    break;
                }
                case 5: {
                    Iiop.jj_consume_token(5);
                    type = 1;
                    break;
                }
                default: {
                    Iiop.jj_la1[8] = jj_gen;
                    Iiop.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Object var3_2 = null;
            if (parsedIiop == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (parsedIiop == null) throw throwable;
            Iiop.addHolder(type, t1, Iiop.getToken(0));
            throw throwable;
        }
        Iiop.addHolder(type, t1, Iiop.getToken(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void typemore() throws ParseException {
        Token t1 = Iiop.getToken(1);
        byte type = 1;
        try {
            switch (Iiop.jj_nt.kind) {
                case 6: {
                    token = Iiop.jj_consume_token(6);
                    Iiop.addr();
                    type = 0;
                    break;
                }
                case 7: {
                    token = Iiop.jj_consume_token(7);
                    Iiop.addr();
                    type = 0;
                    break;
                }
                case 8: {
                    token = Iiop.jj_consume_token(8);
                    type = 1;
                    break;
                }
                default: {
                    Iiop.jj_la1[9] = jj_gen;
                    Iiop.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Object var3_2 = null;
            if (parsedIiop == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (parsedIiop == null) throw throwable;
            Iiop.addHolder(type, t1, Iiop.getToken(0));
            throw throwable;
        }
        Iiop.addHolder(type, t1, Iiop.getToken(0));
    }

    public static final void addr() throws ParseException {
        switch (Iiop.jj_nt.kind) {
            case 14: {
                Iiop.jj_consume_token(14);
                break;
            }
            default: {
                Iiop.jj_la1[10] = jj_gen;
            }
        }
        Iiop.host();
        switch (Iiop.jj_nt.kind) {
            case 9: {
                Iiop.jj_consume_token(9);
                Iiop.jj_consume_token(18);
                break;
            }
            default: {
                Iiop.jj_la1[11] = jj_gen;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void host() throws ParseException {
        block0 : switch (Iiop.jj_nt.kind) {
            case 16: {
                Iiop.jj_consume_token(16);
                block23: while (true) {
                    switch (Iiop.jj_nt.kind) {
                        case 13: 
                        case 16: 
                        case 18: {
                            break;
                        }
                        default: {
                            Iiop.jj_la1[12] = jj_gen;
                            break block0;
                        }
                    }
                    switch (Iiop.jj_nt.kind) {
                        case 18: {
                            Iiop.jj_consume_token(18);
                            continue block23;
                        }
                        case 16: {
                            Iiop.jj_consume_token(16);
                            continue block23;
                        }
                        case 13: {
                            Iiop.jj_consume_token(13);
                            continue block23;
                        }
                    }
                    break;
                }
                Iiop.jj_la1[13] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
            case 20: {
                int i;
                Token token2 = Iiop.jj_consume_token(20);
                String str = token2.image;
                StringTokenizer sk = new StringTokenizer(str, ".");
                do {
                    if (!sk.hasMoreTokens()) return;
                    i = Integer.parseInt(sk.nextToken());
                    if (i > 255) throw new ParseException("IP Address (" + token2.image + ") out of range.");
                } while (i >= 0);
                throw new ParseException("IP Address (" + token2.image + ") out of range.");
            }
            default: {
                Iiop.jj_la1[17] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block25: while (true) {
            switch (Iiop.jj_nt.kind) {
                case 12: {
                    break;
                }
                default: {
                    Iiop.jj_la1[14] = jj_gen;
                    return;
                }
            }
            Iiop.jj_consume_token(12);
            Iiop.jj_consume_token(16);
            block26: while (true) {
                switch (Iiop.jj_nt.kind) {
                    case 13: 
                    case 16: 
                    case 18: {
                        break;
                    }
                    default: {
                        Iiop.jj_la1[15] = jj_gen;
                        continue block25;
                    }
                }
                switch (Iiop.jj_nt.kind) {
                    case 18: {
                        Iiop.jj_consume_token(18);
                        continue block26;
                    }
                    case 16: {
                        Iiop.jj_consume_token(16);
                        continue block26;
                    }
                    case 13: {
                        Iiop.jj_consume_token(13);
                        continue block26;
                    }
                }
                break;
            }
            break;
        }
        Iiop.jj_la1[16] = jj_gen;
        Iiop.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final void componentloc() throws ParseException {
        block0 : switch (Iiop.jj_nt.kind) {
            case 12: {
                Iiop.jj_consume_token(12);
                while (true) {
                    switch (Iiop.jj_nt.kind) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 16: 
                        case 18: 
                        case 20: 
                        case 21: 
                        case 22: {
                            break;
                        }
                        default: {
                            Iiop.jj_la1[18] = jj_gen;
                            break block0;
                        }
                    }
                    Iiop.nam();
                }
            }
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                block17: while (true) {
                    Iiop.nam();
                    switch (Iiop.jj_nt.kind) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 16: 
                        case 18: 
                        case 20: 
                        case 21: 
                        case 22: {
                            continue block17;
                        }
                    }
                    break;
                }
                Iiop.jj_la1[19] = jj_gen;
                block18: while (true) {
                    switch (Iiop.jj_nt.kind) {
                        case 12: {
                            break;
                        }
                        default: {
                            Iiop.jj_la1[20] = jj_gen;
                            break block0;
                        }
                    }
                    Iiop.jj_consume_token(12);
                    while (true) {
                        switch (Iiop.jj_nt.kind) {
                            case 9: 
                            case 10: 
                            case 13: 
                            case 16: 
                            case 18: 
                            case 20: 
                            case 21: 
                            case 22: {
                                break;
                            }
                            default: {
                                Iiop.jj_la1[21] = jj_gen;
                                continue block18;
                            }
                        }
                        Iiop.nam();
                    }
                    break;
                }
            }
            default: {
                Iiop.jj_la1[22] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void checkEscapedName() throws ParseException {
        Token t1 = Iiop.getToken(1);
        try {
            Iiop.componentnamescaped();
            block5: while (true) {
                switch (Iiop.jj_nt.kind) {
                    case 11: {
                        break;
                    }
                    default: {
                        Iiop.jj_la1[23] = jj_gen;
                        break block5;
                    }
                }
                Iiop.jj_consume_token(11);
                Iiop.componentnamescaped();
            }
            Iiop.jj_consume_token(0);
            Object var3_1 = null;
            if (parsedIiop == null) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (parsedIiop == null) throw throwable;
            Iiop.addToHolders(t1, Iiop.getToken(0));
            throw throwable;
        }
        Iiop.addToHolders(t1, Iiop.getToken(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void checkName() throws ParseException {
        Token t1 = Iiop.getToken(1);
        try {
            Iiop.componentnam();
            block5: while (true) {
                switch (Iiop.jj_nt.kind) {
                    case 11: {
                        break;
                    }
                    default: {
                        Iiop.jj_la1[24] = jj_gen;
                        break block5;
                    }
                }
                Iiop.jj_consume_token(11);
                Iiop.componentnam();
            }
            Iiop.jj_consume_token(0);
            Object var3_1 = null;
            if (parsedIiop == null) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (parsedIiop == null) throw throwable;
            Iiop.addToHolders(t1, Iiop.getToken(0));
            throw throwable;
        }
        Iiop.addToHolders(t1, Iiop.getToken(0));
    }

    public static final void componentnam() throws ParseException {
        ++count;
        block0 : switch (Iiop.jj_nt.kind) {
            case 12: {
                Iiop.jj_consume_token(12);
                while (true) {
                    switch (Iiop.jj_nt.kind) {
                        case 13: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 22: {
                            break;
                        }
                        default: {
                            Iiop.jj_la1[25] = jj_gen;
                            break block0;
                        }
                    }
                    Iiop.kindloc();
                }
            }
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 22: {
                block17: while (true) {
                    Iiop.idloc();
                    switch (Iiop.jj_nt.kind) {
                        case 13: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 22: {
                            continue block17;
                        }
                    }
                    break;
                }
                Iiop.jj_la1[26] = jj_gen;
                block18: while (true) {
                    switch (Iiop.jj_nt.kind) {
                        case 12: {
                            break;
                        }
                        default: {
                            Iiop.jj_la1[27] = jj_gen;
                            break block0;
                        }
                    }
                    Iiop.jj_consume_token(12);
                    while (true) {
                        switch (Iiop.jj_nt.kind) {
                            case 13: 
                            case 16: 
                            case 18: 
                            case 19: 
                            case 22: {
                                break;
                            }
                            default: {
                                Iiop.jj_la1[28] = jj_gen;
                                continue block18;
                            }
                        }
                        Iiop.kindloc();
                    }
                    break;
                }
            }
            default: {
                Iiop.jj_la1[29] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void componentnamescaped() throws ParseException {
        block0 : switch (Iiop.jj_nt.kind) {
            case 12: {
                Iiop.jj_consume_token(12);
                block37: while (true) {
                    switch (Iiop.jj_nt.kind) {
                        case 13: 
                        case 16: 
                        case 18: 
                        case 21: 
                        case 22: {
                            break;
                        }
                        default: {
                            Iiop.jj_la1[30] = jj_gen;
                            break block0;
                        }
                    }
                    switch (Iiop.jj_nt.kind) {
                        case 16: {
                            Iiop.jj_consume_token(16);
                            continue block37;
                        }
                        case 18: {
                            Iiop.jj_consume_token(18);
                            continue block37;
                        }
                        case 22: {
                            Iiop.jj_consume_token(22);
                            continue block37;
                        }
                        case 21: {
                            Iiop.jj_consume_token(21);
                            continue block37;
                        }
                        case 13: {
                            Iiop.jj_consume_token(13);
                            continue block37;
                        }
                    }
                    break;
                }
                Iiop.jj_la1[31] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                block38: while (true) {
                    switch (Iiop.jj_nt.kind) {
                        case 16: {
                            Iiop.jj_consume_token(16);
                            break;
                        }
                        case 18: {
                            Iiop.jj_consume_token(18);
                            break;
                        }
                        case 22: {
                            Iiop.jj_consume_token(22);
                            break;
                        }
                        case 21: {
                            Iiop.jj_consume_token(21);
                            break;
                        }
                        case 13: {
                            Iiop.jj_consume_token(13);
                            break;
                        }
                        default: {
                            Iiop.jj_la1[32] = jj_gen;
                            Iiop.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (Iiop.jj_nt.kind) {
                        case 13: 
                        case 16: 
                        case 18: 
                        case 21: 
                        case 22: {
                            continue block38;
                        }
                    }
                    break;
                }
                Iiop.jj_la1[33] = jj_gen;
                block39: while (true) {
                    switch (Iiop.jj_nt.kind) {
                        case 12: {
                            break;
                        }
                        default: {
                            Iiop.jj_la1[34] = jj_gen;
                            break block0;
                        }
                    }
                    Iiop.jj_consume_token(12);
                    block40: while (true) {
                        switch (Iiop.jj_nt.kind) {
                            case 13: 
                            case 16: 
                            case 18: 
                            case 21: 
                            case 22: {
                                break;
                            }
                            default: {
                                Iiop.jj_la1[35] = jj_gen;
                                continue block39;
                            }
                        }
                        switch (Iiop.jj_nt.kind) {
                            case 16: {
                                Iiop.jj_consume_token(16);
                                continue block40;
                            }
                            case 18: {
                                Iiop.jj_consume_token(18);
                                continue block40;
                            }
                            case 22: {
                                Iiop.jj_consume_token(22);
                                continue block40;
                            }
                            case 21: {
                                Iiop.jj_consume_token(21);
                                continue block40;
                            }
                            case 13: {
                                Iiop.jj_consume_token(13);
                                continue block40;
                            }
                        }
                        break;
                    }
                    break;
                }
                Iiop.jj_la1[36] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                Iiop.jj_la1[37] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void idloc() throws ParseException {
        switch (Iiop.jj_nt.kind) {
            case 16: {
                Token token2 = Iiop.jj_consume_token(16);
                if (nm == null) break;
                Iiop.nm[Iiop.count].id = Iiop.nm[Iiop.count].id.concat(token2.image);
                break;
            }
            case 18: {
                Token token3 = Iiop.jj_consume_token(18);
                if (nm == null) break;
                Iiop.nm[Iiop.count].id = Iiop.nm[Iiop.count].id.concat(token3.image);
                break;
            }
            case 19: {
                Token token4 = Iiop.jj_consume_token(19);
                if (nm == null) break;
                Iiop.nm[Iiop.count].id = Iiop.nm[Iiop.count].id.concat(token4.image);
                break;
            }
            case 22: {
                Token token5 = Iiop.jj_consume_token(22);
                if (nm == null) break;
                Iiop.nm[Iiop.count].id = Iiop.nm[Iiop.count].id.concat(token5.image);
                break;
            }
            case 13: {
                Token token6 = Iiop.jj_consume_token(13);
                if (nm == null) break;
                Iiop.nm[Iiop.count].id = Iiop.nm[Iiop.count].id.concat(token6.image);
                break;
            }
            default: {
                Iiop.jj_la1[38] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void kindloc() throws ParseException {
        switch (Iiop.jj_nt.kind) {
            case 16: {
                Token token2 = Iiop.jj_consume_token(16);
                if (nm == null) break;
                Iiop.nm[Iiop.count].kind = Iiop.nm[Iiop.count].kind.concat(token2.image);
                break;
            }
            case 18: {
                Token token3 = Iiop.jj_consume_token(18);
                if (nm == null) break;
                Iiop.nm[Iiop.count].kind = Iiop.nm[Iiop.count].kind.concat(token3.image);
                break;
            }
            case 19: {
                Token token4 = Iiop.jj_consume_token(19);
                if (nm == null) break;
                Iiop.nm[Iiop.count].kind = Iiop.nm[Iiop.count].kind.concat(token4.image);
                break;
            }
            case 22: {
                Token token5 = Iiop.jj_consume_token(22);
                if (nm == null) break;
                Iiop.nm[Iiop.count].kind = Iiop.nm[Iiop.count].kind.concat(token5.image);
                break;
            }
            case 13: {
                Token token6 = Iiop.jj_consume_token(13);
                if (nm == null) break;
                Iiop.nm[Iiop.count].kind = Iiop.nm[Iiop.count].kind.concat(token6.image);
                break;
            }
            default: {
                Iiop.jj_la1[39] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void nam() throws ParseException {
        switch (Iiop.jj_nt.kind) {
            case 16: {
                Iiop.jj_consume_token(16);
                break;
            }
            case 18: {
                Iiop.jj_consume_token(18);
                break;
            }
            case 21: {
                Iiop.jj_consume_token(21);
                break;
            }
            case 22: {
                Iiop.jj_consume_token(22);
                break;
            }
            case 13: {
                Iiop.jj_consume_token(13);
                break;
            }
            case 20: {
                Iiop.jj_consume_token(20);
                break;
            }
            case 10: {
                Iiop.jj_consume_token(10);
                break;
            }
            case 9: {
                Iiop.jj_consume_token(9);
                break;
            }
            default: {
                Iiop.jj_la1[40] = jj_gen;
                Iiop.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public Iiop(InputStream stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        token_source = new IiopTokenManager(jj_input_stream);
        token = new Token();
        Iiop.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            Iiop.jj_la1[i] = -1;
        }
    }

    public static void ReInit(InputStream stream) {
        ASCII_CharStream.ReInit(stream, 1, 1);
        IiopTokenManager.ReInit(jj_input_stream);
        token = new Token();
        Iiop.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            Iiop.jj_la1[i] = -1;
        }
    }

    public Iiop(Reader stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        token_source = new IiopTokenManager(jj_input_stream);
        token = new Token();
        Iiop.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            Iiop.jj_la1[i] = -1;
        }
    }

    public static void ReInit(Reader stream) {
        ASCII_CharStream.ReInit(stream, 1, 1);
        IiopTokenManager.ReInit(jj_input_stream);
        token = new Token();
        Iiop.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            Iiop.jj_la1[i] = -1;
        }
    }

    public Iiop(IiopTokenManager tm) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        Iiop.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            Iiop.jj_la1[i] = -1;
        }
    }

    public void ReInit(IiopTokenManager tm) {
        token_source = tm;
        token = new Token();
        Iiop.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            Iiop.jj_la1[i] = -1;
        }
    }

    private static final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = jj_nt;
        jj_nt = Iiop.token.next != null ? Iiop.jj_nt.next : (Iiop.jj_nt.next = token_source.getNextToken());
        if (Iiop.token.kind == kind) {
            ++jj_gen;
            return token;
        }
        jj_nt = token;
        token = oldToken;
        jj_kind = kind;
        throw Iiop.generateParseException();
    }

    public static final Token getNextToken() {
        token = jj_nt;
        jj_nt = Iiop.token.next != null ? Iiop.jj_nt.next : (Iiop.jj_nt.next = token_source.getNextToken());
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = token_source.getNextToken());
        }
        return t;
    }

    public static final ParseException generateParseException() {
        int i;
        jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[23];
        for (i = 0; i < 23; ++i) {
            la1tokens[i] = false;
        }
        if (jj_kind >= 0) {
            la1tokens[Iiop.jj_kind] = true;
            jj_kind = -1;
        }
        for (i = 0; i < 41; ++i) {
            if (jj_la1[i] != jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 23; ++i) {
            if (!la1tokens[i]) continue;
            jj_expentry = new int[1];
            Iiop.jj_expentry[0] = i;
            jj_expentries.addElement(jj_expentry);
        }
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i2 = 0; i2 < jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])jj_expentries.elementAt(i2);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    static {
        jj_initialized_once = false;
        jj_la1 = new int[41];
        jj_la1_0 = new int[]{448, 448, 8, 6, 0x114000, 2048, 7681536, 2048, 560, 448, 16384, 512, 335872, 335872, 4096, 335872, 335872, 0x110000, 7677440, 7677440, 4096, 7677440, 7681536, 2048, 2048, 5054464, 5054464, 4096, 5054464, 5058560, 6627328, 6627328, 6627328, 6627328, 4096, 6627328, 6627328, 6631424, 5054464, 5054464, 7677440};
        jj_expentries = new Vector();
        jj_kind = -1;
    }

    public static class Holder {
        public static final byte IIOP = 0;
        public static final byte RIR = 1;
        private byte type;
        private String address;
        private String key;
        private int port;
        private String name;

        public Holder(byte t) {
            this.type = t;
        }

        public Holder(byte t, String a, int p) {
            this.type = t;
            this.address = a;
            this.port = p;
        }

        public byte getType() {
            return this.type;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        protected void setKey(String k) {
            this.key = k;
        }

        protected void setName(String n) {
            this.name = n;
        }

        public String toString() {
            return "Address is " + this.address + " and port is " + this.port + " and key is " + this.key + " and name is " + this.name + " and type is " + this.type;
        }
    }
}

