/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms;

import cerent.cms.idl.CMS.GeneralPOA;
import cerent.cms.idl.CMS.eTabId;
import cerent.cms.idl.CMS.sNetElement;
import cerent.cms.idl.CMS.sProxyClient;
import cerent.cms.idl.CMS.xBackgroundProcessingActive;
import cerent.cms.idl.CMS.xBadNeId;
import cerent.cms.idl.CMS.xBadShelfNumber;
import cerent.cms.idl.CMS.xBadSlotNumber;
import cerent.cms.idl.CMS.xBadTabId;
import cerent.cms.idl.CMS.xBadTabSpec;
import cerent.cms.idl.CMS.xIoException;
import cerent.cms.idl.CMS.xLoginError;
import cerent.cms.idl.CMS.xModalDialogShowing;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsSecurityException;
import cerent.cms.model.INodeModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractInvalidViewException;
import cerent.cms.ui.MainPanel;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.ViewName;
import cerent.util.SDebug;
import cerent.util.job.JobControllerFactory;
import cerent.util.orb.CtcIncarnationException;
import cerent.util.orb.OngORB;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.SckfwdClient;
import com.cisco.ctc.CtcApplication;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class CmsControlImpl
extends GeneralPOA {
    private static final String NORTHBOUND_POA_NAME = "NorthboundPOA";
    private static final xBadTabId badTabIdException = new xBadTabId("");
    private MainPanel mainPanel;
    private boolean loggedIn = false;
    private NetworkViewController nvc;
    private String userName;
    private String password;
    private Exception loginException;
    private String loginReason;
    private java.lang.Object loginLock = new java.lang.Object();
    private static final SDebug db = new SDebug("CmsControlImpl");

    public CmsControlImpl(MainPanel mainPanel) throws CtcIncarnationException {
        this.mainPanel = mainPanel;
        this.connectToORB();
    }

    public String getIor() {
        return OngORB.instance().object_to_string((Object)this._this());
    }

    private String getNodeName(INodeModel iNodeModel) {
        String string = null;
        try {
            string = iNodeModel.getName();
        }
        catch (Exception exception) {
            db.finer("Exception in getNodeName, node=" + iNodeModel + " " + exception);
        }
        if (string == null) {
            string = "???";
        }
        return string;
    }

    private String getNodeHostName(INodeModel iNodeModel) {
        String string;
        try {
            string = iNodeModel.getHostName();
        }
        catch (Exception exception) {
            string = "?.?.?.?";
        }
        return string;
    }

    private int getNodeId(INodeModel iNodeModel) {
        int n;
        try {
            n = iNodeModel.getNodeId();
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    private boolean getNodeState(INodeModel iNodeModel) {
        boolean bl;
        try {
            bl = iNodeModel.getConnectionState();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public sNetElement[] elements() {
        if (!this.loggedIn) {
            return new sNetElement[0];
        }
        try {
            Iterator iterator = Network.instance().getElements().iterator();
            LinkedList<sNetElement> linkedList = new LinkedList<sNetElement>();
            while (iterator.hasNext()) {
                INetElement iNetElement = (INetElement)iterator.next();
                INodeModel iNodeModel = iNetElement.getNodeModel();
                if (!iNodeModel.isLiteInited()) continue;
                linkedList.add(new sNetElement(this.getNodeName(iNodeModel), this.getNodeHostName(iNodeModel), this.getNodeId(iNodeModel), this.getNodeState(iNodeModel)));
            }
            return linkedList.toArray(new sNetElement[0]);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return new sNetElement[0];
        }
    }

    public int lastTopologyChangeTime() {
        int n;
        if (!this.loggedIn) {
            return 0;
        }
        try {
            n = (int)(this.getNvc().getConnectionStatusChangeTime() / 1000L);
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public void setProxyClients(String string, sProxyClient[] sProxyClientArray) throws xIoException {
        try {
            LinkedList<SckfwdClient> linkedList = new LinkedList<SckfwdClient>();
            for (int i = 0; i < sProxyClientArray.length; ++i) {
                sProxyClient sProxyClient2 = sProxyClientArray[i];
                linkedList.add(new SckfwdClient(sProxyClient2.host, sProxyClient2.maskLength, sProxyClient2.cost, sProxyClient2.flags));
            }
            CtcProxyFactory.setClients((String)string, linkedList);
        }
        catch (IOException iOException) {
            throw new xIoException(iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String string, String string2) throws xLoginError {
        String string3;
        if (db.on()) {
            db.println("login:" + string + "/" + string2);
        }
        java.lang.Object object = this;
        synchronized (object) {
            if (this.loggedIn) {
                throw new xLoginError("Already logged in");
            }
            this.loggedIn = true;
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            this.userName = string;
            this.password = string2;
            this.notifyAll();
        }
        object = this.loginLock;
        synchronized (object) {
            try {
                if (db.on()) {
                    db.println("login: wait on login lock");
                }
                this.loginLock.wait();
            }
            catch (InterruptedException interruptedException) {
                db.finest("InterruptedException in login() " + interruptedException);
            }
        }
        if (db.on()) {
            db.println("login: unblocked");
        }
        if ((string3 = this.loginException == null ? null : (this.loginException instanceof AbstractCmsSecurityException ? "User authentication error" : (this.loginException instanceof AbstractCmsIOException ? "Cms IO Exception" : this.loginException.toString()))) != null) {
            object = this;
            synchronized (object) {
                this.loggedIn = false;
            }
            throw new xLoginError(string3 + "/" + this.loginReason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() {
        String string = this.userName;
        while (string == null) {
            CmsControlImpl cmsControlImpl = this;
            synchronized (cmsControlImpl) {
                try {
                    this.wait();
                    string = this.userName;
                }
                catch (InterruptedException interruptedException) {
                    db.finest("InterruptedException in getUserName() " + interruptedException);
                }
            }
        }
        this.userName = null;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword() {
        String string = this.password;
        while (string == null) {
            CmsControlImpl cmsControlImpl = this;
            synchronized (cmsControlImpl) {
                try {
                    this.wait();
                    string = this.password;
                }
                catch (InterruptedException interruptedException) {
                    db.finest("InterruptedException in getPassword() " + interruptedException);
                }
            }
        }
        this.password = null;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginCompleted(Exception exception, String string) {
        this.loginException = exception;
        this.loginReason = string;
        java.lang.Object object = this.loginLock;
        synchronized (object) {
            this.loginLock.notifyAll();
        }
    }

    public void showNetworkView(eTabId eTabId2) throws xModalDialogShowing, xBadTabId {
        block2: {
            try {
                this.showNodeView(0, eTabId2);
            }
            catch (xBadNeId xBadNeId2) {
                if (!db.on()) break block2;
                db.println("Caught xBadNeId in showNetworkView for tabId " + eTabId2);
            }
        }
    }

    public void showNodeView(int n, eTabId eTabId2) throws xModalDialogShowing, xBadNeId, xBadTabId {
        block2: {
            try {
                this.showShelfView(n, (short)0, eTabId2);
            }
            catch (xBadShelfNumber xBadShelfNumber2) {
                if (!db.on()) break block2;
                db.println("Caught " + (java.lang.Object)((java.lang.Object)xBadShelfNumber2) + " in showShelfView for neId " + n + " tabId " + eTabId2);
            }
        }
    }

    public void showShelfView(int n, short s, eTabId eTabId2) throws xModalDialogShowing, xBadNeId, xBadShelfNumber, xBadTabId {
        block4: {
            try {
                this.showCardView(n, s, (short)0, eTabId2);
            }
            catch (xBadShelfNumber xBadShelfNumber2) {
                if (db.on()) {
                    db.println("Caught " + (java.lang.Object)((java.lang.Object)xBadShelfNumber2) + " in showShelfView for neId " + n + " tabId " + eTabId2);
                }
            }
            catch (xBadSlotNumber xBadSlotNumber2) {
                if (!db.on()) break block4;
                db.println("Caught " + (java.lang.Object)((java.lang.Object)xBadSlotNumber2) + " in showShelfView for neId " + n + " tabId " + eTabId2);
            }
        }
    }

    public void showCardView(int n, short s, short s2, eTabId eTabId2) throws xModalDialogShowing, xBadNeId, xBadShelfNumber, xBadSlotNumber, xBadTabId {
        this.jumpView(new ViewName(new int[]{n, s, s2, 0, 0, this.getTabId(eTabId2)}));
    }

    public void showTab(int n, short s, short s2, String[] stringArray) throws xBadNeId, xBadShelfNumber, xBadSlotNumber, xModalDialogShowing, xBadTabSpec {
        block6: {
            try {
                this.jumpView(new ViewName(new int[]{n, s, s2, 0, 0, 0}, stringArray));
            }
            catch (xBadShelfNumber xBadShelfNumber2) {
                if (db.on()) {
                    db.println("Caught " + (java.lang.Object)((java.lang.Object)xBadShelfNumber2) + " in showShelfView(" + Integer.toHexString(n) + ", " + s + ", " + s2 + ", " + stringArray + ")");
                }
            }
            catch (xBadSlotNumber xBadSlotNumber2) {
                if (db.on()) {
                    db.println("Caught " + (java.lang.Object)((java.lang.Object)xBadSlotNumber2) + " in showShelfView(" + Integer.toHexString(n) + ", " + s + ", " + s2 + ", " + stringArray + ")");
                }
            }
            catch (xBadTabId xBadTabId2) {
                if (!db.on()) break block6;
                db.println("Caught " + (java.lang.Object)((java.lang.Object)xBadTabId2) + " in showShelfView(" + Integer.toHexString(n) + ", " + s + ", " + s2 + ", " + stringArray + ")");
            }
        }
    }

    public String[][] getCurViewTabSpecs() {
        String[][] stringArray = this.getNvc().getCurTabHierarchy();
        return stringArray;
    }

    public void terminate(boolean bl) throws xBackgroundProcessingActive {
        if (!JobControllerFactory.isDisposable() && !bl) {
            throw new xBackgroundProcessingActive("");
        }
        try {
            CtcApplication.instance().exitCtc(false);
        }
        catch (Exception exception) {
            db.finer("Exception in terminate, force= " + bl + " " + exception);
        }
    }

    public void setWindowState(boolean bl, boolean bl2) {
        if (bl2) {
            CtcApplication.instance().fireIdleTimer();
        } else {
            CtcApplication.instance().unlockCtc();
        }
        if (bl) {
            this.mainPanel.setState(1);
        } else {
            this.mainPanel.setState(0);
        }
    }

    public String getWindowTitle() {
        return this.mainPanel.getTitle();
    }

    private void jumpView(ViewName viewName) throws xModalDialogShowing, xBadNeId, xBadShelfNumber, xBadSlotNumber, xBadTabId {
        if (!this.loggedIn) {
            throw new xBadNeId("Not logged in");
        }
        CtcApplication.instance().unlockCtc();
        if (UiToolkit.instance().isModalVisible()) {
            throw new xModalDialogShowing("");
        }
        if (db.on()) {
            db.println("jump to view " + viewName);
        }
        try {
            this.getNvc().jumpView(viewName, true);
            this.mainPanel.setState(0);
        }
        catch (AbstractInvalidViewException abstractInvalidViewException) {
            SDebug.printStackTrace((Throwable)abstractInvalidViewException);
            switch (abstractInvalidViewException.getCode()) {
                case 1: {
                    throw new xBadNeId(abstractInvalidViewException.getMessage());
                }
                case 2: {
                    throw new xBadShelfNumber(abstractInvalidViewException.getMessage());
                }
                case 3: {
                    throw new xBadSlotNumber(abstractInvalidViewException.getMessage());
                }
                case 6: {
                    throw new xBadTabId(abstractInvalidViewException.getMessage());
                }
            }
            if (db.on()) {
                db.println("CORBA/jumpView:" + (java.lang.Object)((java.lang.Object)abstractInvalidViewException));
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("CORBA/jumpView:" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private int getTabId(eTabId eTabId2) {
        int n = eTabId2.value();
        switch (n) {
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    private NetworkViewController getNvc() {
        if (this.nvc == null) {
            this.nvc = this.mainPanel.getNetworkViewController();
        }
        return this.nvc;
    }

    public POA _default_POA() {
        return this.getNorthboundPOA();
    }

    private void connectToORB() throws CtcIncarnationException {
        try {
            POA pOA = this.getNorthboundPOA();
            byte[] byArray = pOA.activate_object((Servant)this);
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            throw new CtcIncarnationException(servantAlreadyActive.toString());
        }
        catch (WrongPolicy wrongPolicy) {
            throw new CtcIncarnationException(wrongPolicy.toString());
        }
    }

    private void disconnectFromORB() throws CtcIncarnationException {
        try {
            POA pOA = this.getNorthboundPOA();
            pOA.deactivate_object(pOA.servant_to_id((Servant)this));
        }
        catch (ObjectNotActive objectNotActive) {
            throw new CtcIncarnationException(objectNotActive.toString());
        }
        catch (WrongPolicy wrongPolicy) {
            throw new CtcIncarnationException(wrongPolicy.toString());
        }
        catch (ServantNotActive servantNotActive) {
            throw new CtcIncarnationException(servantNotActive.toString());
        }
    }

    private POA getNorthboundPOA() {
        POA pOA;
        try {
            POA pOA2 = POAHelper.narrow((Object)OngORB.instance().resolve_initial_references("RootPOA"));
            pOA = pOA2.find_POA(NORTHBOUND_POA_NAME, false);
        }
        catch (InvalidName invalidName) {
            throw new CtcIncarnationException(invalidName.toString());
        }
        catch (AdapterNonExistent adapterNonExistent) {
            pOA = this.createNorthboundPOA();
        }
        return pOA;
    }

    private POA createNorthboundPOA() {
        POA pOA;
        try {
            POA pOA2 = POAHelper.narrow((Object)OngORB.instance().resolve_initial_references("RootPOA"));
            POAManager pOAManager = pOA2.the_POAManager();
            Policy[] policyArray = new Policy[]{pOA2.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID), pOA2.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID), pOA2.create_request_processing_policy(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY), pOA2.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN), pOA2.create_lifespan_policy(LifespanPolicyValue.TRANSIENT)};
            pOA = pOA2.create_POA(NORTHBOUND_POA_NAME, pOAManager, policyArray);
            pOAManager.activate();
        }
        catch (InvalidName invalidName) {
            throw new CtcIncarnationException(invalidName.toString());
        }
        catch (AdapterAlreadyExists adapterAlreadyExists) {
            throw new CtcIncarnationException(adapterAlreadyExists.toString());
        }
        catch (InvalidPolicy invalidPolicy) {
            throw new CtcIncarnationException(invalidPolicy.toString());
        }
        catch (AdapterInactive adapterInactive) {
            throw new CtcIncarnationException(adapterInactive.toString());
        }
        return pOA;
    }
}

