/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.ncp.CircuitMergeError;
import cerent.cms.ncp.CircuitMergeSplicer;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitMergeOperator;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NotFullyMerged;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CircuitMergeManager {
    public static final int STRICT_MERGE = 0;
    public static final int LOOSE_MERGE = 1;
    public static final int GENERAL_MERGE = 2;
    private static final SDebug db = new SDebug("CircuitMergeManager");
    private static CircuitMergeManager singleton;
    private static int UNINITIATED;
    private static int MERGING;
    private CircuitMergeSplicer splicer;
    private Map circuitsInMergeMap = new HashMap();
    private Map nodeOperatorMap = new HashMap();
    private Set involvedCircuits = new HashSet();
    private INetCircuit masterCircuit;
    private int operation;
    private int state = UNINITIATED;

    private CircuitMergeManager() {
    }

    public static synchronized CircuitMergeManager instance() {
        if (singleton == null) {
            singleton = new CircuitMergeManager();
        }
        return singleton;
    }

    public CircuitMergeSplicer getSplicer() {
        return this.splicer;
    }

    private void validateCircuitsForMerge() throws CircuitMergeError {
        if (!this.inMerging()) {
            throw new IllegalStateException("init() has not been called");
        }
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitMergeOperator)iterator.next()).validateForMerge();
        }
    }

    public void init(List list, int n) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("No circuit is selected to merge");
        }
        if (this.inMerging()) {
            throw new IllegalStateException("Another merge operation is still processing.");
        }
        if (db.on()) {
            db.fine("Start to merge " + list.size() + " circuits. " + "operation = " + n);
        }
        try {
            this.splicer = new CircuitMergeSplicer();
            this.operation = n;
            this.state = MERGING;
            if (n == 0 || n == 1) {
                this.masterCircuit = (INetCircuit)list.get(0);
            }
            this.circuitsInMergeMap.clear();
            this.nodeOperatorMap.clear();
            this.involvedCircuits.clear();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
                this.involvedCircuits.add(netCcatCircuit);
                NetCircuitMergeOperator netCircuitMergeOperator = new NetCircuitMergeOperator(netCcatCircuit, n);
                this.circuitsInMergeMap.put(netCcatCircuit, netCircuitMergeOperator);
                Iterator iterator2 = netCcatCircuit.getCircuitNodes().iterator();
                while (iterator2.hasNext()) {
                    this.nodeOperatorMap.put(iterator2.next(), netCircuitMergeOperator);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            SDebug.printStackTrace((Throwable)runtimeException);
            this.dispose();
            throw runtimeException;
        }
    }

    private synchronized void dispose() {
        this.state = UNINITIATED;
        this.splicer.dispose();
        this.splicer = null;
        this.masterCircuit = null;
        Iterator iterator = this.circuitsInMergeMap.keySet().iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            if (netCcatCircuit == null) continue;
            netCcatCircuit.setInCircuitMerge(false);
        }
        this.circuitsInMergeMap.clear();
        this.nodeOperatorMap.clear();
        this.involvedCircuits.clear();
    }

    public boolean inMerging() {
        return this.state != UNINITIATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeResult mergeCircuits() throws CircuitMergeError {
        if (!this.inMerging()) {
            throw new IllegalStateException("init() has not been called");
        }
        try {
            Object object;
            this.validateCircuitsForMerge();
            this.prepareMerge();
            this.startMerge();
            this.finalizeMerge();
            this.cleanup();
            MergeResult mergeResult = new MergeResult();
            mergeResult.addedCircuitNum = this.involvedCircuits.size() - this.circuitsInMergeMap.size();
            Object object2 = this.circuitsInMergeMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                NetCcatCircuit netCcatCircuit = (NetCcatCircuit)object.getKey();
                NetCircuitMergeOperator netCircuitMergeOperator = (NetCircuitMergeOperator)object.getValue();
                if (netCcatCircuit == null || !netCcatCircuit.isCircuitRefValid()) {
                    ++mergeResult.deletedCircuitNum;
                    continue;
                }
                if (!netCircuitMergeOperator.changed()) continue;
                ++mergeResult.changedCircuitNum;
            }
            if (db.on()) {
                db.println("involvedCircuits size=" + this.involvedCircuits.size());
            }
            object2 = this.involvedCircuits.iterator();
            while (object2.hasNext()) {
                object = (INetCircuit)((Object)object2.next());
                if (object == null || !object.isCircuitRefValid()) continue;
                if (db.on()) {
                    db.fine("add circuit: " + object.getCircuitName());
                }
                mergeResult.validCircuitsAfterMerge.add(object);
            }
            if (db.on()) {
                db.println("result=" + mergeResult);
            }
            object2 = mergeResult;
            return object2;
        }
        finally {
            this.dispose();
        }
    }

    private void prepareMerge() {
        if (db.on()) {
            db.fine("prepareMerge started");
        }
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitMergeOperator)iterator.next()).prepareMerge();
        }
    }

    private void startMerge() {
        if (db.on()) {
            db.fine("startMerge started");
        }
        this.splicer.startSplice();
    }

    private void finalizeMerge() throws CircuitMergeError {
        Object object;
        boolean bl;
        if (db.on()) {
            db.fine("finalizeMerge started");
        }
        NetCircuitMergeOperator netCircuitMergeOperator = null;
        if (this.operation == 0 || this.operation == 1) {
            netCircuitMergeOperator = this.getMergeOperator(this.masterCircuit);
            if (this.circuitsInMergeMap.size() > 1 && netCircuitMergeOperator.getNodeNumInAllDisjointParts() <= netCircuitMergeOperator.getCircuitNodeNumBeforeMerge()) {
                this.rollbackAllOperations();
                throw new CircuitMergeError("No cross-connect from the selected circuit" + (this.circuitsInMergeMap.size() > 2 ? "(s)" : "") + " can be merged into the current circuit.");
            }
            boolean bl2 = bl = netCircuitMergeOperator.getDisjointPartsNum() == 1 && netCircuitMergeOperator.canBeCompleted();
            if (this.operation == 0) {
                if (db.on()) {
                    db.println("# disjoint parts = " + this.getTotalDisjointPartsNum());
                }
                object = "The selected circuit" + (this.circuitsInMergeMap.size() > 2 ? "(s)" : "") + " cannot be merged into the current circuit (\"<" + this.getMasterCircuit().getCircuitName() + ">\").";
                if (!bl) {
                    this.rollbackAllOperations();
                    throw new CircuitMergeError((String)object);
                }
                if (this.getTotalDisjointPartsNum() != 1) {
                    this.rollbackAllOperations();
                    throw new NotFullyMerged((String)object);
                }
            } else if (!bl) {
                this.rollbackAllOperations();
                throw new CircuitMergeError("Merging in the selected circuit connections cannot make the current circuit (\"<" + this.getMasterCircuit().getCircuitName() + ">\") DISCOVERED.");
            }
        }
        bl = true;
        if (netCircuitMergeOperator != null) {
            bl &= netCircuitMergeOperator.finalizeMerge();
        }
        object = this.circuitsInMergeMap.values().iterator();
        while (object.hasNext()) {
            NetCircuitMergeOperator netCircuitMergeOperator2 = (NetCircuitMergeOperator)object.next();
            if (netCircuitMergeOperator2 == netCircuitMergeOperator) continue;
            bl &= netCircuitMergeOperator2.finalizeMerge();
        }
    }

    private void cleanup() {
        if (db.on()) {
            db.fine("cleanup started");
        }
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitMergeOperator)iterator.next()).cleanup();
        }
    }

    private void rollbackAllOperations() {
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitMergeOperator)iterator.next()).reloadWholeCircuit();
        }
    }

    private int getTotalDisjointPartsNum() {
        int n = 0;
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            n += ((NetCircuitMergeOperator)iterator.next()).getDisjointPartsNum();
        }
        return n;
    }

    private boolean canAllCircuitsBeCompleted() {
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            if (((NetCircuitMergeOperator)iterator.next()).canBeCompleted()) continue;
            return false;
        }
        return true;
    }

    public INetCircuit getMasterCircuit() {
        return this.masterCircuit;
    }

    public NetCircuitMergeOperator getMergeOperator(INetCircuit iNetCircuit) {
        return (NetCircuitMergeOperator)this.circuitsInMergeMap.get(iNetCircuit);
    }

    public static boolean isCktInMerge(INetCircuit iNetCircuit) {
        if (db.on()) {
            db.println("isCktInMerge called for circuit <" + iNetCircuit.getCircuitName() + ">");
        }
        return CircuitMergeManager.instance().inMerging() && CircuitMergeManager.instance().getMergeOperator(iNetCircuit) != null;
    }

    private static boolean isValidForMerge(INetCircuit iNetCircuit) {
        try {
            NetCircuitMergeOperator.validateForMerge(iNetCircuit);
            return true;
        }
        catch (CircuitMergeError circuitMergeError) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)circuitMergeError);
            }
            return false;
        }
    }

    public void addNewCreatedCircuit(INetCircuit iNetCircuit) {
        this.involvedCircuits.add(iNetCircuit);
    }

    public NetCircuitMergeOperator findOperatorBeforeMerge(NetCircuitNode netCircuitNode) {
        return (NetCircuitMergeOperator)this.nodeOperatorMap.get(netCircuitNode);
    }

    public static boolean qualifyForMergeMaster(INetCircuit iNetCircuit) {
        return CircuitMergeManager.isValidForMerge(iNetCircuit);
    }

    static {
        UNINITIATED = 0;
        MERGING = 1;
    }

    public class MergeResult {
        public int changedCircuitNum = 0;
        public int deletedCircuitNum = 0;
        public int addedCircuitNum = 0;
        public List validCircuitsAfterMerge = new ArrayList();

        public String toString() {
            return "[" + this.changedCircuitNum + "," + this.deletedCircuitNum + "," + this.addedCircuitNum + "," + this.validCircuitsAfterMerge.size() + "]";
        }
    }
}

