/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeOpticsTopologyModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPpmModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IServiceState;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchccCircuitNode;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OchTrailHelper {
    private static final SDebug db = new SDebug("OchTrailHelper");
    private static final int EQ_Rw = 120;
    private static final int EQ_RwP = 121;
    private static final int EQ_Be = 183;
    private static final int EQ_BeP = 184;
    private static final int EQ_SkT = 118;
    private static final int EQ_SkM = 119;
    private static final int EQ_MvT = 181;
    private static final int EQ_MvM = 182;
    private static final int EQ_BaT = 181;
    private static final int EQ_BaM = 182;
    private static final int EQ_MaT = 181;
    private static final int EQ_MaM = 182;
    private static final int EQ_AdM = 243;
    private static final int EQ_Ma = 11;
    private static final int EQ_Cop = 60;
    private static final int EQ_Hum = 219;
    public static final Map interOperabilityMap = new HashMap();
    public static final int MAPPING_NOTUSED = 0;
    public static final int MAPPING_ASYNCH = 1;
    public static final int MAPPING_SYNCH = 2;
    public static final int MAPPING_ODU_MUX = 3;

    public static List filterNodeForOchTrail(CircuitCreatInfo circuitCreatInfo, INetCircuit iNetCircuit, INodeModel iNodeModel) {
        StringBuffer stringBuffer;
        LinkedList<StringBuffer> linkedList = new LinkedList<StringBuffer>();
        if (db.on()) {
            db.println("filterNodeForOchTrail: " + iNodeModel);
        }
        CircuitCreatInfo.ProtectionInfo protectionInfo = circuitCreatInfo.getProtectionInfo();
        CircuitCreatInfo.TrunkInfo trunkInfo = circuitCreatInfo.getTrunkInfo();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (iEntityTableModel == null) {
            return linkedList;
        }
        int[] nArray = new int[]{};
        OchccCircuitSize ochccCircuitSize = OchccCircuitSize.fromInt(circuitCreatInfo.specificSize(), iNodeModel.getFramingType());
        if (db.on()) {
            db.println("Using och trail size " + ochccCircuitSize);
        }
        if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
            block19: {
                try {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailEntitiesForOchcc(circuitCreatInfo.cktOptChannel(), OchTrailHelper.getEqTypeForSize(ochccCircuitSize));
                }
                catch (AlreadyInUse alreadyInUse) {
                    if (db.on()) {
                        db.println("Channel/size already in use for OCHCC.");
                        SDebug.printStackTrace((Throwable)alreadyInUse);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block19;
                    db.println("Cannot get avail entities for OCHCC.");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (db.on()) {
                stringBuffer = new StringBuffer();
                for (int i = 0; i < nArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(Integer.toHexString(nArray[i]));
                }
                db.println("Called getAvailEntitiesForOchcc(" + circuitCreatInfo.cktOptChannel() + "," + OchTrailHelper.getEqTypeForSize(ochccCircuitSize) + "): [" + stringBuffer + "]");
            }
        } else if (db.on()) {
            db.println("Node does not provide OCH_TRAIL feature");
        }
        for (int i = 0; i < nArray.length; ++i) {
            block20: {
                int n = nArray[i];
                try {
                    stringBuffer = iEntityTableModel.getEntityModelByIndex(n);
                    if (!db.on()) break block20;
                    db.println("Found available entity [" + Integer.toHexString(n) + "] " + stringBuffer);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) continue;
                    db.println("Cannot get entity " + Integer.toHexString(n));
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    continue;
                }
            }
            IModuleModel iModuleModel = stringBuffer.getModuleModel();
            int n = stringBuffer.getEqType();
            int n2 = iModuleModel.getEqType();
            if (db.on()) {
                db.println("Starting filtering for module " + iModuleModel + " [ " + n2 + "]");
            }
            try {
                if (protectionInfo != null && !OchTrailHelper.filterProtection(protectionInfo, n2) || trunkInfo != null && !OchTrailHelper.filterTrunk(trunkInfo, iNodeModel, iModuleModel, n2, (IEntityModel)stringBuffer, n) || iNetCircuit != null && !OchTrailHelper.filterInterOperability(iNetCircuit, ochccCircuitSize, iModuleModel, n2, (IEntityModel)stringBuffer, n)) continue;
                linkedList.add(stringBuffer);
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("OCHCC filtering failure: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return linkedList;
    }

    public static boolean filterProtection(CircuitCreatInfo.ProtectionInfo protectionInfo, int n) {
        boolean bl = false;
        if (db.on()) {
            db.println("Filtering protection info: " + protectionInfo.toString());
        }
        if (protectionInfo.isProtected()) {
            if (OchTrailHelper.isProtected(n)) {
                bl = true;
            }
        } else if (!OchTrailHelper.isProtected(n)) {
            bl = true;
        }
        if (db.on()) {
            db.println("Filter result: " + bl);
        }
        return bl;
    }

    public static boolean filterTrunk(CircuitCreatInfo.TrunkInfo trunkInfo, INodeModel iNodeModel, IModuleModel iModuleModel, int n, IEntityModel iEntityModel, int n2) {
        boolean bl;
        block28: {
            bl = false;
            if (db.on()) {
                db.println("Filtering trunk info: " + trunkInfo.toString());
            }
            if (!OchTrailHelper.isClientPort(n2)) {
                if (db.on()) {
                    db.println("Filtering applies only to client ports");
                }
                bl = true;
            } else if (!OchTrailHelper.isMxpCard(n)) {
                if (db.on()) {
                    db.println("Filtering applies only to MxP cards");
                }
                bl = true;
            } else if (trunkInfo.isG709() && iModuleModel instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel).supportsOTN()) {
                if (db.on()) {
                    db.println("Filtering can not be applied to cards not supporting OTN if G709 is enabled");
                }
            } else {
                boolean bl2 = false;
                try {
                    IEntityModel[] iEntityModelArray = OchTrailHelper.getTrunkPorts(iNodeModel, iEntityModel.getEntityIndex());
                    bl2 = OchTrailHelper.isTrunkInUse(iEntityModelArray[0]);
                    if (bl2) {
                        IEntityModel iEntityModel2 = iEntityModelArray[0];
                        try {
                            if (trunkInfo.isG709()) {
                                if (!OchTrailHelper.isLineCard(n)) {
                                    CircuitCreatInfo.TrunkInfo trunkInfo2 = OchTrailHelper.getTrunkAttrs(iEntityModel2);
                                    if (db.on()) {
                                        db.println("Found trunk port: " + iEntityModel2);
                                        db.println("My trunk info: " + trunkInfo2);
                                    }
                                    if (OchTrailHelper.areFECEquivalent(iModuleModel, trunkInfo2.getFecMode(), iModuleModel, trunkInfo.getFecMode()) && trunkInfo2.getSdBer() == trunkInfo.getSdBer() && OchTrailHelper.areMappingEquivalent(trunkInfo2.getMappingType(), trunkInfo.getMappingType())) {
                                        bl = true;
                                    }
                                } else if (db.on()) {
                                    db.println("Line card skipped: OTN required");
                                }
                                break block28;
                            }
                            if (!OchTrailHelper.isLineCard(n)) {
                                IPortModel iPortModel = (IPortModel)iEntityModel2;
                                IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iPortModel.getInterfaceModel();
                                if (db.on()) {
                                    db.println("Found trunk port: " + iEntityModel2);
                                    db.println("isG709 = " + iDwdmTrkLineModel.getOTNStatus());
                                }
                                if (!iDwdmTrkLineModel.getOTNStatus()) {
                                    bl = true;
                                }
                                break block28;
                            }
                            if (db.on()) {
                                db.println("Line card has no OTN: accepted");
                            }
                            bl = true;
                        }
                        catch (Exception exception) {
                            if (db.on()) {
                                db.println("Cannot check trunk attributes: " + exception.getMessage());
                                SDebug.printStackTrace((Throwable)exception);
                            }
                            break block28;
                        }
                    }
                    if (db.on()) {
                        db.println("Filtering applies only to already in use trunks");
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    if (!db.on()) break block28;
                    db.println("Cannot get trunks: " + exception.getMessage());
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (db.on()) {
            db.println("Filter result: " + bl);
        }
        return bl;
    }

    public static boolean checkTrunkAttrs(IModuleModel iModuleModel, CircuitCreatInfo.TrunkInfo trunkInfo, IModuleModel iModuleModel2, CircuitCreatInfo.TrunkInfo trunkInfo2) {
        boolean bl = false;
        if (db.on()) {
            db.println("checkTrunkAttrs:\n" + trunkInfo + "\n" + trunkInfo2);
        }
        bl = OchTrailHelper.areG709Equivalent(iModuleModel, trunkInfo.isG709(), iModuleModel2, trunkInfo2.isG709()) ? OchTrailHelper.areFECEquivalent(iModuleModel, trunkInfo.getFecMode(), iModuleModel2, trunkInfo2.getFecMode()) && trunkInfo.getSdBer() == trunkInfo2.getSdBer() && OchTrailHelper.areMappingEquivalent(trunkInfo.getMappingType(), trunkInfo2.getMappingType()) : false;
        if (db.on()) {
            db.println("Check result: " + bl);
        }
        return bl;
    }

    public static boolean checkProtectionAttrs(CircuitCreatInfo.ProtectionInfo protectionInfo, CircuitCreatInfo.ProtectionInfo protectionInfo2) {
        boolean bl = false;
        if (db.on()) {
            db.println("checkProtectionAttrs:\n" + protectionInfo + "\n" + protectionInfo2);
        }
        if (protectionInfo.isProtected() == protectionInfo2.isProtected()) {
            if (protectionInfo.isProtected()) {
                IRevertiveBehavior iRevertiveBehavior = protectionInfo.getRevertiveBehavior();
                IRevertiveBehavior iRevertiveBehavior2 = protectionInfo2.getRevertiveBehavior();
                bl = iRevertiveBehavior != null ? iRevertiveBehavior.equals(iRevertiveBehavior2) : iRevertiveBehavior2 == null;
            } else {
                bl = true;
            }
        } else {
            bl = false;
        }
        if (db.on()) {
            db.println("Check result: " + bl);
        }
        return bl;
    }

    public static boolean checkInteroperability(OchccCircuitSize ochccCircuitSize, IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        boolean bl = false;
        if (db.on()) {
            db.println("checkInteroperability(" + ochccCircuitSize + ", " + iEntityModel + ", " + iEntityModel2);
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        int n = iModuleModel.getEqType();
        IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
        int n2 = iModuleModel2.getEqType();
        if (db.on()) {
            db.println("Filtering interoperability with : (" + iModuleModel + ", " + n + ") and (" + iModuleModel2 + ", " + n2 + ")");
        }
        if (n == n2) {
            if (db.on()) {
                db.println("Same card type always compatible");
            }
            bl = true;
        } else {
            Map map = (Map)interOperabilityMap.get(ochccCircuitSize);
            int[] nArray = (int[])map.get(new Integer(n));
            if (db.on()) {
                db.println("Interoperability matrix found for module A:\n" + OchTrailHelper.dumpArray(nArray));
            }
            for (int i = 0; !bl && nArray != null && i < nArray.length; ++i) {
                if (nArray[i] != n2) continue;
                bl = true;
            }
        }
        if (db.on()) {
            db.println("Check result: " + bl);
        }
        return bl;
    }

    public static boolean filterInterOperability(INetCircuit iNetCircuit, OchccCircuitSize ochccCircuitSize, IModuleModel iModuleModel, int n, IEntityModel iEntityModel, int n2) {
        boolean bl;
        block19: {
            bl = false;
            INetCircuitEnd iNetCircuitEnd = iNetCircuit.getPrimarySource();
            if (iNetCircuitEnd.getEntityIndex() == 0) {
                if (OchTrailHelper.isLineCard(n)) {
                    OchccCircuitSize ochccCircuitSize2 = OchccCircuitSize.fromInt(n2, iNetCircuitEnd.getNetElement().getFramingType());
                    boolean bl2 = bl = ochccCircuitSize2 == ochccCircuitSize;
                    if (db.on()) {
                        db.println("Found entity index = 0; comparing tmp size " + ochccCircuitSize2 + " and cktSize " + ochccCircuitSize + ": " + bl);
                    }
                }
            } else if (!OchTrailHelper.isLineCard(n)) {
                try {
                    int n3;
                    int[] nArray;
                    Object object;
                    IEntityModel iEntityModel2 = iNetCircuitEnd.getEntityModel();
                    IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
                    int n4 = iModuleModel2.getEqType();
                    if (db.on()) {
                        db.println("Filtering interoperability with source: " + iModuleModel2 + " [ " + n4 + "]");
                    }
                    if (n4 == n) {
                        if (db.on()) {
                            db.println("Same card type always compatible");
                        }
                        bl = true;
                    } else {
                        object = (Map)interOperabilityMap.get(ochccCircuitSize);
                        nArray = (int[])object.get(new Integer(n4));
                        if (db.on()) {
                            db.println("Interoperability matrix found for source module:\n" + OchTrailHelper.dumpArray(nArray));
                        }
                        for (n3 = 0; !bl && nArray != null && n3 < nArray.length; ++n3) {
                            if (nArray[n3] != n) continue;
                            bl = true;
                        }
                    }
                    if (bl && OchTrailHelper.isMxpCard(n) && OchTrailHelper.isMxpCard(n4)) {
                        object = ((IPortModel)iEntityModel).getPortNum();
                        if (((Object)object).length == (nArray = ((IPortModel)iEntityModel2).getPortNum()).length) {
                            for (n3 = 0; bl && n3 < ((Object)object).length; ++n3) {
                                boolean bl3 = bl = object[n3] == nArray[n3];
                                if (bl || !db.on()) continue;
                                db.println("Found different client ports at index " + n3 + ": " + (int)object[n3] + " != " + nArray[n3]);
                            }
                        } else {
                            if (db.on()) {
                                db.println("Found different length of client ports: " + ((Object)object).length + " != " + nArray.length);
                            }
                            bl = false;
                        }
                    }
                }
                catch (ObjNotFound objNotFound) {
                    if (!db.on()) break block19;
                    db.println("Cannot check interoperability: " + objNotFound.getMessage());
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
        }
        if (db.on()) {
            db.println("Filter result: " + bl);
        }
        return bl;
    }

    public static boolean isWorkingPort(INodeModel iNodeModel, int n) {
        boolean bl;
        block4: {
            bl = false;
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            try {
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                if (OchTrailHelper.isTrunkPort(iEntityModel.getEqType())) {
                    bl = OchTrailHelper.isWorkingPort(iEntityModel);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("isWorkingPort(" + iNodeModel + ", " + n + ") - Cannot get entity model : " + exception.getMessage());
            }
        }
        if (db.on()) {
            db.println("isWorkingPort(" + iNodeModel + ", " + n + "):  " + bl);
        }
        return bl;
    }

    public static boolean isWorkingPort(IEntityModel iEntityModel) {
        boolean bl = false;
        if (iEntityModel instanceof IDwdmPortModel) {
            IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
            IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iDwdmPortModel.getInterfaceModel();
            bl = iDwdmTrkLineModel.isWorkingLine();
        }
        if (db.on()) {
            db.println("isWorkingPort(" + iEntityModel + "):  " + bl);
        }
        return bl;
    }

    public static boolean isActivePort(INodeModel iNodeModel, int n) {
        try {
            return OchTrailHelper.isActivePort(iNodeModel.getEntityTable().getEntityModelByIndex(n));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return false;
        }
    }

    public static boolean isActivePort(IEntityModel iEntityModel) {
        boolean bl;
        block6: {
            bl = false;
            if (iEntityModel instanceof IDwdmPortModel) {
                IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
                IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iDwdmPortModel.getInterfaceModel();
                try {
                    bl = iDwdmTrkLineModel.isCurrentlyActive();
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("Cannot state if " + iDwdmTrkLineModel + " is active: " + noSuchInterface.getMessage());
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block6;
                    db.println("Cannot state if " + iDwdmTrkLineModel + " is active: " + wrongInterfaceType.getMessage());
                }
            }
        }
        if (db.on()) {
            db.println("isActivePort(" + iEntityModel + "):  " + bl);
        }
        return bl;
    }

    public static IEntityModel getWorkingTrunk(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        if (db.on()) {
            db.println("getWorkingTrunk(" + iEntityModel);
        }
        IEntityModel iEntityModel2 = null;
        if (OchTrailHelper.isTrunkPort(iEntityModel.getEqType())) {
            if (OchTrailHelper.isWorkingPort(iEntityModel)) {
                iEntityModel2 = iEntityModel;
            }
        } else {
            IEntityModel[] iEntityModelArray = OchTrailHelper.getTrunkPorts(iEntityModel);
            if (iEntityModelArray.length == 1) {
                iEntityModel2 = iEntityModelArray[0];
            } else {
                for (int i = 0; iEntityModel2 == null && i < iEntityModelArray.length; ++i) {
                    if (!OchTrailHelper.isWorkingPort(iEntityModelArray[i])) continue;
                    iEntityModel2 = iEntityModelArray[i];
                }
            }
        }
        if (db.on()) {
            db.println("getWorkingTrunk() return " + iEntityModel2);
        }
        return iEntityModel2;
    }

    public static IEntityModel[] getTrunkPorts(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        if (OchTrailHelper.isTrunkPort(iEntityModel.getEqType())) {
            return new IEntityModel[]{iEntityModel};
        }
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        return OchTrailHelper.getTrunkPorts(iNodeModel, iEntityModel.getEntityIndex());
    }

    public static IEntityModel getOtherTrunkPort(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        IEntityModel[] iEntityModelArray;
        IEntityModel iEntityModel2 = null;
        IEntityModel[] iEntityModelArray2 = OchTrailHelper.getClientPorts(iEntityModel);
        if (iEntityModelArray2.length != 0 && (iEntityModelArray = OchTrailHelper.getTrunkPorts(iEntityModelArray2[0])).length == 2) {
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                if (iEntityModelArray[i].getEntityIndex() == iEntityModel.getEntityIndex()) continue;
                iEntityModel2 = iEntityModelArray[i];
                break;
            }
        }
        return iEntityModel2;
    }

    public static IEntityModel[] getTrunkPorts(INodeModel iNodeModel, int n) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        Object object;
        if (db.on()) {
            db.println("Finding trunk ports for client " + n + ", node " + iNodeModel);
        }
        IEntityModel[] iEntityModelArray = new IEntityModel[]{};
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
            IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
            if (OchTrailHelper.isLineCard(iEntityModel.getModuleModel().getEqType())) {
                object = new int[]{n};
                iEntityModelArray = new IEntityModel[]{iEntityModel};
            } else {
                object = iNodeModel.getINodeOpticsTopologyModel().getOchTrailTrunkPort(n);
                iEntityModelArray = new IEntityModel[((Object)object).length];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    iEntityModelArray[i] = iEntityTableModel.getEntityModelByIndex((int)object[i]);
                }
            }
            if (iEntityModelArray.length == 2 && OchTrailHelper.isWorkingPort(iEntityModelArray[1])) {
                IEntityModel iEntityModel2 = iEntityModelArray[0];
                iEntityModelArray[0] = iEntityModelArray[1];
                iEntityModelArray[1] = iEntityModel2;
            }
        } else if (db.on()) {
            db.println("Node does not provide OCH_TRAIL feature");
        }
        if (db.on()) {
            object = new StringBuffer();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                ((StringBuffer)object).append("\n" + iEntityModelArray[i]);
            }
            db.println("Found trunk ports: " + object);
        }
        return iEntityModelArray;
    }

    public static boolean areTrunkAndClientCoLocated(INetElement iNetElement, int n, int n2) {
        if (n == n2) {
            return true;
        }
        try {
            int[] nArray = iNetElement.getNodeModel().getINodeOpticsTopologyModel().getOchTrailTrunkPort(n);
            boolean bl = false;
            String string = "";
            for (int i = 0; i < nArray.length && !bl; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + Integer.toHexString(nArray[i]);
                bl = nArray[i] == n2;
            }
            if (!bl) {
                if (db.on()) {
                    db.println("WARNING: Client port " + Integer.toHexString(n) + " is not co-located with Trunk port(s) " + string + " - Node " + iNetElement.getName());
                }
                return false;
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Exception checking trunk and client ports." + exception);
            }
            return false;
        }
        return true;
    }

    public static int getEqTypeForSize(OchccCircuitSize ochccCircuitSize) {
        return ochccCircuitSize.intValue();
    }

    public static OchccCircuitSize getSizeForEqType(int n, INodeModel iNodeModel) {
        OchccCircuitSize ochccCircuitSize = OchccCircuitSize.fromInt(n, iNodeModel.getFramingType());
        if (ochccCircuitSize == null && db.on()) {
            db.println("Cannot find valid mapping for equipment type " + n + " on node " + iNodeModel);
        }
        return ochccCircuitSize;
    }

    public static boolean isDwdmCard(int n) {
        boolean bl;
        boolean bl2 = bl = OchTrailHelper.isTxpCard(n) || OchTrailHelper.isMxpCard(n);
        if (db.on()) {
            db.println("isDwdmCard(" + n + " - " + EqTypeHelper.eqTypeToName((TDMTerminology)TDMTerminology.getDefault(), (int)n) + "):  " + bl);
        }
        return bl;
    }

    public static boolean isTxpCard(int n) {
        boolean bl;
        boolean bl2 = bl = n == 120 || n == 121 || n == 118 || n == 181 || n == 181 || n == 181;
        if (db.on()) {
            db.println("isTxpCard(" + n + ":  " + bl);
        }
        return bl;
    }

    public static boolean isMxpCard(int n) {
        boolean bl;
        boolean bl2 = bl = n == 183 || n == 184 || n == 119 || n == 182 || n == 182 || n == 182 || n == 243;
        if (db.on()) {
            db.println("isMxpCard(" + n + ": " + bl);
        }
        return bl;
    }

    public static boolean isLineCard(IEntityModel iEntityModel) {
        if (iEntityModel instanceof IModuleModel) {
            return OchTrailHelper.isLineCard(iEntityModel.getEqType());
        }
        return OchTrailHelper.isLineCard(iEntityModel.getModuleModel().getEqType());
    }

    public static boolean isLineCard(int n) {
        boolean bl;
        boolean bl2 = bl = n == 60 || n == 11 || n == 219;
        if (db.on()) {
            db.println("isLineCard(" + n + ":  " + bl);
        }
        return bl;
    }

    public static boolean isTrunkPort(int n) {
        boolean bl;
        boolean bl2 = bl = n == 30 || n == 61 || n == 123;
        if (db.on()) {
            db.println("isTrunkPort(" + n + " - " + EqTypeHelper.eqTypeToName((TDMTerminology)TDMTerminology.getDefault(), (int)n) + "):  " + bl);
        }
        return bl;
    }

    public static boolean isClientPort(int n) {
        boolean bl;
        boolean bl2 = bl = n == 122;
        if (db.on()) {
            db.println("isClientPort(int)(" + n + " - " + EqTypeHelper.eqTypeToName((TDMTerminology)TDMTerminology.getDefault(), (int)n) + "):  " + bl);
        }
        return bl;
    }

    public static boolean isTrunkPort(INodeModel iNodeModel, int n) {
        boolean bl;
        block2: {
            int n2 = 0;
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                n2 = iEntityModel.getEqType();
                bl = OchTrailHelper.isTrunkPort(n2);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("isTrunkPort: exception getting entity model" + exception);
            }
        }
        return bl;
    }

    public static boolean isClientPort(INodeModel iNodeModel, int n) {
        boolean bl;
        block2: {
            int n2 = 0;
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                n2 = iEntityModel.getEqType();
                bl = OchTrailHelper.isClientPort(n2);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("isClientPort: exception getting entity model" + exception);
            }
        }
        return bl;
    }

    public static boolean isProtected(INodeModel iNodeModel, int n) {
        boolean bl;
        block2: {
            int n2 = 0;
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                IModuleModel iModuleModel = iEntityModel.getModuleModel();
                n2 = iModuleModel.getEqType();
                bl = OchTrailHelper.isProtected(n2);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("isProtected: exception getting entity model" + exception);
            }
        }
        return bl;
    }

    public static boolean isProtected(IEntityModel iEntityModel) {
        return OchTrailHelper.isProtected(iEntityModel.getModuleModel().getEqType());
    }

    public static boolean isProtected(int n) {
        boolean bl;
        boolean bl2 = bl = n == 121 || n == 184;
        if (db.on()) {
            db.println("isProtected(" + n + ": " + bl);
        }
        return bl;
    }

    public static IEntityModel[] getColocatedOchPorts(IEntityModel iEntityModel) {
        Object object;
        IOptLinkModel[] iOptLinkModelArray = OchTrailHelper.getInternalOptLinks(iEntityModel);
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        IEntityTableModel iEntityTableModel = iEntityModel.getNodeModel().getEntityTable();
        int n = iEntityModel.getEntityIndex();
        for (int i = 0; i < iOptLinkModelArray.length; ++i) {
            IEntityModel iEntityModel2;
            object = iOptLinkModelArray[i];
            if (n == object.getFrom()) {
                try {
                    iEntityModel2 = iEntityTableModel.getEntityModelByIndex(object.getTo());
                    linkedList.addFirst(iEntityModel2);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                continue;
            }
            if (n != object.getTo()) continue;
            try {
                iEntityModel2 = iEntityTableModel.getEntityModelByIndex(object.getFrom());
                linkedList.addLast(iEntityModel2);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        IEntityModel[] iEntityModelArray = linkedList.toArray(new IEntityModel[0]);
        if (iEntityModelArray.length == 2 && !OchPortsHelper.isAddPort(iEntityModelArray[0])) {
            object = iEntityModelArray[0];
            iEntityModelArray[0] = iEntityModelArray[1];
            iEntityModelArray[1] = object;
        }
        if (db.on()) {
            object = new StringBuffer();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                ((StringBuffer)object).append("\n" + iEntityModelArray[i]);
            }
            db.println("Found " + linkedList.size() + " OCH ports colocated:" + object);
        }
        return iEntityModelArray;
    }

    public static int[] getColocatedOchPorts(INetElement iNetElement, int n) throws AbstractCmsNoSuchEntityException, FeatureUnsupported, NoSuchInterface {
        IEntityModel[] iEntityModelArray;
        IEntityModel iEntityModel;
        IEntityTableModel iEntityTableModel;
        int[] nArray = new int[2];
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel != null && (iEntityTableModel = iNodeModel.getEntityTable()) != null && (iEntityModel = iEntityTableModel.getEntityModelByIndex(n)) != null && (iEntityModelArray = OchTrailHelper.getColocatedOchPorts(iEntityModel)).length != 0) {
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                nArray[i] = iEntityModelArray[i].getEntityIndex();
            }
            return nArray;
        }
        return null;
    }

    public static int getColocatedTrunkPort(INodeModel iNodeModel, int n) {
        int n2;
        block3: {
            n2 = 0;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                IEntityModel iEntityModel2 = OchTrailHelper.getColocatedTrunkPort(iEntityModel);
                if (iEntityModel2 != null) {
                    n2 = iEntityModel2.getEntityIndex();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("getColocatedTrunkPort: exception getting entity model" + exception);
            }
        }
        return n2;
    }

    public static IEntityModel getColocatedTrunkPort(IEntityModel iEntityModel) {
        IOptLinkModel[] iOptLinkModelArray = OchTrailHelper.getInternalOptLinks(iEntityModel);
        int n = iEntityModel.getEntityIndex();
        IEntityTableModel iEntityTableModel = iEntityModel.getNodeModel().getEntityTable();
        IEntityModel iEntityModel2 = null;
        for (int i = 0; iEntityModel2 == null && i < iOptLinkModelArray.length; ++i) {
            IEntityModel iEntityModel3;
            IOptLinkModel iOptLinkModel = iOptLinkModelArray[i];
            if (n == iOptLinkModel.getFrom()) {
                try {
                    iEntityModel3 = iEntityTableModel.getEntityModelByIndex(iOptLinkModel.getTo());
                    if (!OchTrailHelper.isTrunkPort(iEntityModel3.getEqType())) continue;
                    iEntityModel2 = iEntityModel3;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                continue;
            }
            if (n != iOptLinkModel.getTo()) continue;
            try {
                iEntityModel3 = iEntityTableModel.getEntityModelByIndex(iOptLinkModel.getFrom());
                if (!OchTrailHelper.isTrunkPort(iEntityModel3.getEqType())) continue;
                iEntityModel2 = iEntityModel3;
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (db.on()) {
            db.println("Found colocated trunk :" + iEntityModel2);
        }
        return iEntityModel2;
    }

    public static IEntityModel getColocatedTrunkPort(INetElement iNetElement, int n, int n2) {
        int[] nArray;
        INodeModel iNodeModel;
        IEntityModel iEntityModel;
        block21: {
            iEntityModel = null;
            iNodeModel = iNetElement.getNodeModel();
            if (!iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
                if (db.on()) {
                    db.println("Cannot check colocated trunk on node " + iNodeModel + " - It does not provide OCH_TRAIL_PROVISIONING");
                }
                return iEntityModel;
            }
            INodeOpticsTopologyModel iNodeOpticsTopologyModel = iNodeModel.getINodeOpticsTopologyModel();
            nArray = new int[]{};
            try {
                nArray = iNodeOpticsTopologyModel.getAvailOchncPathEntities(n2, n);
            }
            catch (AlreadyInUse alreadyInUse) {
                if (db.on()) {
                    db.println("OCH channel in use. Try to get index from exception");
                }
                if (alreadyInUse.hasEntityIndex()) {
                    nArray = new int[]{alreadyInUse.getEntityIndex()};
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (!db.on()) break block21;
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
        }
        if (nArray.length > 0) {
            IEntityModel iEntityModel2;
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            IEntityModel iEntityModel3 = null;
            for (int i = 0; iEntityModel == null && i < nArray.length; ++i) {
                iEntityModel2 = null;
                try {
                    iEntityModel2 = iEntityTableModel.getEntityModelByIndex(nArray[i]);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) continue;
                    db.println("Cannot get entity " + nArray[i] + " on node " + iNodeModel + " :" + abstractCmsNoSuchEntityException.getMessage());
                    continue;
                }
                if (OchPortsHelper.isOtsPort(iEntityModel2)) {
                    if (!db.on()) continue;
                    db.println("Skipping OTS port " + iEntityModel2);
                    continue;
                }
                if (db.on()) {
                    db.println("Trying with OCH port " + iEntityModel2);
                }
                if ((iEntityModel = OchTrailHelper.getColocatedTrunkPort(iEntityModel2)) == null) continue;
                iEntityModel3 = iEntityModel2;
            }
            if (db.on()) {
                db.println("Found trunk: " + iEntityModel);
            }
            if (iEntityModel != null) {
                IEntityModel iEntityModel4 = OchPortsHelper.getReversePort(n2, iEntityModel3);
                if (db.on()) {
                    db.println("Trying with other OCH port " + iEntityModel4);
                }
                if (iEntityModel4 != null) {
                    iEntityModel2 = OchTrailHelper.getColocatedTrunkPort(iEntityModel4);
                    if (db.on()) {
                        db.println("Found other trunk: " + iEntityModel2);
                    }
                    if (iEntityModel2 == null || iEntityModel2.getEntityIndex() != iEntityModel.getEntityIndex()) {
                        iEntityModel = null;
                    }
                } else {
                    iEntityModel = null;
                }
            }
        }
        if (db.on()) {
            db.println("Found colocated trunk :" + iEntityModel);
        }
        return iEntityModel;
    }

    public static IRevertiveBehavior getReversion(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, AbstractCmsNoSuchElementException {
        int n = iEntityModel.getEqType();
        int n2 = iEntityModel.getModuleModel().getEqType();
        IRevertiveBehavior iRevertiveBehavior = null;
        if (OchTrailHelper.isProtected(n2)) {
            INodeModel iNodeModel;
            IEntityModel iEntityModel2 = iEntityModel;
            if (OchTrailHelper.isClientPort(n)) {
                iNodeModel = iEntityModel2.getNodeModel();
                iEntityModel2 = OchTrailHelper.getTrunkPorts(iNodeModel, iEntityModel.getEntityIndex())[0];
            }
            if ((iNodeModel = OchTrailHelper.getYCableModel(iEntityModel2)) != null) {
                iRevertiveBehavior = iNodeModel.getReversion();
                if (db.on()) {
                    db.println("Got Reversion = " + iRevertiveBehavior);
                }
            }
        } else if (db.on()) {
            db.println("Non-protected cards have not reversion");
        }
        return iRevertiveBehavior;
    }

    public static void setReversion(IRevertiveBehavior iRevertiveBehavior, IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, AbstractCmsNoSuchElementException {
        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
        IElementModel iElementModel = iDwdmPortModel.getElementModel();
        if (iElementModel != null && iElementModel instanceof IYCableModel) {
            IYCableModel iYCableModel = (IYCableModel)iElementModel;
            iYCableModel.setReversion(iRevertiveBehavior);
            if (db.on()) {
                db.println("Configured Reversion = " + iRevertiveBehavior);
            }
        } else if (db.on()) {
            db.println("Cannot find Element Model or is not a IYCableModel: " + iElementModel);
        }
    }

    public static CircuitCreatInfo.TrunkInfo getTrunkAttrs(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface, WrongInterfaceType {
        CircuitCreatInfo.TrunkInfo trunkInfo = null;
        int n = iEntityModel.getEqType();
        int n2 = iEntityModel.getModuleModel().getEqType();
        if (!OchTrailHelper.isLineCard(n2)) {
            INodeModel iNodeModel;
            IEntityModel iEntityModel2 = iEntityModel;
            if (OchTrailHelper.isClientPort(n)) {
                iNodeModel = iEntityModel2.getNodeModel();
                iEntityModel2 = OchTrailHelper.getTrunkPorts(iNodeModel, iEntityModel.getEntityIndex())[0];
            }
            iNodeModel = (IDwdmPortModel)iEntityModel2;
            IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iNodeModel.getInterfaceModel();
            if (db.on()) {
                db.println("Found trunk port: " + iEntityModel2);
            }
            short s = iDwdmTrkLineModel.getOTNSfBerLevel();
            short s2 = iDwdmTrkLineModel.getOTNSdBerLevel();
            trunkInfo = new CircuitCreatInfo.TrunkInfo(iDwdmTrkLineModel.getOTNStatus(), iDwdmTrkLineModel.getFECModeValue(), s, s2, iDwdmTrkLineModel.getMappingTypeValue());
            if (db.on()) {
                db.println("Found trunk attrs: " + trunkInfo);
            }
        } else if (db.on()) {
            db.println("Line cards have no trunk attrs");
        }
        return trunkInfo;
    }

    public static void setTrunkAttrs(CircuitCreatInfo.TrunkInfo trunkInfo, IEntityModel iEntityModel) throws NoSuchEquipment, DetailedConfigError, AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, ConfigError {
        if (trunkInfo == null) {
            if (db.on()) {
                db.println("Null Trunk attrs for " + iEntityModel);
            }
            return;
        }
        if (db.on()) {
            db.println("Configuring Trunk attrs for " + iEntityModel + " to " + trunkInfo);
        }
        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
        IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iDwdmPortModel.getInterfaceModel();
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        if (!(iModuleModel instanceof IDwdmModuleModel)) {
            return;
        }
        int n = iModuleModel.getEqType();
        if (((IDwdmModuleModel)iModuleModel).supportsOTN()) {
            int n2;
            boolean bl = trunkInfo.isG709();
            int n3 = trunkInfo.getFecMode();
            if (n == 182 || n == 243 || n == 181) {
                n2 = trunkInfo.getMappingType();
                if (n == 182 && n2 == 1) {
                    n2 = 3;
                } else if (!bl) {
                    n2 = 2;
                }
            } else {
                n2 = 0;
            }
            if (n == 243) {
                iDwdmTrkLineModel.setOTNData(bl, n3, n2);
            } else if (!bl) {
                iDwdmTrkLineModel.setMappingType(n2);
                iDwdmTrkLineModel.setFECModeValue(n3);
                iDwdmTrkLineModel.setOTNStatus(bl);
            } else {
                iDwdmTrkLineModel.setOTNStatus(bl);
                iDwdmTrkLineModel.setFECModeValue(n3);
                iDwdmTrkLineModel.setMappingType(n2);
            }
            if (db.on()) {
                db.println("Configured G709 = " + bl + " FEC = " + n3 + " Mapping = " + n2);
            }
        } else if (db.on()) {
            db.println("OTN Setup skipped (not supported by " + iModuleModel + ")");
        }
        iDwdmTrkLineModel.setOTNSdBerLevel((short)trunkInfo.getSdBer());
        if (db.on()) {
            db.println("Configured SD BER = " + trunkInfo.getSdBer());
        }
    }

    public static String getCircuitSizeString(OchccCircuit ochccCircuit) {
        OchccCircuitSize ochccCircuitSize = OchccCircuitSize.fromInt(ochccCircuit.getSpecificSize(), ochccCircuit.getSourceNE().getFramingType());
        if (ochccCircuitSize != null) {
            return ochccCircuitSize.toString();
        }
        return "Unknown size " + ochccCircuit.getSpecificSize();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static IEntityModel getEntityModel(INetCircuitEnd iNetCircuitEnd) throws AbstractCmsNoSuchEntityException, ObjNotFound, SanityCheckFailed {
        IEntityModel iEntityModel;
        block10: {
            block11: {
                if (db.on()) {
                    db.println("Called getEntityModel ( " + iNetCircuitEnd + ")");
                }
                iEntityModel = null;
                IEntityTableModel iEntityTableModel = iNetCircuitEnd.getNodeModel().getEntityTable();
                INetCircuit iNetCircuit = NetCircuitManager.instance().getCircuitFromCircuitEnd(iNetCircuitEnd);
                if (iNetCircuit == null) break block11;
                INetCircuitNode iNetCircuitNode = iNetCircuit.getCircuitNodeFromNE(iNetCircuitEnd.getNetElement());
                if (iNetCircuitNode instanceof OchccCircuitNode) {
                    OchccCircuitNode ochccCircuitNode = (OchccCircuitNode)iNetCircuitNode;
                    IOchccPathDefModel iOchccPathDefModel = (IOchccPathDefModel)ochccCircuitNode.getPathList().get(0);
                    int n = iOchccPathDefModel.getPortEntityIdx();
                    if (db.on()) {
                        db.println("OchccCircuitNode returned index " + n);
                    }
                    iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    break block10;
                } else if (iNetCircuitNode instanceof OchTrailTunnelNode) {
                    OchTrailTunnelNode ochTrailTunnelNode = (OchTrailTunnelNode)iNetCircuitNode;
                    int n = ochTrailTunnelNode.getEntityIndex();
                    if (db.on()) {
                        db.println("OchTrailTunnelNode returned index " + n);
                    }
                    iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    break block10;
                } else {
                    if (iNetCircuitNode == null) {
                        throw new ObjNotFound("Ckt node for cktEnd " + iNetCircuitEnd + " is null");
                    }
                    throw new ObjNotFound("Found unhandled ckt of type " + iNetCircuitNode.getClass().getName() + " for cktEnd " + iNetCircuitEnd);
                }
            }
            if (db.on()) {
                db.println("Cannot find ckt for cktEnd " + iNetCircuitEnd);
            }
            throw new ObjNotFound("Cannot find ckt for cktEnd " + iNetCircuitEnd);
        }
        if (db.on()) {
            db.println("getEntityModel is " + iEntityModel);
        }
        return iEntityModel;
    }

    public static IEntityModel[] getConnectedOchPorts(IEntityModel iEntityModel) {
        Object object;
        IEntityModel iEntityModel2 = null;
        IEntityModel iEntityModel3 = null;
        int n = iEntityModel.getEntityIndex();
        INetElement iNetElement = Network.instance().findNetElem(iEntityModel.getNodeModel());
        if (iNetElement != null && (object = Network.instance().findNetLinkFromSource(false, iNetElement, n, null)) != null) {
            INetElement iNetElement2 = object.getDst();
            int n2 = object.getDstEntityIndex();
            IEntityTableModel iEntityTableModel = iNetElement2.getNodeModel().getEntityTable();
            try {
                iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    db.println("Cannot find Entity Model for och port " + n2 + " on  node " + iNetElement2.getName());
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                return null;
            }
            if (OchPortsHelper.isAddPort(iEntityModel2)) {
                int n3;
                try {
                    n3 = ((IOpticsChannelModel)((IPortModel)iEntityModel2).getInterfaceModel()).getExpectedWaveLength();
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("Cannot find wlen for och port " + iEntityModel2);
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    return null;
                }
                iEntityModel3 = OchPortsHelper.getReversePort(n3, iEntityModel2);
                if (iEntityModel3 != null) {
                    return new IEntityModel[]{iEntityModel2, iEntityModel3};
                }
                if (db.on()) {
                    db.println("Cannot find wlreverse Tx port for och port " + iEntityModel2);
                }
                return null;
            }
            if (db.on()) {
                db.println("Found port connected to trunk " + iEntityModel + " via VL, but it is nor OCH Rx: " + iEntityModel2);
            }
            return null;
        }
        object = OchTrailHelper.getColocatedOchPorts(iEntityModel);
        if (((IEntityModel[])object).length == 2) {
            if (OchPortsHelper.isAddPort(object[0]) && OchPortsHelper.isOchPort((IEntityModel)object[1])) {
                return object;
            }
            if (OchPortsHelper.isOchPort((IEntityModel)object[0]) && OchPortsHelper.isAddPort((IEntityModel)object[1])) {
                return new IEntityModel[]{object[1], object[0]};
            }
            if (db.on()) {
                db.println("Found two ports connected to trunk " + iEntityModel + " but not OCH ports: " + object[0] + ", " + object[1]);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static UpgradeOchncInfo getConnectedTrunk(INetCircuitEnd var0, INetCircuitEnd var1_1) {
        var2_2 = var0.getEntityIndex();
        var3_3 = var1_1.getEntityIndex();
        var4_4 = Network.instance().findNetLinkFromSource(false, var0.getNetElement(), var2_2, null);
        if (var4_4 == null) {
            var4_4 = Network.instance().findNetLinkFromDestination(false, var0.getNetElement(), var2_2, null);
        }
        if ((var5_5 = Network.instance().findNetLinkFromSource(false, var1_1.getNetElement(), var3_3, null)) == null) {
            var5_5 = Network.instance().findNetLinkFromDestination(false, var1_1.getNetElement(), var3_3, null);
        }
        if (var4_4 != null && var5_5 != null) {
            if (var4_4.getSrcEntityIndex() == var2_2) {
                var6_6 = var4_4.getDstEntityIndex();
                var7_8 = var4_4.getDst().getNodeModel();
            } else {
                var6_6 = var4_4.getSrcEntityIndex();
                var7_8 = var4_4.getSrc().getNodeModel();
            }
            if (var5_5.getSrcEntityIndex() == var3_3) {
                var8_10 = var5_5.getDstEntityIndex();
                var9_13 = var5_5.getDst().getNodeModel();
            } else {
                var8_10 = var5_5.getSrcEntityIndex();
                var9_13 = var5_5.getSrc().getNodeModel();
            }
            if (var7_8.equals(var9_13) && var6_6 == var8_10) {
                var10_15 = var7_8.getEntityTable();
                try {
                    var11_17 = var10_15.getEntityModelByIndex(var6_6);
                    if (OchTrailHelper.isTrunkPort(var11_17.getEqType())) {
                        if (OchTrailHelper.db.on()) {
                            OchTrailHelper.db.println("Found common trunk port: " + var11_17);
                        }
                        var12_19 = new UpgradeOchncInfo(var11_17, var4_4, var5_5);
                        return var12_19;
                    }
                    if (!OchTrailHelper.db.on()) ** GOTO lbl40
                    OchTrailHelper.db.println("Found common port linking 2 OCH ports, but it is not a Trunk port: " + var11_17);
                }
                catch (AbstractCmsNoSuchEntityException var11_18) {
                    if (OchTrailHelper.db.on()) {
                        OchTrailHelper.db.println("Cannot find EM for common port " + var6_6 + " on node " + var7_8);
                    }
                    return null;
                }
            } else {
                if (OchTrailHelper.db.on()) {
                    OchTrailHelper.db.println("Found 2 VL starting from the 2 OCH ports, but they have different destinations: " + var6_6 + "/" + var7_8 + " and " + var8_10 + "/" + var9_13);
                }
                return null;
            }
        }
lbl40:
        // 4 sources

        if (var4_4 != null || var5_5 != null) {
            if (OchTrailHelper.db.on()) {
                OchTrailHelper.db.println("Found only one VL starting from one of the 2 OCH ports: " + (var4_4 != null ? var4_4.prettyString() : var5_5.prettyString()));
            }
            return null;
        }
        try {
            var6_7 = OchTrailHelper.getInternalOptLinks(var0.getEntityModel());
        }
        catch (ObjNotFound var7_9) {
            if (OchTrailHelper.db.on()) {
                OchTrailHelper.db.println("Cannot find interal links for " + var0);
                SDebug.printStackTrace((Throwable)var7_9);
            }
            return null;
        }
        try {
            var7_8 = OchTrailHelper.getInternalOptLinks(var1_1.getEntityModel());
        }
        catch (ObjNotFound var8_11) {
            if (OchTrailHelper.db.on()) {
                OchTrailHelper.db.println("Cannot find interal links for " + var1_1);
                SDebug.printStackTrace((Throwable)var8_11);
            }
            return null;
        }
        if (var6_7.length == 1 && var6_7.length == 1) {
            var8_12 = var0.getNodeModel().getEntityTable();
            var9_14 = var6_7[0].getFrom() == var0.getEntityIndex() ? var6_7[0].getTo() : var6_7[0].getFrom();
            if (var9_14 == (var10_16 = var7_8[0].getFrom() == var1_1.getEntityIndex() ? var7_8[0].getTo() : var7_8[0].getFrom())) {
                try {
                    var11_17 = var8_12.getEntityModelByIndex(var9_14);
                }
                catch (AbstractCmsNoSuchEntityException var12_20) {
                    if (OchTrailHelper.db.on()) {
                        OchTrailHelper.db.println("Cannot find Entity Model for trunk port " + Integer.toHexString(var9_14) + " on  node " + var0.getNetElement().getName());
                        SDebug.printStackTrace((Throwable)var12_20);
                    }
                    return null;
                }
                if (OchTrailHelper.isTrunkPort(var11_17.getEqType())) {
                    var12_21 = new UpgradeOchncInfo(var11_17, var6_7[0], var7_8[0]);
                    return var12_21;
                }
                if (OchTrailHelper.db.on()) {
                    OchTrailHelper.db.println("Found 1 internal port connected to both OCH ports but not a Trunk port: " + var11_17);
                }
            } else if (OchTrailHelper.db.on()) {
                OchTrailHelper.db.println("Found 2 internal links starting from the OCH ports but terminating on different ports: " + Integer.toHexString(var9_14) + ", " + Integer.toHexString(var10_16));
            }
        } else {
            OchTrailHelper.db.println("Found 2 lists of internal links starting but not all of length 1: " + var6_7.length + " and " + var7_8.length);
        }
        return null;
    }

    public static IEntityModel[] getClientPorts(IEntityModel iEntityModel) {
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        List list = iModuleModel.getDescendantsOfEqType(122);
        if (db.on()) {
            StringBuffer stringBuffer = new StringBuffer("getClientPorts(" + iEntityModel + ") :\n");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n" + iterator.next());
            }
            db.println(stringBuffer.toString());
        }
        return list.toArray(new IEntityModel[0]);
    }

    public static List getAvailOchccPorts(INodeModel iNodeModel) {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
            int[] nArray;
            IEntityTableModel iEntityTableModel;
            block9: {
                iEntityTableModel = iNodeModel.getEntityTable();
                nArray = new int[]{};
                try {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailOchccPorts();
                }
                catch (Exception exception) {
                    if (!db.on()) break block9;
                    db.println("Cannot get available client ports for OCHNC: " + exception.getMessage());
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (db.on()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(Integer.toHexString(nArray[i]));
                }
                db.println("Node " + iNodeModel + " - ADD entities for " + ": [" + stringBuffer + "]");
            }
            for (int i = 0; nArray != null && i < nArray.length; ++i) {
                try {
                    linkedList.add(iEntityTableModel.getEntityModelByIndex(nArray[i]));
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        } else {
            throw new FeatureNotSupported("OchTrailHelper.getAvailOchccPorts() is not supported");
        }
        return linkedList;
    }

    public static int getProtectionOp(IEntityModel iEntityModel) throws AbstractCmsNoSuchElementException {
        if (db.on()) {
            db.println("getProtectionOp(" + iEntityModel + ")");
        }
        int n = -1;
        IYCableModel iYCableModel = OchTrailHelper.getYCableModel(iEntityModel);
        if (iYCableModel != null) {
            n = iYCableModel.getProtection();
        }
        if (db.on()) {
            db.println("getProtectionOp() return " + n);
        }
        return n;
    }

    public static void setProtectionOp(IEntityModel iEntityModel, int n) throws AbstractCmsNoSuchElementException, InvalidProtectionOp, InternalCommError {
        IYCableModel iYCableModel;
        if (db.on()) {
            db.println("switchToProtect(" + iEntityModel + ")");
        }
        if ((iYCableModel = OchTrailHelper.getYCableModel(iEntityModel)) != null) {
            iYCableModel.setProtection(n);
        }
        if (db.on()) {
            db.println("switchToProtect() completed ");
        }
    }

    public static IYCableModel getYCableModel(IEntityModel iEntityModel) throws AbstractCmsNoSuchElementException {
        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
        IElementModel iElementModel = iDwdmPortModel.getElementModel();
        if (iElementModel != null && iElementModel instanceof IYCableModel) {
            IYCableModel iYCableModel = (IYCableModel)iElementModel;
            return iYCableModel;
        }
        if (db.on()) {
            db.println("Cannot find Element Model or is not a IYCableModel: " + iElementModel);
        }
        return null;
    }

    public static int getPayloadEqType(IEntityModel iEntityModel) {
        int n = -1;
        IEntityModel iEntityModel2 = OchTrailHelper.getPPM(iEntityModel);
        if (iEntityModel2 != null) {
            n = iEntityModel2.getEqType();
        }
        if (db.on()) {
            db.println("getPayloadEqType( " + iEntityModel + ") is : " + EqTypeHelper.eqTypeToName((TDMTerminology)iEntityModel.getNodeModel().getTDMTerminology(), (int)n));
        }
        return n;
    }

    public static IEntityModel getPPM(IEntityModel iEntityModel) {
        Object object;
        Iterator iterator;
        IEntityModel iEntityModel2 = null;
        List list = iEntityModel.getModuleModel().getDescendantsOfEqType(150);
        IPpmModel iPpmModel = null;
        LinkedList linkedList = null;
        if (list.size() > 0) {
            if (db.on()) {
                db.println("getPayloadEqType( " + iEntityModel + ") found " + list.size() + " ppms");
            }
            linkedList = new LinkedList();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (IPpmModel)iterator.next();
                iPpmModel = object;
                linkedList.addAll(object.getContainedPorts());
                if (!db.on()) continue;
                db.println("Found " + object.getContainedPorts().size() + " in container " + iPpmModel);
            }
        } else {
            if (db.on()) {
                db.println("getPayloadEqType( " + iEntityModel + ") cannot find PPMs");
            }
            if ((iterator = iEntityModel.getModuleModel().getDescendantsOfEqType(193)) != null && iterator.size() > 0) {
                if (db.on()) {
                    db.println("getPayloadEqType( " + iEntityModel + ") found " + iterator.size() + " MR slots");
                }
                linkedList = new LinkedList();
                object = iterator.iterator();
                while (object.hasNext()) {
                    iPpmModel = (IEntityModel)object.next();
                    linkedList.addAll(iPpmModel.getDescendantsOfClassType(7));
                    if (!db.on()) continue;
                    db.println("Found " + iPpmModel.getDescendantsOfClassType(7).size() + " in container " + iPpmModel);
                }
            } else if (db.on()) {
                db.println("getPayloadEqType( " + iEntityModel + ") cannot find MR slots");
            }
        }
        if (linkedList != null) {
            iterator = linkedList.iterator();
            object = ((IPortModel)iEntityModel).getPortNum();
            while (iterator.hasNext() && iEntityModel2 == null) {
                int[] nArray;
                IEntityModel iEntityModel3 = (IEntityModel)iterator.next();
                if (iEntityModel3 == null || !(iEntityModel3 instanceof IPortModel) || (nArray = ((IPortModel)iEntityModel3).getPortNum()).length <= 0 || nArray[0] != object[0]) continue;
                iEntityModel2 = iEntityModel3;
            }
        }
        if (db.on()) {
            db.println("getPPM( " + iEntityModel + ") is : " + iEntityModel2);
        }
        return iEntityModel2;
    }

    private static IOptLinkModel[] getInternalOptLinks(IEntityModel iEntityModel) {
        IOptLinkModel[] iOptLinkModelArray;
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        int n = iEntityModel.getEntityIndex();
        if (db.on()) {
            db.println("getInternalOptLinks(" + iEntityModel + ") [" + Integer.toHexString(n) + "] on node " + iNodeModel.getName());
        }
        LinkedList<IOptLinkModel> linkedList = new LinkedList<IOptLinkModel>();
        if (iEntityModel.getNodeModel().provides(Feature.OCH_TRAIL_PROVISIONING)) {
            iOptLinkModelArray = iNodeModel.getIOpticalPatchCordModel();
            try {
                IOptLinkModel[] iOptLinkModelArray2 = iOptLinkModelArray.getIOptLinkModels();
                for (int i = 0; i < iOptLinkModelArray2.length; ++i) {
                    IOptLinkModel iOptLinkModel = iOptLinkModelArray2[i];
                    if (iOptLinkModel.getFrom() != n && iOptLinkModel.getTo() != n) continue;
                    linkedList.add(iOptLinkModel);
                }
            }
            catch (FeatureUnsupported featureUnsupported) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
            }
        } else if (db.on()) {
            db.println("getInternalOptLinks(" + iEntityModel + ") Node pre 7.0 - Skipped");
        }
        iOptLinkModelArray = linkedList.toArray(new IOptLinkModel[0]);
        if (db.on()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < iOptLinkModelArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(Integer.toHexString(iOptLinkModelArray[i].getFrom()) + "<--> " + Integer.toHexString(iOptLinkModelArray[i].getTo()));
            }
            db.println("Found " + iOptLinkModelArray.length + " optical links from/to " + Integer.toHexString(n) + ": [" + stringBuffer + "]");
        }
        return iOptLinkModelArray;
    }

    public static boolean isTrunkInUse(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface {
        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
        IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iDwdmPortModel.getInterfaceModel();
        IServiceState iServiceState = iDwdmTrkLineModel.getServiceSt();
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        if (db.on()) {
            db.println("Trunk port " + iEntityModel + " is in state " + iServiceState.toString(iNodeModel.getTDMTerminology()));
        }
        if (iServiceState.equals(102)) {
            if (db.on()) {
                db.println("Trunk port is already in service");
            }
            return true;
        }
        int n = iEntityModel.getEntityIndex();
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        IOchccConnectionModel[] iOchccConnectionModelArray = iConnectionModels.getOchccConnectionModels();
        if (db.on()) {
            db.println("Found " + iOchccConnectionModelArray.length + " OCHCCs connections on this node");
        }
        boolean bl = false;
        for (int i = 0; !bl && i < iOchccConnectionModelArray.length; ++i) {
            IOchccConnectionModel iOchccConnectionModel = iOchccConnectionModelArray[i];
            IOchccPathDefModel[] iOchccPathDefModelArray = iOchccConnectionModel.getPaths();
            for (int j = 0; !bl && j < iOchccPathDefModelArray.length; ++j) {
                IOchccPathDefModel iOchccPathDefModel = iOchccPathDefModelArray[j];
                if (db.on()) {
                    db.println("Checking OCHCC path " + iOchccPathDefModel);
                }
                if (iOchccPathDefModel.getPortEntityIdx() != n) continue;
                if (db.on()) {
                    db.println("This OCHCC path involves the selected trunk [" + n + "]");
                }
                bl = true;
            }
        }
        return bl;
    }

    private static boolean areG709Equivalent(IModuleModel iModuleModel, boolean bl, IModuleModel iModuleModel2, boolean bl2) {
        if (iModuleModel instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel).supportsOTN()) {
            return true;
        }
        if (iModuleModel2 instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel2).supportsOTN()) {
            return true;
        }
        return bl == bl2;
    }

    private static boolean areFECEquivalent(IModuleModel iModuleModel, int n, IModuleModel iModuleModel2, int n2) {
        if (iModuleModel instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel).supportsOTN()) {
            return true;
        }
        if (iModuleModel2 instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel2).supportsOTN()) {
            return true;
        }
        return n == n2;
    }

    private static boolean areMappingEquivalent(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (n == 1 && n2 == 3) {
            return true;
        }
        if (n2 == 1 && n == 3) {
            return true;
        }
        return n == 0 || n2 == 0;
    }

    private static String dumpArray(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i] + ": " + EqTypeHelper.eqTypeToName((TDMTerminology)TDMTerminology.getDefault(), (int)nArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        hashMap.put(new Integer(181), new int[]{118, 181});
        hashMap.put(new Integer(118), new int[]{181, 181});
        hashMap.put(new Integer(181), new int[]{181, 118, 181});
        hashMap.put(new Integer(181), new int[]{181});
        interOperabilityMap.put(OchccCircuitSize.SIZE_OCHCC_OC_192, hashMap);
        hashMap = new HashMap();
        hashMap.put(new Integer(182), new int[]{182});
        hashMap.put(new Integer(182), new int[]{182});
        interOperabilityMap.put(OchccCircuitSize.SIZE_OCHCC_OC_48, hashMap);
        hashMap = new HashMap();
        hashMap.put(new Integer(181), new int[]{118, 181});
        hashMap.put(new Integer(118), new int[]{181, 181});
        hashMap.put(new Integer(181), new int[]{181, 118, 181});
        hashMap.put(new Integer(181), new int[]{181});
        interOperabilityMap.put(OchccCircuitSize.SIZE_OCHCC_STM_64, hashMap);
        hashMap = new HashMap();
        hashMap.put(new Integer(182), new int[]{182});
        hashMap.put(new Integer(182), new int[]{182});
        interOperabilityMap.put(OchccCircuitSize.SIZE_OCHCC_STM_16, hashMap);
        hashMap = new HashMap();
        hashMap.put(new Integer(181), new int[]{118, 181});
        hashMap.put(new Integer(118), new int[]{181, 181});
        hashMap.put(new Integer(181), new int[]{181, 118, 181});
        hashMap.put(new Integer(181), new int[]{181});
        interOperabilityMap.put(OchccCircuitSize.SIZE_OCHCC_10_GE, hashMap);
    }

    public static class UpgradeOchncInfo {
        private IEntityModel trunkPort;
        private INetLink virtualLink1;
        private INetLink virtualLink2;
        private IOptLinkModel internalLink1;
        private IOptLinkModel internalLink2;

        public UpgradeOchncInfo(IEntityModel iEntityModel, INetLink iNetLink, INetLink iNetLink2) {
            this.trunkPort = iEntityModel;
            this.virtualLink1 = iNetLink;
            this.virtualLink2 = iNetLink2;
            this.internalLink1 = null;
            this.internalLink2 = null;
        }

        public UpgradeOchncInfo(IEntityModel iEntityModel, IOptLinkModel iOptLinkModel, IOptLinkModel iOptLinkModel2) {
            this.trunkPort = iEntityModel;
            this.virtualLink1 = null;
            this.virtualLink2 = null;
            this.internalLink1 = iOptLinkModel;
            this.internalLink2 = iOptLinkModel2;
        }

        public IEntityModel getTrunkPort() {
            return this.trunkPort;
        }

        public INetLink getVirtualLink1() {
            return this.virtualLink1;
        }

        public INetLink getVirtualLink2() {
            return this.virtualLink2;
        }

        public IOptLinkModel getInternalLink1() {
            return this.internalLink1;
        }

        public IOptLinkModel getInternalLink2() {
            return this.internalLink2;
        }

        public boolean isColocated() {
            return this.internalLink1 != null && this.internalLink2 != null;
        }
    }

    public static class OchccCircuitSize
    implements Comparable {
        public static final OchccCircuitSize SIZE_OCHCC_OC_192 = new OchccCircuitSize("OC-192", 61, 0);
        public static final OchccCircuitSize SIZE_OCHCC_OC_48 = new OchccCircuitSize("OC-48", 30, 0);
        public static final OchccCircuitSize SIZE_OCHCC_OC_12 = new OchccCircuitSize("OC-12", 29, 0);
        public static final OchccCircuitSize SIZE_OCHCC_OC_3 = new OchccCircuitSize("OC-3", 28, 0);
        public static final OchccCircuitSize SIZE_OCHCC_STM_64 = new OchccCircuitSize("STM-64", 61);
        public static final OchccCircuitSize SIZE_OCHCC_STM_16 = new OchccCircuitSize("STM-16", 30);
        public static final OchccCircuitSize SIZE_OCHCC_STM_4 = new OchccCircuitSize("STM-4", 29);
        public static final OchccCircuitSize SIZE_OCHCC_STM_1 = new OchccCircuitSize("STM-1", 28);
        public static final OchccCircuitSize SIZE_OCHCC_10_GE = new OchccCircuitSize("10GE", 168);
        public static final OchccCircuitSize SIZE_OCHCC_1_GE = new OchccCircuitSize("1GE", 167);
        public static final OchccCircuitSize SIZE_OCHCC_10_GFC = new OchccCircuitSize("FC10G", 178);
        public static final OchccCircuitSize SIZE_OCHCC_4_GFC = new OchccCircuitSize("FC4G", 244);
        public static final OchccCircuitSize SIZE_OCHCC_2_GFC = new OchccCircuitSize("FC2G", 177);
        public static final OchccCircuitSize SIZE_OCHCC_1_GFC = new OchccCircuitSize("FC1G", 176);
        public static final OchccCircuitSize SIZE_OCHCC_4_GFICON = new OchccCircuitSize("FICON4G", 245);
        public static final OchccCircuitSize SIZE_OCHCC_2_GFICON = new OchccCircuitSize("FICON2G", 180);
        public static final OchccCircuitSize SIZE_OCHCC_1_GFICON = new OchccCircuitSize("FICON1G", 179);
        public static final OchccCircuitSize SIZE_OCHCC_ESCON = new OchccCircuitSize("ESCON", 169);
        public static final OchccCircuitSize SIZE_OCHCC_ETR_CLO = new OchccCircuitSize("ETR-CLO", 174);
        public static final OchccCircuitSize SIZE_OCHCC_ISC_PEER = new OchccCircuitSize("ISC PEER", 194);
        public static final OchccCircuitSize SIZE_OCHCC_ISC3_PEER_1G = new OchccCircuitSize("ISC3 PEER 1G", 246);
        public static final OchccCircuitSize SIZE_OCHCC_ISC3_PEER_2G = new OchccCircuitSize("ISC3 PEER 2G", 247);
        public static final OchccCircuitSize SIZE_OCHCC_ISC_COMPAT = new OchccCircuitSize("ISC COMPAT", 175);
        public static final OchccCircuitSize SIZE_OCHCC_HDTV = new OchccCircuitSize("HDTV", 172);
        public static final OchccCircuitSize SIZE_OCHCC_SD1_D1 = new OchccCircuitSize("SD1/D1", 171);
        public static final OchccCircuitSize SIZE_OCHCC_DV6000 = new OchccCircuitSize("DV6000", 170);
        public static final OchccCircuitSize SIZE_OCHCC_PASSTROUGH = new OchccCircuitSize("Pass-trough", 173);
        private static int counter = 0;
        private static Map enums;
        private String label;
        private int eqType;
        private int framingType;

        private OchccCircuitSize(String string, int n) {
            this(string, n, -1);
        }

        private OchccCircuitSize(String string, int n, int n2) {
            Integer n3;
            Object v;
            this.label = string;
            this.eqType = n;
            this.framingType = n2;
            if (enums == null) {
                enums = new HashMap();
            }
            if ((v = enums.get(n3 = new Integer(n))) == null) {
                enums.put(n3, this);
            } else {
                LinkedList<Object> linkedList;
                if (v instanceof OchccCircuitSize) {
                    linkedList = new LinkedList<Object>();
                    linkedList.add(v);
                } else {
                    linkedList = (LinkedList<Object>)v;
                }
                linkedList.add(this);
                enums.put(n3, linkedList);
            }
        }

        public String toString() {
            return this.label;
        }

        public int intValue() {
            return this.eqType;
        }

        public static OchccCircuitSize fromInt(int n, int n2) {
            if (db.on()) {
                db.println("Mapping Och-Trail ckt size from eqType = " + n + ", framingType = " + n2);
            }
            OchccCircuitSize ochccCircuitSize = null;
            Object v = enums.get(new Integer(n));
            if (v != null) {
                if (v instanceof OchccCircuitSize) {
                    ochccCircuitSize = (OchccCircuitSize)v;
                } else {
                    LinkedList linkedList = (LinkedList)v;
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext() && ochccCircuitSize == null) {
                        OchccCircuitSize ochccCircuitSize2 = (OchccCircuitSize)iterator.next();
                        if (db.on()) {
                            db.println("Trying with " + ochccCircuitSize2 + " (framingType = " + ochccCircuitSize2.framingType + ")");
                        }
                        if (ochccCircuitSize2.framingType != -1) {
                            if (ochccCircuitSize2.framingType != n2) continue;
                            ochccCircuitSize = ochccCircuitSize2;
                            continue;
                        }
                        ochccCircuitSize = ochccCircuitSize2;
                    }
                }
            }
            if (db.on()) {
                db.println("Returning " + ochccCircuitSize);
            }
            return ochccCircuitSize;
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(((OchccCircuitSize)object).toString());
        }
    }
}

