/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.BuildInfo;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import org.omg.CORBA.StringHolder;

public class ShellDebugManager
extends Model
implements Observer {
    private Set nodes = Collections.synchronizedSet(new TreeSet(new NComparator()));
    private static final SDebug db = new ShellDbgMgr("ShellDebugManager");
    private static ShellDebugManager instance = null;

    public static final synchronized ShellDebugManager instance() {
        if (instance == null) {
            instance = new ShellDebugManager();
        }
        return instance;
    }

    private ShellDebugManager() {
        super(db);
        this.updateNodeTable();
        Network.instance().getNetElementCreationNotifier().addObserver(this);
    }

    public synchronized String shellDebugCommand(INodeModel iNodeModel, int n) {
        StringHolder stringHolder = new StringHolder();
        String string = "";
        try {
            iNodeModel.shellDebugCommand(n, stringHolder);
        }
        catch (InvalidOperation invalidOperation) {
            if (db.on()) {
                db.println("shellDebugCommand failed on node: " + iNodeModel + " cmd: " + n);
            }
            return string;
        }
        string = BuildInfo.sanitize(stringHolder.value);
        return string;
    }

    public synchronized INodeModel[] getKnownNodes() {
        this.updateNodeTable();
        return this.nodes.toArray(new INodeModel[this.nodes.size()]);
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update from " + observable + " regarding " + object);
        }
        if (observable instanceof Network.NetElementCreationNotifier) {
            INetElement iNetElement;
            INodeModel iNodeModel;
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier;
            if (object instanceof INetElement && (abstractConnectionNotifier = (iNodeModel = (iNetElement = (INetElement)object).getNodeModel()).getConnectionNotifier()) != null) {
                abstractConnectionNotifier.addObserver(this);
            }
        } else if (observable instanceof NodeModel.ConnectionNotifier) {
            NodeModel.ConnectionNotifier connectionNotifier = (NodeModel.ConnectionNotifier)((Object)observable);
            NodeModel nodeModel = connectionNotifier.getNodeModel();
            if (object == ModelUpdateType.DELETED) {
                this.deregisterNode(nodeModel, connectionNotifier);
            } else {
                this.registerNode(nodeModel);
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
        if (db.on()) {
            db.println("update: finish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeTable() {
        Iterator iterator = Network.instance().getElements().iterator();
        Object object = this.nodes;
        synchronized (object) {
            this.nodes.clear();
        }
        while (iterator.hasNext()) {
            object = (INetElement)iterator.next();
            INodeModel iNodeModel = object.getNodeModel();
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier = iNodeModel.getConnectionNotifier();
            if (abstractConnectionNotifier != null) {
                abstractConnectionNotifier.addObserver(this);
            }
            this.registerNode(iNodeModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNode(INodeModel iNodeModel) {
        if (!this.nodes.contains(iNodeModel) && iNodeModel.isInited()) {
            Set set = this.nodes;
            synchronized (set) {
                this.nodes.add(iNodeModel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterNode(INodeModel iNodeModel, INodeModel.AbstractConnectionNotifier abstractConnectionNotifier) {
        abstractConnectionNotifier.deleteObserver((Observer)this);
        Set set = this.nodes;
        synchronized (set) {
            this.nodes.remove(iNodeModel);
        }
    }

    protected static class ShellDbgMgr
    extends SDebug {
        public ShellDbgMgr(String string) {
            super(string);
        }

        public final void dumpNodes() {
            db.println("Known Nodes:");
            INodeModel[] iNodeModelArray = instance.getKnownNodes();
            for (int i = 0; i < iNodeModelArray.length; ++i) {
                db.println("\t" + iNodeModelArray[i].getName());
            }
        }
    }

    public class NComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof INodeModel) {
                if (object2 instanceof INodeModel) {
                    INodeModel iNodeModel = (INodeModel)object;
                    INodeModel iNodeModel2 = (INodeModel)object2;
                    try {
                        IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
                        IIpAddr iIpAddr2 = iNodeModel2.getIpConfig().getIpAddress();
                        if (iIpAddr != null && iIpAddr2 != null) {
                            try {
                                return iIpAddr.compareTo((Object)iIpAddr2);
                            }
                            catch (ClassCastException classCastException) {
                                try {
                                    return -iIpAddr2.compareTo((Object)iIpAddr);
                                }
                                catch (ClassCastException classCastException2) {
                                    return ComparisonUtil.compare((byte[])iIpAddr.getAddr(), (byte[])iIpAddr2.getAddr());
                                }
                            }
                        }
                        if (iIpAddr != null) {
                            return 1;
                        }
                        return -1;
                    }
                    catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                        if (iNodeModel == iNodeModel2) {
                            return 0;
                        }
                        return 1;
                    }
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof NComparator) {
                NComparator nComparator = (NComparator)object;
                bl = nComparator == this;
            }
            return bl;
        }
    }
}

