/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.blsr;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrSpanSwitched;
import cerent.cms.model.Busy;
import cerent.cms.model.DuplicateNodeId;
import cerent.cms.model.Feature;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IBlsrProtectionOp;
import cerent.cms.model.IBlsrProvision;
import cerent.cms.model.IElementModels;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IRipTblEntry;
import cerent.cms.model.ISquelchTblEntry;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.blsr.BlsrProvision;
import cerent.cms.model.blsr.BlsrRingInfo;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.model.blsr.PortAlreadyAssignedException;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.UObservable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class BlsrNode
extends UObservable
implements Observer,
IObserver {
    private IBlsrModel blsrModel;
    private BlsrSpan westSpan;
    private BlsrSpan eastSpan;
    private int westPortIndex;
    private int eastPortIndex;
    private int westProtectIndex;
    private int eastProtectIndex;
    private BlsrRingInfo ringInfo;
    private NodeModel nodeModel;
    private NetElement netElem;
    private IBlsrProtectionOp westOp;
    private IBlsrProtectionOp eastOp;
    private short eastChannelState;
    private short eastProtectChannelState;
    private short westChannelState;
    private short westProtectChannelState;
    private short nodeId;
    private boolean alreadyDestroyed = false;
    private static Map provisionedBlsrMap = Collections.synchronizedMap(new HashMap());
    private static final SDebug db = new SDebug("BlsrNode");
    public static final short EXTENDED_RING_CHANGED = 1;
    public static final short NODE_ID_CHANGED = 2;
    public static final short RING_ID_CHANGED = 3;
    public static final short RING_REVERSION_CHANGED = 4;
    public static final short SPAN_REVERSION_CHANGED = 5;
    public static final short UPGRADE_2_TO_4 = 6;
    public static final short WEST_PROTECTION_OP_CHANGED = 7;
    public static final short EAST_PROTECTION_OP_CHANGED = 8;
    public static final short EAST_CHANNEL_STATE_CHANGED = 9;
    public static final short EAST_PROTECT_CHANNEL_STATE_CHANGED = 10;
    public static final short WEST_CHANNEL_STATE_CHANGED = 11;
    public static final short WEST_PROTECT_CHANNEL_STATE_CHANGED = 12;
    public static final short BLSR_SPEED_CHANGED = 13;
    public static final short DEAD = 666;
    private PortChangeObserver portChangeObserver = new PortChangeObserver();
    private NetElementChangeObserver netElemChangeObserver = new NetElementChangeObserver();

    public static boolean compareNodeModels(INodeModel iNodeModel, INodeModel iNodeModel2) {
        if (null == iNodeModel || null == iNodeModel2) {
            return false;
        }
        try {
            return iNodeModel.getNodeId() == iNodeModel2.getNodeId();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return false;
        }
    }

    BlsrNode(NodeModel nodeModel, BlsrRingInfo blsrRingInfo) {
        db.fine("special ctor (ringInfo is null? " + (blsrRingInfo == null) + ")");
        this.nodeModel = nodeModel;
        this.ringInfo = blsrRingInfo;
    }

    private BlsrNode(IBlsrModel iBlsrModel, NodeModel nodeModel) {
        db.fine("ctor (blsrModel is null? " + (iBlsrModel == null) + ")");
        this.init(iBlsrModel, nodeModel);
    }

    private void init(IBlsrModel iBlsrModel, NodeModel nodeModel) {
        db.fine("init(" + iBlsrModel + ", " + nodeModel + ")");
        this.blsrModel = iBlsrModel;
        this.nodeModel = nodeModel;
        this.ringInfo = new BlsrRingInfo(iBlsrModel);
        this.netElem = (NetElement)Network.instance().findNetElem(this.nodeModel);
        try {
            this.westPortIndex = ((ITdmPortModel)iBlsrModel.getWestEntityModel()).getEntityIndex();
            this.eastPortIndex = ((ITdmPortModel)iBlsrModel.getEastEntityModel()).getEntityIndex();
            db.fine("...east/west port indicies are: " + this.eastPortIndex + "/" + this.westPortIndex);
            ModelIndirectObservable.instance().addObserver((IObservable)((ITdmPortModel)iBlsrModel.getWestEntityModel()), this.portChangeObserver);
            ModelIndirectObservable.instance().addObserver((IObservable)((ITdmPortModel)iBlsrModel.getEastEntityModel()), this.portChangeObserver);
            db.fine("West and East ports extracted from " + iBlsrModel.getNodeModel().getName());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.fine("The blsrModel passed in the constructor is missing one or both westEntity or eastEntity Models");
        }
        try {
            if (this.isFourFiber()) {
                this.westProtectIndex = ((ITdmPortModel)iBlsrModel.getWestProtectEntityModel()).getEntityIndex();
                this.eastProtectIndex = ((ITdmPortModel)iBlsrModel.getEastProtectEntityModel()).getEntityIndex();
                db.fine("The BlsrModel for " + iBlsrModel.getNodeModel().getName() + " passed in the constructor is a four-Fiber blsr");
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.fine("The BlsrModel passed in the constructor is a two-Fiber blsr");
        }
        this.nodeId = iBlsrModel.getBlsrProvision().getNodeId();
        this.westOp = iBlsrModel.getBlsrWestProtectionOp();
        this.eastOp = iBlsrModel.getBlsrEastProtectionOp();
        this.eastChannelState = (short)iBlsrModel.getEastMainState().intValue();
        this.eastProtectChannelState = (short)iBlsrModel.getEastProtState().intValue();
        this.westChannelState = (short)iBlsrModel.getWestMainState().intValue();
        this.westProtectChannelState = (short)iBlsrModel.getWestProtState().intValue();
        ModelIndirectObservable.instance().addObserver((IObservable)iBlsrModel, this);
        if (this.netElem != null) {
            ModelIndirectObservable.instance().addObserver((IObservable)this.netElem, this.netElemChangeObserver);
        }
        this.alreadyDestroyed = false;
        db.fine("NodeModel is null? " + (this.nodeModel == null));
    }

    static BlsrNode provisionedInstance(IBlsrModel iBlsrModel, NodeModel nodeModel) {
        BlsrNode blsrNode = null;
        if (provisionedBlsrMap.containsKey(iBlsrModel)) {
            blsrNode = (BlsrNode)provisionedBlsrMap.get(iBlsrModel);
            db.fine("(provisioned) found " + blsrNode + " in my map. Returning it.\n");
            if (blsrNode.isDestroyed()) {
                blsrNode.init(iBlsrModel, nodeModel);
            }
            return blsrNode;
        }
        db.fine("(provisioned) Could not find the BlsrNode.  Building a new one.\n");
        blsrNode = new BlsrNode(iBlsrModel, nodeModel);
        provisionedBlsrMap.put(iBlsrModel, blsrNode);
        return blsrNode;
    }

    public boolean isProvisioned() {
        return null != this.blsrModel;
    }

    public ISquelchTblEntry[] getSquelchData() throws IllegalStateException {
        if (!this.isProvisioned()) {
            db.fine("Attempted to get squelch data on an unprovisioned BlsrNode.\n\t\tThrowing IllegalStateException");
            throw new IllegalStateException("This method is only supported on a provisioned BLSR node");
        }
        return this.blsrModel.getISquelchTbl();
    }

    public IRipTblEntry[] getRipData() throws IllegalStateException {
        if (!this.isProvisioned()) {
            db.fine("Attempted to get RIP data on an unprovisioned BlsrNode.\n\t\tThrowing IllegalStateException");
            throw new IllegalStateException("This method is only supported on a provisioned BLSR node");
        }
        return this.blsrModel.getIRipTbl();
    }

    public boolean hasPCAConnections() throws IllegalStateException {
        if (!this.isProvisioned()) {
            db.fine("Attempted to call hasPCAConnections() on an unprovisioned BlsrNode.\n\t\tThrowing IllegalStateException");
            throw new IllegalStateException("This method is only supported on a provisioned BLSR node");
        }
        return this.blsrModel.hasPCAConnections();
    }

    public boolean hasDriConnections() throws IllegalStateException {
        if (!this.isProvisioned()) {
            db.fine("Attempted to call hasDriConnections() on an unprovisioned BlsrNode.\n\t\tThrowing IllegalStateException");
            throw new IllegalStateException("This method is only supported on a provisioned BLSR node");
        }
        INodeModel iNodeModel = this.blsrModel.getNodeModel();
        if (iNodeModel != null && iNodeModel.provides(Feature.BLSR_UPSR_DRI)) {
            return this.blsrModel.hasDriConnections();
        }
        db.fine("BlsrModel " + this.blsrModel + " failed feature check");
        return false;
    }

    public IBlsrModel getBlsrModel() {
        return this.blsrModel;
    }

    public NodeModel getNodeModel() {
        return this.nodeModel;
    }

    public boolean is15600Node() {
        return this.getNodeModel().getChassis().getEqType() == 92;
    }

    void setEastMain(BlsrSpan blsrSpan) {
        this.eastSpan = blsrSpan;
    }

    public BlsrSpan getEastMain() {
        return this.eastSpan;
    }

    void setWestMain(BlsrSpan blsrSpan) {
        this.westSpan = blsrSpan;
    }

    public BlsrSpan getWestMain() {
        return this.westSpan;
    }

    public BlsrSpan getEastProtect() {
        if (this.eastSpan == null) {
            return null;
        }
        return this.eastSpan.getParallelProtectSpan();
    }

    public BlsrSpan getWestProtect() {
        if (this.westSpan == null) {
            return null;
        }
        return this.westSpan.getParallelProtectSpan();
    }

    public ITdmPortModel getWestPort() {
        ITdmPortModel iTdmPortModel;
        block7: {
            iTdmPortModel = null;
            try {
                if (this.isProvisioned()) {
                    iTdmPortModel = (ITdmPortModel)this.blsrModel.getWestEntityModel();
                } else if (this.nodeModel != null && this.nodeModel.isInited()) {
                    if (this.westPortIndex > 0) {
                        iTdmPortModel = (ITdmPortModel)this.nodeModel.getEntityTable().getEntityModelByIndex(this.westPortIndex);
                    } else {
                        db.fine("eastPortIndex is " + this.westPortIndex + ". Would return NULL east port.");
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return iTdmPortModel;
    }

    public ITdmPortModel getEastPort() {
        ITdmPortModel iTdmPortModel;
        block7: {
            iTdmPortModel = null;
            try {
                if (this.isProvisioned()) {
                    iTdmPortModel = (ITdmPortModel)this.blsrModel.getEastEntityModel();
                } else if (this.nodeModel != null && this.nodeModel.isInited()) {
                    if (this.eastPortIndex > 0) {
                        iTdmPortModel = (ITdmPortModel)this.nodeModel.getEntityTable().getEntityModelByIndex(this.eastPortIndex);
                    } else {
                        db.fine("eastPortIndex is " + this.eastPortIndex + ". Would return NULL east port.");
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return iTdmPortModel;
    }

    public ITdmPortModel getWestProtectPort() {
        ITdmPortModel iTdmPortModel;
        block7: {
            iTdmPortModel = null;
            try {
                if (this.westProtectIndex == 0 && this.isProvisioned()) {
                    iTdmPortModel = (ITdmPortModel)this.blsrModel.getWestProtectEntityModel();
                } else if (this.nodeModel != null && this.nodeModel.isInited()) {
                    if (this.westProtectIndex > 0) {
                        iTdmPortModel = (ITdmPortModel)this.nodeModel.getEntityTable().getEntityModelByIndex(this.westProtectIndex);
                    } else {
                        db.fine("westProtectIndex is " + this.westProtectIndex + ". Would return NULL west protect port.");
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return iTdmPortModel;
    }

    public ITdmPortModel getEastProtectPort() {
        ITdmPortModel iTdmPortModel;
        block7: {
            iTdmPortModel = null;
            try {
                if (this.eastProtectIndex == 0 && this.isProvisioned()) {
                    iTdmPortModel = (ITdmPortModel)this.blsrModel.getEastProtectEntityModel();
                } else if (this.nodeModel != null && this.nodeModel.isInited()) {
                    if (this.eastProtectIndex > 0) {
                        iTdmPortModel = (ITdmPortModel)this.nodeModel.getEntityTable().getEntityModelByIndex(this.eastProtectIndex);
                    } else {
                        db.fine("eastProtectIndex is " + this.eastProtectIndex + ". Would return NULL east protect port.");
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return iTdmPortModel;
    }

    void setWestPort(ITdmPortModel iTdmPortModel) throws IllegalArgumentException, IllegalStateException {
        if (this.isProvisioned()) {
            db.fine("Trying to change a port on a provisioned BlsrNode. Exception thrown.");
            throw new IllegalStateException("This BLSR node is provisioned. Changing a port is not permitted");
        }
        if (iTdmPortModel != null) {
            if (!BlsrNode.compareNodeModels(iTdmPortModel.getNodeModel(), this.nodeModel)) {
                db.fine("Trying to set a port on a node different form the the other port(s).");
                throw new IllegalArgumentException("The port supplied is on a different node");
            }
            this.westPortIndex = iTdmPortModel.getEntityIndex();
        }
        if (!this.isFourFiber()) {
            try {
                this.setWestProtectPort(iTdmPortModel);
            }
            catch (PortAlreadyAssignedException portAlreadyAssignedException) {
                SDebug.printStackTrace((Throwable)portAlreadyAssignedException);
            }
        }
    }

    void setEastPort(ITdmPortModel iTdmPortModel) throws IllegalArgumentException, IllegalStateException {
        if (this.isProvisioned()) {
            db.fine("Trying to change a port on a provisioned BlsrNode. Exception thrown.");
            throw new IllegalStateException("This BLSR node is provisioned. Changing a port is not permitted");
        }
        if (iTdmPortModel != null) {
            if (!BlsrNode.compareNodeModels(iTdmPortModel.getNodeModel(), this.nodeModel)) {
                db.fine("Trying to set a port on a node different form the the other port(s).");
                throw new IllegalArgumentException("The SONET port supplied is on a different node");
            }
            this.eastPortIndex = iTdmPortModel.getEntityIndex();
        }
        if (!this.isFourFiber()) {
            try {
                this.setEastProtectPort(iTdmPortModel);
            }
            catch (PortAlreadyAssignedException portAlreadyAssignedException) {
                SDebug.printStackTrace((Throwable)portAlreadyAssignedException);
            }
        }
    }

    public void setWestProtectPort(ITdmPortModel iTdmPortModel) throws IllegalArgumentException, IllegalStateException, PortAlreadyAssignedException {
        if (this.isProvisioned() && this.isFourFiber()) {
            db.fine("Trying to change a port on a provisioned four fiber BlsrNode. Exception thrown.");
            throw new IllegalStateException("This BLSR node is provisioned four fiber. Changing a port is not permitted");
        }
        if (iTdmPortModel != null) {
            if (iTdmPortModel.equals(this.getEastProtectPort())) {
                throw new PortAlreadyAssignedException("The west and east protect ports must be different!");
            }
            if (!BlsrNode.compareNodeModels(iTdmPortModel.getNodeModel(), this.nodeModel)) {
                db.fine("Trying to set a port on a node different form the the other port(s).");
                throw new IllegalArgumentException("The SONET port supplied is on a different node");
            }
            this.westProtectIndex = iTdmPortModel.getEntityIndex();
        } else {
            db.fine("Got null west port. Setting westProtectIndex to zero.");
            this.westProtectIndex = 0;
        }
    }

    public void setEastProtectPort(ITdmPortModel iTdmPortModel) throws IllegalArgumentException, IllegalStateException, PortAlreadyAssignedException {
        if (this.isProvisioned() && this.isFourFiber()) {
            db.fine("Trying to change a port on a provisioned four fiber BlsrNode. Exception thrown.");
            throw new IllegalStateException("This BLSR node is a provisioned four fiber. Changing a port is not permitted");
        }
        if (iTdmPortModel != null) {
            if (iTdmPortModel.equals(this.getWestProtectPort())) {
                throw new PortAlreadyAssignedException("The west and east protect ports must differ.");
            }
            if (!BlsrNode.compareNodeModels(iTdmPortModel.getNodeModel(), this.nodeModel)) {
                db.fine("Trying to set a port on a node different form the the other port(s).");
                throw new IllegalArgumentException("The SONET port supplied is on a different node");
            }
            this.eastProtectIndex = iTdmPortModel.getEntityIndex();
        } else {
            db.fine("Got null east port. Setting eastProtectIndex to zero.");
            this.eastProtectIndex = 0;
        }
    }

    boolean areAllWorkingPortsClear() {
        return this.isWestProtOpClear() && this.isEastProtOpClear();
    }

    boolean areAllWorkingPortsLockedout() {
        return this.isWestProtOpLockedout() && this.isEastProtOpLockedout();
    }

    boolean canPortsBeLockedout() {
        return !(!this.isEastProtOpLockedout() && !this.isEastProtOpClear() || !this.isWestProtOpLockedout() && !this.isWestProtOpClear());
    }

    public boolean isWestProtOpClear() {
        int n = this.getWestProtectionOp().getKOp();
        return n == 0 || n == 8;
    }

    boolean isWestProtOpLockedout() {
        return this.getWestProtectionOp().getKOp() == 1;
    }

    public boolean isEastProtOpClear() {
        int n = this.getEastProtectionOp().getKOp();
        return n == 0 || n == 8;
    }

    boolean isEastProtOpLockedout() {
        return this.getEastProtectionOp().getKOp() == 1;
    }

    boolean anyChannelStateOnStandby() {
        return this.getWestChannelState() == 1 || this.getEastChannelState() == 1;
    }

    void clearWorkingPorts() {
        try {
            this.setWestProtectionOp(0);
            this.setEastProtectionOp(0);
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            db.fine("Unable to set protection op");
        }
        catch (InternalCommError internalCommError) {
            db.fine("Unable to set protection op, card communication failure");
        }
    }

    void lockoutPorts() {
        this.clearWorkingPorts();
        try {
            this.setWestProtectionOp(1);
            this.setEastProtectionOp(1);
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            db.fine("Unable to set protection op");
        }
        catch (InternalCommError internalCommError) {
            db.fine("Unable to set protection op, card communication failure");
        }
    }

    public IBlsrProtectionOp getEastProtectionOp() {
        return this.eastOp.duplicate();
    }

    public void setEastProtectionOp(IBlsrProtectionOp iBlsrProtectionOp) throws InvalidProtectionOp, InternalCommError {
        if (!this.isProvisioned()) {
            db.fine("Trying to set a protection operation on an unprovisioned node " + this);
            throw new IllegalStateException("BLSR node not provisioned " + this);
        }
        this.blsrModel.setBlsrEastProtectionOp(iBlsrProtectionOp);
    }

    public void setEastProtectionOp(int n) throws InvalidProtectionOp, InternalCommError {
        IBlsrProtectionOp iBlsrProtectionOp = this.getEastProtectionOp();
        iBlsrProtectionOp.setKOp(n);
        this.setEastProtectionOp(iBlsrProtectionOp);
    }

    public IBlsrProtectionOp getWestProtectionOp() {
        return this.westOp.duplicate();
    }

    public void setWestProtectionOp(IBlsrProtectionOp iBlsrProtectionOp) throws InvalidProtectionOp, InternalCommError {
        if (!this.isProvisioned()) {
            db.fine("Trying to set a protection operation on an unprovisioned node " + this);
            throw new IllegalStateException("BLSR node not provisioned " + this);
        }
        this.blsrModel.setBlsrWestProtectionOp(iBlsrProtectionOp);
    }

    public void setWestProtectionOp(int n) throws InvalidProtectionOp, InternalCommError {
        IBlsrProtectionOp iBlsrProtectionOp = this.getWestProtectionOp();
        iBlsrProtectionOp.setKOp(n);
        this.setWestProtectionOp(iBlsrProtectionOp);
    }

    public short getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(short s) throws DuplicateNodeId, BlsrSpanSwitched {
        if (this.isProvisioned()) {
            this.blsrModel.setNodeId(s);
            return;
        }
        this.nodeId = s;
        this.setChanged();
        db.fine("NODE_ID_CHANGED for BlsrNode:" + this.toString());
        this.notifyObservers(new Short(2));
    }

    synchronized void delete() throws Busy, IllegalStateException {
        if (!this.isProvisioned()) {
            throw new IllegalStateException("Can not unprovision an unprovisioned BLSR node!");
        }
        this.blsrModel.delete();
    }

    private short _getGlobalRingId() {
        short s = -1;
        try {
            s = Short.parseShort(this.getRingName());
            if (s < 0 || s > 9999) {
                s = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            db.finest("Caught " + numberFormatException + " because " + this.getRingName() + " must be alphanumeric.");
        }
        return s;
    }

    synchronized void provision() throws IllegalStateException, Busy, ProvisionError {
        if (this.isProvisioned()) {
            db.fine("Can not provision a provisioned BlsrNode!!  Exception thrown.");
            throw new IllegalStateException("Can not provision a provisioned BLSR node!");
        }
        int n = this.isFourFiber() ? 3 : 2;
        IElementModels iElementModels = this.nodeModel.getIElementModels();
        TDMTerminology tDMTerminology = this.nodeModel.getTDMTerminology();
        String string = tDMTerminology.getRingTerms(1) + " Ring";
        BlsrRingInfo blsrRingInfo = this.getBlsrRingInfo();
        iElementModels.createBlsr((IBlsrProvision)new BlsrProvision(this.getEastPort().getEntityIndex(), this.getWestPort().getEntityIndex(), this.isFourFiber() ? this.getEastProtectPort().getEntityIndex() : 0, this.isFourFiber() ? this.getWestProtectPort().getEntityIndex() : 0, this._getGlobalRingId(), blsrRingInfo.getRingName(), blsrRingInfo.getRingId(), true, true, this.getNodeId(), blsrRingInfo.getRingReversion(), blsrRingInfo.getSpanReversion()), n, string);
    }

    private void destroy() {
        block5: {
            db.fine(this + " destroy");
            this.alreadyDestroyed = true;
            provisionedBlsrMap.remove(this.blsrModel);
            try {
                ITdmPortModel iTdmPortModel = (ITdmPortModel)this.nodeModel.getEntityTable().getEntityModelByIndex(this.eastPortIndex);
                ITdmPortModel iTdmPortModel2 = (ITdmPortModel)this.nodeModel.getEntityTable().getEntityModelByIndex(this.westPortIndex);
                ModelIndirectObservable.instance().deleteObserver((IObservable)this.blsrModel, this);
                ModelIndirectObservable.instance().deleteObserver((IObservable)iTdmPortModel, this.portChangeObserver);
                ModelIndirectObservable.instance().deleteObserver((IObservable)iTdmPortModel2, this.portChangeObserver);
                if (this.netElem != null) {
                    ModelIndirectObservable.instance().deleteObserver((IObservable)this.netElem, this.netElemChangeObserver);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.blsrModel = null;
        if (this.westSpan != null) {
            this.westSpan.getParallelProtectSpan().destroy();
            this.westSpan.destroy();
            this.westSpan = null;
        }
        if (this.eastSpan != null) {
            this.eastSpan.getParallelProtectSpan().destroy();
            this.eastSpan.destroy();
            this.eastSpan = null;
        }
        this.westPortIndex = 0;
        this.eastPortIndex = 0;
        this.westProtectIndex = 0;
        this.eastProtectIndex = 0;
        this.ringInfo = null;
        this.nodeModel = null;
        this.nodeId = (short)-1;
        this.deleteObservers();
    }

    public boolean isDestroyed() {
        return this.alreadyDestroyed;
    }

    public String getRingName() {
        return this.ringInfo.getRingName();
    }

    BlsrRingInfo getBlsrRingInfo() {
        return this.ringInfo;
    }

    public boolean isFourFiber() {
        return this.ringInfo.getRingType() == 3;
    }

    protected void upgradeTo4Fiber(IRevertiveBehavior iRevertiveBehavior) throws Busy, ProvisionError, IllegalStateException {
        if (!this.isProvisioned()) {
            db.fine("Throwing an IllegalStatException:  Can not upgrade an unprovisioned BlsrNode");
            throw new IllegalStateException("Can not upgrade an unprovisioned BLSR node");
        }
        if (this.getWestProtectPort() == null || this.getEastProtectPort() == null) {
            db.fine("Throwing an IllegalStatException:  Can not upgrade as one, or both protect ports have not been set.");
            throw new IllegalStateException("Can not upgrade as one, or both protect ports have not been set.");
        }
        this.blsrModel.upgrade2FiberTo4Fiber(this.getEastProtectPort().getEntityIndex(), this.getWestProtectPort().getEntityIndex(), iRevertiveBehavior);
    }

    protected boolean isOrderwireOnProtectPorts() {
        boolean bl = false;
        if (this.getWestProtectPort() != null && this.getEastProtectPort() != null) {
            bl = this.getWestProtectPort().isOrderwireOn() || this.getEastProtectPort().isOrderwireOn();
        }
        return bl;
    }

    protected boolean isProtectPortsSpecified() {
        return this.getWestProtectPort() != null && this.getEastProtectPort() != null;
    }

    protected boolean isProtectPortsEnabled() {
        block3: {
            try {
                if (this.getWestProtectPort() != null && this.getEastProtectPort() != null) {
                    return BlsrRingModel.isPortIS(this.getWestProtectPort()) && BlsrRingModel.isPortIS(this.getEastProtectPort());
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                db.fine("NoSuchInterface exception thown!");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    boolean isProtectPortsSdccEnabled() {
        boolean bl = false;
        if (this.getWestProtectPort() != null && this.getEastProtectPort() != null) {
            bl = this.getWestProtectPort().isSonetDccTermination() || this.getEastProtectPort().isSonetDccTermination();
        }
        return bl;
    }

    boolean isProtectPortsTimingReference() {
        return BlsrNode.isEntityTimingReference((IPortModel)this.getWestProtectPort()) || BlsrNode.isEntityTimingReference((IPortModel)this.getEastProtectPort());
    }

    static boolean isEntityTimingReference(IPortModel iPortModel) {
        return Arrays.asList(iPortModel.getNodeModel().getTimingRefEntities()).contains(iPortModel);
    }

    protected boolean isWorkingPortsInProtectionGroup() {
        boolean bl = false;
        if (this.getEastPort() != null && this.getWestPort() != null) {
            bl = this.getEastPort().hasOpticalProtection() || this.getWestPort().hasOpticalProtection();
        }
        return bl;
    }

    public short getEastChannelState() {
        return this.eastChannelState;
    }

    public short getEastProtectChannelState() {
        return this.eastProtectChannelState;
    }

    public short getWestChannelState() {
        return this.westChannelState;
    }

    public short getWestProtectChannelState() {
        return this.westProtectChannelState;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDestroyed()) {
            stringBuffer.append((this.nodeModel == null ? "<NULL> NodeModel" : this.nodeModel.getName().toUpperCase()) + " is destroyed!");
        } else {
            stringBuffer.append(this.nodeModel.getName().toUpperCase());
            if (this.getWestPort() != null) {
                stringBuffer.append(" ");
                stringBuffer.append("[W-s" + this.getWestPort().getSlot() + "/");
                stringBuffer.append("p" + PortHelper.getPortNumString((IPortModel)this.getWestPort()) + "]");
            }
            if (this.getEastPort() != null) {
                stringBuffer.append(" ");
                stringBuffer.append("[E-s" + this.getEastPort().getSlot() + "/");
                stringBuffer.append("p" + PortHelper.getPortNumString((IPortModel)this.getEastPort()) + "]");
            }
            if (this.isFourFiber()) {
                if (this.getWestProtectPort() != null) {
                    stringBuffer.append(" ");
                    stringBuffer.append("[WP-s" + this.getWestProtectPort().getSlot() + "/");
                    stringBuffer.append("p" + PortHelper.getPortNumString((IPortModel)this.getWestProtectPort()) + "]");
                }
                if (this.getEastProtectPort() != null) {
                    stringBuffer.append(" ");
                    stringBuffer.append("[EP-s" + this.getEastProtectPort().getSlot() + "/");
                    stringBuffer.append("p" + PortHelper.getPortNumString((IPortModel)this.getEastProtectPort()) + "]");
                }
            }
        }
        return stringBuffer.toString();
    }

    void reverseDirection() throws IllegalStateException {
        if (this.isProvisioned()) {
            throw new IllegalStateException("East/West changes can not be performed on provsisioned BLSRs.");
        }
        try {
            ITdmPortModel iTdmPortModel = this.getEastProtectPort();
            ITdmPortModel iTdmPortModel2 = this.getWestProtectPort();
            this.setEastProtectPort(null);
            this.setWestProtectPort(null);
            ITdmPortModel iTdmPortModel3 = this.getEastPort();
            this.setEastPort(this.getWestPort());
            this.setWestPort(iTdmPortModel3);
            this.setEastProtectPort(iTdmPortModel2);
            this.setWestProtectPort(iTdmPortModel);
            BlsrSpan blsrSpan = this.eastSpan;
            this.setEastMain(this.westSpan);
            this.setWestMain(blsrSpan);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            db.fine(illegalArgumentException.toString());
        }
        catch (PortAlreadyAssignedException portAlreadyAssignedException) {
            db.fine(portAlreadyAssignedException.toString());
        }
        db.fine(this.toString() + " - direction reversed.");
    }

    private void findChange(Integer n) {
        db.fine("In method find change with message -- " + n);
        if (ModelUpdateType.DELETED == n) {
            this.alreadyDestroyed = true;
            this.setChanged();
            db.fine("DEAD for BlsrNode:" + this.toString());
            this.notifyObservers(new Short(666));
            this.destroy();
        } else {
            short s;
            IBlsrProtectionOp iBlsrProtectionOp;
            short s2;
            db.fine("The underlying BlsrModel has changed.");
            BlsrRingInfo blsrRingInfo = new BlsrRingInfo(this.blsrModel);
            BlsrRingInfo blsrRingInfo2 = this.ringInfo;
            if (!blsrRingInfo.getRingName().equals(blsrRingInfo2.getRingName())) {
                db.fine("Ring Id has changed");
                this.ringInfo = blsrRingInfo;
                this.setChanged();
                db.fine("RING_ID_CHANGED for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(3));
            }
            if (!this.blsrModel.getRingReversion().equals(blsrRingInfo2.getRingReversion())) {
                db.fine("Ring Reversion changed");
                this.ringInfo = blsrRingInfo;
                this.setChanged();
                db.fine("RING_REVERSION_CHANGED for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(4));
            }
            if (blsrRingInfo2.getRingType() == 3 && !this.blsrModel.getSpanReversion().equals(blsrRingInfo2.getSpanReversion())) {
                db.fine("Span Reversion changed");
                this.ringInfo = blsrRingInfo;
                this.setChanged();
                db.fine("SPAN_REVERSION_CHANGED for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(5));
            }
            if ((s2 = this.blsrModel.getBlsrProvision().getNodeId()) != this.nodeId) {
                db.fine("NodeId has changed");
                this.nodeId = s2;
                this.setChanged();
                db.fine("NODE_ID_CHANGED for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(2));
            }
            if (!this.westOp.equals(iBlsrProtectionOp = this.blsrModel.getBlsrWestProtectionOp())) {
                db.fine("The west IBlsrProtectionOp has changed.");
                this.westOp = iBlsrProtectionOp;
                this.setChanged();
                db.fine("WEST_PROTECTION_OP_CHANGED for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(7));
            }
            if (!this.eastOp.equals(iBlsrProtectionOp = this.blsrModel.getBlsrEastProtectionOp())) {
                db.fine("The east IBlsrProtectionOp has changed.");
                this.eastOp = iBlsrProtectionOp;
                this.setChanged();
                db.fine("EAST_PROTECTION_OP_CHANGED for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(8));
            }
            if (blsrRingInfo2.getRingType() == 2 && blsrRingInfo.getRingType() == 3) {
                db.fine("This is now a four fiber ring.");
                this.ringInfo = blsrRingInfo;
                try {
                    this.westProtectIndex = ((ITdmPortModel)this.blsrModel.getWestProtectEntityModel()).getEntityIndex();
                    this.eastProtectIndex = ((ITdmPortModel)this.blsrModel.getEastProtectEntityModel()).getEntityIndex();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Error setting protect ports for node " + this);
                }
                this.setChanged();
                db.fine("UPGRADE_2_TO_4 for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(6));
            }
            if ((s = (short)this.blsrModel.getEastMainState().intValue()) != this.eastChannelState) {
                db.fine("East eBlsrChannelState has changed.");
                this.eastChannelState = s;
                this.setChanged();
                db.fine("EAST_CHANNEL_STATE_CHANGED for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(9));
            }
            if ((s = (short)this.blsrModel.getEastProtState().intValue()) != this.eastProtectChannelState) {
                db.fine("East Protect eBlsrChannelState has changed.");
                this.eastProtectChannelState = s;
                this.setChanged();
                db.fine("EAST_PROTECT_CHANNEL_STATE_CHANGED for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(10));
            }
            if ((s = (short)this.blsrModel.getWestMainState().intValue()) != this.westChannelState) {
                db.fine("West eBlsrChannelState has changed.");
                this.westChannelState = s;
                this.setChanged();
                db.fine("WEST_CHANNEL_STATE_CHANGED for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(11));
            }
            if ((s = (short)this.blsrModel.getWestProtState().intValue()) != this.westProtectChannelState) {
                db.fine(" West Protect eBlsrChannelState has changed.");
                this.westProtectChannelState = s;
                this.setChanged();
                db.fine("WEST_PROTECT_CHANNEL_STATE_CHANGED for BlsrNode:" + this.toString());
                this.notifyObservers(new Short(12));
            }
        }
    }

    public void update(Observable observable, Object object) {
        this._update(observable, object);
    }

    public void update(IObservable iObservable, Object object) {
        this._update(iObservable, object);
    }

    private void _update(Object object, Object object2) {
        if (object instanceof IBlsrModel) {
            final Integer n = (Integer)object2;
            new Thread(new Runnable(){

                public void run() {
                    BlsrNode.this.findChange(n);
                }
            }).start();
        }
    }

    private class PortChangeObserver
    implements Observer,
    IObserver {
        private PortChangeObserver() {
        }

        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private void _update(Object object, Object object2) {
            Integer n = (Integer)object2;
            int n2 = 5;
            if (n == ModelUpdateType.CHANGED) {
                if (BlsrNode.this.getWestPort().getEqType() == BlsrNode.this.getEastPort().getEqType()) {
                    switch (BlsrNode.this.getWestPort().getEqType()) {
                        case 29: {
                            n2 = 1;
                            break;
                        }
                        case 30: {
                            n2 = 2;
                            break;
                        }
                        case 61: {
                            n2 = 3;
                        }
                    }
                }
                BlsrNode.this.ringInfo.setRingSpeed(n2);
                BlsrNode.this.setChanged();
                BlsrNode.this.notifyObservers(new Short(13));
            }
        }
    }

    private class NetElementChangeObserver
    implements Observer,
    IObserver {
        private NetElementChangeObserver() {
        }

        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private void _update(Object object, Object object2) {
            NetElement netElement = (NetElement)object;
            if (!netElement.getConnectionState()) {
                BlsrNode.this.alreadyDestroyed = true;
                BlsrNode.this.setChanged();
                BlsrNode.this.notifyObservers(new Short(666));
                BlsrNode.this.destroy();
            }
        }
    }
}

