/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.blsr;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrSpanSwitched;
import cerent.cms.model.Busy;
import cerent.cms.model.DuplicateRingId;
import cerent.cms.model.Feature;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IBlsrProvision;
import cerent.cms.model.ILinkPhysicalType;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.LinkPhysicalType;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class BlsrRingInfo {
    public static String INCONSISTENT = "INCONSISTENT";
    public static String OC12 = "OC-12*";
    public static String OC48 = "OC-48*";
    public static String OC192 = "OC-192*";
    public static final String BLSR_2F = "2-Fiber";
    public static final String BLSR_4F = "4-Fiber";
    private String ringName = null;
    private int ringId = -1;
    private int ringType = 2;
    private int ringSpeed = 1;
    private IRevertiveBehavior ringReversion = null;
    private IRevertiveBehavior spanReversion = null;
    private boolean extendedRing = true;
    private boolean provisioned = false;
    private IBlsrModel blsrModel = null;
    private static final SDebug db = new SDebug("BlsrRingInfo");
    private TDMTerminology tdmTerm;

    public BlsrRingInfo(IBlsrModel iBlsrModel) {
        this.blsrModel = iBlsrModel;
        IBlsrProvision iBlsrProvision = iBlsrModel.getBlsrProvision();
        if (iBlsrModel.getNodeModel().provides(Feature.BLSR_PATRIOT_EXTENSIONS)) {
            this.ringName = iBlsrProvision.getRingName();
            this.ringId = iBlsrProvision.getRingId();
        } else {
            try {
                this.ringName = iBlsrProvision.getGlobalRingId() + "";
                this.ringId = iBlsrProvision.getGlobalRingId();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                SDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        }
        if (db.on()) {
            db.println("[constructor] RingName: " + this.ringName + " - and Ring ID: " + this.ringId);
        }
        this.ringReversion = iBlsrModel.getRingReversion();
        this.spanReversion = iBlsrModel.getSpanReversion();
        this.extendedRing = iBlsrProvision.getExtendedRing();
        this.ringType = iBlsrModel.getType();
        this.provisioned = true;
        this.tdmTerm = iBlsrModel.getNodeModel().getTDMTerminology();
        try {
            OC12 = EqTypeHelper.eqTypeToName((TDMTerminology)this.tdmTerm, (int)10);
            OC48 = EqTypeHelper.eqTypeToName((TDMTerminology)this.tdmTerm, (int)11);
            OC192 = EqTypeHelper.eqTypeToName((TDMTerminology)this.tdmTerm, (int)60);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        try {
            if (iBlsrModel.getEastEntityModel().getEqType() != iBlsrModel.getWestEntityModel().getEqType()) {
                this.ringSpeed = 5;
            } else {
                switch (iBlsrModel.getEastEntityModel().getEqType()) {
                    case 29: {
                        this.ringSpeed = 1;
                        break;
                    }
                    case 30: {
                        this.ringSpeed = 2;
                        break;
                    }
                    case 61: {
                        this.ringSpeed = 3;
                    }
                }
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.ringSpeed = -1;
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
    }

    public BlsrRingInfo(String string, int n, int n2, int n3, TDMTerminology tDMTerminology) {
        this.ringName = string;
        this.ringId = n;
        this.ringType = n2;
        this.ringSpeed = n3;
        this.tdmTerm = tDMTerminology;
    }

    public BlsrRingInfo(String string, int n, TDMTerminology tDMTerminology) {
        this.ringName = string;
        this.ringId = n;
        this.tdmTerm = tDMTerminology;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.getRingName().hashCode();
        n = 37 * n + this.getRingType();
        n = 37 * n + this.getRingSpeed();
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BlsrRingInfo)) {
            return false;
        }
        BlsrRingInfo blsrRingInfo = (BlsrRingInfo)object;
        return blsrRingInfo.getRingName().equals(this.getRingName()) && blsrRingInfo.getRingType() == this.getRingType() && blsrRingInfo.getRingSpeed() == this.getRingSpeed();
    }

    static BlsrRingInfo unProvisionedDuplicate(BlsrRingInfo blsrRingInfo) {
        BlsrRingInfo blsrRingInfo2 = new BlsrRingInfo(blsrRingInfo.getRingName(), blsrRingInfo.getRingId(), blsrRingInfo.getRingType(), blsrRingInfo.getRingSpeed(), blsrRingInfo.getTDMTerminology());
        blsrRingInfo2.setUnprovisionedRingReversion(blsrRingInfo.getRingReversion());
        if (blsrRingInfo.isFourFiber()) {
            blsrRingInfo2.setUnprovisionedSpanReversion(blsrRingInfo.getSpanReversion());
        }
        blsrRingInfo2.setExtendedRing(true);
        return blsrRingInfo2;
    }

    public TDMTerminology getTDMTerminology() {
        return this.tdmTerm;
    }

    public String getRingName() {
        return this.ringName;
    }

    public int getRingId() {
        return this.ringId;
    }

    public void setRingName(String string) throws DuplicateRingId, BlsrSpanSwitched {
        if (this.isProvisioned()) {
            if (this.blsrModel.getNodeModel().provides(Feature.BLSR_PATRIOT_EXTENSIONS)) {
                try {
                    this.blsrModel.setRingName(string);
                }
                catch (DuplicateRingId duplicateRingId) {
                    SDebug.printStackTrace((Throwable)duplicateRingId);
                    throw new DuplicateRingId(duplicateRingId.toString());
                }
            } else {
                try {
                    this.blsrModel.setRingId(Short.parseShort(string));
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    SDebug.printStackTrace((Throwable)unsupportedOperation);
                }
                catch (AbstractMethodError abstractMethodError) {
                    SDebug.printStackTrace((Throwable)abstractMethodError);
                }
            }
        } else {
            this.ringName = string;
        }
    }

    public int getRingType() {
        return this.ringType;
    }

    public boolean isFourFiber() {
        return this.ringType == 3;
    }

    public void setRingType(int n) {
        this.ringType = n;
    }

    public String getRingTypeString() {
        String string = new String();
        switch (this.ringType) {
            case 2: {
                string = BLSR_2F;
                break;
            }
            case 3: {
                string = BLSR_4F;
                break;
            }
            default: {
                string = "Unknown in BlsrRingInfo";
            }
        }
        return string;
    }

    public int getRingTypeForString(String string) {
        int n = -1;
        n = string.equals(BLSR_2F) ? 2 : (string.equals(BLSR_4F) ? 3 : -1);
        return n;
    }

    public int getRingSpeed() {
        return this.ringSpeed;
    }

    public ILinkPhysicalType getRingSpeedObj() {
        return LinkPhysicalType.getLinkPhysicalType((int)this.ringSpeed);
    }

    public void setRingSpeed(int n) {
        this.ringSpeed = n;
    }

    public String getRingSpeedString() {
        String string = new String();
        switch (this.ringSpeed) {
            case 5: {
                string = INCONSISTENT;
                break;
            }
            case 1: {
                string = this.tdmTerm.getTermForPhysicalLink(1);
                break;
            }
            case 2: {
                string = this.tdmTerm.getTermForPhysicalLink(2);
                break;
            }
            case 3: {
                string = this.tdmTerm.getTermForPhysicalLink(3);
                break;
            }
            default: {
                string = "Unknown in BlsrRingInfo";
            }
        }
        return string;
    }

    public int getRingSpeedForString(String string) {
        int n = 0;
        if (string.equals(this.tdmTerm.getLinkPhysicalTypeTerm(1))) {
            n = 1;
        } else if (string.equals(this.tdmTerm.getLinkPhysicalTypeTerm(2))) {
            n = 2;
        } else if (string.equals(this.tdmTerm.getLinkPhysicalTypeTerm(3))) {
            n = 3;
        } else if (string.equals(INCONSISTENT)) {
            n = 5;
        }
        return n;
    }

    public IRevertiveBehavior getRingReversion() {
        return this.ringReversion == null ? null : this.ringReversion.duplicate();
    }

    public void setRingReversion(IRevertiveBehavior iRevertiveBehavior) throws Busy {
        if (db.on()) {
            db.println("In setRingReversion: isProvisioned=" + this.isProvisioned());
        }
        if (this.isProvisioned()) {
            this.blsrModel.setRingReversion(iRevertiveBehavior);
        } else {
            this.ringReversion = iRevertiveBehavior;
        }
    }

    public void setUnprovisionedRingReversion(IRevertiveBehavior iRevertiveBehavior) {
        if (db.on()) {
            db.println("In setUnprovisionedRingReversion");
        }
        this.ringReversion = iRevertiveBehavior;
    }

    public IRevertiveBehavior getSpanReversion() {
        return this.spanReversion == null ? null : this.spanReversion.duplicate();
    }

    public void setSpanReversion(IRevertiveBehavior iRevertiveBehavior) throws Busy {
        if (db.on()) {
            db.println("In setblsSpanReversion: isProvisioned=" + this.isProvisioned());
        }
        if (this.isProvisioned()) {
            this.blsrModel.setSpanReversion(iRevertiveBehavior);
        } else {
            this.spanReversion = iRevertiveBehavior;
        }
    }

    public void setUnprovisionedSpanReversion(IRevertiveBehavior iRevertiveBehavior) {
        if (db.on()) {
            db.println("In setUnprovisionedSpanReversion");
        }
        this.spanReversion = iRevertiveBehavior;
    }

    public boolean isExtendedRing() {
        return this.extendedRing;
    }

    public void setExtendedRing(boolean bl) {
        this.extendedRing = bl;
    }

    public boolean isBusy() {
        return this.blsrModel.getEastMainState().shortValue() != 0 || this.blsrModel.getWestMainState().shortValue() != 0;
    }

    private boolean isProvisioned() {
        return this.provisioned;
    }

    public String toString() {
        String string = "BlsrRingInfo [name=" + this.getRingName();
        string = string + ", ringType=" + this.getRingTypeString();
        string = string + ", ringSpeed=" + this.getRingSpeedString();
        if (null != this.ringReversion) {
            string = string + ", ringReversion=" + this.getRingReversion().toString();
        }
        if (null != this.spanReversion) {
            string = string + ", spanReversion=" + this.getSpanReversion().toString();
        }
        string = string + "]";
        return string;
    }
}

