/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.circuits.CircuitAccessorFactory;
import cerent.cms.model.circuits.CircuitDataSource;
import cerent.cms.model.circuits.CircuitFilterCriteria;
import cerent.cms.model.circuits.ICircuitAccessor;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import cerent.util.matcher.AbstractMatcher;
import cerent.util.matcher.AndMatcher;
import cerent.util.matcher.BooleanFieldMatcher;
import cerent.util.matcher.CollectionFieldMatcher;
import cerent.util.matcher.LongFieldMatcher;
import cerent.util.matcher.OrMatcher;
import cerent.util.matcher.StringFieldMatcher;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;

public class CircuitFilter
implements Observer {
    private static boolean isLastFilterActive = false;
    private static SDebug db = new SDebug("CircuitFilter");
    private AndMatcher coreMatcher = new AndMatcher("", new AbstractMatcher[0]);
    private boolean isActive = false;
    private LinkedList listeners = new LinkedList();
    private CircuitFilterCriteria filterCriteria = null;
    private ICircuitAccessor circuitAccessor = null;
    private CktTypeAccessor cktTypeAccessor = new CktTypeAccessor();
    private CktSizeAccessor cktSizeAccessor = new CktSizeAccessor();
    private CircuitNameAccessor cktNameAccessor = new CircuitNameAccessor();
    private CktOptDirAccessor cktOptDirAccessor = new CktOptDirAccessor();
    private CktOptChannelAccessor cktOptChannelAccessor = new CktOptChannelAccessor();
    private CktDirectionAccessor cktDirectionAccessor = new CktDirectionAccessor();
    private CktStatusAccessor cktStatusAccessor = new CktStatusAccessor();
    private CktServiceStateAccessor cktServiceStateAccessor = new CktServiceStateAccessor();
    private CktProtectionTypeAccessor cktProtectionTypeAccessor = new CktProtectionTypeAccessor();
    private SrcPortAccessor srcPortAccessor = new SrcPortAccessor();
    private ListDropsAccessor listDropsAccessor = new ListDropsAccessor();
    private DstPortAccessor dstPortAccessor = new DstPortAccessor();
    private SrcSlotAccessor srcSlotAccessor = new SrcSlotAccessor();
    private SrcShelfAccessor srcShelfAccessor = new SrcShelfAccessor();
    private DstShelfAccessor dstShelfAccessor = new DstShelfAccessor();
    private DstSlotAccessor dstSlotAccessor = new DstSlotAccessor();

    public CircuitFilter() {
        this.circuitAccessor = CircuitAccessorFactory.createCircuitAccessor();
        this.setFilterCriteria(CircuitFilterCriteria.instance());
    }

    public void clearFilter() {
        this.coreMatcher = new AndMatcher("", new AbstractMatcher[0]);
    }

    private void buildFilterFromCriteria() {
        this.clearFilter();
        this.createNameMatcher(this.filterCriteria.getName());
        this.createDirectionMatcher(this.filterCriteria.getDirection());
        this.createOptDirMatcher(this.filterCriteria.getOptDir());
        this.createOptChannelMatcher(this.filterCriteria.getOptChannel());
        this.createStatusMatcher(this.filterCriteria.getStatus());
        this.createServiceStateMatcher(this.filterCriteria.getServiceState());
        this.createProtectionTypeMatcher(this.filterCriteria.getProtectionType());
        this.createTypeMatcher(this.filterCriteria.getType());
        this.createShelfAndSlotAndPortMatcher(this.filterCriteria.getShelf(), this.filterCriteria.getSlot(), this.filterCriteria.getPort());
        this.createSizeMatcher(this.filterCriteria.getSize());
        this.createRingMatcher(this.filterCriteria.getRing());
        this.createNetElementMatcher(this.filterCriteria.getNetElements());
        this.createLinkMatcher(this.filterCriteria.getLink());
        this.createSrcDropTypeMatcher(this.filterCriteria.getSrcDropType());
    }

    protected void addListener(Object object) {
        this.listeners.add(object);
    }

    protected boolean removeListener(Object object) {
        return this.listeners.remove(object);
    }

    private void notifyListeners() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CircuitDataSource)) continue;
            ((CircuitDataSource)e).filterChanged();
        }
    }

    public void setActive(boolean bl) {
        this.setCircuitFilterActive(bl);
        isLastFilterActive = this.isActive;
    }

    private void setCircuitFilterActive(boolean bl) {
        if (bl && this.size() > 0 || !bl) {
            this.isActive = bl;
            this.notifyListeners();
        } else {
            this.isActive = false;
            this.notifyListeners();
        }
    }

    public void setMergeFilterActive(boolean bl) {
        this.setCircuitFilterActive(bl);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public static boolean isLastFilterActive() {
        return isLastFilterActive;
    }

    public void setFilterCriteria(CircuitFilterCriteria circuitFilterCriteria) {
        if (this.filterCriteria != null) {
            this.filterCriteria.deleteObserver(this);
        }
        this.filterCriteria = circuitFilterCriteria;
        if (this.filterCriteria != null) {
            this.filterCriteria.addObserver(this);
            this.buildFilterFromCriteria();
        } else {
            this.clearFilter();
        }
    }

    public CircuitFilterCriteria getFilterCriteria() {
        return this.filterCriteria;
    }

    public void addMatcher(AbstractMatcher abstractMatcher) {
        if (db.on()) {
            db.fine("addmatcher:" + abstractMatcher.getName());
        }
        this.coreMatcher.add(abstractMatcher);
    }

    public boolean doesMatch(INetCircuit iNetCircuit) {
        return this.coreMatcher.doesMatch((Object)iNetCircuit);
    }

    public int size() {
        if (db.on()) {
            db.fine("matcher size=" + this.coreMatcher.getNumMatchers());
            Iterator iterator = this.coreMatcher.getMatchers().iterator();
            while (iterator.hasNext()) {
                db.fine(((AbstractMatcher)iterator.next()).getName());
            }
        }
        return this.coreMatcher.getNumMatchers();
    }

    private void createTypeMatcher(int n) {
        if (db.on()) {
            db.fine("createTypeMatcher(): type = " + n);
        }
        if (n >= 0) {
            if (n == 1 || n == 4) {
                AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{new LongFieldMatcher("Base", n, (LongFieldMatcher.IAccessor)this.cktTypeAccessor, null), new LongFieldMatcher("Additional", 0, (LongFieldMatcher.IAccessor)this.cktTypeAccessor, null)};
                this.addMatcher((AbstractMatcher)new OrMatcher("CktTypeMatcherOr", abstractMatcherArray));
            } else {
                this.addMatcher((AbstractMatcher)new LongFieldMatcher("CktTypeMatcher", n, (LongFieldMatcher.IAccessor)this.cktTypeAccessor, null));
            }
        }
    }

    private void createSizeMatcher(int[] nArray) {
        if (db.on()) {
            db.fine("createSizeMatcher(): sizes = " + nArray + " and sizes.length = " + (nArray == null ? 0 : nArray.length));
        }
        if (nArray != null && nArray.length > 0) {
            this.addMatcher(this.createMultiSizeMatcher("CktSizeIndvMatcher", nArray));
        } else if (nArray != null) {
            int[] nArray2 = new int[]{-1};
            this.addMatcher(this.createMultiSizeMatcher("NoSizeMatcher", nArray2));
        }
    }

    private AbstractMatcher createMultiSizeMatcher(String string, int[] nArray) {
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            abstractMatcherArray[i] = new LongFieldMatcher(string, nArray[i], (LongFieldMatcher.IAccessor)this.cktSizeAccessor, null);
        }
        return new OrMatcher("CktSizeMatcher", abstractMatcherArray);
    }

    private void createNameMatcher(String string) {
        if (db.on()) {
            db.fine("createNameMatcher(): name = " + string);
        }
        if (string != null && string.length() > 0) {
            String string2 = "CktNameMatcher";
            boolean bl = false;
            StringFieldMatcher stringFieldMatcher = new StringFieldMatcher(string2, string, 2, bl, (StringFieldMatcher.IAccessor)this.cktNameAccessor, null);
            this.addMatcher((AbstractMatcher)stringFieldMatcher);
        }
    }

    private void createOptDirMatcher(int n) {
        if (db.on()) {
            db.fine("createOptDirMatcher(): optdir = " + n);
        }
        if (n >= 0) {
            String string = "CktOptDirMatcher";
            this.addMatcher((AbstractMatcher)new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.cktOptDirAccessor, null));
        }
    }

    private void createOptChannelMatcher(int n) {
        if (db.on()) {
            db.fine("createOptChannelMatcher(): optch = " + n);
        }
        if (n >= 0) {
            String string = "CktOptChannelMatcher";
            this.addMatcher((AbstractMatcher)new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.cktOptChannelAccessor, null));
        }
    }

    private void createDirectionMatcher(int n) {
        if (db.on()) {
            db.fine("createDirectionMatcher(): direction = " + n);
        }
        if (n >= 0) {
            String string = "CktDirectionMatcher";
            this.addMatcher((AbstractMatcher)new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.cktDirectionAccessor, null));
        }
    }

    private AbstractMatcher createSingleStatusMatcher(int n) {
        return new LongFieldMatcher("CktStatusMatcher", n, (LongFieldMatcher.IAccessor)this.cktStatusAccessor, null);
    }

    private void createStatusMatcher(int n) {
        if (db.on()) {
            db.fine("createStatusMatcher(): status = " + n);
        }
        if (n >= 0) {
            this.addMatcher(this.createSingleStatusMatcher(n));
        }
    }

    private AbstractMatcher createSingleServiceStateMatcher(int n) {
        String string = "CktServiceStateMatcher";
        return new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.cktServiceStateAccessor, null);
    }

    private void createServiceStateMatcher(int n) {
        if (db.on()) {
            db.fine("createServiceStateMatcher(): serviceState = " + n);
        }
        if (n >= 0) {
            this.addMatcher(this.createSingleServiceStateMatcher(n));
        }
    }

    private AbstractMatcher createSingleProtectionTypeMatcher(int n) {
        String string = "CktProtectionTypeMatcher";
        return new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.cktProtectionTypeAccessor, null);
    }

    private AbstractMatcher createMultiProtectionTypeMatcher(int[] nArray) {
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            AbstractMatcher abstractMatcher;
            abstractMatcherArray[i] = abstractMatcher = this.createSingleProtectionTypeMatcher(nArray[i]);
        }
        return new OrMatcher("CktProtectionMatcher", abstractMatcherArray);
    }

    private void createProtectionTypeMatcher(int n) {
        if (db.on()) {
            db.fine("createProtectionTypeMatcher(): protectionType = " + n);
        }
        if (n >= 0) {
            if (n == 3) {
                int[] nArray = new int[]{3, 14};
                this.addMatcher(this.createMultiProtectionTypeMatcher(nArray));
            } else {
                this.addMatcher(this.createSingleProtectionTypeMatcher(n));
            }
        }
    }

    private void createShelfAndSlotAndPortMatcher(int n, int n2, int[] nArray) {
        if (db.on()) {
            db.fine("createShelfAndSlotAndPortMatcher(): shelfNumber = " + n + " slotNumber = " + n2 + " and portNumber = " + nArray);
            if (nArray != null && nArray.length > 0) {
                db.fine("createShelfAndSlotAndPortMatcher(): portNumber[0] = " + nArray[0]);
            }
        }
        if (n2 > 0 && nArray == null && n <= 0) {
            this.addMatcher(this.createSimpleSlotMatcher(n2));
        } else if (nArray != null && n2 <= 0 && n <= 0) {
            this.addMatcher(this.createSimplePortMatcher(nArray));
        } else if (nArray == null && n2 <= 0 && n > 0) {
            this.addMatcher(this.createSimpleShelfMatcher(n));
        } else if (n2 > 0 && nArray != null && n <= 0) {
            this.addMatcher(this.createCompoundSlotAndPortMatcher(n2, nArray));
        } else if (n2 > 0 && nArray == null && n > 0) {
            this.addMatcher(this.createCompoundShelfAndSlotMatcher(n, n2));
        } else if (n2 <= 0 && nArray != null && n > 0) {
            this.addMatcher(this.createCompoundShelfAndPortMatcher(n, nArray));
        } else if (n2 > 0 && nArray != null && n > 0) {
            this.addMatcher(this.createCompoundShelfAndSlotAndPortMatcher(n, n2, nArray));
        }
    }

    private AbstractMatcher createListDstShelfAndSlotMatcher(int n, int n2) {
        String string = "DstShelfAndSlotMatcher";
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.dstShelfAccessor, null), new LongFieldMatcher(string, n2, (LongFieldMatcher.IAccessor)this.dstSlotAccessor, null)};
        AndMatcher andMatcher = new AndMatcher(string, abstractMatcherArray);
        String string2 = "ListDstMatcher";
        return new CollectionFieldMatcher(string2, (AbstractMatcher)andMatcher, (CollectionFieldMatcher.IAccessor)this.listDropsAccessor, null, null);
    }

    private AbstractMatcher createListDstSlotAndPortMatcher(int n, int[] nArray) {
        String string = "DstSlotAndPortMatcher";
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.dstSlotAccessor, null), new StringFieldMatcher(string, PortHelper.getConcatenatedString((int[])nArray), 6, false, (StringFieldMatcher.IAccessor)this.dstPortAccessor, null)};
        AndMatcher andMatcher = new AndMatcher(string, abstractMatcherArray);
        String string2 = "ListDstMatcher";
        return new CollectionFieldMatcher(string2, (AbstractMatcher)andMatcher, (CollectionFieldMatcher.IAccessor)this.listDropsAccessor, null, null);
    }

    private AbstractMatcher createListDstShelfAndSlotAndPortMatcher(int n, int n2, int[] nArray) {
        String string = "DstShelfAndSlotAndPortMatcher";
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.dstShelfAccessor, null), new LongFieldMatcher(string, n2, (LongFieldMatcher.IAccessor)this.dstSlotAccessor, null), new StringFieldMatcher(string, PortHelper.getConcatenatedString((int[])nArray), 6, false, (StringFieldMatcher.IAccessor)this.dstPortAccessor, null)};
        AndMatcher andMatcher = new AndMatcher(string, abstractMatcherArray);
        String string2 = "ListDstMatcher";
        return new CollectionFieldMatcher(string2, (AbstractMatcher)andMatcher, (CollectionFieldMatcher.IAccessor)this.listDropsAccessor, null, null);
    }

    private AbstractMatcher createListDstShelfAndPortMatcher(int n, int[] nArray) {
        String string = "DstSlotAndPortMatcher";
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.dstShelfAccessor, null), new StringFieldMatcher(string, PortHelper.getConcatenatedString((int[])nArray), 6, false, (StringFieldMatcher.IAccessor)this.dstPortAccessor, null)};
        AndMatcher andMatcher = new AndMatcher(string, abstractMatcherArray);
        String string2 = "ListDstMatcher";
        return new CollectionFieldMatcher(string2, (AbstractMatcher)andMatcher, (CollectionFieldMatcher.IAccessor)this.listDropsAccessor, null, null);
    }

    private AbstractMatcher createCompoundShelfAndSlotMatcher(int n, int n2) {
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{this.createSrcShelfMatcher(n), this.createSrcSlotMatcher(n2)};
        AndMatcher andMatcher = new AndMatcher("", abstractMatcherArray);
        AbstractMatcher[] abstractMatcherArray2 = new AbstractMatcher[]{andMatcher, this.createListDstShelfAndSlotMatcher(n, n2)};
        return new OrMatcher("CktShelfAndSlotMatcher", abstractMatcherArray2);
    }

    private AbstractMatcher createCompoundSlotAndPortMatcher(int n, int[] nArray) {
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{this.createSrcSlotMatcher(n), this.createSrcPortMatcher(nArray)};
        AndMatcher andMatcher = new AndMatcher("", abstractMatcherArray);
        AbstractMatcher[] abstractMatcherArray2 = new AbstractMatcher[]{andMatcher, this.createListDstSlotAndPortMatcher(n, nArray)};
        return new OrMatcher("CktSlotAndPortMatcher", abstractMatcherArray2);
    }

    private AbstractMatcher createCompoundShelfAndSlotAndPortMatcher(int n, int n2, int[] nArray) {
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{this.createSrcShelfMatcher(n), this.createSrcSlotMatcher(n2), this.createSrcPortMatcher(nArray)};
        AndMatcher andMatcher = new AndMatcher("", abstractMatcherArray);
        AbstractMatcher[] abstractMatcherArray2 = new AbstractMatcher[]{andMatcher, this.createListDstShelfAndSlotAndPortMatcher(n, n2, nArray)};
        return new OrMatcher("CktSlotAndPortMatcher", abstractMatcherArray2);
    }

    private AbstractMatcher createCompoundShelfAndPortMatcher(int n, int[] nArray) {
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{this.createSrcShelfMatcher(n), this.createSrcPortMatcher(nArray)};
        AndMatcher andMatcher = new AndMatcher("", abstractMatcherArray);
        AbstractMatcher[] abstractMatcherArray2 = new AbstractMatcher[]{andMatcher, this.createListDstShelfAndPortMatcher(n, nArray)};
        return new OrMatcher("CktShelfAndPortMatcher", abstractMatcherArray2);
    }

    private AbstractMatcher createSimplePortMatcher(int[] nArray) {
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{this.createSrcPortMatcher(nArray), this.createListDstPortMatcher(nArray)};
        return new OrMatcher("CktSimplePortMatcher", abstractMatcherArray);
    }

    private AbstractMatcher createSrcPortMatcher(int[] nArray) {
        String string = "SrcPortMatcher";
        boolean bl = false;
        String string2 = PortHelper.getConcatenatedString((int[])nArray);
        return new StringFieldMatcher(string, string2, 6, bl, (StringFieldMatcher.IAccessor)this.srcPortAccessor, null);
    }

    private AbstractMatcher createListDstPortMatcher(int[] nArray) {
        String string = "DstPortMatcher";
        StringFieldMatcher stringFieldMatcher = null;
        boolean bl = false;
        String string2 = PortHelper.getConcatenatedString((int[])nArray);
        stringFieldMatcher = new StringFieldMatcher(string, string2, 6, bl, (StringFieldMatcher.IAccessor)this.dstPortAccessor, null);
        String string3 = "ListDstMatcher";
        return new CollectionFieldMatcher(string3, (AbstractMatcher)stringFieldMatcher, (CollectionFieldMatcher.IAccessor)this.listDropsAccessor, null, null);
    }

    public AbstractMatcher createSimpleSlotMatcher(int n) {
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{this.createSrcSlotMatcher(n), this.createListDstSlotMatcher(n)};
        return new OrMatcher("CktSimpleSlotMatcher", abstractMatcherArray);
    }

    public AbstractMatcher createSimpleShelfMatcher(int n) {
        AbstractMatcher[] abstractMatcherArray = new AbstractMatcher[]{this.createSrcShelfMatcher(n), this.createListDstShelfMatcher(n)};
        return new OrMatcher("CktSimpleShelfMatcher", abstractMatcherArray);
    }

    private AbstractMatcher createSrcShelfMatcher(int n) {
        String string = "SrcShelfMatcher";
        return new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.srcShelfAccessor, null);
    }

    private AbstractMatcher createSrcSlotMatcher(int n) {
        String string = "SrcSlotMatcher";
        return new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.srcSlotAccessor, null);
    }

    private AbstractMatcher createListDstShelfMatcher(int n) {
        String string = "DstShelfMatcher";
        LongFieldMatcher longFieldMatcher = null;
        longFieldMatcher = new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.dstShelfAccessor, null);
        String string2 = "ListDstMatcher";
        return new CollectionFieldMatcher(string2, (AbstractMatcher)longFieldMatcher, (CollectionFieldMatcher.IAccessor)this.listDropsAccessor, null, null);
    }

    private AbstractMatcher createListDstSlotMatcher(int n) {
        String string = "DstSlotMatcher";
        LongFieldMatcher longFieldMatcher = null;
        longFieldMatcher = new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)this.dstSlotAccessor, null);
        String string2 = "ListDstMatcher";
        return new CollectionFieldMatcher(string2, (AbstractMatcher)longFieldMatcher, (CollectionFieldMatcher.IAccessor)this.listDropsAccessor, null, null);
    }

    private void createRingMatcher(BlsrRingModel blsrRingModel) {
        if (db.on()) {
            db.fine("createRingMatcher(): ring = " + blsrRingModel);
        }
        if (blsrRingModel != null) {
            BooleanFieldMatcher booleanFieldMatcher = new BooleanFieldMatcher("RingMatcher", (BooleanFieldMatcher.IAccessor)new RingAccessor(blsrRingModel), null);
            this.addMatcher((AbstractMatcher)booleanFieldMatcher);
        }
    }

    private void createLinkMatcher(INetLink iNetLink) {
        if (db.on()) {
            db.fine("createLinkMatcher(): name = " + iNetLink);
        }
        if (iNetLink != null) {
            BooleanFieldMatcher booleanFieldMatcher = new BooleanFieldMatcher("LinkMatcher", (BooleanFieldMatcher.IAccessor)new LinkAccessor(iNetLink), null);
            this.addMatcher((AbstractMatcher)booleanFieldMatcher);
        }
    }

    private void createNetElementMatcher(INetElement[] iNetElementArray) {
        if (iNetElementArray != null) {
            if (db.on()) {
                db.fine("createNetElemMatcher(): nes size = " + iNetElementArray.length);
            }
            BooleanFieldMatcher booleanFieldMatcher = new BooleanFieldMatcher("NetElemMatcher", (BooleanFieldMatcher.IAccessor)new NetElemAccessor(iNetElementArray), null);
            this.addMatcher((AbstractMatcher)booleanFieldMatcher);
        }
    }

    private void createSrcDropTypeMatcher(int n) {
        if (db.on()) {
            db.fine("createSrcDropTypeMatcher(): srcDropType = " + n);
        }
        if (n >= 0) {
            BooleanFieldMatcher booleanFieldMatcher = new BooleanFieldMatcher("SrcDropTypeMatcher", (BooleanFieldMatcher.IAccessor)new SrcDropTypeAccessor(n), null);
            this.addMatcher((AbstractMatcher)booleanFieldMatcher);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CircuitFilterCriteria) {
            this.buildFilterFromCriteria();
            if (db.on()) {
                db.fine("filterCriteria changed");
                db.fine("new filter size=" + this.size());
            }
            if (this.isActive()) {
                this.notifyListeners();
            }
        }
    }

    public void dispose() {
        if (this.filterCriteria != null) {
            this.filterCriteria.deleteObserver(this);
        }
    }

    private class SrcDropTypeAccessor
    implements BooleanFieldMatcher.IAccessor {
        private int srcDropType;

        SrcDropTypeAccessor(int n) {
            this.srcDropType = n;
        }

        public boolean getAttribute(Object object) {
            INetCircuit iNetCircuit = (INetCircuit)object;
            switch (this.srcDropType) {
                case 1: {
                    return CircuitFilter.this.circuitAccessor.hasSingleSource(iNetCircuit) && CircuitFilter.this.circuitAccessor.hasSingleDrop(iNetCircuit);
                }
                case 2: {
                    return CircuitFilter.this.circuitAccessor.hasMultipleSources(iNetCircuit) || CircuitFilter.this.circuitAccessor.hasMultipleDrops(iNetCircuit);
                }
            }
            return false;
        }
    }

    private class NetElemAccessor
    implements BooleanFieldMatcher.IAccessor {
        private INetElement[] nes;

        NetElemAccessor(INetElement[] iNetElementArray) {
            this.nes = iNetElementArray;
        }

        public boolean getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.useNetElement((INetCircuit)object, this.nes);
        }
    }

    private class LinkAccessor
    implements BooleanFieldMatcher.IAccessor {
        private INetLink link;

        LinkAccessor(INetLink iNetLink) {
            this.link = iNetLink;
        }

        public boolean getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.useLink((INetCircuit)object, this.link);
        }
    }

    private class RingAccessor
    implements BooleanFieldMatcher.IAccessor {
        private BlsrRingModel ring;

        RingAccessor(BlsrRingModel blsrRingModel) {
            this.ring = blsrRingModel;
        }

        public boolean getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.useBlsr((INetCircuit)object, this.ring);
        }
    }

    private class DstSlotAccessor
    implements LongFieldMatcher.IAccessor {
        private DstSlotAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getDstCktSlot((NetCircuitDropInfo)object);
        }
    }

    private class DstShelfAccessor
    implements LongFieldMatcher.IAccessor {
        private DstShelfAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getDstCktShelf((NetCircuitDropInfo)object);
        }
    }

    private class SrcShelfAccessor
    implements LongFieldMatcher.IAccessor {
        private SrcShelfAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getSrcCktShelf((INetCircuit)object);
        }
    }

    private class SrcSlotAccessor
    implements LongFieldMatcher.IAccessor {
        private SrcSlotAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getSrcCktSlot((INetCircuit)object);
        }
    }

    private class DstPortAccessor
    implements StringFieldMatcher.IAccessor {
        private DstPortAccessor() {
        }

        public String getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getDstCktPort((NetCircuitDropInfo)object);
        }
    }

    private class ListDropsAccessor
    implements CollectionFieldMatcher.IAccessor {
        private ListDropsAccessor() {
        }

        public Iterator getIterator(Object object) {
            return CircuitFilter.this.circuitAccessor.getDstCktDrops((INetCircuit)object);
        }
    }

    private class SrcPortAccessor
    implements StringFieldMatcher.IAccessor {
        private SrcPortAccessor() {
        }

        public String getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getSrcCktPort((INetCircuit)object);
        }
    }

    private class CktProtectionTypeAccessor
    implements LongFieldMatcher.IAccessor {
        private CktProtectionTypeAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getCircuitProtectionType((INetCircuit)object);
        }
    }

    private class CktServiceStateAccessor
    implements LongFieldMatcher.IAccessor {
        private CktServiceStateAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getCircuitServiceState((INetCircuit)object);
        }
    }

    private class CktStatusAccessor
    implements LongFieldMatcher.IAccessor {
        private CktStatusAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getCircuitStatus((INetCircuit)object);
        }
    }

    private class CktDirectionAccessor
    implements LongFieldMatcher.IAccessor {
        private CktDirectionAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getCircuitDirection((INetCircuit)object);
        }
    }

    private class CktOptChannelAccessor
    implements LongFieldMatcher.IAccessor {
        private CktOptChannelAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getCircuitOptChannel((INetCircuit)object);
        }
    }

    private class CktOptDirAccessor
    implements LongFieldMatcher.IAccessor {
        private CktOptDirAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getCircuitOptDir((INetCircuit)object);
        }
    }

    private class CircuitNameAccessor
    implements StringFieldMatcher.IAccessor {
        private CircuitNameAccessor() {
        }

        public String getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getCircuitName((INetCircuit)object);
        }
    }

    private class CktSizeAccessor
    implements LongFieldMatcher.IAccessor {
        private CktSizeAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getCircuitSize((INetCircuit)object);
        }
    }

    private class CktTypeAccessor
    implements LongFieldMatcher.IAccessor {
        private CktTypeAccessor() {
        }

        public long getAttribute(Object object) {
            return CircuitFilter.this.circuitAccessor.getCircuitType((INetCircuit)object);
        }
    }
}

