/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.circuits.CircuitFilterCriteria;
import cerent.util.Preferences;

public class CircuitFilterCriteriaPreferences {
    private static CircuitFilterCriteriaPreferences prefs;
    protected static final String ROOT_PREF = "circuitFilter";
    protected static final String NAME_PREF = "name";
    protected static final String DIR_PREF = "direction";
    protected static final String OPTDIR_PREF = "optDir";
    protected static final String OPTCHAN_PREF = "optChannel";
    protected static final String STATUS_PREF = "status";
    protected static final String SERVICESTATE_PREF = "serviceState";
    protected static final String PROT_PREF = "protectionType";
    protected static final String SLOT_PREF = "slot";
    protected static final String SHELF_PREF = "shelf";
    protected static final String PORT_PREF = "port";
    protected static final String TYPE_PREF = "type";
    protected static final String SIZE_PREF = "size";
    protected static final String PREF_IS_FILTER_ACTIVE = "isActive";
    protected Preferences preferences = Preferences.instance();

    private CircuitFilterCriteriaPreferences() {
    }

    public static CircuitFilterCriteriaPreferences instance() {
        if (prefs == null) {
            prefs = new CircuitFilterCriteriaPreferences();
        }
        return prefs;
    }

    public void loadInto(CircuitFilterCriteria circuitFilterCriteria) {
        circuitFilterCriteria.setName(this.loadName());
        circuitFilterCriteria.setDirection(this.loadDirection());
        circuitFilterCriteria.setOptDir(this.loadOptDir());
        circuitFilterCriteria.setOptChannel(this.loadOptChNum());
        circuitFilterCriteria.setStatus(this.loadStatus());
        circuitFilterCriteria.setServiceState(this.loadServiceState());
        circuitFilterCriteria.setProtectionType(this.loadProtectionType());
        circuitFilterCriteria.setType(this.loadType());
        circuitFilterCriteria.setShelf(this.loadShelf());
        circuitFilterCriteria.setSlot(this.loadSlot());
        circuitFilterCriteria.setPort(this.loadPort());
        circuitFilterCriteria.setSize(this.loadSizes());
    }

    public void saveFrom(CircuitFilterCriteria circuitFilterCriteria) {
        this.saveName(circuitFilterCriteria.getName());
        this.saveDirection(circuitFilterCriteria.getDirection());
        this.saveOptDir(circuitFilterCriteria.getOptDir());
        this.saveOptChNum(circuitFilterCriteria.getOptChannel());
        this.saveStatus(circuitFilterCriteria.getStatus());
        this.saveServiceState(circuitFilterCriteria.getServiceState());
        this.saveProtectionType(circuitFilterCriteria.getProtectionType());
        this.saveType(circuitFilterCriteria.getType());
        this.saveShelf(circuitFilterCriteria.getShelf());
        this.saveSlot(circuitFilterCriteria.getSlot());
        this.savePort(circuitFilterCriteria.getPort());
        this.saveSizes(circuitFilterCriteria.getSize());
    }

    public String loadName() {
        return this.preferences.getProperty(ROOT_PREF, NAME_PREF, "");
    }

    public void saveName(String string) {
        this.preferences.setProperty(ROOT_PREF, NAME_PREF, string);
    }

    public int loadDirection() {
        return this.preferences.getInt(ROOT_PREF, DIR_PREF, -1);
    }

    public void saveDirection(int n) {
        this.preferences.setInt(ROOT_PREF, DIR_PREF, n);
    }

    public int loadOptDir() {
        return this.preferences.getInt(ROOT_PREF, OPTDIR_PREF, -1);
    }

    public void saveOptDir(int n) {
        this.preferences.setInt(ROOT_PREF, OPTDIR_PREF, n);
    }

    public int loadOptChNum() {
        return this.preferences.getInt(ROOT_PREF, OPTCHAN_PREF, -1);
    }

    public void saveOptChNum(int n) {
        this.preferences.setInt(ROOT_PREF, OPTCHAN_PREF, n);
    }

    public int loadStatus() {
        return this.preferences.getInt(ROOT_PREF, STATUS_PREF, -1);
    }

    public void saveStatus(int n) {
        this.preferences.setInt(ROOT_PREF, STATUS_PREF, n);
    }

    public int loadServiceState() {
        return this.preferences.getInt(ROOT_PREF, SERVICESTATE_PREF, -1);
    }

    public void saveServiceState(int n) {
        this.preferences.setInt(ROOT_PREF, SERVICESTATE_PREF, n);
    }

    public int loadProtectionType() {
        return this.preferences.getInt(ROOT_PREF, PROT_PREF, -1);
    }

    public void saveProtectionType(int n) {
        this.preferences.setInt(ROOT_PREF, PROT_PREF, n);
    }

    public int loadSlot() {
        return this.preferences.getInt(ROOT_PREF, SLOT_PREF, -1);
    }

    public void saveSlot(int n) {
        this.preferences.setInt(ROOT_PREF, SLOT_PREF, n);
    }

    public int loadShelf() {
        return this.preferences.getInt(ROOT_PREF, SHELF_PREF, -1);
    }

    public void saveShelf(int n) {
        this.preferences.setInt(ROOT_PREF, SHELF_PREF, n);
    }

    public int[] loadPort() {
        String[] stringArray = this.preferences.getPropertyArray(ROOT_PREF, PORT_PREF, null);
        int[] nArray = CircuitFilterCriteriaPreferences.strArr2intArr(stringArray);
        if (nArray != null && nArray.length == 0) {
            nArray = null;
        }
        return nArray;
    }

    public void savePort(int[] nArray) {
        if (nArray == null) {
            String[] stringArray = new String[]{};
            this.preferences.setPropertyArray(ROOT_PREF, PORT_PREF, stringArray);
        } else {
            this.preferences.setPropertyArray(ROOT_PREF, PORT_PREF, CircuitFilterCriteriaPreferences.intArr2strArr(nArray));
        }
    }

    public int loadType() {
        return this.preferences.getInt(ROOT_PREF, TYPE_PREF, -1);
    }

    public void saveType(int n) {
        this.preferences.setInt(ROOT_PREF, TYPE_PREF, n);
    }

    public int[] loadSizes() {
        String[] stringArray = this.preferences.getPropertyArray(ROOT_PREF, SIZE_PREF, null);
        int[] nArray = CircuitFilterCriteriaPreferences.strArr2intArr(stringArray);
        if (nArray != null && nArray.length == 1 && nArray[0] == -1) {
            nArray = null;
        }
        return nArray;
    }

    public static int[] strArr2intArr(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = new Integer(stringArray[i]);
        }
        return nArray;
    }

    public static String[] intArr2strArr(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = new Integer(nArray[i]).toString();
        }
        return stringArray;
    }

    public void saveSizes(int[] nArray) {
        if (nArray == null) {
            nArray = new int[]{-1};
        }
        this.preferences.setPropertyArray(ROOT_PREF, SIZE_PREF, CircuitFilterCriteriaPreferences.intArr2strArr(nArray));
    }
}

